//package com.tyw.updatedemo;
//
//import android.content.Context;
//import android.os.Handler;
//import android.os.Looper;
//import android.os.UpdateEngine;
//import android.os.UpdateEngineCallback;
//import android.util.Log;
//
//import java.io.BufferedReader;
//import java.io.File;
//import java.io.FileInputStream;
//import java.io.FileOutputStream;
//import java.io.IOException;
//import java.io.InputStream;
//import java.io.InputStreamReader;
//import java.util.ArrayList;
//import java.util.List;
//import java.util.zip.ZipEntry;
//import java.util.zip.ZipFile;
//
///**
// * A/B系统升级核心逻辑管理类。 (V4 - 最终正确版)
// * 修正了 applyPayload 的调用方式，不再解压升级包，而是直接操作 .zip 文件。
// * 这与系统内置更新应用的行为保持一致。
// */
//public class AbUpdateManager {
//
//    private static final String TAG = "AbUpdateManager";
//    private static final boolean debug = true;
//
//    // 状态和进度常量
//    private static final int PROGRESS_COPY_START = 5;
//    // 解压步骤已移除，但保留常量以防未来需要
//    private static final int PROGRESS_UNZIP_START = 10;
//    private static final int PROGRESS_VERIFY_START = 15;
//    private static final int PROGRESS_APPLY_START = 20;
//    private static final int PROGRESS_COMPLETE = 100;
//
//    // 错误码
//    public static final int ERROR_CODE_COPY_FAILED = 210;
//    public static final int ERROR_CODE_APPLY_FAILED = 213;
//    public static final int ERROR_INVALID_FILE_PATH = 217;
//    public static final int ERROR_INVALID_FILE_TYPE = 218;
//
//    // 路径和文件名常量
//    private final String DATA_OTA_PATH;
//    private final String OTA_UPDATE_ZIP_PATH;
//    private static final String OTA_FILE_LINK = "file://";
//    private static final String OTA_UPDATE_ZIP_NAME = "update.zip";
//    private static final String OTA_PAYLOAD_BIN_NAME = "payload.bin";
//    private static final String OTA_METADATA_NAME_IN_ZIP = "META-INF/com/android/metadata";
//    private static final String OTA_PAYLOAD_PROP_NAME_IN_ZIP = "payload_properties.txt";
//
//    // 成员变量
//    private final Context mContext;
//    private final AbUpdateListener mListener;
//    private final Handler mMainHandler;
//    private final UpdateEngine mUpdateEngine;
//    private final UECallback mUpdateEngineCallback;
//    private String mUpdateFilePath;
//
//    public AbUpdateManager(Context context, AbUpdateListener listener) {
//        this.mContext = context.getApplicationContext();
//        this.mListener = listener;
//        this.mMainHandler = new Handler(Looper.getMainLooper());
//        this.mUpdateEngine = new UpdateEngine();
//        this.mUpdateEngineCallback = new UECallback();
//
//        // 使用应用的缓存目录，这是应用保证有权限读写的
//        File otaDir = new File(mContext.getCacheDir(), "ota_package");
//        this.DATA_OTA_PATH = otaDir.getAbsolutePath() + File.separator;
//        this.OTA_UPDATE_ZIP_PATH = new File(otaDir, OTA_UPDATE_ZIP_NAME).getAbsolutePath();
//    }
//
//    /**
//     * 开始升级流程。
//     * @param updateFilePath 升级包的完整路径 (必须是.zip文件)
//     */
//    public void startUpdate(String updateFilePath) {
//        if (updateFilePath == null || !updateFilePath.endsWith(".zip")) {
//            reportFailure(ERROR_INVALID_FILE_TYPE, "无效的升级文件类型，必须是 .zip 文件");
//            return;
//        }
//        File sourceFile = new File(updateFilePath);
//        if (!sourceFile.exists()) {
//            reportFailure(ERROR_INVALID_FILE_PATH, "升级文件不存在: " + updateFilePath);
//            return;
//        }
//        this.mUpdateFilePath = updateFilePath;
//        mUpdateEngine.bind(mUpdateEngineCallback);
//        new Thread(this::runUpdateProcess).start();
//    }
//
//    private void runUpdateProcess() {
//        cleanup();
//
//        // 步骤 1: 复制 .zip 包到缓存目录
//        if (!copyPackage()) {
//            reportFailure(ERROR_CODE_COPY_FAILED, "复制升级包失败");
//            return;
//        }
//
//        // 步骤 2: 应用升级 (直接操作复制后的 .zip 包)
//        applyUpdate();
//    }
//
//    private void applyUpdate() {
//        reportProgress(PROGRESS_APPLY_START, "正在应用升级...");
//
//        try (ZipFile zipFile = new ZipFile(OTA_UPDATE_ZIP_PATH)) {
//            // 从 .zip 包中直接读取 metadata
//            int[] data = getMetadataInfo(zipFile);
//            if (data == null) {
//                reportFailure(ERROR_CODE_APPLY_FAILED, "从升级包中读取 metadata 失败");
//                return;
//            }
//
//            // 从 .zip 包中直接读取 properties
//            String[] payloadProperties = getPayloadProperties(zipFile);
//            if (payloadProperties == null) {
//                reportFailure(ERROR_CODE_APPLY_FAILED, "从升级包中读取 payload properties 失败");
//                return;
//            }
//
//            // 【关键】: fileLink 指向 .zip 文件，而不是 payload.bin
//            String fileLink = OTA_FILE_LINK + OTA_UPDATE_ZIP_PATH;
//
//            Log.d(TAG, "Applying payload from: " + fileLink + " with offset=" + data[0] + ", size=" + data[1]);
//            mUpdateEngine.applyPayload(fileLink, data[0], data[1], payloadProperties);
//
//        } catch (Exception e) {
//            Log.e(TAG, "Apply payload failed", e);
//            reportFailure(ERROR_CODE_APPLY_FAILED, "应用升级失败: " + e.getLocalizedMessage());
//        }
//    }
//
//    /**
//     * 【关键修改】: 从 ZipFile 对象中直接读取 metadata.
//     */
//    private int[] getMetadataInfo(ZipFile zipFile) {
//        try {
//            ZipEntry entry = zipFile.getEntry(OTA_METADATA_NAME_IN_ZIP);
//            if (entry == null) {
//                Log.e(TAG, "Metadata entry not found in zip: " + OTA_METADATA_NAME_IN_ZIP);
//                return null;
//            }
//            try (InputStream is = zipFile.getInputStream(entry);
//                 BufferedReader br = new BufferedReader(new InputStreamReader(is))) {
//                String line;
//                while ((line = br.readLine()) != null) {
//                    if (line.contains(OTA_PAYLOAD_BIN_NAME)) {
//                        String[] lineInfo = line.split(",");
//                        for (String item : lineInfo) {
//                            if (item.contains(OTA_PAYLOAD_BIN_NAME)) {
//                                String[] data = item.split(":");
//                                if (data.length >= 3) {
//                                    int[] result = new int[2];
//                                    result[0] = Integer.parseInt(data[1]); // offset
//                                    result[1] = Integer.parseInt(data[2]); // size
//                                    return result;
//                                }
//                            }
//                        }
//                    }
//                }
//            }
//        } catch (IOException | NumberFormatException e) {
//            Log.e(TAG, "Failed to get metadata info from zip", e);
//        }
//        return null;
//    }
//
//    /**
//     * 【关键修改】: 从 ZipFile 对象中直接读取 properties.
//     */
//    private String[] getPayloadProperties(ZipFile zipFile) {
//        try {
//            ZipEntry entry = zipFile.getEntry(OTA_PAYLOAD_PROP_NAME_IN_ZIP);
//            if (entry == null) {
//                Log.e(TAG, "Payload properties entry not found in zip: " + OTA_PAYLOAD_PROP_NAME_IN_ZIP);
//                return null;
//            }
//            List<String> lines = new ArrayList<>();
//            try (InputStream is = zipFile.getInputStream(entry);
//                 BufferedReader br = new BufferedReader(new InputStreamReader(is))) {
//                String line;
//                while ((line = br.readLine()) != null) {
//                    lines.add(line);
//                }
//                return lines.toArray(new String[0]);
//            }
//        } catch (IOException e) {
//            Log.e(TAG, "Failed to get payload properties from zip", e);
//        }
//        return null;
//    }
//
//    private boolean copyPackage() {
//        reportProgress(PROGRESS_COPY_START, "正在复制升级包...");
//        File sourceFile = new File(mUpdateFilePath);
//        File destDir = new File(DATA_OTA_PATH);
//        if (!destDir.exists()) {
//            if (!destDir.mkdirs()) {
//                Log.e(TAG, "无法创建目标目录: " + destDir.getAbsolutePath());
//                return false;
//            }
//        }
//        File targetFile = new File(OTA_UPDATE_ZIP_PATH);
//        try (FileInputStream inputStream = new FileInputStream(sourceFile);
//             FileOutputStream outputStream = new FileOutputStream(targetFile)) {
//            byte[] buf = new byte[8192];
//            int length;
//            while ((length = inputStream.read(buf)) > 0) {
//                outputStream.write(buf, 0, length);
//            }
//            outputStream.flush();
//            Log.d(TAG, "文件成功复制到: " + targetFile.getAbsolutePath());
//            return true;
//        } catch (IOException e) {
//            Log.e(TAG, "Failed to copy file", e);
//            return false;
//        }
//    }
//
//    private class UECallback extends UpdateEngineCallback {
//        @Override
//        public void onStatusUpdate(int status, float percent) {
//            if (status == UpdateEngine.UpdateStatusConstants.DOWNLOADING) {
//                int overallProgress = PROGRESS_APPLY_START + (int) (percent * (PROGRESS_COMPLETE - PROGRESS_APPLY_START));
//                String message = "正在升级..." + (int) (percent * 100) + "%";
//                reportProgress(overallProgress, message);
//            }
//        }
//        @Override
//        public void onPayloadApplicationComplete(int errCode) {
//            if (errCode == UpdateEngine.ErrorCodeConstants.SUCCESS) {
//                Log.i(TAG, "Installation succeeded!");
//                reportProgress(PROGRESS_COMPLETE, "升级完成，准备重启");
//                mMainHandler.post(() -> {
//                    if (mListener != null) {
//                        mListener.onRebootRequired();
//                    }
//                });
//            } else {
//                Log.e(TAG, "Installation failed with error code: " + errCode);
//                reportFailure(ERROR_CODE_APPLY_FAILED, "应用升级失败，错误码: " + errCode);
//            }
//        }
//    }
//
//    public void cleanup() {
//        File otaDir = new File(DATA_OTA_PATH);
//        if (otaDir.exists() && otaDir.isDirectory()) {
//            deleteRecursive(otaDir);
//        }
//    }
//    private void deleteRecursive(File fileOrDirectory) {
//        if (fileOrDirectory.isDirectory()) {
//            File[] children = fileOrDirectory.listFiles();
//            if (children != null) {
//                for (File child : children) {
//                    deleteRecursive(child);
//                }
//            }
//        }
//        fileOrDirectory.delete();
//    }
//
//    public void cancelUpdate() {
//        mUpdateEngine.cancel();
//        cleanup();
//    }
//
//    private void reportProgress(int progress, String message) {
//        mMainHandler.post(() -> {
//            if (mListener != null) {
//                mListener.onProgress(progress, message);
//            }
//        });
//    }
//
//    private void reportFailure(int errorCode, String errorMessage) {
//        cleanup();
//        mMainHandler.post(() -> {
//            if (mListener != null) {
//                mListener.onFailure(errorCode, errorMessage);
//            }
//        });
//    }
//}