package com.tyw.colortest.tools;

import android.widget.TextView;
import com.tyw.colortest.bean.InfoDataBean;
import java.util.List;

/**
 * JSON解析使用示例
 * 展示如何将JSON数据解析并显示到TextView上
 */
public class JsonParseExample {

    /**
     * 示例：解析你提供的JSON数据并显示到TextView
     * @param textView 目标TextView
     */
    public static void parseAndShowExample(TextView textView) {
        // 你提供的JSON数据
        String jsonData = "[\n" +
                "  {\n" +
                "    \"text\": \"行人匆忙脚步，\",\n" +
                "    \"color\": \"#33aaff\",\n" +
                "    \"size\": 20,\n" +
                "    \"bold\": true\n" +
                "  },\n" +
                "  {\n" +
                "    \"text\": \"霓虹倒影闪烁。\\n\",\n" +
                "    \"color\": \"#ffbb33\",\n" +
                "    \"size\": 23,\n" +
                "    \"bold\": false\n" +
                "  }\n" +
                "]";

        // 直接将JSON解析并设置到TextView
        HtmlTextUtils.setJsonToTextView(textView, jsonData);
    }

    /**
     * 示例：解析JSON数据（控制台输出）
     */
    public static void parseExample() {
        // 你提供的JSON数据
        String jsonData = "[\n" +
                "  {\n" +
                "    \"text\": \"行人匆忙脚步，\",\n" +
                "    \"color\": \"#33aaff\",\n" +
                "    \"size\": 20,\n" +
                "    \"bold\": true\n" +
                "  },\n" +
                "  {\n" +
                "    \"text\": \"霓虹倒影闪烁。\\n\",\n" +
                "    \"color\": \"#ffbb33\",\n" +
                "    \"size\": 23,\n" +
                "    \"bold\": false\n" +
                "  }\n" +
                "]";

        // 解析JSON数据
        List<InfoDataBean> dataList = InfoDataBean.parseFromJson(jsonData);

        // 使用解析后的数据
        if (dataList != null) {
            for (InfoDataBean item : dataList) {
                System.out.println("文本: " + item.getText());
                System.out.println("颜色: " + item.getColor());
                System.out.println("大小: " + item.getSize());
                System.out.println("加粗: " + item.isBold());
                System.out.println("---");
            }
            
            // 转换为HTML并输出
            String html = HtmlTextUtils.convertToHtml(dataList);
            System.out.println("生成的HTML: " + html);
        }
    }

    /**
     * 创建数据并转换为JSON的示例
     */
    public static String createJsonExample() {
        // 创建InfoDataBean对象
        InfoDataBean item1 = new InfoDataBean("行人匆忙脚步，", "#33aaff", 20, true);
        InfoDataBean item2 = new InfoDataBean("霓虹倒影闪烁。\n", "#ffbb33", 23, false);

        // 转换为JSON
        java.util.List<InfoDataBean> list = java.util.Arrays.asList(item1, item2);
        return InfoDataBean.toJson(list);
    }

    /**
     * 完整的使用示例：从JSON到TextView显示
     * @param textView 目标TextView
     * @param jsonString 要解析的JSON字符串
     */
    public static void fullExample(TextView textView, String jsonString) {
        try {
            // 1. 解析JSON
            List<InfoDataBean> dataList = InfoDataBean.parseFromJson(jsonString);
            
            // 2. 转换为HTML
            String htmlText = HtmlTextUtils.convertToHtml(dataList);
            System.out.println("生成的HTML: " + htmlText);
            
            // 3. 设置到TextView
            HtmlTextUtils.setDataToTextView(textView, dataList);
            
        } catch (Exception e) {
            e.printStackTrace();
            textView.setText("解析失败: " + e.getMessage());
        }
    }
}