/*****************************************************************************
 * Copyright (c) 2022, Nations Technologies Inc.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/

/**
 * @file main.c
 * @author Nations
 * @version v1.0.0
 *
 * @copyright Copyright (c) 2022, Nations Technologies Inc. All rights reserved.
 */
#include "main.h"
#include <stdio.h>
#include <stdint.h>
#include "Sys_Scheduler.h"
#include "RTE.h"
#include "Components.h"
#include "Can_User.h"
#include "userdefine.h"
#include "BackLight.h"
#include "tim.h"
#include "PowerManagement\PowerManagement.h"
void Sys_Startup_Pre_Init(void)
{
#if (HAS_BOOTLOADER == 1u)
    __disable_irq();
    SCB->VTOR = APP_BASE;
    __DMB();
    __enable_irq();
#endif
    __disable_irq();

    /* soft delay, for power to stabilize */
    {
        uint32_t  tmpPowerStabCnt = 20000;

		while ( tmpPowerStabCnt-- ) 
        {  ;  }
    }

    __enable_irq();
    RTE_CLOCK_Select_Start();
}


uint32_t u4Freq = 0;
void Sys_Startup_Init(void)
{
    uint8_t u8StartupMode = 0U;

    uint32_t width = 0;
    uint32_t temp = 0 ;
    __disable_irq();
    RTE_WDT_Enable();
    GenDelay_Init(RTE_WDT_Clear);
    RTE_GPIO_Init(); 

    // TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
    RTE_CAPTURE_KL30_Init();
    Gpio_Init(Gpio_KL30_Init);
    RTE_DEEPSLEEP_GPIO_Interrupt_Disable();
    __enable_irq();

    // Gen_TimeDelay(10000u, 1000u); 
    PwrMemInit( );
    Power_Management_Init(u8StartupMode);
    Can_Init();
    Amt630hInit();

}

/**
 * @brief  Main program.
 */
int main(void)
{

 	Sys_Startup_Pre_Init();
    Sys_Scheduler_Init();
	Sys_Startup_Init();
    while ( 1 )
    {
        
        RTE_WDT_Clear();        
        Sys_Scheduling_Service();
    }
}

/**
 * @brief Assert failed function by user.
 * @param file The name of the call that failed.
 * @param line The source line number of the call that failed.
 */
#ifdef USE_FULL_ASSERT
void assert_failed(const uint8_t* expr, const uint8_t* file, uint32_t line)
{
    while (1)
    {
    }
}
#endif // USE_FULL_ASSERT

/**
 * @}
 */
