#ifndef DATA_COOLANT_H
#define DATA_COOLANT_H

#include "Components.h"

typedef struct
{
    uint16_t Goal;
    uint16_t CoolantTemperatureCurrent;
    uint16_t Time;
} CoolantTemperature;

typedef enum{
    CoolantSensorNormal = 0u,
    CoolantSensorShortCircuit,
    CoolantSensorOpenCircuit,
}CoolantSensorSts_t;

extern void Coolant_KL15_Init(void);
extern void Coolant_KL30_Init(void);
extern void Coolant_Cal_Sevice(uint8_t deltaTime);
extern uint8_t Get_CurCoolantSetp(void);
extern CoolantSensorSts_t Get_Coolant_Sensor_State(void);
extern void Coolant_R_Cal(uint8_t deltaTime);
extern uint8_t Get_CurCoolantRed(void);
extern uint16_t Get_Coolant_Percentage(void);
extern void Coolant_Percentage_Figure(uint8_t deltaTime);
extern void Coolant_Self_InspectionOld(void);

#endif
