#include "Data_Fuel.h"
#include "Components.h"
#include "Backlight.h"
#include "Battery_Voltage.h"
#include "PowerManagement\PowerManag_user.h"

#define FUEL_DATA_TIME 20u /*这里填写多长时间采集一个数据，单位ms*/
#define FUEL_DATA_NUM 20u  /*燃油电阻采集数据总数 最大255*/
#define FUEL_CAL_START 10u  /*数据排序后取中间部分计算平均：起始*/
#define FUEL_CAL_END 20u   /*数据排序后取中间部分计算平均：结束*/

#define RETURN_DIFFERENCE 25u /*判断上升或下降的回差，精度0.1*/

#define FUEL_SEG_UP 0u
#define FUEL_SEG_DOWN 1u

static const uint16_t Fuel_Table_Up [9u] =
    /*显示段：| 0 | 1 |  2   |  3  | 4 |  5  | 6 | 7 | 8 |  ...*/
    {30,160,270,380,490,590,690,800,900};    // 上升时小于等于表值则熄灭相应段

/*** 燃油液位上升表格 ***/
static const uint16_t Fuel_Table_Dn [ 9u ] =
    /*显示段：|    0     |    1     |    2     |    3     |    4     |      ...*/
    {60,190,300,410,520,620,720,830,930};    // 下降时小于等于表值则熄灭相应段

uint16_t g_u16FuelData[FUEL_DATA_NUM];
uint8_t g_u8FuelDataCount = 0u;
uint16_t FuelR = 0u; /*滤波后的燃油电阻，精度0.1*/
uint16_t Fuelvalue_Last = 0;
uint16_t FuelRBak = 0;
uint16_t Fuel_Self_Inspection_Stage = 0u;
uint8_t Timerf = 0u;
uint8_t  Fuel_Self_Last = 0u;
uint8_t g_u8DesFuelSetp = 0u;
uint8_t g_u8DeFuelSetp = 0u;
uint8_t g_u8CurFuelSetp = 0u;
uint8_t g_u8FuelInitFlag = 0u;
uint8_t g_u8FuelEmergency_StopFlag = 0u;
uint8_t g_u8FuelStateInitFlag = 0u;
uint8_t g_u8FuelDir = FUEL_SEG_UP;
uint16_t g_u16FuelSensorNormalTime = 0u;
uint16_t g_u16FuelSensorShortTime = 0u;
uint16_t g_u16FuelSensorOpenTime = 0u;
uint16_t g_u16FuelSensostausTime = 0u;
uint8_t g_u8FuelADCompleteFlg = 0u;
uint32_t  NumChangeTime = 0;
uint32_t NumTime = 0;
static uint16_t g_DropoutTime = 0u;
static uint16_t Fpercentage;
uint8_t g_u8FuelRedFlg = 0u;
static uint16_t Fuelpercentage = 0u;
static uint8_t FuelSensorStaus = 1;
uint8_t Fuel_SensorStaus = 0;
FuelSensorSts_t FuelSensorState = FuelSensorNormal;
uint16_t F_DstSeg = 0u;
FuelOilSensor FuelOilSensorCtrl;
void Fuel_KL30_Init(void)
{
    g_u8DesFuelSetp = 0u;
    g_u8DeFuelSetp = 0u;
    g_u8CurFuelSetp = 0u;
    Fuel_Self_Inspection_Stage = 0u;
    Timerf = 0u;
    Fuel_Self_Last = 0u;
    g_u8FuelInitFlag = 1u;
    FuelSensorStaus = 1;
    g_u8FuelStateInitFlag = 1u;
    g_u8FuelDir = FUEL_SEG_UP;
    FuelSensorState = FuelSensorNormal;
    g_u16FuelSensorNormalTime = 0u;
    g_u16FuelSensorShortTime = 0u;
    g_u16FuelSensorOpenTime = 0u;
    g_u16FuelSensostausTime = 0u;
    NumChangeTime = 0u;
    g_u8FuelADCompleteFlg = 0u;
    g_DropoutTime = 0u;
    g_u8FuelRedFlg = 0u;
    Fuel_SensorStaus = 0;
    Fuelpercentage = 0u;
    Fuelvalue_Last = 0;
    F_DstSeg = 0u;
    g_u8FuelEmergency_StopFlag = 0u;
}

void Fuel_KL15_Init(void)
{
    g_u8DesFuelSetp = 0u;
    g_u8DeFuelSetp = 0u;
    g_u8CurFuelSetp = 0u;
    g_u8FuelInitFlag = 1u;
    Fuel_Self_Inspection_Stage = 0u;
    Timerf = 0u;
    Fuel_Self_Last = 0u;
    FuelSensorStaus = 1;
    g_u8FuelStateInitFlag = 1u;
    g_u8FuelDir = FUEL_SEG_UP;
    FuelSensorState = FuelSensorNormal;
    g_u16FuelSensorNormalTime = 0u;
    g_u16FuelSensorShortTime = 0u;
    g_u16FuelSensorOpenTime = 0u;
    g_u16FuelSensostausTime = 0u;
    NumChangeTime = 0;
    g_u8FuelADCompleteFlg = 0u;
    g_DropoutTime = 0u;
    g_u8FuelRedFlg = 0u;
    Fuel_SensorStaus = 0;
    Fuelpercentage = 0u;
    Fuelvalue_Last = 0;
    F_DstSeg = 0u;
    g_u8FuelEmergency_StopFlag = 0u;
}

void Fuel_R_Cal(uint8_t deltaTime)
{
    uint16_t FuelRes = 0;
    uint8_t i, j;
    uint32_t temp32;
    static uint16_t timeCount = 0;

    if(g_u8FuelStateInitFlag)
    {
        FuelR = ADC_Read_Signal(ADC_CH_FUEL);
    }

    if (timeCount >= FUEL_DATA_TIME)
    {
        timeCount = 0;
        if (g_u8FuelDataCount < FUEL_DATA_NUM)
        {
            /*获取燃油电阻*/
            FuelRes = ADC_Read_Signal(ADC_CH_FUEL);

            /*四舍五入*/
            if (FuelRes < 65535)
            {
                if (FuelRes % 10 >= 5)
                {
                    FuelRes += 5;
                }
            }
            else
            {
                FuelRes = 0xFFFF;
            }
            /*由小到大插入数据*/
            for (i = 0; i < g_u8FuelDataCount; i++)
            {
                if (FuelRes < g_u16FuelData[i])
                {
                    break;
                }
            }
            for (j = g_u8FuelDataCount; j > i; j--)
            {
                g_u16FuelData[j] = g_u16FuelData[j - 1];
            }
            g_u16FuelData[i] = FuelRes;
            g_u8FuelDataCount++;
        }
        else
        {
            /*一组数据采集完毕，取中间部分计算平均值*/
            temp32 = 0;
            for (i = FUEL_CAL_START; i < FUEL_CAL_END; i++)
            {
                temp32 += g_u16FuelData[i];
            }
            FuelR = (uint16_t)(temp32 / (FUEL_CAL_END - FUEL_CAL_START));
            g_u8FuelDataCount = 0;
            g_u8FuelADCompleteFlg = 1;
        }
    }
    timeCount += deltaTime;
}

void Fuel_State_Check(uint8_t deltaTime)
{

    if (FuelR < 30)
    { /*短路3*/
        g_u16FuelSensorOpenTime = 0;
        g_u16FuelSensorNormalTime = 0;
        if(Get_Voltage_Anomaly() == 2u)
        {
            g_u16FuelSensorShortTime = 3001u;
        }
        if (Get_Self() == 1)
        {
            g_u16FuelSensorShortTime = 3001u;
        }
        if ((g_u16FuelSensorShortTime > 3000u) || ((g_u8FuelStateInitFlag) && (g_u16FuelSensorShortTime > 3000u)))
        {
            FuelSensorState = FuelSensorShortCircuit;
            g_u8DesFuelSetp = 0;
            g_u8CurFuelSetp = 8;
            Fuel_SensorStaus = 1;
            g_u8FuelStateInitFlag = 0;
            g_u8FuelInitFlag = 1;
            g_u8FuelDir = FUEL_SEG_UP;
        }
        else
        {
            g_u16FuelSensorShortTime += deltaTime;
        }
    }
    else if (FuelR >= 5000)
    { /*开路 500*/
        g_u16FuelSensorShortTime = 0u;
        g_u16FuelSensorNormalTime = 0u;
        if(Get_Voltage_Anomaly() == 2u)
        {
            g_u16FuelSensorOpenTime = 3001u;
        }
        if (Get_Self() == 1)
        {
            g_u16FuelSensorOpenTime = 3001u;
        }
        if ((g_u16FuelSensorOpenTime > 3000u) || ((g_u8FuelStateInitFlag) && (g_u16FuelSensorOpenTime > 3000u)))
        {
            FuelSensorState = FuelSensorOpenCircuit;
            g_u8DesFuelSetp = 0u;
            g_u8CurFuelSetp = 8u;
            Fuel_SensorStaus = 1u;
            g_u8FuelStateInitFlag = 0u;
            g_u8FuelInitFlag = 1u;
            g_u8FuelDir = FUEL_SEG_UP;
        }
        else
        {
            g_u16FuelSensorOpenTime += deltaTime;
        }
    }
    else
    {
        g_u16FuelSensorShortTime = 0u;
        g_u16FuelSensorOpenTime = 0u;
        FuelSensorState = FuelSensorNormal;
        g_u8FuelStateInitFlag = 0u;
    }
    if (FuelSensorState == FuelSensorNormal)
    {
        if (Fuel_SensorStaus == 1u)
        {
            g_u16FuelSensostausTime += deltaTime;
            if (g_u16FuelSensostausTime > 3000u)
            {
                Fuel_SensorStaus = 0u;
                g_u16FuelSensostausTime = 0u;
            }
            else
            {
                FuelSensorState = FuelSensorOpenCircuit;
                g_u8DesFuelSetp = 8u;
                g_u8CurFuelSetp = 8u;
                g_u8FuelStateInitFlag = 0u;
                g_u8FuelInitFlag = 1u;
                Fuel_SensorStaus = 1u;
                g_u8FuelDir = FUEL_SEG_UP;
            }
        }
        else
        {
            g_u16FuelSensostausTime = 0u;
        }
    }
}

void Fuel_Gauges_Cal(uint8_t deltaTime)
{
    static uint16_t time = 0u;
    static uint16_t Fuel_Value_Last = 0u;

    if ((FuelSensorState == FuelSensorNormal) && (FuelR < 5000u) && (FuelR >= 30u))
    {
        /*采集完第一组数据后，开始计算燃油格数*/

        if (g_u8FuelInitFlag)
        {
            FuelRBak = FuelR;
        }

        if (FuelRBak >= FuelR + RETURN_DIFFERENCE)
        {
            g_u8FuelDir = FUEL_SEG_UP;
            FuelRBak = FuelR;
        }
        if (FuelR < FuelRBak)
        {
            FuelRBak = FuelR;
        }
        if (FuelR < Fuelvalue_Last) // 新燃油液位高于前次燃油液位,查上升表
        {
            while (F_DstSeg)
            {
                if (FuelR > Fuel_Table_Up[F_DstSeg - 1u])
                    break;
                F_DstSeg--;
            }
        }
        else if (FuelR > Fuelvalue_Last) // 新燃油液位低于前次燃油液位,查下降表
        {
            while (F_DstSeg < 9)
            {
                if (FuelR < Fuel_Table_Dn[F_DstSeg])
                    break;
                F_DstSeg++;
            }
        }
        Fuelvalue_Last = FuelR;
        g_u8DesFuelSetp = 9 - F_DstSeg;

        /*IGN ON 5秒/故障恢复后，开始走格  立即指向当前格*/
        if (Common_GetIgnOnTime() >= 2000u)
        {
            time += deltaTime;
            if (g_u8FuelInitFlag)
            {
                g_u8FuelInitFlag = 0u;
                time = 0u;
                g_u8CurFuelSetp = g_u8DesFuelSetp;
            }
            if(g_DropoutTime < 15000u) //自检后立即指示
            {
                g_DropoutTime += deltaTime;
                if( FuelSensorStaus == 1u)
                {
                    FuelSensorStaus = 2u;
                    Fuel_Value_Last = g_u8DesFuelSetp;
                }
                if (Fuel_Value_Last == g_u8DesFuelSetp)
                {
                    g_u8CurFuelSetp = g_u8DesFuelSetp;
                    Fuel_Value_Last = g_u8DesFuelSetp;
                }
            }
            else
            {  
            }
            if (time >= 15000u)
            { /* 15S变化一格 */
                time = 0;
                if (g_u8CurFuelSetp < g_u8DesFuelSetp)
                {
                    g_u8CurFuelSetp++;
                }
                else if (g_u8CurFuelSetp > g_u8DesFuelSetp)
                {
                    g_u8CurFuelSetp--;
                }
            }

            if (g_u8CurFuelSetp == g_u8DesFuelSetp)
            {
                time = 0;
            }
        }
    }
}

void Fuel_Percentage_(uint8_t deltaTime)
{
    static uint16_t  Fuelpercentage_last;
    static uint16_t  FuelpercentageVal;
    if (Fuel_SensorStaus == 1u)
    {
        FuelOilSensorCtrl.FuelOilPreCurrent = 0u;
        FuelpercentageVal = 0u;
        Fuelpercentage = 0u;
        Fpercentage = 0u;
    }
    else
    {
        if ((FuelR < 5000u) && (FuelR >= 900u))
        {
            FuelpercentageVal = ((5000u - FuelR) / 372u);
        }
        else if ((FuelR < 900u) && (FuelR >= 800u))
        {
            FuelpercentageVal = (((900u - FuelR) / 9u)) + 11u;
        }
        else if ((FuelR < 800u) && (FuelR >= 697u))
        {
            FuelpercentageVal = (((800u - FuelR) / 9u)) + 22u;
        }
        else if ((FuelR < 697u) && (FuelR >= 596))
        {
            FuelpercentageVal = (((697u - FuelR) / 9u)) + 33u;
        }
        else if ((FuelR < 596u) && (FuelR >= 495u))
        {
            FuelpercentageVal = (((596u - FuelR) / 9u)) + 44u;
        }
        else if ((FuelR < 495u) && (FuelR >= 396u))
        {
            FuelpercentageVal = (((495u - FuelR) / 9u)) + 55u;
        }
        else if ((FuelR < 396u) && (FuelR >= 277u))
        {
            FuelpercentageVal = ((3960u - (FuelR * 10u)) / 108u) + 66u;
        }
        else if ((FuelR < 277u) && (FuelR >= 169u))
        {
            FuelpercentageVal = ((2770u - (FuelR * 10u)) / 98u) + 77u;
        }
        else if((FuelR < 169u) && (FuelR >= 30u))
        {
            FuelpercentageVal = ((1690u - (FuelR * 10u)) / 126u) + 88u;
            if ((FuelR < 40u))
            {
                FuelpercentageVal = 100u;
            }
        }
        if (g_u8DesFuelSetp != g_u8CurFuelSetp)
        {
            if ((g_u8DeFuelSetp == 1u) || (g_u8DeFuelSetp == 2u))
            {
                NumTime += deltaTime;
            }
            else
            {                
                if (g_u8DesFuelSetp > g_u8CurFuelSetp)
                {
                    g_u8DeFuelSetp = 1u;
                    NumChangeTime = ((g_u8DesFuelSetp - g_u8CurFuelSetp)) * 15000u;
                    NumChangeTime = NumChangeTime / (FuelpercentageVal - Fuelpercentage);
                }
                else
                {
                    g_u8DeFuelSetp = 2u;
                    NumChangeTime = ((g_u8CurFuelSetp - g_u8DesFuelSetp)) * 15000u;
                    NumChangeTime = NumChangeTime / (Fuelpercentage - FuelpercentageVal);
                }
            }
            
            if (NumTime > NumChangeTime)
            {
                if (g_u8DesFuelSetp > g_u8CurFuelSetp)
                {
                    Fuelpercentage += 1u;
                }
                else
                {
                    Fuelpercentage -= 1u;
                }
                NumTime = 0u;
            }
            
            if (g_u8DeFuelSetp == 1)
            {
                if (FuelpercentageVal > Fpercentage)
                {
                //     if (g_u8FuelEmergency_StopFlag < 1)
                //     {
                        Fpercentage = Fuelpercentage;
                    // }
                }
                else
                {
                    // g_u8FuelEmergency_StopFlag++;
                }
            }
            if (g_u8DeFuelSetp == 2)
            {
                if (FuelpercentageVal < Fpercentage)
                {
                    // if (g_u8FuelEmergency_StopFlag < 1)
                    // {
                        Fpercentage = Fuelpercentage;
                    // }
                }
                else
                {
                    // g_u8FuelEmergency_StopFlag++;
                }
            }
        }
        else
        {
            g_u8FuelEmergency_StopFlag = 0u;
            Fuelpercentage = FuelpercentageVal;
            NumTime = 0;
            NumChangeTime = 0;
            g_u8DeFuelSetp = 0;
        }
    }

    if ((Get_Self() == 1u) || (g_u16FuelSensostausTime == 3000u))
    {
        if ((FuelR < 5000u) && (FuelR >= 900u))
        {
            FuelpercentageVal = ((5000u - FuelR) / 372u);
        }
        else if ((FuelR < 900u) && (FuelR >= 800u))
        {
            FuelpercentageVal = (((900u - FuelR) / 9u)) + 11u;
        }
        else if ((FuelR < 800) && (FuelR >= 697))
        {
            FuelpercentageVal = (((800u - FuelR) / 9u)) + 22u;
        }
        else if ((FuelR < 697u) && (FuelR >= 596u))
        {
            FuelpercentageVal = (((697u - FuelR) / 9u)) + 33u;
        }
        else if ((FuelR < 596u) && (FuelR >= 495u))
        {
            FuelpercentageVal = (((596u - FuelR) / 9u)) + 44u;
        }
        else if ((FuelR < 495u) && (FuelR >= 396u))
        {
            FuelpercentageVal = (((495u - FuelR) / 9u)) + 55u;
        }
        else if ((FuelR < 396u) && (FuelR >= 277u))
        {
            FuelpercentageVal = ((3960u - (FuelR * 10u)) / 108u) + 66u;
        }
        else if ((FuelR < 277u) && (FuelR >= 169u))
        {
            FuelpercentageVal = ((2770u - (FuelR * 10u)) / 98u) + 77u;
        }
        else if ((FuelR < 169u) && (FuelR >= 30u))
        {
            FuelpercentageVal = ((1690u - (FuelR * 10u)) / 126u) + 88u;
            if ((FuelR < 40u))
            {
                FuelpercentageVal = 100u;
            }
        }
      FuelOilSensorCtrl.FuelOilPreCurrent =  FuelpercentageVal;
      Fuelpercentage =  FuelpercentageVal;
    }
    if (Fuelpercentage >= Fuelpercentage_last) // 上升
    {
        Fpercentage = Fuelpercentage;
        Fuelpercentage_last = Fuelpercentage;
    }
    else // 下降
    {
        if (((Fuelpercentage_last - Fuelpercentage) > 2u) || (Fpercentage == 0u))
        {
            Fpercentage = Fuelpercentage;
            Fuelpercentage_last = Fuelpercentage;
        }
        else // 保持上一状态
        {
            Fpercentage = Fuelpercentage_last;
        }
    }
    if (Fpercentage > 100u)
    {
        Fpercentage = 100u;
    }
    FuelOilSensorCtrl.Fuel_Goal = Fpercentage;
    Duty_Cycle_Delta(FuelOilSensorCtrl.Fuel_Goal, &FuelOilSensorCtrl.FuelOilPreCurrent, &FuelOilSensorCtrl.Time);
}



/*100ms*/
void Fuel_Cal_Sevice(uint8_t deltaTime)
{
    /*检测燃油电阻状态*/
    Fuel_State_Check(deltaTime);

    /*显示燃油格*/
    Fuel_Gauges_Cal(deltaTime);
    /*燃油百分比*/
    Fuel_Percentage_(deltaTime);
}
void Fuel_Self_InspectionOld(void)
{

    if (Get_Voltage_Anomaly() == 2u)
    {
    }
    else
    {
        if (Common_Get_IG_Sts() == COMMON_POWER_OFF)
        {
            Fuel_Self_Inspection_Stage = 0u;
            Timerf = 0u;
        }
        else
        {
            if (Get_Dis_Old_Staus() == 3u)
            {
                Timerf = 0u;
            }
            Fuel_Self_Inspection_Stage = 1u;
            if (Timerf <= 20u)
            {
                FuelSensorState = FuelSensorNormal;
                g_u8CurFuelSetp = 0;
                 if (GetLcdInitSt() == 1u)
                {
                    if (Get_Uptime_Staus() == 1u)
                    {
                        Timerf++;
                    }
                }
                if (Timerf >= 3u)
                {
                    if (Fuel_Self_Inspection_Stage == 1u)
                    {
                        if (Timerf <= 10u)
                        {
                            Fuel_Self_Last = ((Timerf ) * 100u) / 125u;
                            g_u8CurFuelSetp = Fuel_Self_Last;
                        }
                        else
                        {
                            Fuel_Self_Last = 8u - (((Timerf - 10u) * 100u) / 125u);
                            g_u8CurFuelSetp = Fuel_Self_Last;
                        }
                    }
                }
            }
            else
            {
                Fuel_Self_Inspection_Stage = 2u;
            }
        }
    }
}

/*0正常，1红色*/
uint8_t Get_CurFuelRed(void)
{
    return g_u8FuelRedFlg;
}
/*返回百分比%*/
uint8_t Get_Fuel_Percentage(void)
{
    return (uint8_t)FuelOilSensorCtrl.FuelOilPreCurrent;
}
/*格数*/
uint8_t Get_CurFuelSetp(void)
{
    return g_u8CurFuelSetp;
}
/*状态*/
FuelSensorSts_t Get_Fuel_Sensor_State(void)
{
    return FuelSensorState;
}