#ifndef DATA_FUEL_H
#define DATA_FUEL_H

// #include "Components.h"
#include "stdint.h"

typedef struct{
    uint16_t Fuel_Goal;
    uint16_t FuelOilPreCurrent;
    uint16_t Time;
} FuelOilSensor;


typedef enum{
    FuelSensorNormal = 0,
    FuelSensorShortCircuit,
    FuelSensorOpenCircuit,
}FuelSensorSts_t;

extern void Fuel_KL15_Init(void);
extern void Fuel_KL30_Init(void);
extern void Fuel_Cal_Sevice(uint8_t deltaTime);
extern uint8_t Get_CurFuelSetp(void);
extern FuelSensorSts_t Get_Fuel_Sensor_State(void);
extern void Fuel_R_Cal(uint8_t deltaTime);
extern uint8_t Get_Fuel_Percentage(void);
extern uint8_t Get_CurFuelRed(void);
// extern void Fuel_Percentage(uint8_t deltaTime);
void Fuel_Self_InspectionOld(void);
#endif
