#ifndef _GPIOUSER_H_
#define _GPIOUSER_H_

#define GpioOut_High RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_HIGH
#define GpioOut_Low RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_LOW
/* GPIO映射 */
#define ABS_Faulty_lights          RTE_GPIO_PORT00_PIN00   
#define KL15_AD_IN                 RTE_GPIO_PORT00_PIN01   
#define MCU_SPI_MOSI               RTE_GPIO_PORT00_PIN02   
#define MCU_SPI_MISO               RTE_GPIO_PORT00_PIN03   
#define MCU_SPI_CLK                RTE_GPIO_PORT00_PIN04   
#define HighBeam_P_In              RTE_GPIO_PORT00_PIN05   
#define VSPEED_TEN_OUT             RTE_GPIO_PORT00_PIN06   

// #define Blacklight_PWM             RTE_GPIO_PORT01_PIN00   //ljs
#define Buzzer_X                   RTE_GPIO_PORT01_PIN01   
#define LIN_TXD_ESP                RTE_GPIO_PORT01_PIN02   
#define Gears_N_MCU                RTE_GPIO_PORT01_PIN03   
#define ABS_Faulty_lights_MCU      RTE_GPIO_PORT01_PIN04   
#define Oil_Pressure_MUC           RTE_GPIO_PORT01_PIN05  //机油压力 
#define ESPEED_TEN_IN              RTE_GPIO_PORT01_PIN06   
#define VSPEED_TEN_IN              RTE_GPIO_PORT01_PIN07   

#define AVDD                       RTE_GPIO_PORT02_PIN00   
#define GND                        RTE_GPIO_PORT02_PIN01   
#define KL30_AD_MCU_IN             RTE_GPIO_PORT02_PIN02     //ljs 
#define KL15_AD_MCU_IN             RTE_GPIO_PORT02_PIN03     //ljs
#define A_NTC_IN                   RTE_GPIO_PORT02_PIN04   
#define A_FuelSender_BitSNSR1_IN   RTE_GPIO_PORT02_PIN05   
#define A_WaterTemp_IN             RTE_GPIO_PORT02_PIN06   
#define A_FULESTANDARDBitSW1_IN    RTE_GPIO_PORT02_PIN07   

#define MAINTENANCE_LAMP_OUT       RTE_GPIO_PORT03_PIN00   
#define L_FuelSender_OUT           RTE_GPIO_PORT03_PIN01   

#define SWDIO_JTMS                 RTE_GPIO_PORT04_PIN00   
#define Start_stop_MCU             RTE_GPIO_PORT04_PIN01   
#define SELECT_MCU                 RTE_GPIO_PORT04_PIN02   
#define VCC1V2_AMT_EN              RTE_GPIO_PORT04_PIN03      //ljs

#define CAN_MCU_RXD                RTE_GPIO_PORT05_PIN00   
#define CAN_MCU_TXD                RTE_GPIO_PORT05_PIN01   
#define CAN_STB_MCU                RTE_GPIO_PORT05_PIN02   
#define HighBeam_MCU               RTE_GPIO_PORT05_PIN03   
#define LeftTurn_MUC_OUT           RTE_GPIO_PORT05_PIN04   
#define RightTurn_MUC_OUT          RTE_GPIO_PORT05_PIN05   

#define IIC_SCL_24G16              RTE_GPIO_PORT06_PIN00   
#define IIC_SDA_24G16              RTE_GPIO_PORT06_PIN01   
#define IIC_SCL_3004               RTE_GPIO_PORT06_PIN02   
#define IIC_SDA_3004               RTE_GPIO_PORT06_PIN03   

#define Brake_Level_MCU            RTE_GPIO_PORT07_PIN00   
#define KEY_SELECT_MCU             RTE_GPIO_PORT07_PIN01   
#define KEY_OK_MCU                 RTE_GPIO_PORT07_PIN02   
#define MCU_Hand_Brake             RTE_GPIO_PORT07_PIN03       //ljs
#define Dipped_Head_Light_MUC      RTE_GPIO_PORT07_PIN04   
#define Width_Lamp_MCU             RTE_GPIO_PORT07_PIN05       //位置灯
#define RXD_2                      RTE_GPIO_PORT07_PIN06       //ljs
#define TXD_2                      RTE_GPIO_PORT07_PIN07       //ljs

#define L_BiasBitSW_POW            RTE_GPIO_PORT12_PIN00 
#define MCU_XI                     RTE_GPIO_PORT12_PIN01 
#define MCU_XO                     RTE_GPIO_PORT12_PIN02 
#define X32768_IN                  RTE_GPIO_PORT12_PIN03 
#define X32768_OUT                 RTE_GPIO_PORT12_PIN04 

#define MCU_SPI_CS                 RTE_GPIO_PORT13_PIN00 
#define RESEVER5_OUT_LOW           RTE_GPIO_PORT13_PIN06 
#define SWCLK                      RTE_GPIO_PORT13_PIN07 

#define VCC_33_EN_MCU              RTE_GPIO_PORT14_PIN00        //ljs
#define KEY_MCU                    RTE_GPIO_PORT14_PIN01 
#define A_Version                  RTE_GPIO_PORT14_PIN06 
#define Engine_Failure_MCU         RTE_GPIO_PORT14_PIN07 

typedef enum
{
    Gpio_KL30_Init = 0,
    Gpio_WakeUp_Init,
    Gpio_Sleep_Init,
    Gpio_Uvalid,
}_GpioUser_Enum;

extern void Gpio_Init(_GpioUser_Enum InitMode);

#endif
