
#include "Services_Mileage_User.h"
#include "Services_Mileage.h"
#include "eepromManage.h"
#include <string.h>
#include "Common_Interface.h"
#include "Services_Mileage.h"

uint8_t DataMilleageBuf [ Data_MEM_Block_Mileage ];
uint8_t DataODOBuf [ Data_MEM_Block_ODO ];
uint8_t DataTripBuf [ Data_MEM_Block_Trip * EM_TRIP_MAX ];
Mileage_t g_WriteMileage;

Mileage_t           g_ReadMileage;
uint8_t             odo_writeState;
uint8_t             odo_readState;
static uint32_t     Data_User_EEPROM_Read(uint16_t u16BlockID, uint32_t u32Data [], uint16_t u16Len);
static void         Data_User_EEPROM_Write(Data_EEPROM_Enum_t BlockID, uint32_t u32Data [], uint16_t u16Len);

#define EEPROM_BLOCK_00 0X00
#define EEPROM_BLOCK_01 0X16
#define EEPROM_BLOCK_02 0X32
#define EEPROM_BLOCK_03 0X48
#define EEPROM_BLOCK_04 0X64
#define EEPROM_BLOCK_05 0X80
#define EEPROM_BLOCK_06 0X90

uint32_t Milleage_InitFlag = 0U;
uint32_t RiskStop_Flag = 0u;

uint8_t ChangAn_ODOClear_Sts;
uint8_t ChangAn_ODOClear_Timer;
uint8_t ChangAn_ODOClear;

/******************************************************************************
  Function：Data_ODO_KL30Init
  Description：
  Input:
  Output:
 ******************************************************************************/
void Data_User_Mileage_KL30Init(void)
{
    uint32_t       TempBuf [ 8 ]  = {0};
    Mileage_Init_t MileInit       = {0};
    Mileage_Func_t Func           = {0};
    ODO_Init_t     ODOInit        = {0};
    EngODO_Init_t  EngODOInit     = {0};
    Trip_Init_t    TripInit [ 4 ] = {0};
    Milleage_InitFlag             = 0U;
    //�������ݴ�EEPROM�ж�ȡ
    ( void )Data_User_EEPROM_Read(EM_MILEAGE_BLOCK, TempBuf, 1);
    if ( TempBuf [ 0 ] == 0xFFFFFFFF )
    {
        MileInit.Mileage = 0u;
    }
    else
    {
        MileInit.Mileage = TempBuf [ 0 ];
    }
    Func.Get_Sys_IG_Sts        = Common_Get_IG_Sts;
    Func.Get_Act_V_Speed_Valid = Common_Get_Act_V_Speed_Valid;
    Func.Get_Act_V_Speed       = Common_Get_Act_V_Speed;
    Func.Get_TireSize          = ( void          *)0;
    Func.EEPromWrite_Cbk       = Data_User_EEPROM_Write;    //��ʱδ����
    Data_Mileage_KL30_Init(DataMilleageBuf, &MileInit, &Func);

    ( void )Data_User_EEPROM_Read(EM_ODO_BLOCK, TempBuf + 1, 2);
    if ( TempBuf [ 1 ] == 0xFFFFFFFF )
    {
        ODOInit.Stamp = 0;
    }
    else
    {
        ODOInit.Stamp = TempBuf [ 1 ];
    }
    if ( TempBuf [ 1 ] == 0xFFFFFFFF )
    {
        ODOInit.Offset = 0;
    }
    else
    {
        ODOInit.Offset = TempBuf [ 2 ];
    }
    ODOInit.MaxValue = 16093439; //999999.0mile
    Data_ODO_KL30_Init(DataODOBuf, &ODOInit, Func.EEPromWrite_Cbk);

    ( void )Data_User_EEPROM_Read(EM_TRIP_BLOCK, TempBuf + 3, 4);
    TripInit [ EM_TRIP_A ].Stamp     = 0xFFFFFFFFu;
    TripInit [ EM_TRIP_A ].MaxValue  = 1609343;//99999.9mile
    TripInit [ EM_TRIP_A ].IsRestart = 1u;

    TripInit [ EM_TRIP_B ].Stamp     = 0xFFFFFFFFu;//99999.9mile
    TripInit [ EM_TRIP_B ].MaxValue  = 1609343;
    TripInit [ EM_TRIP_B ].IsRestart = 1u;

    TripInit [ EM_TRIP_C ].Stamp     = 0xFFFFFFFFu;//99999.9mile
    TripInit [ EM_TRIP_C ].MaxValue  = 1609343;
    TripInit [ EM_TRIP_C ].IsRestart = 1u;

    TripInit [ EM_TRIP_D ].Stamp     = 0xFFFFFFFFu;//99999.9mile
    TripInit [ EM_TRIP_D ].MaxValue  = 1609343;
    TripInit [ EM_TRIP_D ].IsRestart = 1u;
    Data_Trip_KL30_Init(DataTripBuf, TripInit, EM_TRIP_MAX, Func.EEPromWrite_Cbk);

    Milleage_InitFlag = 0X5AA53AA3UL;
    RiskStop_Flag = 0;
    ChangAn_ODOClear_Sts = 0xAA;
    ChangAn_ODOClear_Timer = 0;
}

void Data_User_Mileage_WakeupInit(void)
{
    Mileage_Func_t Func = {0};
    Milleage_InitFlag             = 0U;

    Func.Get_Sys_IG_Sts        = Common_Get_IG_Sts;
    Func.Get_Act_V_Speed_Valid = Common_Get_Act_V_Speed_Valid;
    Func.Get_Act_V_Speed       = Common_Get_Act_V_Speed;
    Func.Get_TireSize          = ( void          *)0;
    Func.EEPromWrite_Cbk       = Data_User_EEPROM_Write;    //��ʱδ����
    Data_Mileage_Wakeup_Init(DataMilleageBuf, &Func);

    Data_ODO_Wakeup_Init(DataODOBuf, Func.EEPromWrite_Cbk);

    Data_Trip_Wakeup_Init(DataTripBuf, EM_TRIP_MAX, Func.EEPromWrite_Cbk);
    Milleage_InitFlag = 0X5AA53AA3UL;
    RiskStop_Flag = 0;
}


uint32_t Get_MileageInit_Status(void)
{
    return Milleage_InitFlag;
}

static uint32_t Data_User_EEPROM_Read(uint16_t u16BlockID, uint32_t u32Data [], uint16_t u16Len)
{
    switch ( u16BlockID )
    {
        case EM_MILEAGE_BLOCK:
            odo_readState = eeprom_ReadODO(&g_ReadMileage);
            u32Data [ 0 ] = g_ReadMileage.Odo;
            // g_EngineRunMileage = g_ReadMileage.Trip;
            // eeprom_ReadRecord(EEPROM_BLOCK_00, ( uint8_t * )u32Data, u16Len * 4);
            break;
        
        case EM_ODO_BLOCK:
            eeprom_ReadRecord(EEPROM_BLOCK_01, ( uint8_t * )u32Data, u16Len * 4);
            break;

        case EM_TRIP_BLOCK:
            eeprom_ReadRecord(EEPROM_BLOCK_03, ( uint8_t * )u32Data, u16Len * 4);
            break;

        default:
            break;
    }

    return 0;
}

static void Data_User_EEPROM_Write(Data_EEPROM_Enum_t BlockID, uint32_t u32Data [], uint16_t u16Len)
{
    uint8_t i = 0u;

    switch ( BlockID )
    {
        case EM_MILEAGE_BLOCK:
            if ( u32Data [ 0 ] == 0 )
            {
                eeprom_ClearOdoSection( );
            }
            else
            {
                g_WriteMileage.Odo = u32Data [ 0 ];
                // g_WriteMileage.Trip = 0;
                g_WriteMileage.IsTripClear = 0;
                // g_WriteMileage.Trip = g_EngineRunMileage;
                odo_writeState = WRITE_FAIL;
                if(g_WriteMileage.Odo % 10 == 0)
                {
                     while(odo_writeState != WRITE_COMPLETE)
                    {
                        odo_writeState     = eeprom_WriteODO(&g_WriteMileage, distance_1000m, 1);
                        i++;
                        if(i > 10)
                        {
                            break;
                        }
                    }
                }
            }
            // eeprom_WriteRecord(EEPROM_BLOCK_00, ( uint8_t * )u32Data, u16Len * 4);
            break;

        case EM_ODO_BLOCK:
            eeprom_WriteRecord(EEPROM_BLOCK_01, ( uint8_t * )u32Data, u16Len * 4);
            break;

        case EM_TRIP_BLOCK:
            eeprom_WriteRecord(EEPROM_BLOCK_03, ( uint8_t * )u32Data, u16Len * 4);
            break;

        default:
            break;
    }
}

void Services_Mileage_Callback(void)
{
    Data_Mileage_ISR( );
}

