
#ifndef TELLTALES_USER_H
#define TELLTALES_USER_H
#include "common.h"

typedef enum
{
    m_LED_RIGHT,           //左转向
    m_LED_LEFT,            //右转向
    m_LED_HI_BEAM,         //远光灯
    m_LED_MIL,             //发动机故障
    m_LED_ABS,             //ABS故障
    m_LED_TSC,             //TSC
    m_LED_AutoStarStop,    //自动启停
    m_LED_Batterylow,      //蓄电池电压报警
    m_LED_Auto_HI_BEAM,    //自动远光灯（预留）
    m_LED_Shore,           //边撑状态
    m_LED_ENGINE_OIL_LOW,  //机油压力报警灯（预留）
    m_LED_TPMS,            //胎压功能（预留）
    m_LED_READY,           //READY
    m_LED_Fuel,            //燃油
    m_LED_Temp,            //水温

    LED_Max,
} LED_Idx_t;


uint16_t LED_RIGHT_Judgement(void);
void    LED_RIGHT_Execution(uint16_t led_status);
uint16_t LED_LEFT_Judgement(void);
void    LED_LEFT_Execution(uint16_t led_status);
uint16_t LED_HI_BEAM_Judgement(void);
void    LED_HI_BEAM_Execution(uint16_t led_status);
uint16_t LED_MIL_Judgement(void);
void    LED_MIL_Execution(uint16_t led_status);
uint16_t LED_ABS_Judgement(void);
void    LED_ABS_Execution(uint16_t led_status);
uint16_t LED_TSC_Judgement(void);
void    LED_TSC_Execution(uint16_t led_status);
uint16_t LED_AutoStarStop_Judgement(void);
void    LED_AutoStarStop_Execution(uint16_t led_status);
uint16_t LED_Batterylow_Judgement(void);
void    LED_Batterylow_Execution(uint16_t led_status);
uint16_t LED_Auto_HI_BEAM_Judgement(void);
void    LED_Auto_HI_BEAM_Execution(uint16_t led_status);
uint16_t LED_Shore_Judgement(void);
void    LED_Shore_Execution(uint16_t led_status);
uint16_t LED_ENGINE_OIL_LOW_Judgement(void);
void    LED_ENGINE_OIL_LOW_Execution(uint16_t led_status);
uint16_t LED_TPMS_Judgement(void);
void    LED_TPMS_Execution(uint16_t led_status);
uint16_t LED_READY_Judgement(void);
void    LED_READY_Execution(uint16_t led_status);
uint16_t LED_Fuel_Judgement(void);
void    LED_Fuel_Execution(uint16_t led_status);
uint16_t LED_Temp_Judgement(void);
void    LED_Temp_Execution(uint16_t led_status);



void Telltales_Init(void);

#endif
