#include "CAN_Communication_Matrix.h"
#include "CAN_User.h"
#include "Menus.h"
/* 2022/01/19 15:02:57 */

const st_CAN_SendAttribute    st_CANSendAttr[ID_SEND_TOTAL] =
{
	{0x105ul,  8ul * 1000ul, 1ul,  0u, MSG_STD, 2u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_105},
    {0x51Cul,  8ul * 1000ul, 3ul,  0u, MSG_STD, 3u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_51C},
    {0x522ul, 48ul * 1000ul, 7ul,  0u, MSG_STD, 4u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_522},
    {0x523ul, 48ul * 1000ul, 11ul, 0u, MSG_STD, 5u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_523},
    {0x510ul, 18ul * 1000ul, 17ul, 0u, MSG_STD, 6u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_510},
	  {0x450ul, 98ul * 1000ul, 23ul, 0u, MSG_STD, 7u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_450},
    {0x515ul, 48ul * 1000ul, 29ul, 0u, MSG_STD, 7u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_515},
	//{0x502ul, 98ul * 1000ul, 48ul, 0u, MSG_STD, 8u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_502},//̥ѹԤ
};




const st_CANMsgAttribute CAN_MSG_CONST_ARRAY[ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x125ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x401ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x111ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x101ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x402ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x113ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
};

uint8_t  Get_ID_125_Sig_TCS_SysState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TCS_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_125_Sig_TCS_WorkMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TCS_Count, 2u) >> 3u) & 0x0Fu));
}

uint8_t  Get_ID_125_Sig_TCS_WarningLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TCS_Count, 4u) >> 0u) & 0x01u));
}

uint8_t  Get_ID_401_Sig_ECU_Battery_Voltage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_ECU_Battery_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_111_Sig_ISG_SideStand(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_ISG_Count, 4u) >> 3u) & 0x01u));
}

uint8_t  Get_ID_111_ISG_Power_Enable(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_ISG_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_111_ISG_Ready(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_ISG_Count, 4u) >> 1u) & 0x01u));
}

uint8_t  Get_ID_12B_RearVehicle_Speed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_ECU_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_12B_RearVehicle_Speed_Valid(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_ECU_Count, 4u) >> 7u) & 0xFFu));
}




uint8_t  Get_ID_101_ECU_Vehicle_Speed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_ECU_Count, 2u) >> 0u) & 0xFFu));
}


uint16_t  Get_ID_101_ECU_Engine_Temperature(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_ECU_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_ECU_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_101_ECU_Engine_Temperature_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_ECU_Count, 6u) >> 7u) & 0x01u));
}

uint16_t  Get_ID_402_ECU_DTC1(void)
{
    //return ((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    //((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 1u) >> 0u) & 0xFFu);
}

uint16_t  Get_ID_402_ECU_DTCH1(void)
{
    //return ((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 0u) >> 0u) & 0xFFu) << 8u);
    return  ((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 0u) >> 0u) & 0xFFu);
}
uint16_t Get_ID_402_ECU_DTCM1(void)
{
	return  ((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 1u) >> 0u) & 0xFFu);
}

uint16_t Get_ID_402_ECU_DTCL1(void)
{
	return	((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 2u) >> 0u) & 0xFFu);
}



uint8_t  Get_ID_402_ECU_DTC1Amnt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_ECU_DTC_Count, 3u) >> 0u) & 0xFFu));
}

uint16_t  Get_ID_402_ECU_DTC2(void)
{
    //return ((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    //((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 5u) >> 0u) & 0xFFu);
}

uint16_t  Get_ID_402_ECU_DTCH2(void)
{
    //return ((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 4u) >> 0u) & 0xFFu) << 8u);
    return  ((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 4u) >> 0u) & 0xFFu);
}
uint16_t Get_ID_402_ECU_DTCM2(void)
{
	return  ((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 5u) >> 0u) & 0xFFu);
}

uint16_t Get_ID_402_ECU_DTCL2(void)
{
	return	((uint32_t)((uint32_t)CAN_MSG_Read(ID_ECU_DTC_Count, 6u) >> 0u) & 0xFFu);
}



uint8_t  Get_ID_113_Tbatt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_ISG_BATT_Count, 2u) >> 0u) & 0xFFu));
}



uint8_t  Co_Can_ConvertSubID(uint32_t MsgID)
{
    uint8_t u8Result = ID_TOTAL_MAX;
    switch (MsgID)
    {
    case ID_TCS:
        u8Result = ID_TCS_Count;
        break;
    case ID_ECU_Battery:
        u8Result = ID_ECU_Battery_Count;
        break;
    case ID_ISG:
        u8Result = ID_ISG_Count;
        break;
    case ID_ECU:
        u8Result = ID_ECU_Count;
        break;
    case ID_ECU_DTC:
        u8Result = ID_ECU_DTC_Count;
        break;
    case ID_ISG_BATT:
        u8Result = ID_ISG_BATT_Count;
        break;
    }
    return u8Result;
}

