#ifndef CAN_COMMUNICATION_MATRIX_H_
#define CAN_COMMUNICATION_MATRIX_H_

#include "common.h"
#include "CAN_Lib.h"

typedef enum
{
    ID_TCS_Count,
    ID_ECU_Battery_Count,
    ID_ISG_Count,
    ID_ECU_Count,
    ID_ECU_DTC_Count,
    ID_ISG_BATT_Count,

    ID_TOTAL_MAX,
} CAN_MSG_ID_t;

typedef enum
{
    ID_ICM_SEND1 = 0,
    ID_ICM_SEND2 ,
    ID_ICM_SEND3 ,
    ID_ICM_SEND4 ,
    ID_ICM_SEND5 ,
    ID_ICM_SEND6 ,
    //ID_ICM_SEND7 ,
    ID_SEND_TOTAL,
} CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_MSG_CONST_ARRAY[ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    st_CANSendAttr[ID_SEND_TOTAL] ;

#define  ID_TCS                       0x125u
#define  ID_ECU_Battery               0x401u
#define  ID_ISG                       0x111u
#define  ID_ECU                       0x101u
#define  ID_ECU_DTC                   0x402u
#define  ID_ISG_BATT                  0x113u

extern uint8_t  Get_ID_125_Sig_TCS_SysState(void);
extern uint8_t  Get_ID_125_Sig_TCS_WorkMode(void);
extern uint8_t  Get_ID_125_Sig_TCS_WarningLamp(void);
extern uint8_t  Get_ID_401_Sig_ECU_Battery_Voltage(void);
extern uint8_t  Get_ID_111_Sig_ISG_SideStand(void);
extern uint8_t  Get_ID_111_ISG_Power_Enable(void);
extern uint8_t  Get_ID_111_ISG_Ready(void);
extern uint8_t  Get_ID_101_ECU_Vehicle_Speed(void);
extern uint8_t  Get_ID_12B_RearVehicle_Speed(void);
extern uint16_t  Get_ID_101_ECU_Engine_Temperature(void);
extern uint8_t  Get_ID_101_ECU_Engine_Temperature_State(void);
extern uint16_t  Get_ID_402_ECU_DTC1(void);
extern uint8_t  Get_ID_402_ECU_DTC1Amnt(void);
extern uint16_t  Get_ID_402_ECU_DTC2(void);
extern uint8_t  Get_ID_113_Tbatt(void);

extern uint8_t  Co_Can_ConvertSubID(uint32_t MsgID);

#endif
