#include "CoolantTemp.h"
#include "Flash_synchronizer.h"
#include "Common_Interface.h"
#include "CAN_User.h"
#include "CAN_Communication_Matrix.h"

#define COOLANT_TEMP_RETURN_DIFFERENCE       3  //80u     /*判断上升或下降的回差，精度1*/

#define COOLANT_TEMP_SEG_UP       0u
#define COOLANT_TEMP_SEG_DOWN     1u



int16_t CoolantTempValue = 0u; 
static int16_t CoolantTempValueBak = 0;

uint8_t DesCoolantTempSetp = 0u;
uint8_t CurCoolantTempSetp = 0u;
uint8_t CoolantTempInitFlag = 0u;
uint8_t CoolantTempDir = COOLANT_TEMP_SEG_UP;
CoolantTempSensorSts_t CoolantTempSensorState = CoolantTempSensorNormal;
uint16_t CoolantTempSensorNormalTime = 0u;
uint16_t CoolantTempSensorShortTime = 0u;
uint16_t CoolantTempSensorOpenTime = 0u;
static uint8_t CoolantTempAlarm = 0u;
uint16_t CoolantTemp_Signal_Time = 0;
uint8_t CoolantTemp_Signal_Connect = 0;

void CoolantTemp_KL30_Init(void)
{


}

void CoolantTemp_KL15_Init(void)
{
    DesCoolantTempSetp = 0u;
    CurCoolantTempSetp = 0u;
    CoolantTempInitFlag = 1u;
    CoolantTempDir = COOLANT_TEMP_SEG_UP;
    CoolantTempSensorState = CoolantTempSensorNormal;
    CoolantTempSensorNormalTime = 0u;
    CoolantTempSensorShortTime = 0u;
    CoolantTempSensorOpenTime = 0u;   
    CoolantTempAlarm = 0;
    CoolantTemp_Signal_Time = 0;
    CoolantTemp_Signal_Connect = 0;
    CoolantTempValue = -273;
    CoolantTempValueBak = -273;

}


void CoolantTemp_State_Check(uint8_t deltaTime)
{
    
    if(CoolantTempValue >= 135){  /*短路*/
        CoolantTempSensorOpenTime = 0;
        CoolantTempSensorNormalTime = 0;
        if(CoolantTempSensorShortTime < 3000){
            CoolantTempSensorShortTime += deltaTime;
        }
        else{
            CoolantTempSensorState = CoolantTempSensorShortCircuit;
            CurCoolantTempSetp = 0;
            DesCoolantTempSetp = 0;
            CoolantTempInitFlag = 1;
            CoolantTempDir = COOLANT_TEMP_SEG_UP;
        }
    }
    else if(CoolantTempValue < -30){   /*断路*/
        CoolantTempSensorShortTime = 0;
        CoolantTempSensorNormalTime = 0;
        if(CoolantTempSensorOpenTime < 3000){
            CoolantTempSensorOpenTime += deltaTime;
        }
        else{
            CoolantTempSensorState = CoolantTempSensorOpenCircuit;
            CurCoolantTempSetp = 0;
            DesCoolantTempSetp = 0;   
            CoolantTempInitFlag = 1;
            CoolantTempDir = COOLANT_TEMP_SEG_UP;
        }

    }
    else{
        CoolantTempSensorShortTime = 0;
        CoolantTempSensorOpenTime = 0;
        if(CoolantTempSensorNormalTime < 3000){
            CoolantTempSensorNormalTime += deltaTime;
        }
        else{
            CoolantTempSensorState = CoolantTempSensorNormal;
        }
    }

    if ((Get_ID_402_ECU_DTC1() == 0x0117) || (Get_ID_402_ECU_DTC2() == 0x0117))
    {
        CoolantTempSensorState = CoolantTempSensorShortCircuit;
        CoolantTempSensorShortTime = 0;
        CoolantTempSensorOpenTime = 0;
        CoolantTempSensorNormalTime = 3000;
    }    
    else if ((Get_ID_402_ECU_DTC1() == 0x0118) || (Get_ID_402_ECU_DTC2() == 0x0118))
    {
        CoolantTempSensorState = CoolantTempSensorOpenCircuit;
        CoolantTempSensorShortTime = 0;
        CoolantTempSensorOpenTime = 0;
        CoolantTempSensorNormalTime = 3000;
    }

    
}


void CoolantTemp_Gauges_Cal(uint8_t deltaTime)
{

    static uint16_t time = 0;

    if((Get_CoolantTemp_Signal_Connect()) && (CoolantTempSensorState == CoolantTempSensorNormal) && (CoolantTempValue >= -30) && (CoolantTempValue < 135)){        
        if(CoolantTempInitFlag){
            CoolantTempValueBak = CoolantTempValue;
        }


        /*根据回差计算走动方向*/
        if(CoolantTempDir == COOLANT_TEMP_SEG_UP){

            if(CoolantTempValue + COOLANT_TEMP_RETURN_DIFFERENCE <= CoolantTempValueBak){
                CoolantTempDir = COOLANT_TEMP_SEG_DOWN;
                CoolantTempValueBak = CoolantTempValue;
            }
            if(CoolantTempValue > CoolantTempValueBak){
                CoolantTempValueBak = CoolantTempValue;
            }
        }
        else{
            if(CoolantTempValue >= CoolantTempValueBak + COOLANT_TEMP_RETURN_DIFFERENCE){
                CoolantTempDir = COOLANT_TEMP_SEG_UP;
                CoolantTempValueBak = CoolantTempValue;
            }
            if(CoolantTempValue < CoolantTempValueBak){
                CoolantTempValueBak = CoolantTempValue;
            }        
        }

        /*计算目标格数*/
        if(CoolantTempDir == COOLANT_TEMP_SEG_UP){
            if(((DesCoolantTempSetp == 4) || (CoolantTempInitFlag)) && (CoolantTempValue >= 115)){
                DesCoolantTempSetp = 5;
            }
            else if(((DesCoolantTempSetp == 3) || (CoolantTempInitFlag)) && (CoolantTempValue >= 100)){
                DesCoolantTempSetp = 4;
            }
            else if(((DesCoolantTempSetp == 2) || (CoolantTempInitFlag)) && (CoolantTempValue >= 90)){
                DesCoolantTempSetp = 3;
            } 
            else if(((DesCoolantTempSetp == 1) || (CoolantTempInitFlag)) && (CoolantTempValue >= 70)){
                DesCoolantTempSetp = 2;
            }
            else if(DesCoolantTempSetp == 0){
                DesCoolantTempSetp = 1;
            }
            
        }
        else if(CoolantTempDir == COOLANT_TEMP_SEG_DOWN){

            if(((DesCoolantTempSetp == 2) || (CoolantTempInitFlag)) && (CoolantTempValue < 70-COOLANT_TEMP_RETURN_DIFFERENCE)){
                DesCoolantTempSetp = 1;
            }
            else if(((DesCoolantTempSetp == 3) || (CoolantTempInitFlag)) && (CoolantTempValue < 90-COOLANT_TEMP_RETURN_DIFFERENCE)){
                DesCoolantTempSetp = 2;
            }
            else if(((DesCoolantTempSetp == 4) || (CoolantTempInitFlag)) && (CoolantTempValue < 100-COOLANT_TEMP_RETURN_DIFFERENCE)){
                DesCoolantTempSetp = 3;
            }
            else if(((DesCoolantTempSetp == 5) || (CoolantTempInitFlag)) && (CoolantTempValue < 115-COOLANT_TEMP_RETURN_DIFFERENCE)){
                DesCoolantTempSetp = 4;
            }

        }
        

        /*IGN ON 1秒后，开始走格*/
        if(Common_GetIgnOnTime() >= 1000){
            time += deltaTime;
            if(CoolantTempInitFlag){
                CoolantTempInitFlag = 0;
                time = 0;
                CurCoolantTempSetp = DesCoolantTempSetp;
            }
            if(time >= 5000){

                time = 0;

                if(CurCoolantTempSetp < DesCoolantTempSetp){
                
                    CurCoolantTempSetp ++;

                }
                else if(CurCoolantTempSetp > DesCoolantTempSetp){

                    CurCoolantTempSetp --;

                }
            }
            if(CurCoolantTempSetp == DesCoolantTempSetp){    
                time = 0;
            }    
        }
    }

    if (Get_CoolantTemp_Signal_Connect() == 0)
    {
        CoolantTempAlarm = 0;
        CoolantTempSensorState = CoolantTempSensorNormal;
        CoolantTempSensorOpenTime = 0;
        CoolantTempSensorShortTime = 0;
        CoolantTempValue = -50;
        CoolantTempValueBak = -50;

        CoolantTempInitFlag = 1;
        CurCoolantTempSetp = 0;
        DesCoolantTempSetp = 0;
        CoolantTempDir = COOLANT_TEMP_SEG_UP;
    }
    else
    { 
        if ((CoolantTempValue >= 115) && (CoolantTempValue <= 135))
        {
            CoolantTempAlarm = 1;
        }
        else if ((CoolantTempValue <= 112))
        {
            CoolantTempAlarm = 0;
        }
    }
    
}


void CoolantTemp_Cal_Sevice(uint8_t deltaTime)
{

    CoolantTempValue = get_CoolantTempVal();
        
    /*检测水温传感器状态*/
    CoolantTemp_State_Check(deltaTime);

    /*显示水温格*/
    CoolantTemp_Gauges_Cal(deltaTime);

}

uint8_t Get_CoolantTemp_Step(void)
{
    return CurCoolantTempSetp;
}
int16_t Get_CoolantTempValue(void)
{
    return CoolantTempValue;
}


CoolantTempSensorSts_t Get_CoolantTemp_Sensor_State(void)
{
    return CoolantTempSensorState;
}


uint8_t Get_CoolantTemp_Disp_Byte(void)
{
    uint8_t CoolantTempDispByte = 0u;

    CoolantTempDispByte = CurCoolantTempSetp;
    if (CoolantTempSensorState == CoolantTempSensorShortCircuit)
    {
        //Shot
        CoolantTempDispByte = FLASH_SYNC_1Hz ? 9 : 0;
    }
    else if (CoolantTempSensorState == CoolantTempSensorOpenCircuit)
    {
        //Open
        CoolantTempDispByte = FLASH_SYNC_1Hz ? 8 : 0;
    }

    if (CoolantTemp_Signal_Connect == 0)
    {
        //CanErr
        CoolantTempDispByte = FLASH_SYNC_1Hz ? 7 : 6;
    }

    return CoolantTempDispByte;
 
}
uint8_t Get_CoolantTemp_Alarm(void)
{
    return CoolantTempAlarm;
}


void CoolantTemp_Signal_Time_Service(uint8_t deltaTime)
{
    /*_BCM_Module bcm_module_temp;

    bcm_module_temp = Get_Bcm_Module();
    if(bcm_module_temp == BCM_DELFU){
        CoolantTemp_Signal_Time += deltaTime;
        if(CoolantTemp_Signal_Time > 3000){ //3秒超时
            CoolantTemp_Signal_Connect = 0;
        }
    }
    else if(bcm_module_temp == BCM_LIANDIAN){
        if(CAN_SIG_NORMAL == CAN_MSG_Status(ID_ECU_Count)){
            CoolantTemp_Signal_Connect = 1;
        }
        else{
            CoolantTemp_Signal_Connect = 0;
        }
    }*/
    if(CAN_SIG_NORMAL == CAN_MSG_Status(ID_ECU_Count)){
        CoolantTemp_Signal_Connect = 1;
    }
    else{
        CoolantTemp_Signal_Connect = 0;
    }

}
void Reset_CoolantTemp_Signal_Time(void)
{
    CoolantTemp_Signal_Time = 0;
    CoolantTemp_Signal_Connect = 1;
}
uint8_t Get_CoolantTemp_Signal_Connect(void)
{
    return CoolantTemp_Signal_Connect;
}

