#ifndef _MCU_CORE_PROTOCOL_H_
#define _MCU_CORE_PROTOCOL_H_

#include "common.h"

/*多媒体主机通讯端口*/
#define COM_CH (0x04u)

/*串口通信基础协议 1.0*/
#define PL_CORE_VERSION (0x00u)
#define PL_CORE_MARK    (0x00u)
/*LENGHT标识符*/
#define LENGTH_ID_MASK      (0x0FFFu)
#define LENGTH_CHKSUM_MASK  (0xF000u)
#define LENGTH_CHKSUM_SHIFT (12u)


#define Uart_RX_MSG_FIFO_MAX_DEPTH (255u)
#define SEND_Key_Count             200u

#define EVENT_MSG_MAX_LENGTH    (54u)
#define EVENT_MSG_MAX_QUEUE_NUM    (6u)

#define PROTOCOL_ID_01 0x01u
#define PROTOCOL_ID_02 0x02u
#define PROTOCOL_ID_06 0x06u

#define IGON_SelfcheckingTimer 	3000U  //自检时间
typedef struct
{
    uint8_t CID;  /*命令标识符*/
    uint8_t DLC;  /*命令的长度*/
    uint8_t Addr; /*存放在缓存的地址*/
} ArmMsgIndexStruct;

typedef struct
{
    uint8_t Iptr;  /*插入位置*/
    uint8_t Optr;  /*读取位置*/
    uint8_t Depth; /*使用的深度*/
    uint8_t Full;  /*缓存存满*/
    /*Buf*/
    uint8_t           Msg [ Uart_RX_MSG_FIFO_MAX_DEPTH ];           /*数据缓存区*/
    ArmMsgIndexStruct MsgIndex [ Uart_RX_MSG_FIFO_MAX_DEPTH / 9u ]; /*定义一个数据结构用于提取和使用数据(/9按照最小单位数据长度)*/
} UartRxMsgFIFOStruct;

/*所有硬线输入的索引*/
typedef enum
{
    CycMsg_01 = 0u, 
    CycMsg_02,

    CycMsgNumber,
} CycMsg_t;

/*****************************************************************/
/*-------------ID:0x10 核心板初始化完毕 ----------*/
/*****************************************************************/
typedef union
{
    uint8_t Msg [ 1u ];
    struct
    {
        /*Byte4*/
        uint8_t MessageID       : 6;
        uint8_t                 : 2;

    } Sig;
} Receive_ID_10_Struct;


/*****************************************************************/
/*-------------ID:0x12-核心板向主板发送，周期100ms----------*/
/*****************************************************************/
typedef union
{
    uint8_t Msg [ 7u ];
    struct
    { /*Byte4*/
        uint8_t MessageID : 6;
        uint8_t PowerMode : 2;
        /*Byte5*/
        uint8_t blueToothConReq;
        /*Byte6*/
        uint8_t PhoneConnectSts;
        /*Byte7*/
        uint8_t PhoneType;
        /*Byte8*/
        uint8_t APP_Sts;
        /*Byte9*/
        uint8_t BlueToothConSts;
        /*Byte10*/
        uint8_t DisplaySts;     

    } Sig;
} Receive_ID_12_Struct;


/*****************************************************************/
/*-------------ID:0x01-00  不显示 ----------*/
/*****************************************************************/
typedef union
{
    uint8_t Msg [ 2u ];
    struct
    {
        /*Byte4*/
        uint8_t MessageID       : 6;
        uint8_t PowerMode       : 2;
        /*Byte5*/
        uint8_t DispMode        : 4;
        uint8_t Language        : 2;
        uint8_t Theme           : 1;
        uint8_t ConnectPhone    : 1;

    } Sig;
} Send_ID_01_00_Struct;
/*****************************************************************/
/*-------------ID:0x01-01  开机动画 ----------*/
/*****************************************************************/
typedef union
{
    uint8_t Msg [ 3u ];
    struct
    {
        /*Byte4*/
        uint8_t MessageID       : 6;
        uint8_t PowerMode       : 2;
        /*Byte5*/
        uint8_t DispMode        : 4;
        uint8_t Language        : 2;
        uint8_t Theme           : 1;
        uint8_t ConnectPhone    : 1;
        /*Byte6*/
        uint8_t Animation;

    } Sig;
} Send_ID_01_01_Struct;

/*****************************************************************/
/*-------------ID:0x01-02  行车信息 ----------*/
/*****************************************************************/
typedef union
{
    uint8_t Msg [ 22u ];
    struct
    {
        /*Byte4*/
        uint8_t MessageID       : 6;
        uint8_t PowerMode       : 2;
        /*Byte5*/
        uint8_t DispMode        : 4;
        uint8_t SelfTest        : 1;
        uint8_t Language        : 1;
        uint8_t Theme           : 1;
        uint8_t ConnectPhone    : 1;
        /*Byte6*/
        uint8_t LED_Coolant     : 2;
        uint8_t LED_ENGINE_OIL_LOW    : 1;
        uint8_t LED_ABS         : 1;
        uint8_t LED_HI_BEAM     : 1;
        uint8_t LED_MIL         : 1;        
        uint8_t LED_RIGHT       : 1;        
        uint8_t LED_LEFT        : 1;
        /*Byte7*/
        uint8_t LED_Fuel        : 2;
        uint8_t LED_TPMS        : 1;
        uint8_t LED_Bluetooth   : 1;
        uint8_t LED_WIFI        : 1;
        uint8_t                 : 3;        
        /*Byte8*/
        uint8_t Vspeed_H        : 1;
        uint8_t Espeed          : 7;
        /*Byte9*/
        uint8_t Vspeed_L;
        /*Byte10*/
        uint8_t Vspeed_Bars;
        /*Byte11*/
        uint8_t Espeed_Bars;
        /*Byte12*/
        uint8_t Time_hour       : 7;
        uint8_t Time_colon      : 1;
        /*Byte13*/
        uint8_t Time_minute;
        /*Byte14*/
        uint8_t Coolant_Temp_Bars;
        /*Byte15*/
        uint8_t Fuel_Bars;
        /*Byte16*/
        uint8_t Gear;
        /*Byte17*/
        uint8_t TOTAL_H4        : 4;        
        uint8_t Mileage_Unit    : 2;   
        uint8_t Disp_Mileage_Mode : 2;   
        /*Byte18*/
        uint8_t TOTAL_M8;   
        /*Byte19*/
        uint8_t TOTAL_L8;   
        /*Byte20*/
        uint8_t TRIPA_H8;   
        /*Byte21*/
        uint8_t TRIPA_L8;  
        /*Byte22*/
        uint8_t TRIPB_H8;   
        /*Byte23*/
        uint8_t TRIPB_L8;  
        /*Byte24*/
        uint8_t                 : 2; 
        uint8_t ICON_Apple       : 2; 
        uint8_t ICON_Android     : 2;  
        uint8_t ICON_Big_Wifi    : 2; 
        /*Byte25*/
        uint8_t Android_Or_Apple  : 4;       
        uint8_t Connect_Phone_Sts : 4;
        /*Byte26*/
        uint8_t EasyNavigation;       

    } Sig;
} Send_ID_01_02_Struct;


/*****************************************************************/
/*-------------ID:0x01-03  菜单 ----------*/
/*****************************************************************/
typedef union
{
    uint8_t Msg [ 6u ];
    struct
    {
        /*Byte4*/
        uint8_t MessageID       : 6;
        uint8_t PowerMode       : 2;
        /*Byte5*/
        uint8_t DispMode        : 4;
        uint8_t Language        : 2;
        uint8_t Theme           : 1;
        uint8_t ConnectPhone    : 1;
        /*Byte6*/
        uint8_t Data6;
        /*Byte7*/
        uint8_t Data7;   
        /*Byte8*/
        uint8_t Data8;   
        /*Byte9*/
        uint8_t Data9;

    } Sig;
} Send_ID_01_03_Struct;

/*****************************************************************/
/*-------------ID:0x02-胎压和报警数据----------*/
/*****************************************************************/
typedef union
{
    uint8_t Msg [ 11u ];
    struct
    { /*Byte4*/
        uint8_t MessageID : 6;
        uint8_t PowerMode : 2;
        /*Byte5*/
        uint8_t DispMode;
        /*Byte6*/
        uint8_t TPMS_Unit;
        /*Byte7*/
        uint8_t TireH_Pressure_H8;
        /*Byte8*/
        uint8_t TireH_Pressure_L8;
        /*Byte9*/
        uint8_t TireR_Pressure_H8;
        /*Byte10*/
        uint8_t TireR_Pressure_L8;     
        /*Byte11*/
        uint8_t TireH_Temp;
        /*Byte12*/
        uint8_t TireR_Temp;
        /*Byte13*/
        uint8_t Alarm_ID_H8;
        /*Byte14*/
        uint8_t Alarm_ID_L8;

    } Sig;
} Send_ID_02_Struct;

typedef enum
{
    DispNone = 0,                       //0：无显示
    DisplayingAnimation,                //1：显示开机动画
    DisplayAnimationDone,               //2：开机动画完成
    DoingSelfTest,                      //3：自检扫表
    SelfTestDone,                       //4：自检完成
    DispDriveInfo,                      //5：行车显示信息
    DispMenu,                           //6：菜单界面

}SocDispSts_E;

enum
{
    Startup = 0u,
    Run,
    Timeout,
};


enum
{
    SendEventMsgOk = 0u,
    SendEventMsgError,
};
typedef struct
{
    uint8_t  SOC_St; /*系统启动状态  0启动中 1启动成功 2启动超时*/
    uint8_t  AnimStatus;
    uint32_t Time_out;
    uint8_t  Restart;
    
} Core_MonitorStructure;

extern uint8_t             Uart2_tx_buf [  ];
extern uint8_t             Uart2_rx_buf [  ];

extern Core_MonitorStructure Core_Monitor;

#define CORE_Timeout_CNT   2500u


extern void Protocol_KL15_ON_Init(void);
extern void MCU_Send_Service(uint8_t deltaTime);

extern void Enable_Cyc_Msg(CycMsg_t msgIndex);
extern void Disable_Cyc_Msg(CycMsg_t msgIndex);

extern uint8_t Send_Event_Msg(uint8_t type, uint8_t* data);
extern uint8_t Get_Event_Msg_Queue_Length(void);
extern void SetUartRxMsg_0x12(uint8_t * data);
extern SocDispSts_E GetSocDispSts(void);

void  Drive_Info_Display_Update_Service(void);
#endif 
