#include "Common_Interface.h"
#include "System_Monitor.h"

/*修饰变量static*/

/*ig on off时间?*/
static uint32_t PowerIgnOnTimeLine;
static uint32_t PowerIgnOffTimeLine;

static MSG_01_DISP_MODE_t g_Disp_Mode;
    
static LANGUAGE_t g_Language;



static COMMON_PowerStatus_t PowerSts;/*1 ON ;  0 OFF*/
static uint16_t Act_V_Speed;/*实际?,十?的*/
static uint16_t Act_E_Speed;/*实际?*/
static uint16_t Disp_V_Speed;/*显示?,十?的*/
static uint16_t Disp_E_Speed;/*显示?*/
static uint16_t Disp_Gauges_E_Speed;/*Gauges*/
static uint16_t Disp_E_Speed_Test;/*自检?*/
static uint16_t Disp_V_Speed_Test;/*自检?*/
static uint16_t Disp_Fuel_Test;/*自检?*/
static uint16_t Disp_Temp_Test;/*自检?*/
//**************************************************

static uint16_t Act_RV_Speed;
static uint16_t Disp_RV_Speed;
//**************************************************

static uint16_t Disp_RV_Speed_Test;




/*数据有效 1 ;数据无效 0 /0xff */
static DataValid_t Act_V_Speed_Valid;
static DataValid_t Act_E_Speed_Valid;
//**************************************************

static DataValid_t Act_RV_Speed_Valid;
//**************************************************


static DataValid_t Disp_V_Speed_Valid;
static DataValid_t Disp_E_Speed_Valid;
//**************************************************

static DataValid_t Disp_RV_Speed_Valid;
//**************************************************


static uint16_t SysRollingCounter;

/*每次唤醒调用*/
void Common_DataInit(void)
{
    PowerSts = COMMON_POWER_UNKNOW;
    Act_V_Speed = 0;
    Act_E_Speed = 0;
    Disp_V_Speed = 0;
    Disp_E_Speed = 0;
	//**************************************************
	Act_RV_Speed = 0;
	Disp_RV_Speed = 0;

	//**************************************************

	Act_RV_Speed_Valid = COMMON_Valid_UNKNOW;
	Disp_RV_Speed_Valid = COMMON_Valid_UNKNOW;
	//**************************************************
    Act_V_Speed_Valid = COMMON_Valid_UNKNOW;
    Act_E_Speed_Valid = COMMON_Valid_UNKNOW;
    Disp_V_Speed_Valid = COMMON_Valid_UNKNOW;
    Disp_E_Speed_Valid = COMMON_Valid_UNKNOW;
    PowerIgnOnTimeLine = 0x0ul;
    PowerIgnOffTimeLine = 0x0ul;
    g_Disp_Mode = DISP_MODE_ANIMATION;

}



/*以下由各个处理模块按?调用*/
/*使用数据之前,?要先判断数据是否有效,如果无效,则不可以使用*/

MSG_01_DISP_MODE_t Common_Get_DispMode(void)
{
    return g_Disp_Mode;
}
void Common_Set_DispMode(MSG_01_DISP_MODE_t mode)
{
    g_Disp_Mode = mode;
}
LANGUAGE_t Common_Get_Language(void)
{
    return g_Language;
}



COMMON_PowerStatus_t Common_Get_IG_Sts(void)
{
    return PowerSts;
}
//**************************************************
uint16_t Common_Get_Act_RV_Speed(void)
{
	return Act_RV_Speed;
}

uint16_t Common_Get_Disp_RV_Speed(void)
{
	return Disp_RV_Speed;
}
//**************************************************

uint16_t Common_Get_Act_V_Speed(void)
{
    return Act_V_Speed;
}
uint16_t Common_Get_Act_E_Speed(void)
{
    return Act_E_Speed;
}
uint16_t Common_Get_Disp_V_Speed(void)
{
    return Disp_V_Speed;
}
uint16_t Common_Get_Disp_E_Speed(void)
{
    return Disp_E_Speed;
}
uint16_t Common_Get_Gauges_Disp_E_Speed(void)
{
    return Disp_Gauges_E_Speed;
}

//自检
uint16_t Common_Get_E_Speed_TEST(void)
{
    return Disp_E_Speed_Test;
}
uint16_t Common_Get_V_Speed_TEST(void)
{
    return Disp_V_Speed_Test;
}
uint8_t Common_Get_Fuel_TEST(void)
{
    return Disp_Fuel_Test;
}
uint8_t Common_Get_Temp_TEST(void)
{
    return Disp_Temp_Test;
}
/**********************************/

//**************************************************
void Common_Set_Act_RV_Speed(uint16_t Val)
{
    Act_RV_Speed = Val;
}

void Common_Set_Disp_RV_Speed(uint16_t Val)
{
    Disp_RV_Speed = Val;
}

void Common_Set_Act_RV_Speed_Valid(DataValid_t Val)
{
    Act_RV_Speed_Valid = Val;
}

void Common_Set_Disp_RV_Speed_Valid(DataValid_t Val)
{
    Disp_RV_Speed_Valid = Val;
}


//**************************************************





void Common_Set_IG_Sts(COMMON_PowerStatus_t Val)
{
    PowerSts = Val;
}
void Common_Set_Act_V_Speed(uint16_t Val)
{
    Act_V_Speed = Val;
}
void Common_Set_Act_E_Speed(uint16_t Val)
{
    Act_E_Speed = Val;
}
void Common_Set_Disp_V_Speed(uint16_t Val)
{
    Disp_V_Speed = Val;
}
void Common_Set_Disp_E_Speed(uint16_t Val)
{
    Disp_E_Speed = Val;
}
void Common_Set_Gauges_E_Speed(uint16_t Val)
{
    Disp_Gauges_E_Speed = Val;
}

//自检
void Common_Set_E_Speed_Test(uint16_t Val)
{
    Disp_E_Speed_Test = Val;
}
void Common_Set_V_Speed_Test(uint16_t Val)
{
    Disp_V_Speed_Test = Val;
}
void Common_Set_Fuel_Test(uint8_t Val)
{
    Disp_Fuel_Test = Val;
}
void Common_Set_Temp_Test(uint8_t Val)
{
    Disp_Temp_Test = Val;
}

/***************************************/

DataValid_t Common_Get_Act_V_Speed_Valid(void)
{
    return  Act_V_Speed_Valid;
}
DataValid_t Common_Get_Act_E_Speed_Valid(void)
{
    return  Act_E_Speed_Valid;
}
DataValid_t Common_Get_Disp_V_Speed_Valid(void)
{
    return Disp_V_Speed_Valid;
}
DataValid_t Common_Get_Disp_E_Speed_Valid(void)
{
    return Disp_E_Speed_Valid;
}

/*=======================================================================*/

void Common_Set_Act_V_Speed_Valid(DataValid_t Val)
{
    Act_V_Speed_Valid = Val;
}
void Common_Set_Act_E_Speed_Valid(DataValid_t Val)
{
    Act_E_Speed_Valid = Val;
}
void Common_Set_Disp_V_Speed_Valid(DataValid_t Val)
{
    Disp_V_Speed_Valid = Val;
}
void Common_Set_Disp_E_Speed_Valid(DataValid_t Val)
{
    Disp_E_Speed_Valid = Val;
}



/*2MS任务*/
void Common_Input_Para(void)
{

    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        PowerIgnOffTimeLine = 0ul;
        if (PowerIgnOnTimeLine < 0x7ffffffful)
        {
            //PowerIgnOnTimeLine += 2u;
			PowerIgnOnTimeLine += 1u;
        }
        

    }
    else
    {
        PowerIgnOnTimeLine = 0ul;
        if (PowerIgnOffTimeLine < 0x7ffffffful)
        {
            //PowerIgnOffTimeLine += 2u;
			PowerIgnOffTimeLine += 1u;
        }
    }

}

void Common_RollingCounterAdd(void)
{
    SysRollingCounter++;
}

void Common_RollingCounterClear(void)
{
    SysRollingCounter = 0u;
}

uint16_t Common_ReadRollingCounter(void)
{
    return SysRollingCounter;
}

void Common_BlockDelay(uint16_t m_MS)
{
    uint16_t RocBackup;
    uint16_t Counter;
    uint16_t DIMCounter;

    DIMCounter = m_MS * 20u;
    Common_RollingCounterClear();
    RocBackup = Common_ReadRollingCounter();
    do
    {
        Counter = Common_ReadRollingCounter();

        if (Counter >= RocBackup)
        {
            Counter -= RocBackup;
        }
        else
        {
            Counter = 65535u - RocBackup + Counter + 1u;
        }

    }
    while (Counter < DIMCounter);
}

uint32_t Common_GetIgnOnTime(void)
{
    return PowerIgnOnTimeLine;
}

uint32_t Common_GetIgnOffTime(void)
{
    return PowerIgnOffTimeLine;
}



