/******************************************************************************
文 件 名：LightDetect.c
功能描述：光线强度检测驱动文件
作    者：刘庆宇
版    本：V1.0
日    期：2021.1.15
******************************************************************************/
#include "common.h"
#include "LightDetect.h"
#include "LtDet_ORAP_29044.h"

static uint16_t LightValue = 0;

/******************************************************************************
  Function：Light_Detect_KL30_Init
  Description：该服务函数首次KL30时调用一次
  Input:
  Output:
 ******************************************************************************/
void Light_Detect_KL30_Init(void)
{
    
}
/******************************************************************************
  Function：Light_Detect_KL15_Init
  Description：该服务函数首次KL15时调用一次
  Input:
  Output:
 ******************************************************************************/
void Light_Detect_KL15_Init(void)
{
    ORAP_29044_Init();
    LightValue = 1200;
}

/******************************************************************************
  Function：Light_Detect_Serivce
  Description：光线检测服务函数，放在100ms任务
  Input:
  Output:
 ******************************************************************************/
void Light_Detect_Serivce(void)
{
    static uint8_t temp8  = 20;
    if(temp8 == 0){
        LightValue = Read_Light_value();
    }
    else{
        temp8--;
    }
    
}

uint16_t Get_Light_Value(void)
{
    return LightValue;
}


