
#include "U2_TP_Layer.h"
#include "U2_app_Service.h"
#include "U2_Link_Layer.h"
#include "UDS_def.h"

#include "U2_UDS_CFG.h"
#include "U2_app_ServiceProc.h"
#include <string.h>
#include "CAN_User.h"
#include "CoolantTemp.h"


#define U2_GLOBALS_UDS_CFG
#define U2_GLOBALS_USER_DEF

volatile _U2_DiagnoCtl U2_DiagnoCtl;  //诊断当前状??
volatile _U2_N_USData U2_Exct_USData; //报文接收的ID数据
volatile _U2_DiagClock U2_DiagClock;
volatile _U2_ErrorFrame U2_Error; //错误信息
_U2_DiagReciveDTC U2_DiagReciveDTC;
_U2_DiagReciveGaugePara U2_DiagReciveGaugePara;
volatile uint32_t U2_CrcCheckSum;

uint8_t U2_NormalCanSt = 0;
uint8_t U2_NMCanSt = 0;


uint8_t UDS_59_MsgRecFlg = 0; //
uint8_t UDS_62_MsgRecFlg = 0; //
uint8_t UDS_01_MsgRecFlg = 0; //
void Set_UDS_59_MsgRecFlg(uint8_t data)
{
    UDS_59_MsgRecFlg = data;
}
void Set_UDS_62_MsgRecFlg(uint8_t data)
{
    UDS_62_MsgRecFlg = data;
}
void Set_UDS_01_MsgRecFlg(uint8_t data)
{
    UDS_01_MsgRecFlg = data;
}

uint8_t Get_UDS_59_MsgRecFlg(void)
{
    return UDS_59_MsgRecFlg;
}
uint8_t Get_UDS_62_MsgRecFlg(void)
{
    return UDS_62_MsgRecFlg;
}
uint8_t Get_UDS_01_MsgRecFlg(void)
{
    return UDS_01_MsgRecFlg;
}
/*-------------------------------------------------------------------------
* Function Name  : DiagnosisInit_main
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_DiagnosisInit_main(void)
{

    U2_N_US_R_MultiData.ind.N_Result = u2_STATE0;
    U2_N_US_S_MultiData.ind.N_Result = u2_STATE0;
    U2_N_USSFData[0].ind.N_Result = u2_STATE0;
    U2_N_USSFData[1].ind.N_Result = u2_STATE0;
    U2_Exct_USData.ind.N_Result = u2_STATE0;
    U2_N_RSPData.ind.N_Result = u2_STATE0;
    U2_LinkDataBuf[0].TransferStatus = u2_empoty;
    U2_LinkDataBuf[1].TransferStatus = u2_empoty;

    U2_DiagnoCtl.SubFunction = 0;
    U2_DiagnoCtl.CommCtl = SubEnableRxAndTx;
    U2_DiagnoCtl.SessionType = DefSession;
    U2_DiagnoCtl.AccessLock = Lock;
    U2_DiagnoCtl.N_REV_MAX_BS = U2_MaxBuff / 8;
    U2_DiagnoCtl.N_STmin = 20;
    U2_DiagnoCtl.DTCSettingType = DtcSetOn;
    U2_DiagnoCtl.tDiagStart = 0;
    U2_DiagnoCtl.DTCByStatusMask = 0x09; //0x08已确认的诊断故障代码
                                      //0x01测试失败

    U2_Error.FrameErr = 0;

    U2_TP_SetSTminTimer(U2_DiagnoCtl.N_STmin, (_U2_DiagClock *)&U2_DiagClock);
}
/*-------------------------------------------------------------------------
* Function Name  : App_Load_DTCNum
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_Load_DTCNum(uint32_t *DtcNum, uint8_t *data)
{
    *(DtcNum) = data[0];
    *(DtcNum) = *(DtcNum) << 8;
    *(DtcNum) |= data[1];
    *(DtcNum) = *(DtcNum) << 8;
    *(DtcNum) |= data[2];
    //*(DtcNum) = *(DtcNum);
}

/*-------------------------------------------------------------------------
* Function Name  : Diagnosis_main
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_Diagnosis_main(void)
{
    uint8_t i;
    U2_TP_Buffer_handle();
    if (U2_LinkData.TransferStatus == u2_full)
    {
        U2_TP_ReciveSF_handle();
        U2_TP_ReciveMultiF_handle();

        U2_TP_NormalRecFC_handle();
        U2_LinkData.TransferStatus = u2_empoty;
    }

    U2_TP_NormalSendFC_Fun();

    if (U2_N_USSFData[0].ind.N_Result == u2_N_OK)
    {
        U2_App_CopyRam((uint8_t *)&U2_Exct_USData, (uint8_t *)&U2_N_USSFData[0], sizeof(_U2_N_USSFData));
        U2_Exct_USData.ind.N_Result = u2_N_OK;
        U2_N_USSFData[0].ind.N_Result = u2_STATE0;
    }
    else if ((U2_N_USSFData[1].ind.N_Result == u2_N_OK) && (U2_Exct_USData.ind.N_Result == u2_STATE0))
    {
        U2_App_CopyRam((uint8_t *)&U2_Exct_USData, (uint8_t *)&U2_N_USSFData[1], sizeof(_U2_N_USSFData));
        U2_Exct_USData.ind.N_Result = u2_N_OK;
        U2_N_USSFData[1].ind.N_Result = u2_STATE0;
    }
    else if ((U2_N_US_R_MultiData.ind.N_Result == u2_N_OK) && (U2_Exct_USData.ind.N_Result == u2_STATE0) &&
             (U2_N_US_S_MultiData.ind.N_Result == u2_STATE0))
    {
        U2_App_CopyRam((uint8_t *)&U2_Exct_USData, (uint8_t *)&U2_N_US_R_MultiData, sizeof(_U2_N_USData));
        U2_N_US_R_MultiData.ind.N_Result = u2_STATE0;
    }

    if (U2_N_US_S_Data_FF.ind.N_PCI == U2_FC_WAIT)
    {
        if (U2_TP_BsTimerOver((_U2_DiagClock *)&U2_DiagClock))
        {
            U2_N_US_S_MultiData.ind.N_Result = u2_N_TIMEOUT_Bs;
        }
    }

    if (U2_N_US_S_MultiData.ind.N_Result == u2_STATE0)
    {
        U2_DiagClock.TT_BsEnable = 0;
        U2_N_US_S_Data_FF.ind.N_FC_Num = 0;
    }

    if (U2_N_US_R_MultiData.ind.N_Result == u2_N_OK)
    {
        U2_N_US_R_Data_FF.ind.pos = 0;
        U2_N_US_R_Data_FF.ind.N_PCI = 0;
    }
    if ((U2_N_US_R_MultiData.ind.N_Result == u2_N_TIMEOUT_Bs) || (U2_N_US_R_MultiData.ind.N_Result == u2_N_WRONG_SN))
    {
        U2_N_US_R_MultiData.ind.N_Result = u2_STATE0;
        U2_N_US_R_Data_FF.ind.pos = 0;
        U2_N_US_R_Data_FF.ind.N_PCI = 0;
        U2_N_US_R_Data_FF.ind.N_RecSN_L = 0;
    }

    if ((U2_N_US_S_MultiData.ind.N_Result == u2_N_TIMEOUT_Bs) ||
        (U2_N_US_S_MultiData.ind.N_Result == u2_OVFLW) ||
        (U2_N_US_S_MultiData.ind.N_Result == u2_N_INVALID_FS))
    {
        U2_N_US_S_MultiData.ind.N_Result = u2_STATE0;
        U2_N_US_S_Data_FF.ind.N_PCI = 0;
        U2_N_US_S_Data_FF.ind.N_SID = 0;
        U2_N_US_S_Data_FF.ind.N_BS_CNT = 0;
    }

    if (U2_App_SessionTimerOver((_U2_DiagClock *)&U2_DiagClock))
    {
        U2_DiagnoCtl.SessionType = DefSession;
        U2_DiagnoCtl.A5_Sequence = 0;
        //	DiagnoCtl.SubFunction = SubHardReset;  
    }
    if (U2_App_ReUnlockTimerOver((_U2_DiagClock *)&U2_DiagClock))
    {
        U2_DiagnoCtl.AccessCount = 0;
    }
    if (U2_App_DtcMsgTimerOver((_U2_DiagClock *)&U2_DiagClock))
    {
        for(i=0; i<25; i++){
            U2_DiagReciveDTC.SubDTC.StructDTC[i] = 0;
        }
    }
    
    if (U2_DiagnoCtl.SessionType == DefSession)
    {
        U2_DiagnoCtl.AccessLock = Lock;
        U2_DiagnoCtl.CommCtl = SubEnableRxAndTx;
        U2_DiagnoCtl.CommType = NOR_NM_Message;

        U2_DiagnoCtl.DTCSettingType = DtcSetOn;
    }

    if (U2_Exct_USData.ind.N_Result == u2_N_OK)
    {
        switch (U2_Exct_USData.ind.N_TAtype)
        {


        case U2_ID_BCM_ResAddr://0x7E8 //BCM物理响应
            switch (U2_Exct_USData.ind.MsgData[0])
            {
                case U2_ReqReadDtcId:
                    U2_App_59_service((_U2_N_USData *)&U2_Exct_USData); //
                    break;
                case U2_ReqReadDataId:
                    U2_App_62_service((_U2_N_USData *)&U2_Exct_USData); //
                    break;
                case U2_ReqProgMilId:
                    U2_App_01_service((_U2_N_USData *)&U2_Exct_USData);
                    break;
                default:

                    /* Error.N_TAtype = ID_PhyAddr;
                    Error.FrameErr = ServiceNotSupported; //服务不支?
                    Error.RespSerId = Exct_USData.ind.MsgData[0];*/
                    break;
            }
            break;
        default:;
        }
        U2_Exct_USData.ind.N_Result = u2_STATE0;
    }

    U2_TP_TransmitPDU(); //仪表诊断回复
    U2_App_11_Reset_handle();
}

/*-------------------------------------------------------------------------
* Function Name  : App_10_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_10_service(_U2_N_USData *AppUSData)
{
 
}
/*-------------------------------------------------------------------------
* Function Name  : App_11_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_11_service(_U2_N_USData *AppUSData)
{
  
}
/*-------------------------------------------------------------------------
* Function Name  : App_85_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_85_service(_U2_N_USData *AppUSData)
{
  
}
/*-------------------------------------------------------------------------
* Function Name  : App_27_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_27_service(_U2_N_USData *AppUSData)
{

}
/*-------------------------------------------------------------------------
* Function Name  : App_31_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_31_service(_U2_N_USData *AppUSData)
{

}
/*-------------------------------------------------------------------------
* Function Name  : App_34_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_34_service(_U2_N_USData *AppUSData)
{

}
/*-------------------------------------------------------------------------
* Function Name  : App_36_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_36_service(_U2_N_USData *AppUSData)
{

}
/*-------------------------------------------------------------------------
* Function Name  : App_37_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_37_service(_U2_N_USData *AppUSData)
{
 
}
/*-------------------------------------------------------------------------
* Function Name  : App_28_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_28_service(_U2_N_USData *AppUSData)
{
 
}
/*-------------------------------------------------------------------------
* Function Name  : App_22_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_62_service(_U2_N_USData *AppUSData)
{

    uint16_t DID;
    U2_App_ErrorInfoInit((_U2_N_USData *)AppUSData);
    //获取DID
    U2_App_Load_DID((uint16_t *)&DID, (uint8_t *)&AppUSData->ind.MsgData[1]);
    if (AppUSData->ind.Length > 1)
    {

        switch (DID)
        {
        case U2_DID0005: //?-当前会话模式
            U2_App_CopyRam((uint8_t *)&U2_DiagReciveGaugePara.CoolantTemp, (uint8_t *)&AppUSData->ind.MsgData[3], (AppUSData->ind.Length - 3));
            UDS_62_MsgRecFlg = 1;
            Reset_CoolantTemp_Signal_Time();
            SetSendUdsTimeCount_220005(0);
            break;

        default:
            break;
        }
    }
}

/*-------------------------------------------------------------------------
* Function Name  : App_2E_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/

void U2_App_2E_service(_U2_N_USData *AppUSData)
{
 
}
/*-------------------------------------------------------------------------
* Function Name  : App_14_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_14_service(_U2_N_USData *AppUSData)
{

}
/*-------------------------------------------------------------------------
* Function Name  : App_19_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_59_service(_U2_N_USData *AppUSData)
{
    uint16_t DID;
    U2_App_ErrorInfoInit((_U2_N_USData *)AppUSData);
    //获取DID
    U2_App_Load_DID((uint16_t *)&DID, (uint8_t *)&AppUSData->ind.MsgData[1]);
     (void)memset((uint8_t *)&U2_DiagReciveDTC.UnionDTC, 0,sizeof(_U2_DiagReciveDTC));
    if (AppUSData->ind.Length > 1)
    {

        if (AppUSData->ind.MsgData[1] == 0x02)
        {
            U2_App_CopyRam((uint8_t *)&U2_DiagReciveDTC.UnionDTC, (uint8_t *)&AppUSData->ind.MsgData[3], (AppUSData->ind.Length - 3));
            UDS_59_MsgRecFlg = 1;
            U2_App_SetDtcMsgTimer(10000, (_U2_DiagClock *)&U2_DiagClock);
            SetSendUdsTimeCount_190209(0);
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_2F_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_2F_service(_U2_N_USData *AppUSData)
{

}
/*-------------------------------------------------------------------------
* Function Name  : App_3E_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_3E_service(_U2_N_USData *AppUSData)
{
 
}
/*-------------------------------------------------------------------------
* Function Name  : App_19_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_01_service(_U2_N_USData *AppUSData)
{

    if (AppUSData->ind.Length == 0x06)
    {
        if (AppUSData->ind.MsgData[1] == 1)
        {
            U2_DiagReciveGaugePara.MilLamp = 1;
            
        }
        else
        {
            U2_DiagReciveGaugePara.MilLamp = 0;
        }
        Reset_Mil_Signal_Time();
        SetSendUdsTimeCount_0101(0);
        DelfuModuleIn();
        UDS_01_MsgRecFlg = 1;
    }
    else
    {
        ;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_SetSequenceTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_SetSequenceTimer(uint32_t Second, _U2_DiagClock *T)
{
    T->TT_SequenceEnable = 1;
    T->OverSequenceTime = Second;
    T->SequenceTime = 0;
}
/*-------------------------------------------------------------------------
* Function Name  : App_SequenceTimerOver
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t U2_App_SequenceTimerOver(_U2_DiagClock *T)
{
    if ((T->SequenceTime >= T->OverSequenceTime) && (T->TT_SequenceEnable))
    {
        T->TT_SequenceEnable = 0;
        T->SequenceTime = 0;
        return 1;
    }
    else
    {
        return 0;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : App_SetSessionTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_SetSessionTimer(uint32_t Second, _U2_DiagClock *T)
{
    T->TT_SessionEnable = 1;
    T->OverSessionTime = Second;
    T->SessionTime = 0;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_TTimerOver3
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t U2_App_SessionTimerOver(_U2_DiagClock *T)
{
    if ((T->SessionTime >= T->OverSessionTime) && (T->TT_SessionEnable))
    {
        T->TT_SessionEnable = 0;
        T->SessionTime = 0;
        return 1;
    }
    else
    {
        return 0;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : App_SetReUnlockTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_SetReUnlockTimer(uint32_t Second, _U2_DiagClock *T)
{
    T->TT_UnlockEnable = 1;
    T->OverUnlockTime = Second;
    T->UnlockTime = 0;
}
/*-------------------------------------------------------------------------
* Function Name  : App_ReUnlockTimerOver
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t U2_App_ReUnlockTimerOver(_U2_DiagClock *T)
{
    if ((T->UnlockTime >= T->OverUnlockTime) && (T->TT_UnlockEnable))
    {
        T->TT_UnlockEnable = 0;
        T->UnlockTime = 0;
        return 1;
    }
    else
    {
        return 0;
    }
}


/*-------------------------------------------------------------------------
* Function Name  : U2_App_SetDtcMsgTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_SetDtcMsgTimer(uint32_t Second, _U2_DiagClock *T)
{
    T->TT_DtcMsgEnable = 1;
    T->OverDtcMsgTime = Second;
    T->DtcMsgTime = 0;
}
/*-------------------------------------------------------------------------
* Function Name  : App_ReUnlockTimerOver
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t U2_App_DtcMsgTimerOver(_U2_DiagClock *T)
{
    if ((T->DtcMsgTime >= T->OverDtcMsgTime) && (T->TT_DtcMsgEnable))
    {
        T->TT_DtcMsgEnable = 0;
        T->DtcMsgTime = 0;
        return 1;
    }
    else
    {
        return 0;
    }
}

