/***********************************************************************************************************************
* Copyright (C) All rights reserved.
***********************************************************************************************************************/

/***********************************************************************************************************************
* @file    pcbz.h
* @brief   This file implements device driver for PCLBUZ module.
* @version 1.0.0
* @date    2019/12/24
***********************************************************************************************************************/
#ifndef PCBZ_H
#define PCBZ_H

/***********************************************************************************************************************
Macro definitions (Register bit)
***********************************************************************************************************************/

/***********************************************************************************************************************
Macro definitions
***********************************************************************************************************************/

/***********************************************************************************************************************
Typedef definitions
***********************************************************************************************************************/
typedef enum
{
	PCBZ_CHANNEL_0,
	PCBZ_CHANNEL_1,
} pcbz_channel_t;

typedef enum
{
	PCBZ_FMAIN_0      = 0x00U,  /* fMAIN/2**0  */
	PCBZ_FMAIN_1      = 0x01U,  /* fMAIN/2**1  */
	PCBZ_FMAIN_2      = 0x02U,  /* fMAIN/2**2  */
	PCBZ_FMAIN_3      = 0x03U,  /* fMAIN/2**3  */
	PCBZ_FMAIN_4      = 0x04U,  /* fMAIN/2**4  */
	PCBZ_FMAIN_11     = 0x05U,  /* fMAIN/2**11 */
	PCBZ_FMAIN_12     = 0x06U,  /* fMAIN/2**12 */
	PCBZ_FMAIN_13     = 0x07U,  /* fMAIN/2**13 */
	PCBZ_FSUB_0       = 0x08U,  /* fSUB/2**0  */
	PCBZ_FSUB_1       = 0x09U,  /* fSUB/2**1  */
	PCBZ_FSUB_2       = 0x0AU,  /* fSUB/2**2  */
	PCBZ_FSUB_3       = 0x0BU,  /* fSUB/2**3  */
	PCBZ_FSUB_4       = 0x0CU,  /* fSUB/2**4  */
	PCBZ_FSUB_5       = 0x0DU,  /* fSUB/2**5  */
	PCBZ_FSUB_6       = 0x0EU,  /* fSUB/2**6  */
	PCBZ_FSUB_7       = 0x0FU   /* fSUB/2**7  */
} pcbz_clock_t;

/***********************************************************************************************************************
Global variables
***********************************************************************************************************************/

/***********************************************************************************************************************
Global functions
***********************************************************************************************************************/
void PCBZ_Init(pcbz_channel_t ch, pcbz_clock_t cks);
void PCBZ_Start(pcbz_channel_t ch);
void PCBZ_Stop(pcbz_channel_t ch);
/* Start user code for function. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */
#endif
