
#include "Key_user.h"
#include "gpio.h"
#include "Key.h"

#define BACK_MENU_TIME		1000
_Menu_Infor MenuInfor ;

void Key_Operation_Left(Key_Event_en_t enKeyEvent)
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:
		break;
	case KEY_EVENT_SHORT_PRESS_2:	
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3
		break;
	case KEY_EVENT_LONG_PRESS_3:	//4s
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
	    KEY_LEFT_EVENT_NONE_Service();
		break;
	default:
		break;
	}
}
void Key_Operation_Right(Key_Event_en_t enKeyEvent)
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:	
		break;
	case KEY_EVENT_SHORT_PRESS_2:		
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2s
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3s
		break;
	case KEY_EVENT_LONG_PRESS_3:	//4s
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
		KEY_RIGHT_EVENT_NONE_Service();
		break;
	default:		
		break;
	}
}


/*---------------------------------------------------------------------------------------*/
Key_Status_en_t Key_Status_Read_Left(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	if (MODE_P_IN)
	{
		enKeyReal = KEY_REALTIME_LOOSEN;
	}
	else
	{
		enKeyReal = KEY_REALTIME_PRESS;
	}
	return enKeyReal;
}
Key_Status_en_t Key_Status_Read_Right(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	if (SET_P_IN)
	{
		enKeyReal = KEY_REALTIME_LOOSEN;
	}
	else
	{
		enKeyReal = KEY_REALTIME_PRESS;
	}
	return enKeyReal;
}


/*---------------------------------------------------------------------------------------*/
const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX] =
{
	{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Left, Key_Operation_Left},
	{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Right, Key_Operation_Right},
	//{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_FLIP, Key_Operation_FLIP},
	//{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_ADJUST, Key_Operation_ADJUST},
};

/*---------------------------------------------------------------------------------------*/

Key_uint8_t u8KeyRamData[KEY_RAM_DATA_LEN];
void Key_KL30_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;
	Key_uint16_t i;
	for (i = 0; i < KEY_RAM_DATA_LEN; i++)
	{
		u8KeyRamData[i] = 0;
	}

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF;
	// Key_KL30_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	// Key_Parameter_Set_Short_Press_1_Time(100U,1000U);
	// Key_Parameter_Set_Short_Press_2_Time(1500U,2000U);

	// Key_Parameter_Set_Long_Press_1_Time(2000U);
	// Key_Parameter_Set_Long_Press_2_Time(3000U);
	// Key_Parameter_Set_Long_Press_3_Time(4000U);
	// Key_Parameter_Set_Long_Press_4_Time(10000U);	
}
void Key_Wakeup_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF; 
	// Key_Wakeup_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	// Key_Parameter_Set_Short_Press_1_Time(100U,1000U);
	// Key_Parameter_Set_Short_Press_2_Time(1500U,2000U);

	// Key_Parameter_Set_Long_Press_1_Time(2000U);
	// Key_Parameter_Set_Long_Press_2_Time(3000U);
	// Key_Parameter_Set_Long_Press_3_Time(4000U);
	// Key_Parameter_Set_Long_Press_4_Time(10000U);	
}


void KEY_LEFT_EVENT_NONE_Service(void)	
{
	MenuInfor.Back_Time_Left++;
	if(MenuInfor.Back_Time_Left > BACK_MENU_TIME)
	{
		MenuInfor.Back_Time_Left = 0;
		MenuInfor.Back_Time_Left_Flag = 1;
	}
	if((MenuInfor.Back_Time_Left_Flag == 1)&&(MenuInfor.Back_Time_Right_Flag == 1))
	{
		MenuInfor.Back_Time_Left_Flag = 0;
		MenuInfor.Back_Time_Right_Flag = 0;
	}
}

void KEY_RIGHT_EVENT_NONE_Service(void)	
{
	MenuInfor.Back_Time_Right++;
	if(MenuInfor.Back_Time_Right > BACK_MENU_TIME)
	{
		MenuInfor.Back_Time_Right = 0;
		MenuInfor.Back_Time_Right_Flag = 1;
	}
	if((MenuInfor.Back_Time_Left_Flag == 1)&&(MenuInfor.Back_Time_Right_Flag == 1))
	{
		MenuInfor.Back_Time_Left_Flag = 0;
		MenuInfor.Back_Time_Right_Flag = 0;
	}
}


void Key_Clear_Time(void)
{
	if(Key_Status_Read_Left() == KEY_REALTIME_PRESS)
	{
		MenuInfor.Back_Time_Left = 0;
		MenuInfor.Back_Time_Left_Flag = 0;
		MenuInfor.Back_Time_Right_Flag = 0;
	}
	if(Key_Status_Read_Right() == KEY_REALTIME_PRESS)
	{
		MenuInfor.Back_Time_Right = 0;
		MenuInfor.Back_Time_Left_Flag = 0;
		MenuInfor.Back_Time_Right_Flag = 0;
	}
}