/*
 * @Author: your name
 * @Date: 2022-01-19 15:41:38
 * @LastEditTime: 2022-01-22 13:54:50
 * @LastEditors: Please set LastEditors
 * @Description: 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 * @FilePath: \QJ350GS_F_20220117_SW00_00_00_BackLight_ok\source\Application\APPCan\CAN_User.h
 */
#ifndef CAN_USER_H
#define CAN_USER_H
#include "common.h"
#include "CAN_Lib.h"
#include "System_Monitor.h"



/******************************************************************************
Bus-off
******************************************************************************/
#define   RSCAN0_BUS_STABLE                 0x00U
#define   RSCAN0_BUS_OFF_LV1                0x01U
#define   RSCAN0_BUS_OFF_LV2                0x02U
#define   RSCAN00_BUS_LIMP                   0x03U
/******************************************************************************
Bus-off
******************************************************************************/

#define   RSCAN0_BUS_OFF_LV1_RECOVERY_TIME  90U             
#define   RSCAN0_BUS_OFF_LV2_RECOVERY_TIME  1000U          

 

typedef struct
{
    uint8_t  Status;
    uint8_t  Timer;
    uint8_t  Cnt;
    uint8_t  ReportDTCCnt;
} RSCAN0BusoffMonitorStruct;


typedef struct
{
    uint32_t StructDtcCurFault;
    uint32_t StructDtcHisFault;
} _DTCReturnVal;

typedef enum
{
    BCM_UNKNOW = 0,
    BCM_DELFU,
    BCM_LIANDIAN,

} _BCM_Module;

void Set_Bcm_Module(_BCM_Module data);
_BCM_Module Get_Bcm_Module(void);
extern void Can_Set_Buff_105(uint8_t CopyData[]);
extern void Can_Set_Buff_51C(uint8_t CopyData[]);
extern void Can_Set_Buff_510(uint8_t CopyData[]);
extern void Can_Set_Buff_523(uint8_t CopyData[]);
extern void Can_Set_Buff_450(uint8_t CopyData[]);
extern void Can_Set_Buff_515(uint8_t CopyData[]);
extern void Can_Set_Buff_522(uint8_t CopyData[]);
extern void SetSendUdsTimeCount_190209(uint32_t data);
extern void SetSendUdsTimeCount_220005(uint32_t data);
extern void SetSendUdsTimeCount_0101(uint32_t data);
extern void Send_22_ID0005(void);
extern void Send_19_0209(void);
extern void Send_01_01(void);
void Diag_Req_Send(uint16_t Diag_Time_SendCn);
extern void CAN_SendAppMesageOpinion(void);
extern uint8_t Can_Write(st_CAN_Msg *Msg);
extern void APP_CAN_Init(void);
void CAN_RX_Tick(void);
void CAN_TX_Tick(void);
void Can_Receive_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg[]);
/* CAN Parometer */
void swap32(uint32_t *DwData);
_DTCReturnVal GetDtcFault(void);
void GetAllDtcFault(uint32_t* pCurFault, uint8_t* pCurFaultNum, uint32_t* pHisFault, uint8_t* pHisFaultNum);
void SetDtcFault(void);
void DtcFaultInit(void);
uint32_t GetDtcDispNum(uint8_t DispNum);
uint8_t GetDtcAmnt(void);
void DtcFaultTimeInit(void);
void LianDianModuleIn(void);
void DelfuModuleIn(void);
void CAN_Check_Liandian(void);
_BCM_Module Get_Bcm_Module(void);
void Reset_Mil_Signal_Time(void);
void Can_User_Time_Service(uint8_t deltaTime);
uint8_t Get_Mil_Signal_Connect(void);
uint16_t Get_TCS_WorkModeFlash(void);
void Set_TCS_WorkModeFlsh(uint16_t Time);
uint8_t get_ECU_Battery_Voltage(void);
uint8_t Get_LED_ECU_Battery_VoltageFlag(void);
void SET_LED_ECU_Battery_VoltageFlag(uint8_t Flag);
void CAN_LED_Check_50msTask(void);
int16_t get_CoolantTempVal(void);
int16_t get_ECU_Temperature_WaterVal(void);
int16_t get_ID_ISG_BATT(void);
int16_t get_ID_ISG_Power(void);

void Test(void);
void Can_BusOff_Fun(uint8_t deltaTime);
void Set_CanSleepDelayTime(uint32_t data);
uint32_t Get_CanSleepDelayTime(void);
void SetSendUdsTimeCount_190209(uint32_t data);
uint16_t Get_ReqSilentTimer(void );
void  Set_ReqSilentTimer( uint16_t  data);
void ReqSilentTimer100mSService(void);
uint8_t Get_RSCAN0Busoff_Status(void );
#endif
