#include "BAT32G137.h"
#include "stdlib.h"
#include "common.h"
#include "init.h"
#include "Sys_Scheduler.h"
#include "Sys_Tick.h"
#include "gpio.h"

/* Private typedef -----------------------------------------------------------*/

typedef struct
{
    uint16_t     ID2ms;
    uint16_t     ID5ms;
    uint16_t     ID10ms;
    uint16_t     ID20ms;
    uint16_t     ID50ms;
    uint16_t     ID100ms;

		uint16_t 	 ID2ms_flg;
		uint16_t     ID5ms_flg;
    uint16_t     ID10ms_flg;
    uint16_t     ID20ms_flg;
    uint16_t     ID50ms_flg;

    uint16_t     ID100ms_Group1_flg;
    uint16_t     ID100ms_Group2_flg;
    uint16_t     ID100ms_Group3_flg;
    uint16_t     ID100ms_Group4_flg;
    uint16_t     ID100ms_Group5_flg;
    uint16_t     ID100ms_Group6_flg;
    uint16_t     ID100ms_Group7_flg;
    uint16_t     ID100ms_Group8_flg;
    uint16_t     ID100ms_Group9_flg;
    uint16_t     ID100ms_Group10_flg;

	
} Sys_Task_Group_st_t;

typedef struct
{
    uint16_t              msRocBak;
    Sys_Task_Group_st_t   TaskGroup;
} Sys_Scheduling_st_t;

Sys_Scheduling_st_t   SysScheduling;

void Sys_Init(void)
{

    SysScheduling.msRocBak            =  0U;

    SysScheduling.TaskGroup.ID2ms     =  0U;
    SysScheduling.TaskGroup.ID10ms    =  0U;
    SysScheduling.TaskGroup.ID20ms    =  0U;
    SysScheduling.TaskGroup.ID50ms    =  0U;
    SysScheduling.TaskGroup.ID100ms   =  0U;

    SysScheduling.TaskGroup.ID2ms_flg     =  0U;
    SysScheduling.TaskGroup.ID10ms_flg    =  0U;
    SysScheduling.TaskGroup.ID20ms_flg    =  0U;
    SysScheduling.TaskGroup.ID50ms_flg    =  0U;

    SysScheduling.TaskGroup.ID100ms_Group1_flg   =  0U;
    SysScheduling.TaskGroup.ID100ms_Group2_flg   =  0U;
    SysScheduling.TaskGroup.ID100ms_Group3_flg   =  0U;
    SysScheduling.TaskGroup.ID100ms_Group4_flg   =  0U;
    SysScheduling.TaskGroup.ID100ms_Group5_flg   =  0U;
    SysScheduling.TaskGroup.ID100ms_Group6_flg   =  0U;
    SysScheduling.TaskGroup.ID100ms_Group7_flg   =  0U;
    SysScheduling.TaskGroup.ID100ms_Group8_flg   =  0U;
    SysScheduling.TaskGroup.ID100ms_Group9_flg   =  0U;
    SysScheduling.TaskGroup.ID100ms_Group10_flg   =  0U;


    Sys_Startup_Init();
}

void Sys_Run_MODE_2ms_Tasks(void)
{
	if(SysScheduling.TaskGroup.ID2ms_flg)
	{
		
		Sys_Run_Mode_2ms_Tasks();

		SysScheduling.TaskGroup.ID2ms_flg = 0;
	}
}

void Sys_Run_MODE_5ms_Tasks(void)
{
	if(SysScheduling.TaskGroup.ID5ms_flg)
	{
		
		Sys_Run_Mode_5ms_Tasks();

		SysScheduling.TaskGroup.ID5ms_flg = 0;
	}
}

void Sys_Run_MODE_10ms_Tasks(void)
{
	if(SysScheduling.TaskGroup.ID10ms_flg)
	{
		
		Sys_Run_Mode_10ms_Tasks();

		SysScheduling.TaskGroup.ID10ms_flg = 0;
	}
}



void Sys_Scheduling_Service(void)
{
    uint32_t u32msROC;
    uint32_t u32msDeltaTime;

    //Sys_Run_Mode_Pseudo_Real_Time_Tasks();

    
    BU98R10_Update_Service();


	Sys_Run_MODE_2ms_Tasks();
	Sys_Run_MODE_5ms_Tasks();
	Sys_Run_MODE_10ms_Tasks();
	
	
/*
	if(SysScheduling.TaskGroup.ID5ms_flg)
	{
		
		Sys_Run_Mode_5ms_Tasks();
		SysScheduling.TaskGroup.ID5ms_flg = 0;
	}
		
	if(SysScheduling.TaskGroup.ID10ms_flg)
	{	
		Sys_Run_Mode_10ms_Tasks();
		SysScheduling.TaskGroup.ID10ms_flg = 0;
	}
*/

	if(SysScheduling.TaskGroup.ID20ms_flg)
	{
    	Sys_Run_Mode_20ms_Tasks();
		SysScheduling.TaskGroup.ID20ms_flg = 0;
	
	}
	

	if(SysScheduling.TaskGroup.ID50ms_flg)
	{
		Sys_Run_Mode_50ms_Tasks();
		SysScheduling.TaskGroup.ID50ms_flg = 0;	
	}


	

	if(SysScheduling.TaskGroup.ID100ms_Group1_flg)
	{
		Sys_Run_Mode_100ms_Tasks_Group1();
		SysScheduling.TaskGroup.ID100ms_Group1_flg = 0;
	}

	else if(SysScheduling.TaskGroup.ID100ms_Group2_flg)
	{
		Sys_Run_Mode_100ms_Tasks_Group2();
		SysScheduling.TaskGroup.ID100ms_Group2_flg = 0;
	}

	else if(SysScheduling.TaskGroup.ID100ms_Group3_flg)
	{
		Sys_Run_Mode_100ms_Tasks_Group3();
		SysScheduling.TaskGroup.ID100ms_Group3_flg = 0;
	}

	else if(SysScheduling.TaskGroup.ID100ms_Group4_flg)
	{
		Sys_Run_Mode_100ms_Tasks_Group4();
		SysScheduling.TaskGroup.ID100ms_Group4_flg = 0;
	}

	else if(SysScheduling.TaskGroup.ID100ms_Group5_flg)
	{
		Sys_Run_Mode_100ms_Tasks_Group5();
		SysScheduling.TaskGroup.ID100ms_Group5_flg = 0;
	}

	else if(SysScheduling.TaskGroup.ID100ms_Group6_flg)
	{
		Sys_Run_Mode_100ms_Tasks_Group6();
		SysScheduling.TaskGroup.ID100ms_Group6_flg = 0;
	}

	else if(SysScheduling.TaskGroup.ID100ms_Group7_flg)
	{
		Sys_Run_Mode_100ms_Tasks_Group7();
		SysScheduling.TaskGroup.ID100ms_Group7_flg = 0;
	}

	else if(SysScheduling.TaskGroup.ID100ms_Group8_flg)
	{
		Sys_Run_Mode_100ms_Tasks_Group8();
		SysScheduling.TaskGroup.ID100ms_Group8_flg = 0;
	}

	else if(SysScheduling.TaskGroup.ID100ms_Group9_flg)
	{
		Sys_Run_Mode_100ms_Tasks_Group9();
		SysScheduling.TaskGroup.ID100ms_Group9_flg = 0;
	}

	else if(SysScheduling.TaskGroup.ID100ms_Group10_flg)
	{
		Sys_Run_Mode_100ms_Tasks_Group10();
		SysScheduling.TaskGroup.ID100ms_Group10_flg = 0;
	}

		
}


void Sys_Scheduling_Tmr(void)
{
	
    uint32_t u32msROC;
    uint32_t u32msDeltaTime;

    Sys_Run_Mode_Pseudo_Real_Time_Tasks();

    u32msROC = SYS_ROLLING_COUNTER_1ms;
    if(u32msROC < SysScheduling.msRocBak){
        u32msDeltaTime = (u32msROC + 0xffff - SysScheduling.msRocBak);
    }
    else{
        u32msDeltaTime = (u32msROC - SysScheduling.msRocBak);
    }
    
    if (u32msDeltaTime >= 1U)
    {
        SysScheduling.msRocBak += 1;


        SysScheduling.TaskGroup.ID2ms++;
        if (SysScheduling.TaskGroup.ID2ms >= 2u)
        {
            Diagno_Tick(2);
            U2_Diagno_Tick(2);
            CAN_TX_Tick();
					
            SysScheduling.TaskGroup.ID2ms = 0u;
            //Sys_Run_Mode_2ms_Tasks();
            SysScheduling.TaskGroup.ID2ms_flg = 1;
					
        }
        SysScheduling.TaskGroup.ID5ms++;
        if (SysScheduling.TaskGroup.ID5ms >= 5u)
        {
					
            SysScheduling.TaskGroup.ID5ms = 0u;
            //Sys_Run_Mode_5ms_Tasks();
            SysScheduling.TaskGroup.ID5ms_flg = 1;
        }
				
				
        SysScheduling.TaskGroup.ID10ms++;
        if (SysScheduling.TaskGroup.ID10ms >= 10u)
        {
					
            SysScheduling.TaskGroup.ID10ms = 0u;
            //Sys_Run_Mode_10ms_Tasks();
            SysScheduling.TaskGroup.ID10ms_flg = 1;
        }
						
				
				
        SysScheduling.TaskGroup.ID20ms++;
        if (SysScheduling.TaskGroup.ID20ms >= 20u)
        {
					
            SysScheduling.TaskGroup.ID20ms = 0u;
            //Sys_Run_Mode_20ms_Tasks();
            SysScheduling.TaskGroup.ID20ms_flg = 1;
        }
				
				
        SysScheduling.TaskGroup.ID50ms++;
        if (SysScheduling.TaskGroup.ID50ms >= 50u)
        {
	
            SysScheduling.TaskGroup.ID50ms = 0u;
            //Sys_Run_Mode_50ms_Tasks();
            SysScheduling.TaskGroup.ID50ms_flg = 1;
        }

				
        SysScheduling.TaskGroup.ID100ms++;
        if (SysScheduling.TaskGroup.ID100ms == 10u)
        {
            //Sys_Run_Mode_100ms_Tasks_Group1();
            SysScheduling.TaskGroup.ID100ms_Group1_flg = 1;
        }
        else if (SysScheduling.TaskGroup.ID100ms == 20u)
        {
            //Sys_Run_Mode_100ms_Tasks_Group2();
            SysScheduling.TaskGroup.ID100ms_Group2_flg = 1;
        }     
        else if (SysScheduling.TaskGroup.ID100ms == 30u)
        {
            //Sys_Run_Mode_100ms_Tasks_Group3();
            SysScheduling.TaskGroup.ID100ms_Group3_flg = 1;
        } 
        else if (SysScheduling.TaskGroup.ID100ms == 40u)
        {
            //Sys_Run_Mode_100ms_Tasks_Group4();
            SysScheduling.TaskGroup.ID100ms_Group4_flg = 1;
        } 
        else if (SysScheduling.TaskGroup.ID100ms == 50u)
        {
            //Sys_Run_Mode_100ms_Tasks_Group5();
            SysScheduling.TaskGroup.ID100ms_Group5_flg = 1;
        } 
        else if (SysScheduling.TaskGroup.ID100ms == 60u)
        {
            //Sys_Run_Mode_100ms_Tasks_Group6();
            SysScheduling.TaskGroup.ID100ms_Group6_flg = 1;
        } 
        else if (SysScheduling.TaskGroup.ID100ms == 70u)
        {
            //Sys_Run_Mode_100ms_Tasks_Group7();
            SysScheduling.TaskGroup.ID100ms_Group7_flg = 1;
        } 
        else if (SysScheduling.TaskGroup.ID100ms == 80u)
        {
            //Sys_Run_Mode_100ms_Tasks_Group8();
            SysScheduling.TaskGroup.ID100ms_Group8_flg = 1;
        } 
        else if (SysScheduling.TaskGroup.ID100ms == 90u)
        {
            //Sys_Run_Mode_100ms_Tasks_Group9();
            SysScheduling.TaskGroup.ID100ms_Group9_flg = 1;
        } 
        else if (SysScheduling.TaskGroup.ID100ms == 100u)
        {
        	SysScheduling.TaskGroup.ID100ms_Group10_flg = 1;
            SysScheduling.TaskGroup.ID100ms = 0;
            //Sys_Run_Mode_100ms_Tasks_Group10();
        } 
    }
}

