#include "common.h"
#include "wdt.h"
#define  GLOBALS_IS31_IIC_MASTER
#include "IS31FL3236.h"
#include "IS31_IIC_Master.h"

#define  AW21xxx_DEVICE_ADDR 0x68
#define  AW21_REG_UPDATE 0x6E
#define  AW21_REG_BR0  1
#define  AW21_REG_COL0 0x4A
#define  AW21_COL_UPDATE 0x49

//#define  IS31FLxxxx_DEVICE_ADDR 0x78
#define  IS31_REG_GCR 0x4A
#define  IS31_REG_UPDATE 0x25

extern uint8_t IIC_addr;



uint8_t IS31FLxxxx_Device_Addr[IS31_CHIP_NUM] = {0x78};

uint32_t IIC_3236_NACK_Time = 0u;
uint8_t u8IS31Data[IS31_CHIP_NUM][IS31_CHANNEL_NUM];


void IS31_Set_SDB_Pin(uint8_t u8Level)
{
    if(u8Level == 0)
    {
        PORT_ClrBit(SEG_LED_CSB);
    }
    else
    {
        PORT_SetBit(SEG_LED_CSB);
    }
}

void IS31_Shutdown(void)
{
    IS31_Set_SDB_Pin(0U);
}
void IS31_OFF_Wakeup(void)
{
    IS31_Set_SDB_Pin(1U);
}

void IS31FL3236_Clear(void)
{
    uint8_t i = 0u;
    uint8_t j = 0U;

    for (i = 0U; i < IS31_CHIP_NUM; i++)
    {
        for (j = 0U; j < IS31_CHANNEL_NUM; j++)
        {
            u8IS31Data[i][j] = 0U;
        }
    }
}

void extend_i2c_write_one_byte(uint8_t DEVICE_ADDR,uint8_t REG_ADDR,uint8_t data)
{
    uint8_t ack = 0u; 
    IS31_IIC_Start();
    IS31_IIC_SendByte(DEVICE_ADDR);
    ack = IS31_IIC_WaitAck();
    IS31_IIC_SendByte(REG_ADDR);
    ack = IS31_IIC_WaitAck();
    IS31_IIC_SendByte(data);
    ack = IS31_IIC_WaitAck();
    IS31_IIC_Stop();  
}

void extend_CheckChips(void)
{
  
}

uint8_t chipType = 0u;
void IS31FL3236_Init(void)
{
    uint8_t i = 0u;
    uint8_t j = 0U;
    uint8_t ack = 0u; 
    
    IS31_Set_SDB_Pin(1);

    for (i = 0U; i < IS31_CHIP_NUM; i++)
    {
        for (j = 0U; j < IS31_CHANNEL_NUM; j++)
        {
            u8IS31Data[i][j] = 0U;
        }
    }
    //IS31_IIC_delay(30000);
    IS31_IIC_delay(35000);

    if(chipType == 0x00)
    {
        IS31_IIC_Start();
        IS31_IIC_SendByte(AW21xxx_DEVICE_ADDR);
        ack = IS31_IIC_WaitAck();
        IS31_IIC_SendByte(0x7E);
        ack = IS31_IIC_WaitAck();
        IS31_IIC_Stop();
        
        IS31_IIC_Start();
        IS31_IIC_SendByte(AW21xxx_DEVICE_ADDR | 0x01);
        ack = IS31_IIC_WaitAck();
        chipType = IS31_IIC_ReadByte();
        IS31_IIC_ACK();
        IS31_IIC_Stop();
        
        if((chipType != 0xA8) && (chipType != 0xFF))
        {
            IS31_IIC_delay(10000);
            
            IS31_IIC_Start();
            IS31_IIC_SendByte(AW21xxx_DEVICE_ADDR);
            ack = IS31_IIC_WaitAck();
            IS31_IIC_SendByte(0x7E);
            ack = IS31_IIC_WaitAck();
            IS31_IIC_Stop();
            
            IS31_IIC_Start();
            IS31_IIC_SendByte(AW21xxx_DEVICE_ADDR | 0x01);
            ack = IS31_IIC_WaitAck();
            chipType = IS31_IIC_ReadByte();
            IS31_IIC_ACK();
            IS31_IIC_Stop();
        }
        
        if((chipType != 0xA8) && (chipType != 0xFF))
        {
            IS31_IIC_delay(10000);
            
            IS31_IIC_Start();
            IS31_IIC_SendByte(AW21xxx_DEVICE_ADDR);
            ack = IS31_IIC_WaitAck();
            IS31_IIC_SendByte(0x7E);
            ack = IS31_IIC_WaitAck();
            IS31_IIC_Stop();
            
            IS31_IIC_Start();
            IS31_IIC_SendByte(AW21xxx_DEVICE_ADDR | 0x01);
            ack = IS31_IIC_WaitAck();
            chipType = IS31_IIC_ReadByte();
            IS31_IIC_ACK();
            IS31_IIC_Stop();
        }
    }
    
    if(chipType == 0xA8) //AW21036
    {
 
        extend_i2c_write_one_byte(AW21xxx_DEVICE_ADDR, 0x7f, 0x00);
        //IS31_IIC_delay(30000);
        IS31_IIC_delay(35000);


        extend_i2c_write_one_byte(AW21xxx_DEVICE_ADDR, 0x00, 0x01);
        

        extend_i2c_write_one_byte(AW21xxx_DEVICE_ADDR, 0x6e, 0xff);

 
        extend_i2c_write_one_byte(AW21xxx_DEVICE_ADDR, 0x6e, 0xff);
        extend_i2c_write_one_byte(AW21xxx_DEVICE_ADDR, 0xab, 0x00);
        extend_i2c_write_one_byte(AW21xxx_DEVICE_ADDR, 0xac, 0x00);
        

        IS31_IIC_Start();
        IS31_IIC_SendByte(AW21xxx_DEVICE_ADDR);
        ack = IS31_IIC_WaitAck();

        IS31_IIC_SendByte(AW21_REG_BR0);
        ack = IS31_IIC_WaitAck();
        
        for(i = 0;i < 36;i++)
        {
            IS31_IIC_SendByte(0x70);
            ack = IS31_IIC_WaitAck();
            WDT_Restart();
        }
        
        for(i = 0;i < 36; i++) 
        {
            extend_i2c_write_one_byte(AW21xxx_DEVICE_ADDR, AW21_REG_COL0 + i,0x00);
        }

        
        extend_i2c_write_one_byte(AW21xxx_DEVICE_ADDR, AW21_COL_UPDATE, 0x00);
    }
    else
    {
        for (j = 0; j < 2; j++)
        {
            
            IIC_addr = IS31FLxxxx_Device_Addr[j];
            extend_i2c_write_one_byte(IS31FLxxxx_Device_Addr[j], 0x4F, 0x00);
            //IS31_IIC_delay(30000);
            IS31_IIC_delay(35000);

            extend_i2c_write_one_byte(IS31FLxxxx_Device_Addr[j],0x00,0x01);
            
            IS31_IIC_Start();
            IS31_IIC_SendByte(IS31FLxxxx_Device_Addr[j]);
            ack = IS31_IIC_WaitAck();
            
            IS31_IIC_SendByte(0x26);
            ack = IS31_IIC_WaitAck();
           
            for(i = 0;i < 36;i++)
            {
                IS31_IIC_SendByte(0x01);
                ack = IS31_IIC_WaitAck();
                WDT_Restart();
            }
            IS31_IIC_Stop();

            extend_i2c_write_one_byte(IS31FLxxxx_Device_Addr[j],IS31_REG_GCR,0x00);
        }
    }
}

uint8_t LedUpdateStep = 0u;
uint8_t LedUpdateDevice = 0u;
uint8_t LedUpdateDeviceFlg = 0u;
void IS31FL3236_Update(void)
{
    uint8_t ack = 0u;
    int i;
    
    IIC_addr = IS31FLxxxx_Device_Addr[LedUpdateDevice];
	if(!LedUpdateDeviceFlg)
		{ return; }
	LedUpdateDeviceFlg = 0;
    
    if(IIC_3236_NACK_Time > 30000)
    {
        IIC_3236_NACK_Time = 0;
        IS31_Set_SDB_Pin(0);
        for(i=0;i<30000;i++)
        {
            WDT_Restart();
        }
        IS31_Set_SDB_Pin(1);
        IS31FL3236_Init();
    }

    if(LedUpdateStep >= 36)
    {
        LedUpdateStep = 0;
    }

    if (LedUpdateStep == 0)
    {
        LedUpdateStep = 5;
    }
    if (LedUpdateStep == 18)
    {
        LedUpdateStep = 23;
    }
    if (LedUpdateStep == 28)
    {
        LedUpdateStep = 33;
    }
    if (LedUpdateStep == 35)
    {
        LedUpdateStep = 5;
    }
    
    if(chipType == 0xA8)
    {
        IS31_IIC_Start();
        IS31_IIC_SendByte(AW21xxx_DEVICE_ADDR);
        ack = IS31_IIC_WaitAck();
        IS31_IIC_SendByte(AW21_REG_COL0 + LedUpdateStep);
        ack = IS31_IIC_WaitAck();

        while(LedUpdateStep < 36)
        {
            if(u8IS31Data[0][LedUpdateStep])
            {
                IS31_IIC_SendByte(0xff);
            }
            else
            {
                IS31_IIC_SendByte(0x00);
            }

            ack = IS31_IIC_WaitAck();
            LedUpdateStep++;
            //if((LedUpdateStep % 7) == 0)
            //{
            //   break;
            //}
            WDT_Restart();
						
						
						Sys_Run_MODE_2ms_Tasks();
						Sys_Run_MODE_5ms_Tasks();
						Sys_Run_MODE_10ms_Tasks();
						
        }
				
        IS31_IIC_Stop();
        
        extend_i2c_write_one_byte(AW21xxx_DEVICE_ADDR, AW21_COL_UPDATE, 0x00);
    }
    else
    {
        IS31_IIC_Start();
        IS31_IIC_SendByte(IS31FLxxxx_Device_Addr[LedUpdateDevice]);
        ack = IS31_IIC_WaitAck();
        IS31_IIC_SendByte(0x01 + LedUpdateStep);
        ack = IS31_IIC_WaitAck();

        while(LedUpdateStep < 36)
        {
            IS31_IIC_SendByte(u8IS31Data[LedUpdateDevice][LedUpdateStep]);
            ack = IS31_IIC_WaitAck();
            LedUpdateStep++;
            //if((LedUpdateStep % 7) == 0)
            //{
            //    break;
            //}
            WDT_Restart();
						Sys_Run_MODE_2ms_Tasks();
						Sys_Run_MODE_5ms_Tasks();
						Sys_Run_MODE_10ms_Tasks();
						
        }
        IS31_IIC_Stop();
        
        
        extend_i2c_write_one_byte(IS31FLxxxx_Device_Addr[LedUpdateDevice],IS31_REG_UPDATE,0x00);
        if(LedUpdateStep >= 36)
        {
            LedUpdateStep = 0;
        }
    }
}
