
/*#include "bt_pwm_driver.h"*/

#include "timerA_B_C.h"
#include "BackgroundLight.h"
#include "BGLInterface.h"
#include "Common_Interface.h"
//#include "LightDetect.h"

#include "sci.h"
#include "System_Monitor.h"
#include "gpio.h"

BL_STATE_PARA BLStatePara;
uint16_t CurLcdBackLightCycle;
dayOrNight_E  DayOrNight = _DAY;
uint32_t Ave_LightValue = 0;  


/*Comfort 指针仪表
 类型 白天 傍晚 夜晚
 背光等级 不同仪表配置不同
*/

const uint16_t BackLightValue_TFT_Default[BL_TYPE_TOTAL][BL_LV_TOTAL] =
{

    {300, 300, 350, 400, 450, 500, 600, 700, 800, 900, 1000, 1000},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    {300, 300, 350, 400, 450, 500, 600, 700, 800, 900, 1000, 1000},


};


#if 0
/**/
const uint16_t BackLightValue_DIAL_Default[BL_TYPE_TOTAL][BL_LV_TOTAL] =
{
    {0, 70, 140, 210, 280, 350, 400, 470, 540, 610, 600, 680},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}



};



/*Comfort 断码仪表
 主题 不同仪表配置不同
 类型 白天 傍晚 夜晚
 背光等级 不同仪表配置不同
*/
const uint16_t BackLightValue_R_Default[BL_THEME_TOTAL][BL_TYPE_TOTAL][BL_LV_TOTAL] =
{
    {   {40, 40, 80, 120, 160, 200, 240, 280, 320, 360, 400, 400},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    {   {10, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 100},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    {   {5, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 50},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    }
};

const uint16_t BackLightValue_G_Default[BL_THEME_TOTAL][BL_TYPE_TOTAL][BL_LV_TOTAL] =
{
    {   {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    {   {7, 7, 14, 21, 28, 35, 42, 49, 56, 63, 70, 70},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    {   {16, 16, 32, 48, 64, 80, 96, 112, 128, 144, 160, 160},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
};

const uint16_t BackLightValue_B_Default[BL_TYPE_TOTAL][BL_TYPE_TOTAL][BL_LV_TOTAL] =
{
    {   {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    {   {20, 20, 40, 60, 80, 100, 120, 140, 160, 180, 200, 200},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    {   {10, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 100},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    }
};
#endif

const uint8_t PwmChannel[BACKLIGHT_TOTAL] =
/*  TFT     表盘       R    G    B */
{TIMERBIO0, 255u, 255u, 255u, 255u};

dayOrNight_E Get_Day_Or_Night(void)
{
    return DayOrNight;
}


/**@brief Back Ground  Light Config function
* @author TYW
* @param[in] BGLType  背光类型
* @param[in] DutyVal  占空�?
* @since 1.0.0.0
*/
void  BGLPwm_Config(uint8_t BGLType,  uint16_t DutyVal)
{

    /*Pwm_Config(2, CurLcdBackLightCycle, DutyVal);*/
    if (PwmChannel[BGLType] == TIMERBIO0)
    {
        TMB0_PWM_Pin33_Freq_Duty(20000, DutyVal);

    }
    else
    {
        ;
    }

}
/**@brief Back Ground  Light Stop function
* @author TYW
* @param[in] BGLType 背光类型
* @since 1.0.0.0
*/

void  BGLPwm_Stop(uint8_t BGLType)
{
    
    if (PwmChannel[BGLType] == TIMERBIO0)
    {
        TMB0_Stop();
    }
    else
    {
        ;
    }

}
/**@brief Back Ground  Light Start function
* @author TYW
* @param[in] BGLType 背光类型
* @since 1.0.0.0
*/
void  BGLPwm_Start(uint8_t BGLType)
{
    
    if (PwmChannel[BGLType] == TIMERBIO0)
    {

        TMB0_Start();
    }
    else
    {
        ;
    }

}


/**@brief Back Ground  Light Schedu function
* @author TYW
* @param[in] BGLTheme 背光主题
* @param[in] BGLType  背光类型
* @param[in] BGLLvl   背光等级
* @since 1.0.0.0
*/
BL_USER_PARA BL_Tmp_PARA;
uint16_t lightValue[Light_Buffer_Size];
uint8_t  pLightValue = 0;
void  BackLightSchedu(uint8_t BGLPowerSt, uint8_t WakeFlag)
{
    static uint16_t time = 0;
    uint32_t temp32 = 0;
    uint32_t i;
    uint32_t a1 = BG_Auto_Mode_Min_Light;
    uint32_t a2 = BG_Auto_Mode_Max_Light;
    uint32_t b1 = BG_Auto_Mode_Min_Duty;
    uint32_t b2 = BG_Auto_Mode_Max_Duty;

//    if(uart2_Get_0x10_Rev_Flag() == 0)
//        return;


    
    CurLcdBackLightCycle = BACKLIGHTCYCLE;
    BL_Tmp_PARA.BL_User_PowerSt = BGLPowerSt;
    BL_Tmp_PARA.BL_User_WakeFlag = WakeFlag;
    BLStatePara. BL_User_Lvl_Total = BL_LV_TOTAL;
    BLStatePara. BL_User_NTC_AD_MAX = NTC_AD_MAX;
    BLStatePara. BL_User_effect = BGL_GRADUAL; 

    

}

/**@brief Get Ground  Light Theme function
* @author TYW
* @param[in] BGLTheme 背光主题
* @since 1.0.0.0
*/
void  SetBGLTheme(uint8_t BGLTheme)
{
    BLStatePara.BL_User_Theme = BGLTheme;
}

/**@brief Get Ground  Light Type function
* @author TYW
* @param[in] BGLType 背光类型 白天 傍晚 晚上
* @since 1.0.0.0
*/
void  SetBGLType(uint8_t BGLType)
{
    BLStatePara.BL_User_Type = BGLType;
}

/**@brief Get Ground  Light Level function
* @author TYW
* @param[in] BGLTheme 背光等级
* @param[in] PositionLight 小灯触发 1是小灯触�? 0是关�?
* @since 1.0.0.0
*/
void  SetBGLLvl(BL_Lvl_PARA BGLLvl, uint8_t FunPositionLight)
{
    uint8_t tmpTFTLvl;
    uint8_t tmpDIALLvl;
    uint8_t tmpRGBLvl;
    tmpTFTLvl = 0u;
    tmpDIALLvl= 0u;
    tmpRGBLvl= 0u;
    if (FunPositionLight)
    {
        tmpTFTLvl = ProcessLittleLight(BGLLvl.BL_TFT_Lvl);
        tmpDIALLvl = ProcessLittleLight(BGLLvl.BL_DIAL_Lvl);
        tmpRGBLvl = ProcessLittleLight(BGLLvl.BL_RGB_Lvl);
    }
    else
    {
        tmpTFTLvl = BGLLvl.BL_TFT_Lvl;
        tmpDIALLvl = BGLLvl.BL_DIAL_Lvl;
        tmpRGBLvl = BGLLvl.BL_RGB_Lvl;
    }
    BLStatePara.BL_User_TFTLvl =  tmpTFTLvl;
    BLStatePara.BL_User_DIALLvl = tmpDIALLvl;
    BLStatePara.BL_User_RGBLvl =  tmpRGBLvl;
}
/**@brief Get Ground  Light Little Light function
* @author TYW
* @param[in] BGLTheme 背光等级
* @since 1.0.0.0
*/
uint8_t  ProcessLittleLight(uint8_t BGLLvl)
{
    uint16_t tmpLvl;
    tmpLvl = BGLLvl ;
    tmpLvl = tmpLvl * POSITION_LIGHT_PERCENT / 100u;
    if ((uint8_t)tmpLvl < BL_LV_2)
    {
        tmpLvl = BL_LV_2;
    }
    else
    {
        ;
    }
    return (uint8_t)tmpLvl;
}
/**@brief Get Ground  Light NTCval function
* @author TYW
* @param[in] BGLNTCADVal 热敏电阻电压�?
* @since 1.0.0.0
*/
void  SetBGLNTCVol(uint16_t BGLNTCVol)
{
    BLStatePara.BL_User_NTC_AD =  BGLNTCVol;
}

/**@brief Debug Ground  Light function
* @author TYW
* @调试背光用传递占空比参数用于调整背后亮度和颜�?
* @since 1.0.0.0
*/
#if COLOR_LED_DEBUG
uint16_t DebugTFTDuty;
uint16_t DebugGaugesDuty;
uint16_t DebugRDuty;
uint16_t DebugGDuty;
uint16_t DebugBDuty;
void  DebugBGLPara(void)
{

    BL_Tmp_PARA.BL_User_TFTDuty = DebugTFTDuty ;
    BL_Tmp_PARA.BL_User_GaugesDuty = DebugGaugesDuty;
    BL_Tmp_PARA.BL_User_RDuty = DebugRDuty;
    BL_Tmp_PARA.BL_User_GDuty = DebugGDuty;
    BL_Tmp_PARA.BL_User_BDuty = DebugBDuty;


}
/**@brief Debug Ground  Light function
* @author TYW
* @param[in] TestTFTDuty TFT占空�?
* @since 1.0.0.0
*/
void  SetTFTDebugPara(uint16_t TestTFTDuty)
{
    DebugTFTDuty = TestTFTDuty;
}
/**@brief Debug Ground  Light function
* @author TYW
* @param[in] TestGaugesDuty Gauges占空�?
* @since 1.0.0.0
*/
void  SetGaugesDebugPara(uint16_t TestGaugesDuty)
{
    DebugGaugesDuty = TestGaugesDuty;
}
/**@brief Debug Ground  Light function
* @author TYW
* @param[in] TestRDuty RED占空�?
* @since 1.0.0.0
*/
void  SetRDebugPara(uint16_t TestRDuty)
{
    DebugRDuty = TestRDuty;
}
/**@brief Debug Ground  Light function
* @author TYW
* @param[in] TestGDuty Green占空�?
* @since 1.0.0.0
*/
void  SetGDebugPara(uint16_t TestGDuty)
{
    DebugGDuty = TestGDuty;
}
#endif

/**用户自己添加函数区域**/
/**@brief BL_Logic_Get_Lv  function
* @author TYW
* @param[in] 
* @since 1.0.0.0
*/

/**@brief Ground  Light Task function
* @author TYW
* @param[in] 
* @since 1.0.0.0
*/
void  BGTask(void)/*必须放在50ms任务*/
{
    uint8_t lv;
    uint8_t BackLightTestWakeFlag;
    BL_Lvl_PARA TmpBGLLvl;
    //dayOrNightControl_E D_Or_N = DayOrNight_Automatic;
    uint8_t u8Condition1 = 0;
    uint8_t u8Condition3 = 0;
    uint8_t bg_igSts = 0;
    
    BackLightTestWakeFlag = 0u;    

   


    lv = 1;
    
    TmpBGLLvl.BL_DIAL_Lvl = BL_LV_MIN;
    TmpBGLLvl.BL_RGB_Lvl = BL_LV_MIN;

    SetBGLTheme(0u);
    SetBGLType(0u);
    //SetBGLLvl(TmpBGLLvl,0);
    SetBGLNTCVol(0u);

    u8Condition1 = Common_Get_IG_Sts() ;
    u8Condition3 = System_FUN_KL30_Status_Get();
    if ((u8Condition1 == COMMON_POWER_ON ) && (u8Condition3 > 1u) && (u8Condition3 < 7u))
    {
        bg_igSts = 1;
    }
    else
    {
        bg_igSts = 0;
    }
    BackLightSchedu(bg_igSts,BackLightTestWakeFlag);
}

