/*
 * bsp_clock.h
 *
 *  Created on: 2021
 *      Author: QTC
 */


#ifndef _BSPTIMERABC_H_
#define _BSPTIMERABC_H_
#include "common.h"

typedef enum 
{
    TMA_COUNT_SOURCE_FCLK       = 0x00U,
    TMA_COUNT_SOURCE_FCLK8      = 0x10U,
    TMA_COUNT_SOURCE_FCLK2      = 0x30U,
    TMA_COUNT_SOURCE_FIL        = 0x40U,
    TMA_COUNT_SOURCE_ELC        = 0x50U,
    TMA_COUNT_SOURCE_FSUB       = 0x60U,
} tma_clock_t;

#define TIMERB_TBIO0    1u


#define TBO0_PORT_SETTING() do{ \
        PORT->P5    &= ~(1 << 0);    /* P50 output low level */ \
        PORT->PM5   &= ~(1 << 0);    /* P50 is used as TBIO0 output */ \
        PORT->POM5  &= ~(1 << 0);    /* P50 is push-pull output mode */ \
}while(0)

extern void bsp_timerA_isr_Handler(void);
extern void TMB0_PWM_Pin33_Freq_Duty(uint16_t freq, uint16_t duty);
extern void bsp_TMA0_IntervalTimer(tma_clock_t clk, uint16_t num);

extern void TMB0_PWM_Pin33_Init(void);
extern void TMB0_Start(void);
extern void TMB0_Stop(void);
#endif /* _BSPTIMERABC_H_ */
