/***********************************************************************************************************************
* Copyright (C) All rights reserved.
***********************************************************************************************************************/

/***********************************************************************************************************************
* @file    rtc.h
* @version 1.0.0
* @brief   This file implements device driver for RTC module.
* @date    2019/12/24
***********************************************************************************************************************/
#ifndef RTC_H
#define RTC_H

typedef struct 
{
    uint8_t sec;
    uint8_t min;
    uint8_t hour;
    uint8_t day;
    uint8_t week;
    uint8_t month;
    uint8_t year;
}rtc_counter_value_t;

typedef enum 
{
    RTC_FSUB,
    RTC_FIL,
    RTC_48MHZ,  /* fHOCO = 48MHz */
    RTC_32MHZ,  /* fHOCO = 32MHz */
    RTC_16MHZ,  /* fMX   = 16MHz */
    RTC_8MHZ,   /* fMX   =  8MHz */
} rtc_cks_t;
	
extern void bsp_Rtc_isr_Handler(void);
extern void RTC_Init(rtc_cks_t rtccks);
extern void RTC_Get_CounterValue(rtc_counter_value_t *counter_val);
extern void RTC_Set_CounterValue(rtc_counter_value_t *counter_val);
extern void RTC_Service(void);
extern void Get_RTC_Time(rtc_counter_value_t* pCalendar);
#endif
