/******************************************************************************
文 件 名：Key.h
功能描述：按键检测函数库头文件
作    者：张暄
版    本：V1.0
日    期：2016.11.21
******************************************************************************/

#ifndef _KEY_H_
#define _KEY_H_
#include "Line_In.h"


/******************************************************************************
按键列表
******************************************************************************/

/*** 按键属性结构 ***/
typedef struct
{
    uint8_t(*InputSignal)(void);//输入信号
    uint8_t   HoldDetMode;      //长按检测模式
    uint8_t   DoubleDetEn;      //连按(双击)检测使能
}KeyAttrStruct;

/*** 长按检测模式 ***/
#define   KEY_HOLD_DISABLE                  0x00      //不支持长按检测
#define   KEY_HOLD_ONLY                     0x01      //仅支持按住检测
#define   KEY_STUCK_ONLY                    0x02      //仅支持卡住检测
#define   KEY_HOLD_STUCK                    0x03      //支持按住/卡住检测
#define   KEY_HOLD_LONG                     0x04      //支持按住/长按检测
#define   KEY_HOLD_LONG_STUCK               0x05      //支持按住/长按/卡住检测

/******************************************************************************
旋扭按键状态检测结构
******************************************************************************/

 
typedef union{
  uint8_t Byte;
 struct
{
  uint8_t KEY_LINE_L  :1;        
  uint8_t KEY_LINE_R  :1;       
  uint8_t KEY_NEWKEY  :2;  
  uint8_t KEY_MIDKEY  :2;         
  uint8_t KEY_OLDKEY  :2;      
}KnobSwitch;
}KEY_Union;
/******************************************************************************
旋扭按键状态输出结构
******************************************************************************/
typedef union
{
  uint8_t  Byte;
  struct
  {
    uint8_t KEY_Right_Turn :2;
    uint8_t KEY_Left_Turn  :2;
  }Sig;
}KeyStates; 


extern  volatile KeyStates   KEYSTA;

extern  uint8_t Get_Key1_Line_In_Sts(void);
extern  uint8_t Get_Key2_Line_In_Sts(void);

/*** 按键属性列表 ***/
static const KeyAttrStruct KeyAttrTable[] =
{
/*=====================================================================
注意：1.应定义按键ID为该按键的属性位于本属性列表中的序号
      2.如果只启用一种长按状态检测,应使能HoldDetEn而不是LongDetEn
-----------------------------------------------------------------------
    ID  |       输入信号       |    长按检测模式    | 连按检测使能 |  
---------------------------------------------------------------------*/
{/* 01 */  Get_Key1_Line_In_Sts,       KEY_HOLD_ONLY,             0 },
{/* 02 */  Get_Key2_Line_In_Sts,       KEY_HOLD_ONLY,             0 },

/*===================================================================*/
};

/*** 按键ID列表 ***/
#define   KEY_MODE          0x00
#define   KEY_SET           0x01


/******************************************************************************
按键检测配置
******************************************************************************/
#define   KEY_DOUBLE_INTERVAL               500       //连按(双击)最长间隔
//#define   KEY_HOLD_THRESHOLD                800       //按住判定时间阈值
static const uint16_t KeyHoldThreshold[] = { 3000, 3000 }; //按住判定时间阈值,顺序与KeyAttrTable一一对应
#define   KEY_LONG_THRESHOLD                10000      //长按判定时间阈值
#define   KEY_STUCK_THRESHOLD               15000     //按键卡住判定时间阈值
#define   KEY_TOTAL_NUMBER                  (sizeof(KeyAttrTable) / sizeof(KeyAttrStruct))

/******************************************************************************
按键状态枚举
******************************************************************************/
typedef enum
{
  KEY_IDLE = 0,   //空闲,按键未按下
  KEY_PRESS,      //按键短按   1
  KEY_HOLD,       //按键按住(比KEY_LONG时间短) 2
  KEY_LONG,       //按键长按   3
  KEY_STUCK,      //按键卡住   4
  KEY_DOUBLE,     //按键连续按下两次(双击) 5  
  
}KeyStatusEnum;

/******************************************************************************
按键状态检测结构
******************************************************************************/
typedef struct
{
  uint8_t         UpdateEnable;
  uint16_t        Timer;
  uint16_t        IdleTimer;  //间隔时间
  KeyStatusEnum   FinalStatus;
  KeyStatusEnum   CurrentStatus;
}KeyDetectStruct;

/******************************************************************************
函数声明
******************************************************************************/
void Key_Status_Init(void);
void Key_Status_Detect_Service(void);
void Reset_Key_Status(uint8_t Key);
void Key_Knob(void);
KeyStatusEnum Key_Get_Status(uint8_t Key);
KeyStatusEnum Key_Get_Current_Status(uint8_t Key);

#endif
