/******************************************************************************
******************************************************************************/
#include "IS31_IIC_Master.h"
#include "IS31FL3236.h"
#include "common.h"
#include "wdt.h"


__inline void bsp_IIC_nop(void)
{
	__NOP();
}




uint8_t IIC_SDAGet (void)
{
	if(PORT_GetBit(SEG_LCD_SD))
		{ return 1; }
	else
		{ return 0; }
}


void IS31_IIC_SCL_Dir_Out(void)
{
	  #ifdef  IIC_ACCESS_PORT_REG_DIRECT
    *((volatile uint8_t*)(&PORT->PMC0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PIM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->POM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
  #else 
  
    PORT_Init( SEG_LED_SCL, OUTPUT );
  #endif
}

void IS31_IIC_SCL_Dir_In(void)
{
	#ifdef  IIC_ACCESS_PORT_REG_DIRECT
    *((volatile uint8_t*)(&PORT->PMC0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PM0+SCL_LED_DRIVER_PORT)) |= ( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PIM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->POM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PU0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
  #else 
    PORT_Init( SEG_LED_SCL, INPUT );
  #endif
}
void IS31_IIC_SDA_Dir_Out(void)
{
	PORT_Init( SEG_LED_SD, OUTPUT );
}

void IS31_IIC_SDA_Dir_In(void)
{
	PORT_Init( SEG_LED_SD, INPUT );
}

void  bsp_IIC_SDA_out( uint8_t dat ) 
{
    if ( dat ) 
    {  
        //PORT_SetBit( SDA_LED_DRIVER ); 
        *( ( volatile uint8_t* )( &PORT->P0 + 7 ) ) |= ( 1 << PIN4 );
    }
    else 
    {  
        //PORT_ClrBit( SDA_LED_DRIVER ); 
        *( ( volatile uint8_t * )( &PORT->P0 + 7 ) ) &= ( ~( 1 << PIN4 ) );
    }
}

void  bsp_IIC_SCL_out( uint8_t dat ) 
{
    if ( dat ) 
    {  
        //PORT_SetBit( SCL_LED_DRIVER );  
        *( ( volatile uint8_t* )( &PORT->P0 + 7 ) ) |= ( 1 << PIN5 );
    }
    else 
    {  
        //PORT_ClrBit( SCL_LED_DRIVER ); 
        *( ( volatile uint8_t * )( &PORT->P0 + 7 ) ) &= ( ~( 1 << PIN5 ) );
    }
}

/******************************************************************************

******************************************************************************/
void Simulated_IIC_2_Init(void)
{
    IS31_IIC_SCL_Dir_Out();
    IS31_IIC_SDA_Dir_Out();
    IS31_IIC_Stop();
}

void Simulated_Release_SCL(void)
{
    //IS31_IIC_SCL_LOW
    bsp_IIC_SCL_out(0);
    IS31_IIC_delay(10);
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_delay
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void IS31_IIC_delay(uint32_t time)
{
    uint32_t i;
    
    for(i = 0;i<= time;i++)
    {
        __NOP();
        WDT_Restart();
        
    }
}

/******************************************************************************

******************************************************************************/
void IS31_IIC_Start(void)
{
    IS31_IIC_SDA_Dir_Out();
    //IS31_IIC_SDA_HIGH
    bsp_IIC_SDA_out(1);
    //IS31_IIC_delay(7);
    bsp_IIC_nop();
	bsp_IIC_SCL_out(1);
    //IS31_IIC_SCL_HIGH
    //IS31_IIC_delay(7);
    bsp_IIC_nop();
	bsp_IIC_SDA_out(0);
    //IS31_IIC_SDA_LOW
    //IS31_IIC_delay(7);
    bsp_IIC_nop();
	bsp_IIC_SCL_out(0);
    //IS31_IIC_SCL_LOW
    //IS31_IIC_delay(10);
		bsp_IIC_nop();
}

/******************************************************************************

******************************************************************************/
void IS31_IIC_Stop(void)
{
    IS31_IIC_SDA_Dir_Out();
		bsp_IIC_SCL_out(0);
    //IS31_IIC_SCL_LOW
    //IS31_IIC_delay(7);
    bsp_IIC_nop();
	bsp_IIC_SDA_out(0);
    //IS31_IIC_SDA_LOW
    //IS31_IIC_delay(7);
    bsp_IIC_nop();
	bsp_IIC_SCL_out(1);
    //IS31_IIC_SCL_HIGH
    //IS31_IIC_delay(7);
    bsp_IIC_nop();
	bsp_IIC_SDA_out(1);
    //IS31_IIC_SDA_HIGH
    //IS31_IIC_delay(150);
	bsp_IIC_nop();
}

/******************************************************************************

******************************************************************************/
void IS31_IIC_SendByte(uint8_t Data)
{
    uint8_t temp;
    uint8_t d = Data;
    IS31_IIC_SDA_Dir_Out();

    for(temp = 8;temp != 0;temp--)
    {
        if(d & 0x80)
        {
            //IS31_IIC_SDA_HIGH
            bsp_IIC_SDA_out(1);
        }
        else
        {
            //IS31_IIC_SDA_LOW
            bsp_IIC_SDA_out(0);
        }
        //IS31_IIC_delay(7);
        bsp_IIC_nop();
        //IS31_IIC_SCL_HIGH
        bsp_IIC_SCL_out(1);
        //IS31_IIC_delay(7);
        bsp_IIC_nop();
        //IS31_IIC_SCL_LOW
        bsp_IIC_SCL_out(0);
        //IS31_IIC_delay(7);
        bsp_IIC_nop();
        d = d <<1;
        //IS31_IIC_delay(2);
        bsp_IIC_nop();
    }
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_IIC_ReadByte
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t IS31_IIC_ReadByte(void)
{
    uint8_t temp;
    uint8_t rbyte = 0;
    IS31_IIC_SDA_Dir_In();
    //__NOP();
    //__NOP();
    //__NOP();
    //__NOP();
    for(temp = 8; temp != 0;temp--)
    {
        //IS31_IIC_SCL_HIGH
        bsp_IIC_SCL_out(1);
			bsp_IIC_nop();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        rbyte = rbyte << 1;
		bsp_IIC_nop();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        if(PORT_GetBit(SEG_LED_SD)){
            rbyte = rbyte | 0x01;
        }

				bsp_IIC_nop();
        //IS31_IIC_SCL_LOW
        bsp_IIC_SCL_out(0);
				
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        // __NOP();
        bsp_IIC_nop();
    }
    return(rbyte);
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_IIC_ACK
* Description    : ack
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void IS31_IIC_ACK(void)
{
    IS31_IIC_SDA_Dir_Out();
		bsp_IIC_SDA_out(0);
    //IS31_IIC_SDA_LOW
    bsp_IIC_nop();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    bsp_IIC_SCL_out(1);
    //IS31_IIC_SCL_HIGH
    bsp_IIC_nop();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    //IS31_IIC_SCL_LOW
    bsp_IIC_SCL_out(0);
    bsp_IIC_nop();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    //IS31_IIC_SDA_HIGH
    bsp_IIC_SDA_out(1);
    bsp_IIC_nop();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_IIC_NACK
* Description    : nack
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void IS31_IIC_NACK(void)
{
    IS31_IIC_SDA_Dir_Out();
		bsp_IIC_nop();
//    __NOP();
//     __NOP();
//     __NOP();
//     __NOP();
//     __NOP();
//     __NOP();
//     __NOP();
//     __NOP();

    //IS31_IIC_SDA_HIGH
    bsp_IIC_SDA_out(1);
    bsp_IIC_nop();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    //IS31_IIC_SCL_HIGH
	bsp_IIC_SCL_out(1);

	bsp_IIC_nop();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    //IS31_IIC_SCL_LOW
    bsp_IIC_SCL_out(0);
    bsp_IIC_nop();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
}

/******************************************************************************

******************************************************************************/
uint8_t IIC_addr = 0u;
uint32_t IIC_8563_NACK_Time = 0u;
uint8_t IS31_IIC_WaitAck(void)
{
    uint8_t  ack = 1;
    uint16_t i = IS31_IIC_WaitOverTime;
    
    IS31_IIC_SDA_Dir_In();
    //IS31_IIC_SCL_HIGH
    bsp_IIC_SCL_out(1);
    while((ack) && (--i != 0 ))
    {
        ack = IIC_SDAGet();
        WDT_Restart();
    }
    //IS31_IIC_SCL_LOW
    bsp_IIC_SCL_out(0);
    if(IIC_addr == 0xA2)
    {
        if(ack)
        {
            if(IIC_8563_NACK_Time < 0xFFFFFFFF)
            {
                IIC_8563_NACK_Time ++;
            }
        }
        else
        {
            IIC_8563_NACK_Time = 0;
        }
    }
    else if(IIC_addr == EXTEND_IO)
    {
        if(ack)
        {
            if(IIC_3236_NACK_Time < 0xFFFFFFFF)
            {
                IIC_3236_NACK_Time ++;
            }
        }
        else
        {
            IIC_3236_NACK_Time = 0;
        }
    }
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
		
		
    bsp_IIC_nop();
		bsp_IIC_nop();
		bsp_IIC_nop();
		bsp_IIC_nop();
    return(ack);
}

