/******************************************************************************
  BU98R10.c
BU98R10Һļ
    ߣ
    V1.0
    ڣ2017.4.28
******************************************************************************/
#include "BU98R10.h"
#include "SEG_LCD.h"
#include "IS31FL3236.h"

#if   USE_BU98R10_CHIP_0
volatile BU98R10DDRAMUnion        BU98R10Chip0DDRAM;
BU98R10DDRAMUnion                 BU98R10Chip0DDRAMBackup;
#endif

#if   USE_BU98R10_CHIP_1
volatile BU98R10DDRAMUnion        BU98R10Chip1DDRAM;
BU98R10DDRAMUnion                 BU98R10Chip1DDRAMBackup;
#endif

BU98R10UpdateCtrlStruct           BU98R10Update;
uint8_t BU98R10_InitFlag = 0u;

#define SEG_LCD_SD_PORT     1
#define SEG_LCD_SD_PIN      2
#define SEG_LCD_SCL_PORT     1
#define SEG_LCD_SCL_PIN      1
#define SEG_LCD_CS_PORT     1
#define SEG_LCD_CS_PIN      0

#define SEG_LCD_SD1_PORT     5
#define SEG_LCD_SD1_PIN      5
#define SEG_LCD_SCL1_PORT     1
#define SEG_LCD_SCL1_PIN      7
#define SEG_LCD_CS1_PORT     1
#define SEG_LCD_CS1_PIN      3

//ɫóʼ(ע⣬δ?оƬ)
/*
static void BU98R10ColorInit(uint8_t R_GrayLevel,uint8_t G_GrayLevel,uint8_t B_GrayLevel)
{
    uint8_t width = 0;
    uint8_t wTemp = 0;
    uint8_t rGrayLevel = R_GrayLevel;
    uint8_t gGrayLevel = G_GrayLevel;
    uint8_t bGrayLevel = B_GrayLevel;

    if(rGrayLevel > 63)
    {
        rGrayLevel = 63;
    }

    if(gGrayLevel > 63)
    {
        gGrayLevel = 63;
    }

    if(bGrayLevel > 63)
    {
        bGrayLevel = 63;
    }

    BU98R10_0_Command_Write(BU98R10_CMD_LED_CTRL);
    BU98R10_0_Data_Write(0x12);

    //R
    BU98R10_0_Command_Write(0xA0); //SRR-SRF
    width = rGrayLevel;
    wTemp = (15 - width/4);
    wTemp <<= 4;
    wTemp |= (15 - width/4);
    BU98R10_0_Data_Write(wTemp);
    BU98R10_0_Command_Write(0xB8); //LRS
    BU98R10_0_Data_Write(63 - width);
    BU98R10_0_Command_Write(0xD0); //LRW
    BU98R10_0_Data_Write(width);

    //G
    BU98R10_0_Command_Write(0xA8); //SGR-SGF
    width = gGrayLevel;
    wTemp = (15 - width/4);
    wTemp <<= 4;
    wTemp |= (15 - width/4);
    BU98R10_0_Data_Write(wTemp);
    BU98R10_0_Command_Write(0xC0); //LGS
    BU98R10_0_Data_Write(63 - width);
    BU98R10_0_Command_Write(0xD8); //LRW
    BU98R10_0_Data_Write(width);

    //B
    BU98R10_0_Command_Write(0xB0); //SBR-SBF
    width = bGrayLevel;
    wTemp = (15 - width/4);
    wTemp <<= 4;
    wTemp |= (15 - width/4);
    BU98R10_0_Data_Write(wTemp);
    BU98R10_0_Command_Write(0xC8); //LBS
    BU98R10_0_Data_Write(63 - width);
    BU98R10_0_Command_Write(0xE0); //LBW
    BU98R10_0_Data_Write(width);
}
*/
/******************************************************************************
BU98R10_Init
  ܣʼBU98R10
  
ֵ
******************************************************************************/
uint8_t Get_BU98R10UpdateEn(void )
{
    return BU98R10Update.En;
}

void BU98R10_Init(void)
{
    uint8_t i;

    if(BU98R10_InitFlag == 1) {
        //return;
    }

    BU98R10_InitFlag = 1;
#if     BU98R10_WRITE_AT_SAME_TIME


#if   BU98R10_COLORFUL_LCD_MODE

    //λ
    BU98R10_All_Command_Write(BU98R10_CMD_SWRST);

    //ģʽ
    BU98R10_All_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);

    //
    BU98R10_All_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

    //֡ˢ
    BU98R10_All_Command_Write(BU98R10_CMD_FREQ);
    BU98R10_All_Data_Write(BU98R10_FRAME_FREQ, BU98R10_FRAME_FREQ);

    //ɫ
#if(USE_NEW_COLORFUL_STRATEGY == 1)
    //ɫóʼ(ע⣬δ?оƬ)
    //BU98R10ColorInit(R_LEVEL, G_LEVEL, B_LEVEL);
#else //USE_NEW_COLORFUL_STRATEGY
    BU98R10_All_Command_Write(BU98R10_CMD_LED_CTRL);
    BU98R10_All_Data_Write(0x12, 0x12);

    BU98R10_All_Command_Write(BU98R10_CMD_SEG_R);
    BU98R10_All_Data_Write(BU98R10_REG_SEG_R, BU98R10_REG_SEG_R);

    BU98R10_All_Command_Write(BU98R10_CMD_SEG_G);
    BU98R10_All_Data_Write(BU98R10_REG_SEG_G, BU98R10_REG_SEG_G);

    BU98R10_All_Command_Write(BU98R10_CMD_SEG_B);
    BU98R10_All_Data_Write(BU98R10_REG_SEG_B, BU98R10_REG_SEG_B);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTR);
    BU98R10_All_Data_Write(BU98R10_LRS, BU98R10_LRS);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTG);
    BU98R10_All_Data_Write(BU98R10_LGS, BU98R10_LGS);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTB);
    BU98R10_All_Data_Write(BU98R10_LBS, BU98R10_LBS);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHR);
    BU98R10_All_Data_Write(BU98R10_LRW, BU98R10_LRW);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHG);
    BU98R10_All_Data_Write(BU98R10_LGW, BU98R10_LGW);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHB);
    BU98R10_All_Data_Write(BU98R10_LBW, BU98R10_LBW);
#endif //USE_NEW_COLORFUL_STRATEGY

    //RAM
    BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
    BU98R10_All_Data_Write(0x00, 0x00);

    BU98R10_All_Command_Write(BU98R10_CMD_DATWR);

    for (i = 0; i < 90; i++)
    { BU98R10_All_Data_Write(BU98R10_DEFAULT_BYTE, BU98R10_DEFAULT_BYTE); }

    for (i = 0; i < BU98R10_DDRAM_SIZE; i++) {
        BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;

        BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
    }

    //ʾ
    BU98R10_All_Command_Write(BU98R10_CMD_DISPON);

#else //BU98R10_COLORFUL_LCD_MODE

    //λ
    BU98R10_All_Command_Write(BU98R10_CMD_SWRST);

    //ģʽ
    BU98R10_All_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);

    //
    BU98R10_All_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

    //֡ˢ
    BU98R10_All_Command_Write(BU98R10_CMD_FREQ);
    BU98R10_All_Data_Write(BU98R10_FRAME_FREQ, BU98R10_FRAME_FREQ);

    //RAM
    BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
    BU98R10_All_Data_Write(0x00, 0x00);

    BU98R10_All_Command_Write(BU98R10_CMD_DATWR);

    for (i = 0; i < 90; i++)
    { BU98R10_All_Data_Write(BU98R10_DEFAULT_BYTE, BU98R10_DEFAULT_BYTE); }

    for (i = 0; i < BU98R10_DDRAM_SIZE; i++) {
        BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;

        BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
    }

    //ʾ
    BU98R10_All_Command_Write(BU98R10_CMD_DISPON);

#endif // BU98R10_COLORFUL_LCD_MODE


#else //BU98R10_WRITE_AT_SAME_TIME


#if BU98R10_COLORFUL_LCD_MODE

#if USE_BU98R10_CHIP_0

    //λ
    BU98R10_0_Command_Write(BU98R10_CMD_SWRST);

    //ģʽ
    BU98R10_0_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);

    //
    BU98R10_0_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

    //֡ˢ
    BU98R10_0_Command_Write(BU98R10_CMD_FREQ);
    BU98R10_0_Data_Write(BU98R10_FRAME_FREQ);

    //ɫ
    BU98R10_0_Command_Write(BU98R10_CMD_LED_CTRL);
    BU98R10_0_Data_Write(0x12);

    BU98R10_0_Command_Write(BU98R10_CMD_SEG_R);
    BU98R10_0_Data_Write(BU98R10_REG_SEG_R);

    BU98R10_0_Command_Write(BU98R10_CMD_SEG_G);
    BU98R10_0_Data_Write(BU98R10_REG_SEG_G);

    BU98R10_0_Command_Write(BU98R10_CMD_SEG_B);
    BU98R10_0_Data_Write(BU98R10_REG_SEG_B);

    BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTR);
    BU98R10_0_Data_Write(BU98R10_LRS);

    BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTG);
    BU98R10_0_Data_Write(BU98R10_LGS);

    BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTB);
    BU98R10_0_Data_Write(BU98R10_LBS);

    BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHR);
    BU98R10_0_Data_Write(BU98R10_LRW);

    BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHG);
    BU98R10_0_Data_Write(BU98R10_LGW);

    BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHB);
    BU98R10_0_Data_Write(BU98R10_LBW);

    //RAM
    BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
    BU98R10_0_Data_Write(0x00);

    BU98R10_0_Command_Write(BU98R10_CMD_DATWR);

    for (i = 0; i < 90; i++)
    { BU98R10_0_Data_Write(BU98R10_DEFAULT_BYTE); }

    for (i = 0; i < BU98R10_DDRAM_SIZE; i++) {
        BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
    }

    //ʾ
    BU98R10_0_Command_Write(BU98R10_CMD_DISPON);

#endif //USE_BU98R10_CHIP_0

#if USE_BU98R10_CHIP_1

    //λ
    BU98R10_1_Command_Write(BU98R10_CMD_SWRST);

    //ģʽ
    BU98R10_1_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);

    //
    BU98R10_1_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

    //֡ˢ
    BU98R10_1_Command_Write(BU98R10_CMD_FREQ);
    BU98R10_1_Data_Write(BU98R10_FRAME_FREQ);

    //ɫ
    BU98R10_1_Command_Write(BU98R10_CMD_LED_CTRL);
    BU98R10_1_Data_Write(0x12);

    BU98R10_1_Command_Write(BU98R10_CMD_SEG_R);
    BU98R10_1_Data_Write(BU98R10_REG_SEG_R);

    BU98R10_1_Command_Write(BU98R10_CMD_SEG_G);
    BU98R10_1_Data_Write(BU98R10_REG_SEG_G);

    BU98R10_1_Command_Write(BU98R10_CMD_SEG_B);
    BU98R10_1_Data_Write(BU98R10_REG_SEG_B);

    BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTR);
    BU98R10_1_Data_Write(BU98R10_LRS);

    BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTG);
    BU98R10_1_Data_Write(BU98R10_LGS);

    BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTB);
    BU98R10_1_Data_Write(BU98R10_LBS);

    BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHR);
    BU98R10_1_Data_Write(BU98R10_LRW);

    BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHG);
    BU98R10_1_Data_Write(BU98R10_LGW);

    BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHB);
    BU98R10_1_Data_Write(BU98R10_LBW);

    //RAM
    BU98R10_1_Command_Write(BU98R10_CMD_ADSET);
    BU98R10_1_Data_Write(0x00);

    BU98R10_1_Command_Write(BU98R10_CMD_DATWR);

    for (i = 0; i < 90; i++)
    { BU98R10_1_Data_Write(BU98R10_DEFAULT_BYTE); }

    for (i = 0; i < BU98R10_DDRAM_SIZE; i++) {
        BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
    }

    //ʾ
    BU98R10_1_Command_Write(BU98R10_CMD_DISPON);

#endif //USE_BU98R10_CHIP_1

#else //BU98R10_COLORFUL_LCD_MODE

#if USE_BU98R10_CHIP_0

    //λ
    BU98R10_0_Command_Write(BU98R10_CMD_SWRST);

    //ģʽ
    BU98R10_0_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);

    //
    BU98R10_0_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

    //֡ˢ
    BU98R10_0_Command_Write(BU98R10_CMD_FREQ);
    BU98R10_0_Data_Write(BU98R10_FRAME_FREQ);

    //RAM
    BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
    BU98R10_0_Data_Write(0x00);

    BU98R10_0_Command_Write(BU98R10_CMD_DATWR);

    for (i = 0; i < 90; i++)
    { BU98R10_0_Data_Write(BU98R10_DEFAULT_BYTE); }

    for (i = 0; i < BU98R10_DDRAM_SIZE; i++) {
        BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
    }

    //ʾ
    BU98R10_0_Command_Write(BU98R10_CMD_DISPON);

#endif //USE_BU98R10_CHIP_0

#if USE_BU98R10_CHIP_1

    //λ
    BU98R10_1_Command_Write(BU98R10_CMD_SWRST);

    //ģʽ
    BU98R10_1_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);

    //
    BU98R10_1_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

    //֡ˢ
    BU98R10_1_Command_Write(BU98R10_CMD_FREQ);
    BU98R10_1_Data_Write(BU98R10_FRAME_FREQ);

    //RAM
    BU98R10_1_Command_Write(BU98R10_CMD_ADSET);
    BU98R10_1_Data_Write(0x00);

    BU98R10_1_Command_Write(BU98R10_CMD_DATWR);

    for (i = 0; i < 90; i++)
    { BU98R10_1_Data_Write(BU98R10_DEFAULT_BYTE); }

    for (i = 0; i < BU98R10_DDRAM_SIZE; i++) {
        BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
    }

    //ʾ
    BU98R10_1_Command_Write(BU98R10_CMD_DISPON);

#endif //USE_BU98R10_CHIP_1

#endif //BU98R10_COLORFUL_LCD_MODE

#endif //BU98R10_WRITE_AT_SAME_TIME

    BU98R10Update.En   = 0;
    BU98R10Update.Step = 0;
    BU98R10Update.Cont = 0;
    BU98R10Update.Addr = 0;

    BU98R10Update.Chip = 0;

}

/******************************************************************************
BU98R10_Shutdown
  ܣرBU98R10ʾ,ʹ͹ģʽ
  
ֵ
******************************************************************************/
void BU98R10_Shutdown(void)
{
    BU98R10_InitFlag = 0U;

#if     BU98R10_WRITE_AT_SAME_TIME
    BU98R10_All_Command_Write(BU98R10_CMD_DISPOFF);
#else
#if USE_BU98R10_CHIP_0
    BU98R10_0_Command_Write(BU98R10_CMD_DISPOFF);
#endif

#if USE_BU98R10_CHIP_1
    BU98R10_1_Command_Write(BU98R10_CMD_DISPOFF);
#endif
#endif
}

/******************************************************************************
BU98R10_Update_Request
  ܣˢBU98R10Ķʾ
  
ֵ
******************************************************************************/

void BU98R10_Update_Request(void)
{
    BU98R10Update.En = 1;
	LedUpdateDeviceFlg = 1;

}

/******************************************************************************
BU98R10_Update_Service
  ܣBU98R10ʾˢ·
  
ֵ
*******************************************************************************
ע  ⣺÷ÿϵͳʱʵʱ
******************************************************************************/
void BU98R10_Update_Service(void)
{
    uint8_t i = 0;

#if BU98R10_WRITE_AT_SAME_TIME

    if (BU98R10Update.En) {

        switch (BU98R10Update.Step) {
            case 0  : //дַ
                //ǰ15SEG
                BU98R10Update.Addr = 7;
                BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
                BU98R10_All_Data_Write(BU98R10Update.Addr,BU98R10Update.Addr);
                BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
                BU98R10Update.Step = 1;

                break;

            case 1  :
                for(i = 0; i < 6; i++) {
                    BU98R10_All_Data_Write(BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr],BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr]);

                    if(BU98R10Update.Addr >= 30) {
                        BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
                        BU98R10_All_Data_Write(BU98R10Update.Addr,BU98R10Update.Addr);
                        BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
                        BU98R10Update.Step = 2;
                        break;
                    }
                    else{
                        //ַ
                        BU98R10Update.Addr++;
                    }
                }

                break;

            case 2  :
                for(i = 0; i < 6; i++) {
                    BU98R10_All_Data_Write(BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr],BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr]);

                    if(BU98R10Update.Addr >= 60) {
                        BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
                        BU98R10_All_Data_Write(BU98R10Update.Addr,BU98R10Update.Addr);
                        BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
                        BU98R10Update.Step = 3;
                        break;
                    }
                    else{
                        //ַ
                        BU98R10Update.Addr++;
                    }
                }

                break;

            case 3  :
                for(i = 0; i < 6; i++) {
                    BU98R10_All_Data_Write(BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr],BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr]);

                    if(BU98R10Update.Addr  == 86) {
                       BU98R10Update.Addr = 0;
                        BU98R10Update.En   = 0;
                        BU98R10Update.Step = 0;
                        break;
                    }
                    else{
                        //ַ
                        BU98R10Update.Addr++;
                    }
                }

                break;

            default :
                BU98R10Update.En   = 0;
                BU98R10Update.Step = 0;
                BU98R10Update.Cont = 0;
                BU98R10Update.Addr = 0;
                break;
        }
        
    }
    
#else

    if (BU98R10Update.En) {

        switch (BU98R10Update.Step) {
            case 0  : //дַ
                //ǰ11SEG
                BU98R10Update.Addr = 5;
                BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
                BU98R10_0_Data_Write(BU98R10Update.Addr);
                BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
                BU98R10Update.Step = 1;

                break;

            case 1  :
                for(i = 0; i < 6; i++) {
                    //д   5--18
                    BU98R10_0_Data_Write(BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr]);

                    if(BU98R10Update.Addr == 18) {  //---SEG38
                        BU98R10Update.Addr = 80;
                        BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
                        BU98R10_0_Data_Write(BU98R10Update.Addr);
                        BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
                        BU98R10Update.Step = 2;
                        break;
                    }
                    else{
                        //ַ
                        BU98R10Update.Addr++;
                    }
                }

                break;

            case 2  :
                for(i = 0; i < 6; i++) {
                    //д   80-86
                    BU98R10_0_Data_Write(BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr]);

                    if(BU98R10Update.Addr == 86) {  //---SEG174
                        BU98R10Update.Addr = 19;
                        BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
                        BU98R10_0_Data_Write(BU98R10Update.Addr);
                        BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
                        BU98R10Update.Step = 3;
                        break;
                    }
                    else{
                        //ַ
                        BU98R10Update.Addr++;
                    }
                }

                break;

            case 3  :
                for(i = 0; i < 6; i++) {
                    //д19-79
                    BU98R10_0_Data_Write(BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr]);

                    if(BU98R10Update.Addr == 79) {
                       BU98R10Update.Addr = 0;
                        BU98R10Update.En   = 0;
                        BU98R10Update.Step = 0;
                        break;
                    }
                    else{
                        //ַ
                        BU98R10Update.Addr++;
                    }
                }

                break;

            default :
                BU98R10Update.En   = 0;
                BU98R10Update.Step = 0;
                BU98R10Update.Cont = 0;
                BU98R10Update.Addr = 0;
                break;
        }
        
    }
#endif

}

#define BU98R10_DELAY_NS \
    __NOP();               \
    __NOP();               \
    __NOP();
//	__NOP();               \
//	__NOP();               \
//	__NOP();               \
//	__NOP();


#if USE_BU98R10_CHIP_0
/******************************************************************************
BU98R10_0_Command_Write
  ܣBU98R10оƬ0д
  CmdҪд
ֵ
******************************************************************************/
void BU98R10_0_Command_Write(uint8_t Cmd)
{
    uint8_t i;

    //D/C = 0,ʾ
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) &= ~(1 << SEG_LCD_SD_PIN); //PORT_ClrBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) &= ~(1 << SEG_LCD_SCL_PIN); //PORT_ClrBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS_PORT)) &= ~(1 << SEG_LCD_CS_PIN); //PORT_ClrBit
    //	PORT_ClrBit(SEG_LCD_SD);
    //	PORT_ClrBit(SEG_LCD_SCL);
    //	PORT_ClrBit(SEG_LCD_CSB);

    BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;

    //  PORT_SetBit(SEG_LCD_SCL);
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) |= (1 << SEG_LCD_SCL_PIN); //PORT_SetBit

    BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;

    for (i = 0; i < 8; i++) {
        //	PORT_ClrBit(SEG_LCD_SCL);
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) &= ~(1 << SEG_LCD_SCL_PIN); //PORT_ClrBit

        if (Cmd & 0x80)
            //  PORT_SetBit(SEG_LCD_SD);
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) |= (1 << SEG_LCD_SD_PIN); } //PORT_SetBit
        else
            // PORT_ClrBit(SEG_LCD_SD);
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) &= ~(1 << SEG_LCD_SD_PIN); } //PORT_ClrBit

        BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;

        //PORT_SetBit(SEG_LCD_SCL);
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) |= (1 << SEG_LCD_SCL_PIN); //PORT_SetBit

        BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;

        Cmd <<= 1;
    }

    //PORT_SetBit(SEG_LCD_CSB);
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS_PORT)) |= (1 << SEG_LCD_CS_PIN); //PORT_SetBit

    BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
}

/******************************************************************************
BU98R10_0_Data_Write
  ܣBU98R10оƬ0д
  DatҪд
ֵ
******************************************************************************/
void BU98R10_0_Data_Write(uint8_t Dat)
{
    uint8_t i;

    //D/C = 1,ʾ
    //PORT_SetBit(SEG_LCD_SD);
    // PORT_ClrBit(SEG_LCD_SCL);
    // PORT_ClrBit(SEG_LCD_CSB);
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) |= (1 << SEG_LCD_SD_PIN); //PORT_SetBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) &= ~(1 << SEG_LCD_SCL_PIN); //PORT_ClrBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS_PORT)) &= ~(1 << SEG_LCD_CS_PIN); //PORT_ClrBit

    BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;

    // PORT_SetBit(SEG_LCD_SCL);
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) |= (1 << SEG_LCD_SCL_PIN); //PORT_SetBit

    BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;

    for (i = 0; i < 8; i++) {
        //PORT_ClrBit(SEG_LCD_SCL);
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) &= ~(1 << SEG_LCD_SCL_PIN); //PORT_ClrBit

        if (Dat & 0x80)
            //PORT_SetBit(SEG_LCD_SD);
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) |= (1 << SEG_LCD_SD_PIN); } //PORT_SetBit
        else
            //PORT_ClrBit(SEG_LCD_SD);
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) &= ~(1 << SEG_LCD_SD_PIN); } //PORT_ClrBit

        BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;

        //PORT_SetBit(SEG_LCD_SCL);
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) |= (1 << SEG_LCD_SCL_PIN); //PORT_SetBit

        BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;
        //		BU98R10_DELAY_NS;

        Dat <<= 1;
    }

    //PORT_SetBit(SEG_LCD_CSB);
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS_PORT)) |= (1 << SEG_LCD_CS_PIN); //PORT_SetBit

    BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
    //	BU98R10_DELAY_NS;
}
#endif

#if   USE_BU98R10_CHIP_1
/******************************************************************************
BU98R10_1_Command_Write
  ܣBU98R10оƬ1д
  CmdҪд
ֵ
******************************************************************************/
void BU98R10_1_Command_Write(uint8_t Cmd)
{
    uint8_t i;

    //D/C = 0,ʾ
    PORT_ClrBit(SEG_LCD_SD1);
    PORT_ClrBit(SEG_LCD_SCL1);
    PORT_ClrBit(SEG_LCD_CSB1);

    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;

    PORT_SetBit(SEG_LCD_SCL1);

    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;

    for (i = 0; i < 8; i++) {
        PORT_ClrBit(SEG_LCD_SCL1);

        if (Cmd & 0x80)
        { PORT_SetBit(SEG_LCD_SD1); }
        else
        { PORT_ClrBit(SEG_LCD_SD1); }

        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;

        PORT_SetBit(SEG_LCD_SCL1);

        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;

        Cmd <<= 1;
    }

    PORT_SetBit(SEG_LCD_CSB1);

    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
}

/******************************************************************************
BU98R10_1_Data_Write
  ܣBU98R10оƬ1д
  DatҪд
ֵ
******************************************************************************/
void BU98R10_1_Data_Write(uint8_t Dat)
{
    uint8_t i;

    //D/C = 1,ʾ
    PORT_SetBit(SEG_LCD_SD1);
    PORT_ClrBit(SEG_LCD_SCL1);
    PORT_ClrBit(SEG_LCD_CSB1);

    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;

    PORT_SetBit(SEG_LCD_SCL1);

    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;

    for (i = 0; i < 8; i++) {
        PORT_ClrBit(SEG_LCD_SCL1);

        if (Dat & 0x80)
        { PORT_SetBit(SEG_LCD_SD1); }
        else
        { PORT_ClrBit(SEG_LCD_SD1); }

        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;

        PORT_SetBit(SEG_LCD_SCL1);

        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;

        Dat <<= 1;
    }

    PORT_SetBit(SEG_LCD_CSB1);

    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
}

#endif
#if   BU98R10_WRITE_AT_SAME_TIME
/******************************************************************************
BU98R10_All_Command_Write
  ܣͬʱBU98R10оƬ0оƬ1д
  CmdҪд
ֵ
******************************************************************************/
void BU98R10_All_Command_Write(uint8_t Cmd)
{
    uint8_t i;

    //D/C = 0,ʾ
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) &= ~(1 << SEG_LCD_SD_PIN); //PORT_ClrBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) &= ~(1 << SEG_LCD_SCL_PIN); //PORT_ClrBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS_PORT)) &= ~(1 << SEG_LCD_CS_PIN); //PORT_ClrBit

    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD1_PORT)) &= ~(1 << SEG_LCD_SD1_PIN); //PORT_ClrBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL1_PORT)) &= ~(1 << SEG_LCD_SCL1_PIN); //PORT_ClrBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS1_PORT)) &= ~(1 << SEG_LCD_CS1_PIN); //PORT_ClrBit


    // PORT_ClrBit(SEG_LCD_SD);
    // PORT_ClrBit(SEG_LCD_SD1);

    // PORT_ClrBit(SEG_LCD_SCL);
    // PORT_ClrBit(SEG_LCD_SCL1);

    // PORT_ClrBit(SEG_LCD_CSB);
    // PORT_ClrBit(SEG_LCD_CSB1);

    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;

    // PORT_SetBit(SEG_LCD_SCL);
    // PORT_SetBit(SEG_LCD_SCL1);
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) |= (1 << SEG_LCD_SCL_PIN); //PORT_SetBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL1_PORT)) |= (1 << SEG_LCD_SCL1_PIN); //PORT_SetBit


    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;

    for (i = 0; i < 8; i++) {
        // PORT_ClrBit(SEG_LCD_SCL);
        // PORT_ClrBit(SEG_LCD_SCL1);
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) &= ~(1 << SEG_LCD_SCL_PIN); //PORT_ClrBit
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL1_PORT)) &= ~(1 << SEG_LCD_SCL1_PIN); //PORT_ClrBit

        if (Cmd & 0x80) {
            // PORT_SetBit(SEG_LCD_SD);
            // PORT_SetBit(SEG_LCD_SD1);
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) |= (1 << SEG_LCD_SD_PIN); } //PORT_SetBit
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD1_PORT)) |= (1 << SEG_LCD_SD1_PIN); } //PORT_SetBit
        }
        else {
            // PORT_ClrBit(SEG_LCD_SD);
            // PORT_ClrBit(SEG_LCD_SD1);
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) &= ~(1 << SEG_LCD_SD_PIN); } //PORT_ClrBit
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD1_PORT)) &= ~(1 << SEG_LCD_SD1_PIN); } //PORT_ClrBit
        }

        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;

        // PORT_SetBit(SEG_LCD_SCL);
        // PORT_SetBit(SEG_LCD_SCL1);
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) |= (1 << SEG_LCD_SCL_PIN); //PORT_SetBit
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL1_PORT)) |= (1 << SEG_LCD_SCL1_PIN); //PORT_SetBit

        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;

        Cmd <<= 1;
    }

    // PORT_SetBit(SEG_LCD_CSB);
    // PORT_SetBit(SEG_LCD_CSB1);
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS_PORT)) |= (1 << SEG_LCD_CS_PIN); //PORT_SetBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS1_PORT)) |= (1 << SEG_LCD_CS1_PIN); //PORT_SetBit

    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
}

/******************************************************************************
BU98R10_All_Data_Write
  ܣͬʱBU98R10оƬ0оƬ1д
  Dat0ҪдBU98R10оƬ0
        Dat1ҪдBU98R10оƬ1
ֵ
******************************************************************************/
void BU98R10_All_Data_Write(uint8_t Dat0, uint8_t Dat1)
{
    uint8_t i;

    //D/C = 1,ʾ
    // PORT_SetBit(SEG_LCD_SD);
    // PORT_SetBit(SEG_LCD_SD1);

    // PORT_ClrBit(SEG_LCD_SCL);
    // PORT_ClrBit(SEG_LCD_SCL1);

    // PORT_ClrBit(SEG_LCD_CSB);
    // PORT_ClrBit(SEG_LCD_CSB1);
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) |= (1 << SEG_LCD_SD_PIN); //PORT_SetBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) &= ~(1 << SEG_LCD_SCL_PIN); //PORT_ClrBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS_PORT)) &= ~(1 << SEG_LCD_CS_PIN); //PORT_ClrBit

    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD1_PORT)) |= (1 << SEG_LCD_SD1_PIN); //PORT_SetBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL1_PORT)) &= ~(1 << SEG_LCD_SCL1_PIN); //PORT_ClrBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS1_PORT)) &= ~(1 << SEG_LCD_CS1_PIN); //PORT_ClrBit

    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;

    // PORT_SetBit(SEG_LCD_SCL);
    // PORT_SetBit(SEG_LCD_SCL1);
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) |= (1 << SEG_LCD_SCL_PIN); //PORT_SetBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL1_PORT)) |= (1 << SEG_LCD_SCL1_PIN); //PORT_SetBit

    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;

    for (i = 0; i < 8; i++) {
        // PORT_ClrBit(SEG_LCD_SCL);
        // PORT_ClrBit(SEG_LCD_SCL1);
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) &= ~(1 << SEG_LCD_SCL_PIN); //PORT_ClrBit
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL1_PORT)) &= ~(1 << SEG_LCD_SCL1_PIN); //PORT_ClrBit

        if (Dat0 & 0x80)
        // { PORT_SetBit(SEG_LCD_SD); }
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) |= (1 << SEG_LCD_SD_PIN); } //PORT_SetBit
        else
        // { PORT_ClrBit(SEG_LCD_SD); }
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD_PORT)) &= ~(1 << SEG_LCD_SD_PIN); } //PORT_ClrBit
        if (Dat1 & 0x80)
        // { PORT_SetBit(SEG_LCD_SD1); }
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD1_PORT)) |= (1 << SEG_LCD_SD1_PIN); } //PORT_SetBit
        else
        // { PORT_ClrBit(SEG_LCD_SD1); }
        { *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SD1_PORT)) &= ~(1 << SEG_LCD_SD1_PIN); } //PORT_ClrBit

        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;

        // PORT_SetBit(SEG_LCD_SCL);
        // PORT_SetBit(SEG_LCD_SCL1);
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL_PORT)) |= (1 << SEG_LCD_SCL_PIN); //PORT_SetBit
        *((volatile uint8_t *)(0x40040300UL + SEG_LCD_SCL1_PORT)) |= (1 << SEG_LCD_SCL1_PIN); //PORT_SetBit

        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;
        // BU98R10_DELAY_NS;

        Dat0 <<= 1;
        Dat1 <<= 1;
    }

    // PORT_SetBit(SEG_LCD_CSB);
    // PORT_SetBit(SEG_LCD_CSB1);
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS_PORT)) |= (1 << SEG_LCD_CS_PIN); //PORT_SetBit
    *((volatile uint8_t *)(0x40040300UL + SEG_LCD_CS1_PORT)) |= (1 << SEG_LCD_CS1_PIN); //PORT_SetBit

    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
    // BU98R10_DELAY_NS;
}

#if 0
static void BU98R10_All_ReadRam(uint8_t addr, uint8_t *data0, uint8_t *data1)
{
    uint8_t i;
    uint8_t Cmd = 0x09;
    uint8_t wdata0 = 0;
    uint8_t wdata1 = 0;

    BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
    BU98R10_All_Data_Write(addr, addr);

    Cmd = 0x09;
    // D/C = 0,ʾ
    //SegLCD_Set_SD(0);
    //SegLCD_Set_SCL(0);
    //SegLCD_Set_CSB(0);

    //PORT_ClrBit(SEG_LCD_SD);
    //PORT_ClrBit(SEG_LCD_SCL);
    //PORT_ClrBit(SEG_LCD_CSB);

    PORT_ClrBit(SEG_LCD_SD1);
    PORT_ClrBit(SEG_LCD_SCL1);
    PORT_ClrBit(SEG_LCD_CSB1);


    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;

    //SegLCD_Set_SCL(1);
    //PORT_SetBit(SEG_LCD_SCL);
    PORT_SetBit(SEG_LCD_SCL1);

    for (i = 0; i < 8; i++) {
        //SegLCD_Set_SCL(0);
        //PORT_ClrBit(SEG_LCD_SCL);
        PORT_ClrBit(SEG_LCD_SCL1);

        if (Cmd & 0x80) {
            //SegLCD_Set_SD(1);
            //PORT_SetBit(SEG_LCD_SD);
            PORT_SetBit(SEG_LCD_SD1);
        }
        else {
            //SegLCD_Set_SD(0);
            //PORT_ClrBit(SEG_LCD_SD);
            PORT_ClrBit(SEG_LCD_SD1);
        }

        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;
        BU98R10_DELAY_NS;

        //SegLCD_Set_SCL(1);
        //PORT_SetBit(SEG_LCD_SCL);
        PORT_SetBit(SEG_LCD_SCL1);


        Cmd <<= 1;
    }

    //SegLCD_Set_SD_Dir(0);
    //PORT_Init(SEG_LCD_SD, INPUT);
    PORT_Init(SEG_LCD_SD1, INPUT);

    //SegLCD_Set_SCL(0);
    //PORT_ClrBit(SEG_LCD_SCL);
    PORT_ClrBit(SEG_LCD_SCL1);

    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;

    //SegLCD_Set_SCL(1);
    //PORT_SetBit(SEG_LCD_SCL);
    PORT_SetBit(SEG_LCD_SCL1);

    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;
    BU98R10_DELAY_NS;

    for (i = 0; i < 8; i++) {
        //SegLCD_Set_SCL(0);
        //PORT_ClrBit(SEG_LCD_SCL);
        PORT_ClrBit(SEG_LCD_SCL1);
        //wdata0 <<= 1;
        wdata1 <<= 1;
        //SegLCD_Set_SCL(1);
        //PORT_SetBit(SEG_LCD_SCL);
        PORT_SetBit(SEG_LCD_SCL1);

        /*if (SegLCD_Get_SD0_Data)
        {
        	wdata0 |= SegLCD_Get_SD0_Data;
        }
        if (SegLCD_Get_SD1_Data)
        {
        	wdata1 |= SegLCD_Get_SD1_Data;
        }*/
        //if (PORT_GetBit(SEG_LCD_SD))
        {
            //wdata0 |= PORT_GetBit(SEG_LCD_SD);
        }

        if (PORT_GetBit(SEG_LCD_SD1)) {
            wdata1 |= PORT_GetBit(SEG_LCD_SD1);
        }
    }

    *data0 = wdata0;
    *data1 = wdata1;

    //SegLCD_Set_SD_Dir(1);
    //PORT_Init(SEG_LCD_SD, OUTPUT);
    PORT_Init(SEG_LCD_SD1, OUTPUT);


    //SegLCD_Set_CSB(1);
    //PORT_SetBit(SEG_LCD_CSB);
    PORT_SetBit(SEG_LCD_CSB1);
}
#endif




#endif

uint8_t checkInterval = 0;
uint8_t checkCount = 0;
uint8_t checkData[2];
uint8_t checkDelay = 0;
void checkSegTftState(void)
{
#if 0

    if (System_FUN_KL15_Status_Get()) {
        if(checkDelay == 0) {
            checkInterval++;

            if (checkInterval >= 5) {
                BU98R10_0_ReadRam(37, &checkData[0], &checkData[1]); // seg61  ͼ귽 (61+1)/2 -1 =30  ==0x07   쳣ʱ heckData[1]= 0xff
                checkInterval = 0;

                if ((checkData[1] & 0x0f) != 0x07) {
                    checkCount = 50;
                    BU98R10Chip1DDRAMBackup.Bit.Seg75 = 0;  //BU98R10_1_SEG75
                }
            }
        }
        else {
            checkDelay --;
            checkInterval = 0;
        }

        if(checkCount > 0) {
            checkCount--;
        }

        if (checkCount == 30) {
            checkDelay = 20;
            SEG_LCD_Init();
        }
    }
    else {
        checkInterval = 0;
        checkCount = 0;
    }

#endif
}

