/******************************************************************************
文 件 名：Simulated_IIC_Master.h
功能描述：IO端口模拟的IIC(I2C)主机函数库头文件
作    者：张暄
版    本：V1.0
日    期：2016.12.21
******************************************************************************/

#ifndef _SIMULATED_IIC_MASTER_H_
#define _SIMULATED_IIC_MASTER_H_

#include "common.h"

/******************************************************************************
1us延时校准
******************************************************************************/
#define   IIC_FREQ_CALIBRATION          4

/******************************************************************************
确认信号
******************************************************************************/
#define   IIC_ACK                       0              //肯定应答
#define   IIC_NAK                       1              //否定应答
#define   IIC_INVALID_ACK               2              //无效的应答信号(应答信号还未收到)


/******************************************************************************
函数声明
******************************************************************************/
void      LtDet_IIC_Init(void);
void      LtDet_IIC_Start(void);
void      LtDet_IIC_Stop(void);
void      LtDet_IIC_Transmit_Data(uint8_t Data);
uint8_t   LtDet_IIC_Receive_Data(void);
void      LtDet_IIC_Transmit_ACK(uint8_t ACK);
uint8_t   LtDet_IIC_Receive_ACK(void);
void      LtDet_IIC_Delay(void);

#endif
