/**************************************************************************//**
  * \file     Tasks.c
  * \brief    Task list
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     07-Sep-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/
#include "BAT32A239.h"
#include "common.h"
#include "Sys_Scheduler.h"
#include "Line_In.h"
#include "adc.h"
#include "Analog_Signals.h"

#include "PowerManagement.h"
#include "System_Monitor.h"
#include "Common_Interface.h"
#include "PowerManagement_user.h"
#include "Telltales_Lib.h"
#include "Sys_Tick.h"
#include "Fuel.h" 

#include "rtc.h" 
#include "Flash_synchronizer.h"
#include "eepromManage.h"
#include "Data_Gear.h"
#include "LightDetect.h"
#include "BGLInterface.h"
#include "Key.h"

#include "CAN_User.h"
#include "gpio.h"
#include "uds_includes.h"
#include "U2_uds_includes.h"

#include "BU98R10.h"

#include "Services_Mileage_User.h"
#include "can.h"
#include "IS31FL3236.h"
#include "IS31_IIC_Master.h"
#include "app_Telltales.h"


/*******************************************************************************
*                                                                              *
*   系统常规运行模式(SYS_MODE_OFF / SYS_MODE_ON / SYS_MODE_STANDBY )任务列表   *
*                                                                              *
*******************************************************************************/

/*==============================================================================
伪实时任�?
------------------------------------------------------------------------------*/

void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{
 
    if (CAN_Initflag == 0xeb)
    {
        Diagnosis_main();
        // Key_Status_Detect_Service();
        // IS31FL3236_Update();
        U2_Diagnosis_main();
        //    DoCAN_Communication_Service();
        //    UDS_Server_Application_Service();
    }
}
/*============================================================================*/



/*==============================================================================
2ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_2ms_Tasks(void)
{
    Analog_Signal_Conv_Real_Time_Run();
    Power_Management_Service();
    Sys_Status_Update_Service();
	BU98R10_Update_Service();
}
/*============================================================================*/
/*==============================================================================
5ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_5ms_Tasks(void)
{

    CAN_RX_Tick();
	
}

/*==============================================================================
10ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_10ms_Tasks(void)
{
						
	Common_SetSelfcheckStart(1);
    Analog_Signal_Conv_Service();

    BackLightDamp(10u);
    
//    DisplayServices();
//    loc_Display_Service();
    Line_In_Debounce_Service();
    Telltales_Management();
    Can_BusOff_Fun(10u);

    Key_Status_Detect_Service();
    //Test();
    
//    Telltales_Left_Right_Management_Service();
//    Key_Service();
//    //CAN_BUSOFF_Recover();
//    /*车�?�处�?*/
//    SetGaugesPara(VehGauges, VehSpeedAmplification(Cal_Veh_Val()));
//    /*转�?�处�?*/
//    Common_Set_Act_E_Speed(Get_ID_CF00400_Sig_EngineSpeed() / 8);
//    SetGaugesPara(RevGauges, RevSpeedManage(Common_Get_Act_E_Speed()));

//    /*表头调度函数 added by yutian*/
//    UserGaugeSchedule();/*在主循环中调�?*/
//    /*end*/
//    Sound_Play_Service();
//    CD4051B_ReadSignal_Serviece();

//    Can_BusOff_Fun();

//    //for (i = 0; i < LED_Max ; i++)
//    //{
//    //    Telltales_DiagCtrl(i, 1u);
//    //}

        //if(Common_Get_IG_Sts() == COMMON_POWER_ON)
				

}
/*============================================================================*/


/*==============================================================================
20ms周期执行任务
------------------------------------------------------------------------------*/

void Sys_Run_Mode_20ms_Tasks(void)
{

    




	
    
	BU98R10_Update_Request();

    Diag_Req_Send(20);		
    IS31FL3236_Update();
 						



}
/*============================================================================*/


/*==============================================================================
50ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_50ms_Tasks(void)
{

	
	
    Flash_Sync_Signal_Generation_Service();


  



    BGTask();


    CAN_LED_Check_50msTask();


    SetDtcFault();




}
/*============================================================================*/


/*==============================================================================
100ms周期执行任务
------------------------------------------------------------------------------*/
uint32_t tempodo = 0;
uint32_t tempTripA = 0;
uint32_t tempTripB = 0;
void Sys_Run_Mode_100ms_Tasks_Group1(void)
{

//    static uint16_t CounterBak;
//    uint16_t delta;
//    if(SYS_ROLLING_COUNTER_1ms >= CounterBak){
//        delta = SYS_ROLLING_COUNTER_1ms - CounterBak;
//    }
//    else{
//        delta = 0xffff - CounterBak + SYS_ROLLING_COUNTER_1ms + 1;
//    }
//    CounterBak = SYS_ROLLING_COUNTER_1ms;  

	
    Power_Management_Service_user();

}
void Sys_Run_Mode_100ms_Tasks_Group2(void)
{


    /*燃油计算*/
    Fuel_Cal_Sevice(100u);

}
void Sys_Run_Mode_100ms_Tasks_Group3(void)
{


}
void Sys_Run_Mode_100ms_Tasks_Group4(void)
{
    

    /*获取RTC时间*/
    RTC_Service();
    

    /*大计小计计算*/
    CalcODO_100ms_Services();
	


}
void Sys_Run_Mode_100ms_Tasks_Group5(void)
{


}
void Sys_Run_Mode_100ms_Tasks_Group6(void)
{


 


}
void Sys_Run_Mode_100ms_Tasks_Group7(void)
{

 
    ReqSilentTimer100mSService();

    /*MIL灯超时计�?*/
    Can_User_Time_Service(100);

 }
void Sys_Run_Mode_100ms_Tasks_Group8(void)
{
	


    bsp_CAN_MaskCheck();
		
	
}
void Sys_Run_Mode_100ms_Tasks_Group9(void)
{	
		/*�?测断码屏数据是否异常*/
		//if(Common_GetIgnOnTime() > 1000)
		//checkSegTftState();

   
    /* 临时测试程序 �?�? */
    // tempodo = Data_ODO_Read( );
    // tempTripA = Data_Read_Trip(EM_TRIP_A);
    // tempTripB = Data_Read_Trip(EM_TRIP_B);
    /*  临时测试程序 结束 */

}
void Sys_Run_Mode_100ms_Tasks_Group10(void)
{

//    if(tempodo<123u) 
//        Data_ODO_Modify ( 123u );    
    
//			PORT->P7 ^= (1<<1); 	// Toggle P71
//		  PORT->P7 ^= (1<<2); 	// Toggle P72              
//    RTE_RTC_Services_100Ms_Cbk();
//    Data_ODO_Processing();
//    Data_Trip_Processing();
//    //Data_Avg_Speed_Processing();
//    Data_TPMS_Value_Processing();
//    Data_Ambient_Temperature_Processing();

//    //Display_Schedule_Service();/*显示函数入口*/

//    if ( Common_get_MotorModeStaFlag() == 0u)
//    {
//        if ((bsp_GetMotorState(0) == Normal) && (bsp_GetMotorState(1) == Normal))
//        {
//            bsp_SetMotorMode(0, MinReset);
//            bsp_SetMotorMode(1, MinReset);
//            Conmmon_Set_MotorModeStaFlag (1u);
//        }
//    }
//    else if ( Common_get_MotorModeStaFlag() == 1u)
//    {
//        if ((bsp_GetMotorState(0) == Normal) && (bsp_GetMotorState(1) == Normal))
//        {
//            bsp_SetMotorMode(0, MaxStep);
//            bsp_SetMotorMode(1, MaxStep);
//            Conmmon_Set_MotorModeStaFlag(2u);
//        }
//    }
//    else if (Common_get_MotorModeStaFlag() == 2u)
//    {
//        if ((bsp_GetMotorState(0) == MaxStepKeep) && (bsp_GetMotorState(1) == MaxStepKeep))
//        {
//            bsp_SetMotorMode(0, MinStep);
//            bsp_SetMotorMode(1, MinStep);
//            Conmmon_Set_MotorModeStaFlag(3u);
//        }
//    }
//    else
//    {
//        Conmmon_Set_MotorModeStaFlag(4u);
//        /*转�?�电机目标步赋�??*/
//        if (bsp_GetMotorState(0) == Normal)
//        {
//            MeterPostion[0].destPosition = GetGaugesCurrentPos(RevGauges);
//        }

//        /*车�?�电机目标步赋�??*/
//        if (bsp_GetMotorState(1) == Normal)
//        {
//            MeterPostion[1].destPosition = GetGaugesCurrentPos(VehGauges);
//        }
//    }

//    //Menu_Display_Service();
//    //External_Influence_ENERGY_RECOVERY_LEVEL_Select();
//    LongTimeNoKey_Operation();
//    //Menu_Get_Battery_Sts_Exist();
//    //BL_Management_service();
//    Popups_Management_Service();
//    Popup_Scheduling_Service();
//    /*综合油�?�信�?*/
//    Data_FuelCounsComprehensive();
//    /*小计油�?�信�?*/
//    Data_FuelCounsumpTrip();
//    /*本次油�?�信�?*/
//    Data_FuelCounsumpThisTime();
//    /*加油后行车信�?*/
//    Data_Info_Last_Refueling();

//    /*当前油�??*/
//    Fuel_CurrentFuelEco_Data();
//    /*综合油�??*/
//    Fuel_ComprehensiveFuelEco_Data();
//    /*综合气�??*/
//    Gas_ComprehensiveGasEco_Data();
//    /*机油压力*/
//    Oil_EngineOilPressure_Data();
}
/*============================================================================*/

/*******************************************************************************
*                                                                              *
*                     系统休眠模式(SYS_MODE_SLEEP)任务列表                     *
*                                                                              *
*******************************************************************************/
/*==============================================================================
休眠模式下执行的后台任务
------------------------------------------------------------------------------*/
void Sys_Sleep_Mode_Tasks(void)
{

}
/*============================================================================*/

/*******************************************************************************
*                                                                              *
*                           精确�?50us计时任务列表                             *
*                                                                              *
*******************************************************************************/
/*==============================================================================
精确�?50us计时任务 禁止添加修改列表中的任务
------------------------------------------------------------------------------*/
void Sys_Exact_50us_Tasks(void)
{
   
}
/*============================================================================*/

/*******************************************************************************
*                                                                              *
*                           精确�?100ms计时任务列表                            *
*                                                                              *
*******************************************************************************/
/*==============================================================================
精确�?100ms计时任务 禁止添加修改列表中的任务
------------------------------------------------------------------------------*/
void Sys_Exact_100ms_Tasks(void)
{
//    Service_OFF_Timing_Process();
//    PORT_ClrBit(CAN0_STB);


    /*不休眠的计时*/
}
/*============================================================================*/


void APP_Startup_Init (uint8_t startMode)
{
//    Power_Management_Init(startMode);
}



