

#ifndef LINE_IN_H__
#define LINE_IN_H__

#include "common.h"
#include "string.h"

/*
Note !  NOW LineIn only support 254 channel!!!!!
Note !  NOW LineIn only support 254 channel!!!!!
Note !  NOW LineIn only support 254 channel!!!!!
Note !  NOW LineIn only support 254 channel!!!!!
Note !  NOW LineIn only support 254 channel!!!!!
*/

/*?有硬线输入的索引*/
typedef enum
{
    LINE_IN_RightTurn = 0u, 
    LINE_IN_LeftTurn,
    LINE_IN_HighBeam,
    LINE_IN_ABS,
    LINE_IN_AutoStarStop,
    LINE_IN_TirePressure,
    LINE_IN_OilPressure,
    LINE_IN_OBD,
	
    LINE_IN_NUMBER,
} Line_In_Channel_en_t;




/*获取实时硬线电平函数指针*/
typedef struct
{

    LINE_IN_WorkSt_en_t enPowerStatus;      /*硬线工作的电源状?*/
    uint16_t u16ValidTime;                  /*从无效到有效的消抖时? ms*/
    uint16_t u16InvalidTime;                /*从有效到无效的消抖时?*/
    uint8_t (*pfnLineIn_Read_Cbk)(void);    /*获取实时电平的回调函?*/
} Line_In_Attribute_st_t;



extern void Line_In_SetPowerSt(LINE_IN_WorkSt_en_t u8PowerSt);
/*10ms调用*/
extern void Line_In_Debounce_Service(void);

extern LineIn_LogicLevel_en_t Line_In_Get_Status(uint8_t Channel);

extern void Line_In_KL30_Init(void);
extern void Line_In_KL15_ON_Init(void);
extern void Line_In_KL15_OFF_Init(void);



extern uint8_t LINE_IN_Get_RightTurn(void);
extern uint8_t LINE_IN_Get_LeftTurn(void);
extern uint8_t LINE_IN_Get_HighBeam(void);
extern uint8_t LINE_IN_Get_ABS(void);
extern uint8_t LINE_IN_Get_AutoStarStop(void);
extern uint8_t LINE_IN_Get_TirePressure(void);
extern uint8_t LINE_IN_Get_OilPressure(void);
extern uint8_t LINE_IN_Get_OBD(void);

#endif
