
#include "SEG_LCD.h"
#include "Flash_synchronizer.h"
#include "Data_Gear.h"
#include "MCU_Core_Protocol.h"
#include "Common_Interface.h"
#include "BU98R10.h"
#include "app_Telltales.h"
#include "string.h"

SEGLCDBackupStruct   SEGLCDBackup;

uint8_t   DispText[6];

                                       /*0,     1,     2,     3,     4,     5,     6,     7,     8,     9  */
const uint8_t SEG_DISPLAY_NUMBER0[] = {0x3Fu, 0x06u, 0x5Bu, 0x4Fu, 0x66u, 0x6Du, 0x7Du, 0x07u, 0x7Fu, 0x6Fu};
const uint8_t SEG_UNDISPLAY_NUMBER0[] = {0x00u, 0x06u, 0x5Bu, 0x4Fu, 0x66u, 0x6Du, 0x7Du, 0x07u, 0x7Fu, 0x6Fu};

                                         /*0,     1,     2,     3,     4,     5,     6,     7,     8,     9,     A,     B,     C,     D,     E,     F  */
const uint8_t SEG_HEX_DISPLAY_NUMBER0[] = {0x3Fu, 0x06u, 0x5Bu, 0x4Fu, 0x66u, 0x6Du, 0x7Du, 0x07u, 0x7Fu, 0x6Fu, 0x77u, 0x7Cu, 0x39u, 0x5Eu, 0x79u, 0x71u};


void SEG_LCD_Init(void)                
{
    SEG_LCD_Vehicle_Speed_Num_Display(0, 0, 0);
    SEG_LCD_Engine_Speed_Seg_Display(0, 0, 0);
    SEG_LCD_ODO_Trip_Display(0, 0, 0, 0);
    SEG_Fuel_Level_Display(0, 0);
    SEG_LCD_Battery_Voltage_Display(0, 0 ,0);
    SEG_Coolant_Temp_Display(0, 0);
    SEG_LCD_Gear_Display(0, 0, 0);

    BU98R10_Init();
}

void SEG_LCD_Shutdown(void)
{
    BU98R10_Shutdown();
    App_Telltales_AllOFF();

    SEGLCDBackup.Brightness = 0x00;
    SEGLCDBackup.Window     = 0x00;
}

void Conv_Single_DECHEX(uint8_t *m_NUM, uint32_t FaultCodeDisp)
{
    uint8_t temp8 = 0;
    uint8_t cont = 0;

    memset(m_NUM, 0, 4);
    if (FaultCodeDisp < 16)
    {
        m_NUM[0] = FaultCodeDisp;
    }
    
    while (FaultCodeDisp >= 16)
    {
        temp8 = (FaultCodeDisp % 16);
        m_NUM[cont] = temp8;
        cont++;
        FaultCodeDisp /= 16;
        if (FaultCodeDisp < 16)
            m_NUM[cont] = FaultCodeDisp;
    }
}

/******************************************************************************
��������SEG_LCD_Gear_Display
��  ��: ��λ����ʾ
��  ��:
����ֵ��
******************************************************************************/
void SEG_LCD_Gear_Display(uint8_t m_Flag, uint8_t SegNum, uint8_t CanStand)
{
    uint8_t Num;
    uint8_t m8;
    static uint8_t Gear;

    if (m_Flag == 1)
    {
        PORT_SetBit(LightModeCtrl);  //背光 ON

        if (CanStand == CAN_SIG_NORMAL)
        {
            Gear = SegNum;
        }
        
        if (SEGLCDBackup.Gear != Gear)
        {
            SEGLCDBackup.Gear = Gear;

            BU98R10_1_SEG46 = SEG_LCD_LIGHT; // Mode
            BU98R10_1_SEG47 = SEG_LCD_LIGHT; // P

            if (Gear >= 2)
            {
                BU98R10_1_SEG54 = SEG_LCD_OFF;

                BU98R10_1_SEG53 = SEG_LCD_OFF;
                BU98R10_1_SEG52 = SEG_LCD_OFF;
                BU98R10_1_SEG51 = SEG_LCD_OFF;
                BU98R10_1_SEG50 = SEG_LCD_OFF;
                BU98R10_1_SEG48 = SEG_LCD_OFF;
                BU98R10_1_SEG49 = SEG_LCD_LIGHT;
            }
            else
            {
                /*个位*/
                Num = Gear % 10u;
                m8 = SEG_DISPLAY_NUMBER0[Num];
                if (Bit_Is_Set(m8, 0))
                {
                    BU98R10_1_SEG54 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_1_SEG54 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 1))
                {
                    BU98R10_1_SEG53 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_1_SEG53 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 2))
                {
                    BU98R10_1_SEG52 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_1_SEG52 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 3))
                {
                    BU98R10_1_SEG51 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_1_SEG51 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 4))
                {
                    BU98R10_1_SEG50 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_1_SEG50 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 5))
                {
                    BU98R10_1_SEG48 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_1_SEG48 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 6))
                {
                    BU98R10_1_SEG49 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_1_SEG49 = SEG_LCD_OFF;
                }
            }

        }
    }
    else
    {
        PORT_ClrBit(LightModeCtrl);  //背光OFF

        BU98R10_1_SEG46 = SEG_LCD_OFF; // Mode
        BU98R10_1_SEG47 = SEG_LCD_OFF; // P
        
        BU98R10_1_SEG54 = SEG_LCD_OFF;
        BU98R10_1_SEG53 = SEG_LCD_OFF;
        BU98R10_1_SEG52 = SEG_LCD_OFF;
        BU98R10_1_SEG51 = SEG_LCD_OFF;
        BU98R10_1_SEG50 = SEG_LCD_OFF;
        BU98R10_1_SEG48 = SEG_LCD_OFF;
        BU98R10_1_SEG49 = SEG_LCD_OFF;
        SEGLCDBackup.Gear = 0xff;
    }
}

void SEG_LCD_Gear_Selftest(uint8_t Gear)
{
    uint8_t Num;
    uint8_t m8;

    PORT_SetBit(LightModeCtrl);  //背光 ON
    if (SEGLCDBackup.Gear != Gear)
    {
        SEGLCDBackup.Gear = Gear;

        BU98R10_1_SEG46 = SEG_LCD_LIGHT; // Mode
        BU98R10_1_SEG47 = SEG_LCD_LIGHT; // P

        /*个位*/
        Gear = Gear > 9 ? 9 : Gear;
        Num = Gear % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_1_SEG54 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG54 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_1_SEG53 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG53 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_1_SEG52 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG52 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_1_SEG51 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG51 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_1_SEG50 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG50 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_1_SEG48 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG48 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_1_SEG49 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG49 = SEG_LCD_OFF;
        }
    }
}

/******************************************************************************
��������SEG_LCD_Vehicle_Speed_Num_Display
��  ��: ���복����ʾ    
��  ��:
����ֵ��                               
******************************************************************************/
void SEG_LCD_Vehicle_Speed_Num_Display(uint8_t m_Flag, uint8_t SetMode ,uint16_t Vspeed)
{
    uint8_t Num;
    uint8_t m8;

    if (m_Flag == 1)
    {
        if ((SEGLCDBackup.VSpeed != Vspeed) || (SEGLCDBackup.SetMode != SetMode))
        {
            SEGLCDBackup.VSpeed = Vspeed;
            SEGLCDBackup.SetMode = SetMode;

            if(SetMode == 1)
            {
                BU98R10_1_SEG64 = SEG_LCD_LIGHT;  //mph
                BU98R10_1_SEG63 = SEG_LCD_OFF;
            }
            else
            {
                BU98R10_1_SEG63 = SEG_LCD_LIGHT;  //km/h
                BU98R10_1_SEG64 = SEG_LCD_OFF;
            }

            /*百位*/
            Num = Vspeed / 100u;
            if (Num >= 1u)
            {
                BU98R10_0_SEG51 = SEG_LCD_LIGHT;
                PORT_SetBit(LightVehHundredsCtrl);
            }
            else
            {
                BU98R10_0_SEG51 = SEG_LCD_OFF;
                PORT_ClrBit(LightVehHundredsCtrl);
            }
            /*十位*/
            Num = (Vspeed / 10u) % 10u;
            if (Vspeed >= 10u)
            {
                PORT_SetBit(LightVehTensCtrl);
            }
            else
            {
                PORT_ClrBit(LightVehTensCtrl);
            }
            if (Vspeed >= 100u)
            {
                m8 = SEG_DISPLAY_NUMBER0[Num];
            }
            else
            {
                m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }

            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_0_SEG43 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG43 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_0_SEG42 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG42 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_0_SEG41 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG41 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_0_SEG34 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG34 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_0_SEG48 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG48 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_0_SEG46 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG46 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_0_SEG47 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG47 = SEG_LCD_OFF;
            }
            /*个位*/
            Num = Vspeed % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_1_SEG62 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_1_SEG62 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_1_SEG61 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_1_SEG61 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_1_SEG59 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_1_SEG59 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_1_SEG58 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_1_SEG58 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_1_SEG57 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_1_SEG57 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_1_SEG56 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_1_SEG56 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_1_SEG60 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_1_SEG60 = SEG_LCD_OFF;
            }
        }
    }
    else
    {
        BU98R10_1_SEG64 = SEG_LCD_OFF; // mph
        BU98R10_1_SEG63 = SEG_LCD_OFF; // km/h

        BU98R10_0_SEG51 = SEG_LCD_OFF;

        BU98R10_0_SEG43 = SEG_LCD_OFF;
        BU98R10_0_SEG42 = SEG_LCD_OFF;
        BU98R10_0_SEG41 = SEG_LCD_OFF;
        BU98R10_0_SEG34 = SEG_LCD_OFF;
        BU98R10_0_SEG48 = SEG_LCD_OFF;
        BU98R10_0_SEG46 = SEG_LCD_OFF;
        BU98R10_0_SEG47 = SEG_LCD_OFF;

        BU98R10_1_SEG62 = SEG_LCD_OFF;
        BU98R10_1_SEG61 = SEG_LCD_OFF;
        BU98R10_1_SEG59 = SEG_LCD_OFF;
        BU98R10_1_SEG58 = SEG_LCD_OFF;
        BU98R10_1_SEG57 = SEG_LCD_OFF;
        BU98R10_1_SEG56 = SEG_LCD_OFF;
        BU98R10_1_SEG60 = SEG_LCD_OFF;

        SEGLCDBackup.VSpeed = 0xFFFF;
        SEGLCDBackup.SetMode = 0xFF;
    }
    
}
void SEG_LCD_Vehicle_Speed_Num_Selftest(uint16_t Vspeed)
{
    uint8_t Num;
    uint8_t m8;

    if (SEGLCDBackup.VSpeed != Vspeed)
    {
        SEGLCDBackup.VSpeed = Vspeed;
        SEGLCDBackup.SetMode = 0xFF;;

        BU98R10_1_SEG63 = SEG_LCD_LIGHT;  //km/h
        BU98R10_1_SEG64 = SEG_LCD_LIGHT;

        Vspeed = Vspeed > 9 ? 9 : Vspeed;

        /*百位*/
        if (Vspeed)
        {
            BU98R10_0_SEG51 = SEG_LCD_LIGHT;
            PORT_SetBit(LightVehHundredsCtrl);
        }
        else
        {
            BU98R10_0_SEG51 = SEG_LCD_OFF;
            PORT_ClrBit(LightVehHundredsCtrl);
        }
        
        /*十位*/
        PORT_SetBit(LightVehTensCtrl);
        Num = Vspeed % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];

        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_0_SEG43 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG43 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_0_SEG42 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG42 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_0_SEG41 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG41 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_0_SEG34 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG34 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_0_SEG48 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG48 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_0_SEG46 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG46 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_0_SEG47 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG47 = SEG_LCD_OFF;
        }
        /*个位*/
        Num = Vspeed % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_1_SEG62 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG62 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_1_SEG61 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG61 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_1_SEG59 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG59 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_1_SEG58 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG58 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_1_SEG57 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG57 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_1_SEG56 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG56 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_1_SEG60 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_1_SEG60 = SEG_LCD_OFF;
        }
    }    
}
/******************************************************************************
��������SEG_LCD_Engine_Speed_Seg_Display
��  ��: ת�ٵ�SEG��ʾ    
��  ��:
����ֵ��                               
******************************************************************************/
uint16_t DispSegNum = 0 ;
uint8_t OldSpeedStand = 0 ;
void SEG_LCD_Engine_Speed_Seg_Display(uint8_t m_Flag, uint16_t SegNum, uint8_t SpeedStand)
{
    static uint8_t time = 0;

    if (m_Flag == 1)
    {
        SegNum = (SegNum + SegNum / 20) / 500;

        if (SegNum > 24)
            SegNum = 24;

        if (SpeedStand == 1)
        {
            OldSpeedStand = 5;
        }

        if (DispSegNum > SegNum)
        {
            if (time >= 2)
            {
                time = 0;
                DispSegNum--;
            }
        }

        if (DispSegNum < SegNum)
        {
            DispSegNum++;
            if (OldSpeedStand)
            {
                OldSpeedStand--;
                DispSegNum = SegNum;
            }
        }

        time++;
        BU98R10_0_SEG130  = SEG_LCD_OFF; //Mark
        BU98R10_1_SEG70  = SEG_LCD_OFF; //Mark
        BU98R10_1_SEG31  = SEG_LCD_OFF; //Mark
        BU98R10_0_SEG101  = SEG_LCD_LIGHT; //Touch1
        BU98R10_1_SEG55  = SEG_LCD_LIGHT; //Touch1
        BU98R10_0_SEG37  = SEG_LCD_LIGHT; //X1000r/min
        
        BU98R10_0_SEG96  = SEG_LCD_LIGHT;
        BU98R10_0_SEG91  = SEG_LCD_LIGHT;
        BU98R10_0_SEG86  = SEG_LCD_LIGHT;
        BU98R10_0_SEG81  = SEG_LCD_LIGHT;  
        BU98R10_0_SEG76  = SEG_LCD_LIGHT;
        BU98R10_0_SEG72  = SEG_LCD_LIGHT;
        BU98R10_0_SEG71  = SEG_LCD_LIGHT;
        BU98R10_0_SEG70  = SEG_LCD_LIGHT;
        BU98R10_0_SEG69  = SEG_LCD_LIGHT;
        BU98R10_0_SEG63  = SEG_LCD_LIGHT;
        BU98R10_0_SEG58  = SEG_LCD_LIGHT;
        BU98R10_0_SEG53  = SEG_LCD_LIGHT;
        BU98R10_0_SEG49  = SEG_LCD_LIGHT;
        BU98R10_0_SEG44  = SEG_LCD_LIGHT;
        BU98R10_0_SEG38  = SEG_LCD_LIGHT;
        BU98R10_0_SEG36  = SEG_LCD_LIGHT;
        BU98R10_0_SEG32  = SEG_LCD_LIGHT;
        BU98R10_0_SEG31  = SEG_LCD_LIGHT;
        BU98R10_0_SEG16  = SEG_LCD_LIGHT;
        BU98R10_0_SEG17  = SEG_LCD_LIGHT;
        BU98R10_0_SEG18  = SEG_LCD_LIGHT;
        BU98R10_0_SEG21  = SEG_LCD_LIGHT;
        BU98R10_0_SEG23  = SEG_LCD_LIGHT;
        BU98R10_0_SEG25  = SEG_LCD_LIGHT;
        BU98R10_0_SEG26  = SEG_LCD_LIGHT;



            
        if (SEGLCDBackup.ESpeedSeg != DispSegNum)
        {

            SEGLCDBackup.ESpeedSeg = DispSegNum;
            BU98R10_0_SEG100  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG95  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG90  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG85  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG80  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG75  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG74  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG73  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG68  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG64  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG59  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG54  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG50  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG45  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG40  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG39  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG35  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG33  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG30  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG29  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG19  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG20  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG22  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG24  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG27  = SEG_LCD_GRAY_2;
            BU98R10_0_SEG28  = SEG_LCD_GRAY_2;

            switch (DispSegNum)
            {
                case 24 :  BU98R10_0_SEG27 = SEG_LCD_LIGHT;  
                case 23 :  BU98R10_0_SEG24 = SEG_LCD_LIGHT;
                case 22 :  BU98R10_0_SEG22 = SEG_LCD_LIGHT; 
                case 21 :  BU98R10_0_SEG20 = SEG_LCD_LIGHT;            
                case 20 :  BU98R10_0_SEG19 = SEG_LCD_LIGHT;          
                case 19 :  BU98R10_0_SEG29 = SEG_LCD_LIGHT;           
                case 18 :  BU98R10_0_SEG30 = SEG_LCD_LIGHT;          
                case 17 :  BU98R10_0_SEG33 = SEG_LCD_LIGHT; 
                case 16 :  BU98R10_0_SEG35 = SEG_LCD_LIGHT;  
                case 15 :  BU98R10_0_SEG39 = SEG_LCD_LIGHT;   
                case 14 :  BU98R10_0_SEG40 = SEG_LCD_LIGHT;   
                case 13 :  BU98R10_0_SEG45 = SEG_LCD_LIGHT; 
                case 12 :  BU98R10_0_SEG50 = SEG_LCD_LIGHT; 
                case 11 :  BU98R10_0_SEG54 = SEG_LCD_LIGHT; 
                case 10 :  BU98R10_0_SEG59 = SEG_LCD_LIGHT; 
                case 9  :  BU98R10_0_SEG64 = SEG_LCD_LIGHT;
                case 8  :  BU98R10_0_SEG68 = SEG_LCD_LIGHT; 
                case 7  :  BU98R10_0_SEG73 = SEG_LCD_LIGHT; 
                case 6  :  BU98R10_0_SEG74 = SEG_LCD_LIGHT; 
                case 5  :  BU98R10_0_SEG75 = SEG_LCD_LIGHT; 
                case 4  :  BU98R10_0_SEG80 = SEG_LCD_LIGHT; 
                case 3  :  BU98R10_0_SEG85 = SEG_LCD_LIGHT;           
                case 2  :  BU98R10_0_SEG90 = SEG_LCD_LIGHT;           
                case 1  :  BU98R10_0_SEG95 = SEG_LCD_LIGHT;          
                default : break;
            }

        }
    }
    else
    {
        BU98R10_0_SEG130  = SEG_LCD_OFF; //Mark
        BU98R10_1_SEG70  = SEG_LCD_OFF; //Mark
        BU98R10_1_SEG31  = SEG_LCD_OFF; //Mark
        BU98R10_0_SEG101  = SEG_LCD_OFF; //Touch1
        BU98R10_1_SEG55  = SEG_LCD_OFF; //Touch1
        BU98R10_0_SEG37  = SEG_LCD_OFF; //X1000r/min
        
        BU98R10_0_SEG96  = SEG_LCD_OFF;
        BU98R10_0_SEG91  = SEG_LCD_OFF;
        BU98R10_0_SEG86  = SEG_LCD_OFF;
        BU98R10_0_SEG81  = SEG_LCD_OFF;  
        BU98R10_0_SEG76  = SEG_LCD_OFF;
        BU98R10_0_SEG72  = SEG_LCD_OFF;
        BU98R10_0_SEG71  = SEG_LCD_OFF;
        BU98R10_0_SEG70  = SEG_LCD_OFF;
        BU98R10_0_SEG69  = SEG_LCD_OFF;
        BU98R10_0_SEG63  = SEG_LCD_OFF;
        BU98R10_0_SEG58  = SEG_LCD_OFF;
        BU98R10_0_SEG53  = SEG_LCD_OFF;
        BU98R10_0_SEG49  = SEG_LCD_OFF;
        BU98R10_0_SEG44  = SEG_LCD_OFF;
        BU98R10_0_SEG38  = SEG_LCD_OFF;
        BU98R10_0_SEG36  = SEG_LCD_OFF;
        BU98R10_0_SEG32  = SEG_LCD_OFF;
        BU98R10_0_SEG31  = SEG_LCD_OFF;
        BU98R10_0_SEG16  = SEG_LCD_OFF;
        BU98R10_0_SEG17  = SEG_LCD_OFF;
        BU98R10_0_SEG18  = SEG_LCD_OFF;
        BU98R10_0_SEG21  = SEG_LCD_OFF;
        BU98R10_0_SEG23  = SEG_LCD_OFF;
        BU98R10_0_SEG25  = SEG_LCD_OFF;
        BU98R10_0_SEG26  = SEG_LCD_OFF;

        BU98R10_0_SEG100  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG95  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG90  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG85  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG80  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG75  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG74  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG73  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG68  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG64  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG59  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG54  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG50  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG45  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG40  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG39  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG35  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG33  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG30  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG29  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG19  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG20  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG22  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG24  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG27  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG28  = SEG_LCD_GRAY_2;

        SEGLCDBackup.ESpeedSeg = 0xff;
    }

}
void SEG_LCD_Engine_Speed_Seg_Selftest(uint16_t SegNum)
{
    SegNum = (SegNum+SegNum/20)/500;
    if (SegNum > 24)
        SegNum = 24;

    BU98R10_0_SEG130  = SEG_LCD_OFF; //Mark
    BU98R10_1_SEG70  = SEG_LCD_OFF; //Mark
    BU98R10_1_SEG31  = SEG_LCD_OFF; //Mark
    BU98R10_0_SEG101  = SEG_LCD_LIGHT; //Touch1
    BU98R10_1_SEG55  = SEG_LCD_LIGHT; //Touch1
    BU98R10_0_SEG37  = SEG_LCD_LIGHT; //X1000r/min
    
    BU98R10_0_SEG96  = SEG_LCD_LIGHT;
    BU98R10_0_SEG91  = SEG_LCD_LIGHT;
    BU98R10_0_SEG86  = SEG_LCD_LIGHT;
    BU98R10_0_SEG81  = SEG_LCD_LIGHT;  
    BU98R10_0_SEG76  = SEG_LCD_LIGHT;
    BU98R10_0_SEG72  = SEG_LCD_LIGHT;
    BU98R10_0_SEG71  = SEG_LCD_LIGHT;
    BU98R10_0_SEG70  = SEG_LCD_LIGHT;
    BU98R10_0_SEG69  = SEG_LCD_LIGHT;
    BU98R10_0_SEG63  = SEG_LCD_LIGHT;
    BU98R10_0_SEG58  = SEG_LCD_LIGHT;
    BU98R10_0_SEG53  = SEG_LCD_LIGHT;
    BU98R10_0_SEG49  = SEG_LCD_LIGHT;
    BU98R10_0_SEG44  = SEG_LCD_LIGHT;
    BU98R10_0_SEG38  = SEG_LCD_LIGHT;
    BU98R10_0_SEG36  = SEG_LCD_LIGHT;
    BU98R10_0_SEG32  = SEG_LCD_LIGHT;
    BU98R10_0_SEG31  = SEG_LCD_LIGHT;
    BU98R10_0_SEG16  = SEG_LCD_LIGHT;
    BU98R10_0_SEG17  = SEG_LCD_LIGHT;
    BU98R10_0_SEG18  = SEG_LCD_LIGHT;
    BU98R10_0_SEG21  = SEG_LCD_LIGHT;
    BU98R10_0_SEG23  = SEG_LCD_LIGHT;
    BU98R10_0_SEG25  = SEG_LCD_LIGHT;
    BU98R10_0_SEG26  = SEG_LCD_LIGHT;

        
    if (SEGLCDBackup.ESpeedSeg != SegNum)
    {

        SEGLCDBackup.ESpeedSeg = SegNum;
        BU98R10_0_SEG100  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG95  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG90  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG85  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG80  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG75  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG74  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG73  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG68  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG64  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG59  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG54  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG50  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG45  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG40  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG39  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG35  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG33  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG30  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG29  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG19  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG20  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG22  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG24  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG27  = SEG_LCD_GRAY_2;
        BU98R10_0_SEG28  = SEG_LCD_GRAY_2;

        switch (SegNum)
        {
            case 24 :  BU98R10_0_SEG27 = SEG_LCD_LIGHT;  
            case 23 :  BU98R10_0_SEG24 = SEG_LCD_LIGHT;
            case 22 :  BU98R10_0_SEG22 = SEG_LCD_LIGHT; 
            case 21 :  BU98R10_0_SEG20 = SEG_LCD_LIGHT;            
            case 20 :  BU98R10_0_SEG19 = SEG_LCD_LIGHT;          
            case 19 :  BU98R10_0_SEG29 = SEG_LCD_LIGHT;           
            case 18 :  BU98R10_0_SEG30 = SEG_LCD_LIGHT;          
            case 17 :  BU98R10_0_SEG33 = SEG_LCD_LIGHT; 
            case 16 :  BU98R10_0_SEG35 = SEG_LCD_LIGHT;  
            case 15 :  BU98R10_0_SEG39 = SEG_LCD_LIGHT;   
            case 14 :  BU98R10_0_SEG40 = SEG_LCD_LIGHT;   
            case 13 :  BU98R10_0_SEG45 = SEG_LCD_LIGHT; 
            case 12 :  BU98R10_0_SEG50 = SEG_LCD_LIGHT; 
            case 11 :  BU98R10_0_SEG54 = SEG_LCD_LIGHT; 
            case 10 :  BU98R10_0_SEG59 = SEG_LCD_LIGHT; 
            case 9  :  BU98R10_0_SEG64 = SEG_LCD_LIGHT;
            case 8  :  BU98R10_0_SEG68 = SEG_LCD_LIGHT; 
            case 7  :  BU98R10_0_SEG73 = SEG_LCD_LIGHT; 
            case 6  :  BU98R10_0_SEG74 = SEG_LCD_LIGHT; 
            case 5  :  BU98R10_0_SEG75 = SEG_LCD_LIGHT; 
            case 4  :  BU98R10_0_SEG80 = SEG_LCD_LIGHT; 
            case 3  :  BU98R10_0_SEG85 = SEG_LCD_LIGHT;           
            case 2  :  BU98R10_0_SEG90 = SEG_LCD_LIGHT;           
            case 1  :  BU98R10_0_SEG95 = SEG_LCD_LIGHT;          
            default : break;
        }

    }

}

/******************************************************************************
�������SSEG_LCD_ODO_Trip_Display
��  ��: ODO_Trip������ʾ    
��  ��: Mode0:TOTAL ,Mode1:Trip 1 ,Mode2:Trip 2 ,Mode3:FaultCode, Unit0:km ,Unit1:miles
����ֵ��                               
******************************************************************************/
void SEG_LCD_ODO_Trip_Display(uint8_t m_Flag, uint8_t Mode ,uint8_t Unit, uint32_t Mileage)
{
    uint32_t m_NUM;
    uint32_t Num;
    uint8_t m8;
    
    if (m_Flag == 1u)
    {
        if ((SEGLCDBackup.ODOMode != Mode) || (SEGLCDBackup.ODOUnit != Unit) || (SEGLCDBackup.ODOMileage != Mileage)) 
        {
            SEGLCDBackup.ODOMode = Mode;
            SEGLCDBackup.ODOUnit = Unit;
            SEGLCDBackup.ODOMileage = Mileage;
            
            m_NUM = Mileage;// /10倍; 
            if(Unit == 1)
            {
                BU98R10_0_SEG168 = SEG_LCD_OFF;  //miles
                BU98R10_0_SEG169 = SEG_LCD_LIGHT;
                BU98R10_0_SEG170 = SEG_LCD_LIGHT;
            }
            else if(Unit == 0)
            {
                BU98R10_0_SEG168 = SEG_LCD_LIGHT;  //Km
                BU98R10_0_SEG169 = SEG_LCD_LIGHT;
                BU98R10_0_SEG170 = SEG_LCD_OFF;
            }

            if (Mode == 0)
            {
                m_NUM = m_NUM > 999999 ? 999999 : m_NUM;
                m_NUM /= 10;
                BU98R10_0_SEG164 = SEG_LCD_OFF;  //Point
                BU98R10_0_SEG146 = SEG_LCD_OFF;  //TOTAL
                BU98R10_0_SEG147 = SEG_LCD_OFF;
                BU98R10_0_SEG148 = SEG_LCD_OFF;
                BU98R10_0_SEG149 = SEG_LCD_LIGHT;

            }
            else if (Mode == 1)
            {
                BU98R10_0_SEG164 = SEG_LCD_LIGHT;  //point
                BU98R10_0_SEG146 = SEG_LCD_LIGHT;  //TRIPA
                BU98R10_0_SEG147 = SEG_LCD_LIGHT;
                BU98R10_0_SEG148 = SEG_LCD_OFF;
                BU98R10_0_SEG149 = SEG_LCD_OFF;
            }
            else if (Mode == 2)
            {
                BU98R10_0_SEG164 = SEG_LCD_LIGHT;  //point
                BU98R10_0_SEG146 = SEG_LCD_LIGHT;  //TRIPB
                BU98R10_0_SEG147 = SEG_LCD_OFF;
                BU98R10_0_SEG148 = SEG_LCD_LIGHT;
                BU98R10_0_SEG149 = SEG_LCD_OFF;
                
            }
            
            /*十万位*/
            Num = (m_NUM / 100000u);
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_0_SEG143 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG143 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_0_SEG142 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG142 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_0_SEG152 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG152 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_0_SEG151 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG151 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_0_SEG145 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG145 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_0_SEG144 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG144 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_0_SEG141 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG141 = SEG_LCD_OFF;
            }
            /*万位*/
            Num = (m_NUM / 10000u) % 10u;
            if (m_NUM > 99999)
            {
                m8 = SEG_DISPLAY_NUMBER0[Num];
            }
            else
            {
                m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }
            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_0_SEG138 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG138 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_0_SEG137 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG137 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_0_SEG136 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG136 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_0_SEG154 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG154 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_0_SEG153 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG153 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_0_SEG139 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG139 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_0_SEG140 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG140 = SEG_LCD_OFF;
            }
            /*千位*/
            Num = (m_NUM / 1000u) % 10u;
            if (m_NUM > 9999)
            {
                m8 = SEG_DISPLAY_NUMBER0[Num];
            }
            else
            {
                m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }
            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_0_SEG128 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG128 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_0_SEG127 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG127 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_0_SEG157 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG157 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_0_SEG156 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG156 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_0_SEG155 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG155 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_0_SEG135 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG135 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_0_SEG114 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG114 = SEG_LCD_OFF;
            }
            /*百位*/
            Num = (m_NUM / 100u) % 10u;
            if (m_NUM > 999)
            {
                m8 = SEG_DISPLAY_NUMBER0[Num];
            }
            else
            {
                m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }
            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_0_SEG111 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG111 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_0_SEG110 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG110 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_0_SEG160 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG160 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_0_SEG159 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG159 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_0_SEG158 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG158 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_0_SEG112 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG112 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_0_SEG113 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG113 = SEG_LCD_OFF;
            }
            /*十位*/
            Num = (m_NUM / 10u) % 10u;
            if ((Mode == 1) || (Mode == 2))
           {
                m8 = SEG_DISPLAY_NUMBER0[Num];
            }
            else
            {
                if (m_NUM > 99)
                {
                   m8 = SEG_DISPLAY_NUMBER0[Num];
                }
                else
                {
                   m8 = SEG_UNDISPLAY_NUMBER0[Num];
                }
            }
            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_0_SEG108 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG108 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_0_SEG107 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG107 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_0_SEG163 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG163 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_0_SEG162 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG162 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_0_SEG161 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG161 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_0_SEG109 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG109 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_0_SEG106 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG106 = SEG_LCD_OFF;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_0_SEG104 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG104 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_0_SEG103 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG103 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_0_SEG167 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG167 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_0_SEG166 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG166 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_0_SEG165 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG165 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_0_SEG105 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG105 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_0_SEG102 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG102 = SEG_LCD_OFF;
            }
        }
    }
    else
    {
        BU98R10_0_SEG168 = SEG_LCD_OFF;  //Km
        BU98R10_0_SEG169 = SEG_LCD_OFF;
        BU98R10_0_SEG170 = SEG_LCD_OFF;
        BU98R10_0_SEG164 = SEG_LCD_OFF;  //Point
        BU98R10_0_SEG146 = SEG_LCD_OFF;  //TOTAL
        BU98R10_0_SEG147 = SEG_LCD_OFF;
        BU98R10_0_SEG148 = SEG_LCD_OFF;
        BU98R10_0_SEG149 = SEG_LCD_OFF;

        BU98R10_0_SEG143 = SEG_LCD_OFF;
        BU98R10_0_SEG142 = SEG_LCD_OFF;
        BU98R10_0_SEG152 = SEG_LCD_OFF;
        BU98R10_0_SEG151 = SEG_LCD_OFF;
        BU98R10_0_SEG145 = SEG_LCD_OFF;
        BU98R10_0_SEG144 = SEG_LCD_OFF;
        BU98R10_0_SEG141 = SEG_LCD_OFF;

        BU98R10_0_SEG138 = SEG_LCD_OFF;
        BU98R10_0_SEG137 = SEG_LCD_OFF;
        BU98R10_0_SEG136 = SEG_LCD_OFF;
        BU98R10_0_SEG154 = SEG_LCD_OFF;
        BU98R10_0_SEG153 = SEG_LCD_OFF;
        BU98R10_0_SEG139 = SEG_LCD_OFF;
        BU98R10_0_SEG140 = SEG_LCD_OFF;

        BU98R10_0_SEG128 = SEG_LCD_OFF;
        BU98R10_0_SEG127 = SEG_LCD_OFF;
        BU98R10_0_SEG157 = SEG_LCD_OFF;
        BU98R10_0_SEG156 = SEG_LCD_OFF;
        BU98R10_0_SEG155 = SEG_LCD_OFF;
        BU98R10_0_SEG135 = SEG_LCD_OFF;
        BU98R10_0_SEG114 = SEG_LCD_OFF;

        BU98R10_0_SEG111 = SEG_LCD_OFF;
        BU98R10_0_SEG110 = SEG_LCD_OFF;
        BU98R10_0_SEG160 = SEG_LCD_OFF;
        BU98R10_0_SEG159 = SEG_LCD_OFF;
        BU98R10_0_SEG158 = SEG_LCD_OFF;
        BU98R10_0_SEG112 = SEG_LCD_OFF;
        BU98R10_0_SEG113 = SEG_LCD_OFF;

        BU98R10_0_SEG108 = SEG_LCD_OFF;
        BU98R10_0_SEG107 = SEG_LCD_OFF;
        BU98R10_0_SEG163 = SEG_LCD_OFF;
        BU98R10_0_SEG162 = SEG_LCD_OFF;
        BU98R10_0_SEG161 = SEG_LCD_OFF;
        BU98R10_0_SEG109 = SEG_LCD_OFF;
        BU98R10_0_SEG106 = SEG_LCD_OFF;

        BU98R10_0_SEG104 = SEG_LCD_OFF;
        BU98R10_0_SEG103 = SEG_LCD_OFF;
        BU98R10_0_SEG167 = SEG_LCD_OFF;
        BU98R10_0_SEG166 = SEG_LCD_OFF;
        BU98R10_0_SEG165 = SEG_LCD_OFF;
        BU98R10_0_SEG105 = SEG_LCD_OFF;
        BU98R10_0_SEG102 = SEG_LCD_OFF;
        
        SEGLCDBackup.ODOMode = 0xFF;
        SEGLCDBackup.ODOMileage = 0xFF;
        SEGLCDBackup.ODOUnit = 0xFF;
    }
    SEGLCDBackup.ODOFaultCode = 0xFF;
}

void SEG_LCD_FaultCode_Display(uint8_t m_Flag, uint32_t FaultCodeDisp)
{
    uint8_t m_NUM[4];
    uint32_t Num;
    uint8_t m8;
    
    if (m_Flag == 1u)
    {
        BU98R10_0_SEG168 = SEG_LCD_OFF;
        BU98R10_0_SEG169 = SEG_LCD_OFF;
        BU98R10_0_SEG170 = SEG_LCD_OFF;
        BU98R10_0_SEG164 = SEG_LCD_OFF;  //point
        BU98R10_0_SEG146 = SEG_LCD_OFF;
        BU98R10_0_SEG147 = SEG_LCD_OFF;
        BU98R10_0_SEG148 = SEG_LCD_OFF;
        BU98R10_0_SEG149 = SEG_LCD_OFF;

        BU98R10_0_SEG143 = SEG_LCD_OFF;
        BU98R10_0_SEG142 = SEG_LCD_OFF;
        BU98R10_0_SEG152 = SEG_LCD_OFF;
        BU98R10_0_SEG151 = SEG_LCD_OFF;
        BU98R10_0_SEG145 = SEG_LCD_OFF;
        BU98R10_0_SEG144 = SEG_LCD_OFF;
        BU98R10_0_SEG141 = SEG_LCD_OFF;
        
        BU98R10_0_SEG138 = SEG_LCD_LIGHT;  //P
        BU98R10_0_SEG137 = SEG_LCD_LIGHT;
        BU98R10_0_SEG136 = SEG_LCD_OFF;
        BU98R10_0_SEG154 = SEG_LCD_OFF;
        BU98R10_0_SEG153 = SEG_LCD_LIGHT;
        BU98R10_0_SEG139 = SEG_LCD_LIGHT;
        BU98R10_0_SEG140 = SEG_LCD_LIGHT;

        if (SEGLCDBackup.ODOFaultCode != FaultCodeDisp)
        {
            SEGLCDBackup.ODOFaultCode = FaultCodeDisp;
            
            Conv_Single_DECHEX(m_NUM, FaultCodeDisp);

            /*千位*/
            Num = m_NUM[3];
            m8 = SEG_HEX_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_0_SEG128 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG128 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_0_SEG127 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG127 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_0_SEG157 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG157 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_0_SEG156 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG156 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_0_SEG155 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG155 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_0_SEG135 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG135 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_0_SEG114 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG114 = SEG_LCD_OFF;
            }
            
            /*百位*/
            Num = m_NUM[2];
            m8 = SEG_HEX_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_0_SEG111 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG111 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_0_SEG110 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG110 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_0_SEG160 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG160 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_0_SEG159 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG159 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_0_SEG158 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG158 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_0_SEG112 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG112 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_0_SEG113 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG113 = SEG_LCD_OFF;
            }

            /*十位*/
            Num = m_NUM[1];
            m8 = SEG_HEX_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_0_SEG108 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG108 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_0_SEG107 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG107 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_0_SEG163 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG163 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_0_SEG162 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG162 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_0_SEG161 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG161 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_0_SEG109 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG109 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_0_SEG106 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG106 = SEG_LCD_OFF;
            }
            /*个位*/
            Num = m_NUM[0];
            m8 = SEG_HEX_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                BU98R10_0_SEG104 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG104 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                BU98R10_0_SEG103 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG103 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                BU98R10_0_SEG167 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG167 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                BU98R10_0_SEG166 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG166 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                BU98R10_0_SEG165 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG165 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                BU98R10_0_SEG105 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG105 = SEG_LCD_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                BU98R10_0_SEG102 = SEG_LCD_LIGHT;
            }
            else
            {
                BU98R10_0_SEG102 = SEG_LCD_OFF;
            }
        }
    }
    else
    {
        BU98R10_0_SEG168 = SEG_LCD_OFF;  //Km
        BU98R10_0_SEG169 = SEG_LCD_OFF;
        BU98R10_0_SEG170 = SEG_LCD_OFF;
        BU98R10_0_SEG164 = SEG_LCD_OFF;  //Point
        BU98R10_0_SEG146 = SEG_LCD_OFF;  //TOTAL
        BU98R10_0_SEG147 = SEG_LCD_OFF;
        BU98R10_0_SEG148 = SEG_LCD_OFF;
        BU98R10_0_SEG149 = SEG_LCD_OFF;

        BU98R10_0_SEG143 = SEG_LCD_OFF;
        BU98R10_0_SEG142 = SEG_LCD_OFF;
        BU98R10_0_SEG152 = SEG_LCD_OFF;
        BU98R10_0_SEG151 = SEG_LCD_OFF;
        BU98R10_0_SEG145 = SEG_LCD_OFF;
        BU98R10_0_SEG144 = SEG_LCD_OFF;
        BU98R10_0_SEG141 = SEG_LCD_OFF;

        BU98R10_0_SEG138 = SEG_LCD_OFF;
        BU98R10_0_SEG137 = SEG_LCD_OFF;
        BU98R10_0_SEG136 = SEG_LCD_OFF;
        BU98R10_0_SEG154 = SEG_LCD_OFF;
        BU98R10_0_SEG153 = SEG_LCD_OFF;
        BU98R10_0_SEG139 = SEG_LCD_OFF;
        BU98R10_0_SEG140 = SEG_LCD_OFF;

        BU98R10_0_SEG128 = SEG_LCD_OFF;
        BU98R10_0_SEG127 = SEG_LCD_OFF;
        BU98R10_0_SEG157 = SEG_LCD_OFF;
        BU98R10_0_SEG156 = SEG_LCD_OFF;
        BU98R10_0_SEG155 = SEG_LCD_OFF;
        BU98R10_0_SEG135 = SEG_LCD_OFF;
        BU98R10_0_SEG114 = SEG_LCD_OFF;

        BU98R10_0_SEG111 = SEG_LCD_OFF;
        BU98R10_0_SEG110 = SEG_LCD_OFF;
        BU98R10_0_SEG160 = SEG_LCD_OFF;
        BU98R10_0_SEG159 = SEG_LCD_OFF;
        BU98R10_0_SEG158 = SEG_LCD_OFF;
        BU98R10_0_SEG112 = SEG_LCD_OFF;
        BU98R10_0_SEG113 = SEG_LCD_OFF;

        BU98R10_0_SEG108 = SEG_LCD_OFF;
        BU98R10_0_SEG107 = SEG_LCD_OFF;
        BU98R10_0_SEG163 = SEG_LCD_OFF;
        BU98R10_0_SEG162 = SEG_LCD_OFF;
        BU98R10_0_SEG161 = SEG_LCD_OFF;
        BU98R10_0_SEG109 = SEG_LCD_OFF;
        BU98R10_0_SEG106 = SEG_LCD_OFF;

        BU98R10_0_SEG104 = SEG_LCD_OFF;
        BU98R10_0_SEG103 = SEG_LCD_OFF;
        BU98R10_0_SEG167 = SEG_LCD_OFF;
        BU98R10_0_SEG166 = SEG_LCD_OFF;
        BU98R10_0_SEG165 = SEG_LCD_OFF;
        BU98R10_0_SEG105 = SEG_LCD_OFF;
        BU98R10_0_SEG102 = SEG_LCD_OFF;
        
        SEGLCDBackup.ODOFaultCode = 0xFF;
    }
    SEGLCDBackup.ODOMode = 0xFF;
    SEGLCDBackup.ODOMileage = 0xFF;
    SEGLCDBackup.ODOUnit = 0xFF;
}
void SEG_LCD_ODO_Trip_FaultCode_Selftest(uint8_t Mileage)
{
    uint32_t m_NUM;
    uint32_t Num;
    uint8_t m8;
    
    if (SEGLCDBackup.ODOMileage != Mileage)
    {
        SEGLCDBackup.ODOMode = 0xFF;
        SEGLCDBackup.ODOUnit = 0xFF;
        SEGLCDBackup.ODOMileage = Mileage;
        
        Mileage = Mileage > 9 ? 9 : Mileage;
        m_NUM = Mileage % 10;// /10倍;         
        
        BU98R10_0_SEG168 = SEG_LCD_LIGHT;
        BU98R10_0_SEG169 = SEG_LCD_LIGHT;
        BU98R10_0_SEG170 = SEG_LCD_LIGHT;
        BU98R10_0_SEG164 = SEG_LCD_OFF;  //point
        BU98R10_0_SEG146 = SEG_LCD_LIGHT;
        BU98R10_0_SEG147 = SEG_LCD_LIGHT;
        BU98R10_0_SEG148 = SEG_LCD_LIGHT;
        BU98R10_0_SEG149 = SEG_LCD_LIGHT;

        /*十万位*/
        Num = m_NUM % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_0_SEG143 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG143 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_0_SEG142 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG142 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_0_SEG152 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG152 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_0_SEG151 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG151 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_0_SEG145 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG145 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_0_SEG144 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG144 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_0_SEG141 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG141 = SEG_LCD_OFF;
        }
        /*万位*/
        Num = m_NUM % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_0_SEG138 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG138 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_0_SEG137 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG137 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_0_SEG136 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG136 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_0_SEG154 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG154 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_0_SEG153 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG153 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_0_SEG139 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG139 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_0_SEG140 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG140 = SEG_LCD_OFF;
        }
        /*千位*/
        Num = m_NUM % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_0_SEG128 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG128 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_0_SEG127 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG127 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_0_SEG157 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG157 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_0_SEG156 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG156 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_0_SEG155 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG155 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_0_SEG135 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG135 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_0_SEG114 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG114 = SEG_LCD_OFF;
        }
        /*百位*/
        Num = m_NUM % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_0_SEG111 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG111 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_0_SEG110 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG110 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_0_SEG160 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG160 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_0_SEG159 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG159 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_0_SEG158 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG158 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_0_SEG112 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG112 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_0_SEG113 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG113 = SEG_LCD_OFF;
        }
        /*十位*/
        Num = m_NUM % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_0_SEG108 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG108 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_0_SEG107 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG107 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_0_SEG163 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG163 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_0_SEG162 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG162 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_0_SEG161 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG161 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_0_SEG109 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG109 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_0_SEG106 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG106 = SEG_LCD_OFF;
        }
        /*个位*/
        Num = m_NUM % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_0_SEG104 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG104 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_0_SEG103 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG103 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_0_SEG167 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG167 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_0_SEG166 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG166 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_0_SEG165 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG165 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_0_SEG105 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG105 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_0_SEG102 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG102 = SEG_LCD_OFF;
        }
    }
}
extern uint8_t BatteryErrFlg;
void SEG_LCD_BatteryErr_Display(uint8_t m_Flag, uint32_t ModeTime)
{
    uint8_t Mode;
    
    if (m_Flag == 1u)
    {
        if (ModeTime < 5000u)
        {
            Mode = 1;
        }
		else if((ModeTime >= 5000u) && (ModeTime < 6000u))
		{
			Mode = 0;
		}
        else if((ModeTime >= 6000) && (ModeTime < 11000))
        {
            Mode = 1;
        }
		else 
		{
			Mode = 0;
			BatteryErrFlg = 0;
		}
        
        if (SEGLCDBackup.ODOMode != Mode)
        {
            SEGLCDBackup.ODOMode = Mode;
            
            if (Mode == 1)
            {
                BU98R10_0_SEG168 = SEG_LCD_OFF;  //Km
                BU98R10_0_SEG169 = SEG_LCD_OFF;
                BU98R10_0_SEG170 = SEG_LCD_OFF;
                BU98R10_0_SEG164 = SEG_LCD_OFF;  //Point
                BU98R10_0_SEG146 = SEG_LCD_OFF;  //TOTAL
                BU98R10_0_SEG147 = SEG_LCD_OFF;
                BU98R10_0_SEG148 = SEG_LCD_OFF;
                BU98R10_0_SEG149 = SEG_LCD_OFF;

                BU98R10_0_SEG143 = SEG_LCD_OFF;
                BU98R10_0_SEG142 = SEG_LCD_OFF;
                BU98R10_0_SEG152 = SEG_LCD_OFF;
                BU98R10_0_SEG151 = SEG_LCD_OFF;
                BU98R10_0_SEG145 = SEG_LCD_OFF;
                BU98R10_0_SEG144 = SEG_LCD_OFF;
                BU98R10_0_SEG141 = SEG_LCD_OFF;

                BU98R10_0_SEG138 = SEG_LCD_OFF;
                BU98R10_0_SEG137 = SEG_LCD_OFF;
                BU98R10_0_SEG136 = SEG_LCD_OFF;
                BU98R10_0_SEG154 = SEG_LCD_OFF;
                BU98R10_0_SEG153 = SEG_LCD_OFF;
                BU98R10_0_SEG139 = SEG_LCD_OFF;
                BU98R10_0_SEG140 = SEG_LCD_OFF;

                BU98R10_0_SEG128 = SEG_LCD_LIGHT;
                BU98R10_0_SEG127 = SEG_LCD_LIGHT;
                BU98R10_0_SEG157 = SEG_LCD_LIGHT;
                BU98R10_0_SEG156 = SEG_LCD_OFF;
                BU98R10_0_SEG155 = SEG_LCD_LIGHT;
                BU98R10_0_SEG135 = SEG_LCD_LIGHT;
                BU98R10_0_SEG114 = SEG_LCD_LIGHT;

                BU98R10_0_SEG111 = SEG_LCD_OFF;
                BU98R10_0_SEG110 = SEG_LCD_LIGHT;
                BU98R10_0_SEG160 = SEG_LCD_LIGHT;
                BU98R10_0_SEG159 = SEG_LCD_OFF;
                BU98R10_0_SEG158 = SEG_LCD_OFF;
                BU98R10_0_SEG112 = SEG_LCD_OFF;
                BU98R10_0_SEG113 = SEG_LCD_OFF;

                BU98R10_0_SEG108 = SEG_LCD_LIGHT;
                BU98R10_0_SEG107 = SEG_LCD_LIGHT;
                BU98R10_0_SEG163 = SEG_LCD_LIGHT;
                BU98R10_0_SEG162 = SEG_LCD_LIGHT;
                BU98R10_0_SEG161 = SEG_LCD_LIGHT;
                BU98R10_0_SEG109 = SEG_LCD_LIGHT;
                BU98R10_0_SEG106 = SEG_LCD_OFF;

                BU98R10_0_SEG104 = SEG_LCD_LIGHT;
                BU98R10_0_SEG103 = SEG_LCD_OFF;
                BU98R10_0_SEG167 = SEG_LCD_OFF;
                BU98R10_0_SEG166 = SEG_LCD_LIGHT;
                BU98R10_0_SEG165 = SEG_LCD_LIGHT;
                BU98R10_0_SEG105 = SEG_LCD_LIGHT;
                BU98R10_0_SEG102 = SEG_LCD_OFF;
            }
            else
            {
                BU98R10_0_SEG168 = SEG_LCD_OFF;  //Km
                BU98R10_0_SEG169 = SEG_LCD_OFF;
                BU98R10_0_SEG170 = SEG_LCD_OFF;
                BU98R10_0_SEG164 = SEG_LCD_OFF;  //Point
                BU98R10_0_SEG146 = SEG_LCD_OFF;  //TOTAL
                BU98R10_0_SEG147 = SEG_LCD_OFF;
                BU98R10_0_SEG148 = SEG_LCD_OFF;
                BU98R10_0_SEG149 = SEG_LCD_OFF;

                BU98R10_0_SEG143 = SEG_LCD_OFF;
                BU98R10_0_SEG142 = SEG_LCD_OFF;
                BU98R10_0_SEG152 = SEG_LCD_OFF;
                BU98R10_0_SEG151 = SEG_LCD_OFF;
                BU98R10_0_SEG145 = SEG_LCD_OFF;
                BU98R10_0_SEG144 = SEG_LCD_OFF;
                BU98R10_0_SEG141 = SEG_LCD_OFF;

                BU98R10_0_SEG138 = SEG_LCD_OFF;
                BU98R10_0_SEG137 = SEG_LCD_OFF;
                BU98R10_0_SEG136 = SEG_LCD_OFF;
                BU98R10_0_SEG154 = SEG_LCD_OFF;
                BU98R10_0_SEG153 = SEG_LCD_OFF;
                BU98R10_0_SEG139 = SEG_LCD_OFF;
                BU98R10_0_SEG140 = SEG_LCD_OFF;

                BU98R10_0_SEG128 = SEG_LCD_OFF;
                BU98R10_0_SEG127 = SEG_LCD_OFF;
                BU98R10_0_SEG157 = SEG_LCD_OFF;
                BU98R10_0_SEG156 = SEG_LCD_OFF;
                BU98R10_0_SEG155 = SEG_LCD_OFF;
                BU98R10_0_SEG135 = SEG_LCD_OFF;
                BU98R10_0_SEG114 = SEG_LCD_OFF;

                BU98R10_0_SEG111 = SEG_LCD_OFF;
                BU98R10_0_SEG110 = SEG_LCD_OFF;
                BU98R10_0_SEG160 = SEG_LCD_OFF;
                BU98R10_0_SEG159 = SEG_LCD_OFF;
                BU98R10_0_SEG158 = SEG_LCD_OFF;
                BU98R10_0_SEG112 = SEG_LCD_OFF;
                BU98R10_0_SEG113 = SEG_LCD_OFF;

                BU98R10_0_SEG108 = SEG_LCD_OFF;
                BU98R10_0_SEG107 = SEG_LCD_OFF;
                BU98R10_0_SEG163 = SEG_LCD_OFF;
                BU98R10_0_SEG162 = SEG_LCD_OFF;
                BU98R10_0_SEG161 = SEG_LCD_OFF;
                BU98R10_0_SEG109 = SEG_LCD_OFF;
                BU98R10_0_SEG106 = SEG_LCD_OFF;

                BU98R10_0_SEG104 = SEG_LCD_OFF;
                BU98R10_0_SEG103 = SEG_LCD_OFF;
                BU98R10_0_SEG167 = SEG_LCD_OFF;
                BU98R10_0_SEG166 = SEG_LCD_OFF;
                BU98R10_0_SEG165 = SEG_LCD_OFF;
                BU98R10_0_SEG105 = SEG_LCD_OFF;
                BU98R10_0_SEG102 = SEG_LCD_OFF;
            }

            SEGLCDBackup.ODOMileage = 0xFF;
            SEGLCDBackup.ODOUnit = 0xFF;
        }
    }
    else
    {
        BU98R10_0_SEG168 = SEG_LCD_OFF;  //Km
        BU98R10_0_SEG169 = SEG_LCD_OFF;
        BU98R10_0_SEG170 = SEG_LCD_OFF;
        BU98R10_0_SEG164 = SEG_LCD_OFF;  //Point
        BU98R10_0_SEG146 = SEG_LCD_OFF;  //TOTAL
        BU98R10_0_SEG147 = SEG_LCD_OFF;
        BU98R10_0_SEG148 = SEG_LCD_OFF;
        BU98R10_0_SEG149 = SEG_LCD_OFF;

        BU98R10_0_SEG143 = SEG_LCD_OFF;
        BU98R10_0_SEG142 = SEG_LCD_OFF;
        BU98R10_0_SEG152 = SEG_LCD_OFF;
        BU98R10_0_SEG151 = SEG_LCD_OFF;
        BU98R10_0_SEG145 = SEG_LCD_OFF;
        BU98R10_0_SEG144 = SEG_LCD_OFF;
        BU98R10_0_SEG141 = SEG_LCD_OFF;

        BU98R10_0_SEG138 = SEG_LCD_OFF;
        BU98R10_0_SEG137 = SEG_LCD_OFF;
        BU98R10_0_SEG136 = SEG_LCD_OFF;
        BU98R10_0_SEG154 = SEG_LCD_OFF;
        BU98R10_0_SEG153 = SEG_LCD_OFF;
        BU98R10_0_SEG139 = SEG_LCD_OFF;
        BU98R10_0_SEG140 = SEG_LCD_OFF;

        BU98R10_0_SEG128 = SEG_LCD_OFF;
        BU98R10_0_SEG127 = SEG_LCD_OFF;
        BU98R10_0_SEG157 = SEG_LCD_OFF;
        BU98R10_0_SEG156 = SEG_LCD_OFF;
        BU98R10_0_SEG155 = SEG_LCD_OFF;
        BU98R10_0_SEG135 = SEG_LCD_OFF;
        BU98R10_0_SEG114 = SEG_LCD_OFF;

        BU98R10_0_SEG111 = SEG_LCD_OFF;
        BU98R10_0_SEG110 = SEG_LCD_OFF;
        BU98R10_0_SEG160 = SEG_LCD_OFF;
        BU98R10_0_SEG159 = SEG_LCD_OFF;
        BU98R10_0_SEG158 = SEG_LCD_OFF;
        BU98R10_0_SEG112 = SEG_LCD_OFF;
        BU98R10_0_SEG113 = SEG_LCD_OFF;

        BU98R10_0_SEG108 = SEG_LCD_OFF;
        BU98R10_0_SEG107 = SEG_LCD_OFF;
        BU98R10_0_SEG163 = SEG_LCD_OFF;
        BU98R10_0_SEG162 = SEG_LCD_OFF;
        BU98R10_0_SEG161 = SEG_LCD_OFF;
        BU98R10_0_SEG109 = SEG_LCD_OFF;
        BU98R10_0_SEG106 = SEG_LCD_OFF;

        BU98R10_0_SEG104 = SEG_LCD_OFF;
        BU98R10_0_SEG103 = SEG_LCD_OFF;
        BU98R10_0_SEG167 = SEG_LCD_OFF;
        BU98R10_0_SEG166 = SEG_LCD_OFF;
        BU98R10_0_SEG165 = SEG_LCD_OFF;
        BU98R10_0_SEG105 = SEG_LCD_OFF;
        BU98R10_0_SEG102 = SEG_LCD_OFF;
        
        SEGLCDBackup.ODOMode = 0xFF;
        SEGLCDBackup.ODOMileage = 0xFF;
        SEGLCDBackup.ODOUnit = 0xFF;
    }
}

/******************************************************************************
��������SEG_Coolant_Temp_Display
��  ��: ˮ�¶���ʾ    
��  ��: 
����ֵ��                               
******************************************************************************/
void SEG_Coolant_Temp_Display(uint8_t m_Flag, uint8_t Seg)
{
    if (m_Flag == 1)
    {        
        if (SEGLCDBackup.TempSeg != Seg)
        {
            SEGLCDBackup.TempSeg = Seg;

            BU98R10_1_SEG45 = SEG_LCD_LIGHT;  //C
            BU98R10_1_SEG38 = SEG_LCD_LIGHT;  //H

            BU98R10_1_SEG44 = SEG_LCD_LIGHT;
            BU98R10_1_SEG42 = SEG_LCD_LIGHT;
            BU98R10_1_SEG33 = SEG_LCD_LIGHT;
            BU98R10_1_SEG34 = SEG_LCD_LIGHT;
            BU98R10_1_SEG36 = SEG_LCD_LIGHT;

            BU98R10_1_SEG43  =  SEG_LCD_GRAY_2; //SEG5
            BU98R10_1_SEG41  =  SEG_LCD_GRAY_2;
            BU98R10_1_SEG40  =  SEG_LCD_GRAY_2;
            BU98R10_1_SEG35  =  SEG_LCD_GRAY_2;
            BU98R10_1_SEG37  =  SEG_LCD_GRAY_2;

            switch(Seg)
            {
                case 9:  BU98R10_1_SEG41  =  SEG_LCD_LIGHT; //ShortCircuit
                    BU98R10_1_SEG40  =  SEG_LCD_LIGHT; 
                    BU98R10_1_SEG35  =  SEG_LCD_LIGHT;     
                    break;         
                case 8 :  BU98R10_1_SEG43  =  SEG_LCD_LIGHT; //OpenCircuit
                    BU98R10_1_SEG37  =  SEG_LCD_LIGHT;  
                    break;      
                case 7 :  BU98R10_1_SEG43  =  SEG_LCD_LIGHT; //Not_Connect
                    BU98R10_1_SEG41  =  SEG_LCD_LIGHT; 
                    BU98R10_1_SEG40  =  SEG_LCD_LIGHT;  
                    break;   
                case 6 :  BU98R10_1_SEG35  =  SEG_LCD_LIGHT; //Not_Connect
                    BU98R10_1_SEG37  =  SEG_LCD_LIGHT;    
                    break;
                case 5 :  BU98R10_1_SEG37  =  SEG_LCD_LIGHT; //SEG5
                case 4 :  BU98R10_1_SEG35  =  SEG_LCD_LIGHT; 
                case 3 :  BU98R10_1_SEG40  =  SEG_LCD_LIGHT; 
                case 2 :  BU98R10_1_SEG41  =  SEG_LCD_LIGHT; 
                case 1 :  BU98R10_1_SEG43  =  SEG_LCD_LIGHT; 
                case 0 :  break;
                default  : break;
            }
        }
    }
    else
    {
        BU98R10_1_SEG45 = SEG_LCD_OFF;  //C
        BU98R10_1_SEG38 = SEG_LCD_OFF;  //H

        BU98R10_1_SEG44 = SEG_LCD_OFF;
        BU98R10_1_SEG42 = SEG_LCD_OFF;
        BU98R10_1_SEG33 = SEG_LCD_OFF;
        BU98R10_1_SEG34 = SEG_LCD_OFF;
        BU98R10_1_SEG36 = SEG_LCD_OFF;

        BU98R10_1_SEG43  =  SEG_LCD_GRAY_2; //SEG5
        BU98R10_1_SEG41  =  SEG_LCD_GRAY_2;
        BU98R10_1_SEG40  =  SEG_LCD_GRAY_2;
        BU98R10_1_SEG35  =  SEG_LCD_GRAY_2;
        BU98R10_1_SEG37  =  SEG_LCD_GRAY_2;

        SEGLCDBackup.TempSeg = 0xff;
    }
}

/******************************************************************************
��������SEG_Fuel_Level_Display
��  ��: ȼ�Ͷ���ʾ   
��  ��: 
����ֵ��                               
******************************************************************************/
void SEG_Fuel_Level_Display(uint8_t m_Flag, uint8_t Seg)
{
    if (m_Flag == 1)
    {                
        if (SEGLCDBackup.FuelSeg != Seg)
        {
            SEGLCDBackup.FuelSeg = Seg;

            BU98R10_0_SEG126 = SEG_LCD_LIGHT;  //E
            BU98R10_0_SEG115 = SEG_LCD_LIGHT;  //F

            BU98R10_0_SEG124 = SEG_LCD_LIGHT;
            BU98R10_0_SEG122 = SEG_LCD_LIGHT;
            BU98R10_0_SEG120 = SEG_LCD_LIGHT;
            BU98R10_0_SEG118 = SEG_LCD_LIGHT;
            BU98R10_0_SEG116 = SEG_LCD_LIGHT;

            BU98R10_0_SEG125  =  SEG_LCD_GRAY_2; //SEG5
            BU98R10_0_SEG123  =  SEG_LCD_GRAY_2;
            BU98R10_0_SEG121  =  SEG_LCD_GRAY_2;
            BU98R10_0_SEG119  =  SEG_LCD_GRAY_2;
            BU98R10_0_SEG117  =  SEG_LCD_GRAY_2;

            switch(Seg)
            {
                case 7:  BU98R10_0_SEG123  =  SEG_LCD_LIGHT; //ShortCircuit
                    BU98R10_0_SEG121  =  SEG_LCD_LIGHT; 
                    BU98R10_0_SEG119  =  SEG_LCD_LIGHT;     
                    break;         
                case 6 :  BU98R10_0_SEG125  =  SEG_LCD_LIGHT; //OpenCircuit
                    BU98R10_0_SEG117  =  SEG_LCD_LIGHT;  
                    break;      
                case 5 :  BU98R10_0_SEG117  =  SEG_LCD_LIGHT; //SEG5
                case 4 :  BU98R10_0_SEG119  =  SEG_LCD_LIGHT; 
                case 3 :  BU98R10_0_SEG121  =  SEG_LCD_LIGHT; 
                case 2 :  BU98R10_0_SEG123  =  SEG_LCD_LIGHT; 
                case 1 :  BU98R10_0_SEG125  =  SEG_LCD_LIGHT; 
                case 0 :  break;
                default  : break;
            }
        }
    }
    else
    {
        BU98R10_0_SEG126 = SEG_LCD_OFF;  //E
        BU98R10_0_SEG115 = SEG_LCD_OFF;  //F

        BU98R10_0_SEG124 = SEG_LCD_OFF;
        BU98R10_0_SEG122 = SEG_LCD_OFF;
        BU98R10_0_SEG120 = SEG_LCD_OFF;
        BU98R10_0_SEG118 = SEG_LCD_OFF;
        BU98R10_0_SEG116 = SEG_LCD_OFF;

        BU98R10_0_SEG125  =  SEG_LCD_GRAY_2; //SEG5
        BU98R10_0_SEG123  =  SEG_LCD_GRAY_2;
        BU98R10_0_SEG121  =  SEG_LCD_GRAY_2;
        BU98R10_0_SEG119  =  SEG_LCD_GRAY_2;
        BU98R10_0_SEG117  =  SEG_LCD_GRAY_2;

        SEGLCDBackup.FuelSeg = 0xff;
    }

}

/******************************************************************************
��������SEG_LCD_Battery_Voltage_Display
��  ��: ���복����ʾ    
��  ��:
����ֵ��                               
******************************************************************************/
void SEG_LCD_Battery_Voltage_Display(uint8_t m_Flag, uint8_t Voltage ,uint16_t VolCANset)
{
    uint8_t Num;
    uint8_t m8;

    if (m_Flag == 1)
    {
        PORT_SetBit(LightBATTCtrl);  //背光 ON

        if ((SEGLCDBackup.Voltage != Voltage) || (SEGLCDBackup.VolCANset != VolCANset))
        {
            SEGLCDBackup.Voltage = Voltage;
            SEGLCDBackup.VolCANset = VolCANset;

            BU98R10_0_SEG61 = SEG_LCD_LIGHT;  //BATT
            BU98R10_0_SEG52 = SEG_LCD_LIGHT;  //V
            BU98R10_0_SEG94 = SEG_LCD_LIGHT;  //.

            if(VolCANset == CAN_SIG_LOST)
            {
                BU98R10_0_SEG79 = SEG_LCD_OFF;
                BU98R10_0_SEG78 = SEG_LCD_OFF;
                BU98R10_0_SEG88 = SEG_LCD_OFF;
                BU98R10_0_SEG87 = SEG_LCD_OFF;
                BU98R10_0_SEG84 = SEG_LCD_OFF;
                BU98R10_0_SEG82 = SEG_LCD_OFF;
                BU98R10_0_SEG83 = SEG_LCD_LIGHT;

                BU98R10_0_SEG67 = SEG_LCD_OFF;
                BU98R10_0_SEG66 = SEG_LCD_OFF;
                BU98R10_0_SEG93 = SEG_LCD_OFF;
                BU98R10_0_SEG92 = SEG_LCD_OFF;
                BU98R10_0_SEG89 = SEG_LCD_OFF;
                BU98R10_0_SEG77 = SEG_LCD_OFF;
                BU98R10_0_SEG65 = SEG_LCD_LIGHT;

                BU98R10_0_SEG57 = SEG_LCD_OFF;
                BU98R10_0_SEG56 = SEG_LCD_OFF;
                BU98R10_0_SEG99 = SEG_LCD_OFF;
                BU98R10_0_SEG98 = SEG_LCD_OFF;
                BU98R10_0_SEG97 = SEG_LCD_OFF;
                BU98R10_0_SEG60 = SEG_LCD_OFF;
                BU98R10_0_SEG55 = SEG_LCD_LIGHT;
            }
            else
            {
                /*百位*/
                Num = (Voltage / 100u) % 10u;
                if (Voltage >= 1000u)
                {
                    m8 = SEG_DISPLAY_NUMBER0[Num];
                }
                else
                {
                    m8 = SEG_UNDISPLAY_NUMBER0[Num];
                }

                if (Bit_Is_Set(m8, 0))
                {
                    BU98R10_0_SEG79 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG79 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 1))
                {
                    BU98R10_0_SEG78 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG78 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 2))
                {
                    BU98R10_0_SEG88 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG88 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 3))
                {
                    BU98R10_0_SEG87 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG87 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 4))
                {
                    BU98R10_0_SEG84 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG84 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 5))
                {
                    BU98R10_0_SEG82 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG82 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 6))
                {
                    BU98R10_0_SEG83 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG83 = SEG_LCD_OFF;
                }
                /*十位*/
                Num = (Voltage / 10u) % 10u;

                m8 = SEG_DISPLAY_NUMBER0[Num];

                if (Bit_Is_Set(m8, 0))
                {
                    BU98R10_0_SEG67 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG67 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 1))
                {
                    BU98R10_0_SEG66 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG66 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 2))
                {
                    BU98R10_0_SEG93 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG93 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 3))
                {
                    BU98R10_0_SEG92 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG92 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 4))
                {
                    BU98R10_0_SEG89 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG89 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 5))
                {
                    BU98R10_0_SEG77 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG77 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 6))
                {
                    BU98R10_0_SEG65 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG65 = SEG_LCD_OFF;
                }
                /*个位*/
                Num = Voltage % 10u;
                m8 = SEG_DISPLAY_NUMBER0[Num];
                if (Bit_Is_Set(m8, 0))
                {
                    BU98R10_0_SEG57 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG57 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 1))
                {
                    BU98R10_0_SEG56 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG56 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 2))
                {
                    BU98R10_0_SEG99 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG99 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 3))
                {
                    BU98R10_0_SEG98 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG98 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 4))
                {
                    BU98R10_0_SEG97 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG97 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 5))
                {
                    BU98R10_0_SEG60 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG60 = SEG_LCD_OFF;
                }
                if (Bit_Is_Set(m8, 6))
                {
                    BU98R10_0_SEG55 = SEG_LCD_LIGHT;
                }
                else
                {
                    BU98R10_0_SEG55 = SEG_LCD_OFF;
                }
            }
        }
    }
    else
    {
        PORT_ClrBit(LightBATTCtrl);  //背光OFF

        BU98R10_0_SEG61 = SEG_LCD_OFF;  //BATT
        BU98R10_0_SEG52 = SEG_LCD_OFF;  //V
        BU98R10_0_SEG94 = SEG_LCD_OFF;  //.

        BU98R10_0_SEG79 = SEG_LCD_OFF;
        BU98R10_0_SEG78 = SEG_LCD_OFF;
        BU98R10_0_SEG88 = SEG_LCD_OFF;
        BU98R10_0_SEG87 = SEG_LCD_OFF;
        BU98R10_0_SEG84 = SEG_LCD_OFF;
        BU98R10_0_SEG82 = SEG_LCD_OFF;
        BU98R10_0_SEG83 = SEG_LCD_OFF;

        BU98R10_0_SEG67 = SEG_LCD_OFF;
        BU98R10_0_SEG66 = SEG_LCD_OFF;
        BU98R10_0_SEG93 = SEG_LCD_OFF;
        BU98R10_0_SEG92 = SEG_LCD_OFF;
        BU98R10_0_SEG89 = SEG_LCD_OFF;
        BU98R10_0_SEG77 = SEG_LCD_OFF;
        BU98R10_0_SEG65 = SEG_LCD_OFF;

        BU98R10_0_SEG57 = SEG_LCD_OFF;
        BU98R10_0_SEG56 = SEG_LCD_OFF;
        BU98R10_0_SEG99 = SEG_LCD_OFF;
        BU98R10_0_SEG98 = SEG_LCD_OFF;
        BU98R10_0_SEG97 = SEG_LCD_OFF;
        BU98R10_0_SEG60 = SEG_LCD_OFF;
        BU98R10_0_SEG55 = SEG_LCD_OFF;

        SEGLCDBackup.Voltage = 0xFFFF;
        SEGLCDBackup.VolCANset = 0xFF;
    }
    
}
void SEG_LCD_Battery_Voltage_Selftest(uint8_t Voltage)
{
    uint8_t Num;
    uint8_t m8;

    PORT_SetBit(LightBATTCtrl);  //背光 ON
    
    if (SEGLCDBackup.Voltage != Voltage)
    {
        SEGLCDBackup.Voltage = Voltage;
        SEGLCDBackup.VolCANset = 0xFF;

        BU98R10_0_SEG61 = SEG_LCD_LIGHT;  //BATT
        BU98R10_0_SEG52 = SEG_LCD_LIGHT;  //V
        BU98R10_0_SEG94 = SEG_LCD_LIGHT;  //.

        Voltage = Voltage > 9 ? 9 : Voltage;

        /*百位*/
        Num = Voltage % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];

        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_0_SEG79 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG79 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_0_SEG78 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG78 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_0_SEG88 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG88 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_0_SEG87 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG87 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_0_SEG84 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG84 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_0_SEG82 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG82 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_0_SEG83 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG83 = SEG_LCD_OFF;
        }
        /*十位*/
        Num = Voltage % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];

        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_0_SEG67 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG67 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_0_SEG66 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG66 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_0_SEG93 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG93 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_0_SEG92 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG92 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_0_SEG89 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG89 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_0_SEG77 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG77 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_0_SEG65 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG65 = SEG_LCD_OFF;
        }
        /*个位*/
        Num = Voltage % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            BU98R10_0_SEG57 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG57 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            BU98R10_0_SEG56 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG56 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            BU98R10_0_SEG99 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG99 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            BU98R10_0_SEG98 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG98 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            BU98R10_0_SEG97 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG97 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            BU98R10_0_SEG60 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG60 = SEG_LCD_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            BU98R10_0_SEG55 = SEG_LCD_LIGHT;
        }
        else
        {
            BU98R10_0_SEG55 = SEG_LCD_OFF;
        }
    }
}



void SEG_LCD_OilPressure(uint8_t state)
{
    BU98R10_1_SEG32 =  state;
}

void SEG_LCD_TirePressure(uint8_t state)
{
    BU98R10_0_SEG150 =  state;
}

void SEG_LCD_READY(uint8_t state)
{
    BU98R10_1_SEG65 =  state;
}

void SEG_LCD_ABS(uint8_t state)
{
    BU98R10_0_SEG133 =  state;
}

void SEG_LCD_TSC(uint8_t state)
{
    BU98R10_1_SEG67 =  state;
}

void SEG_LCD_AutoStarStop(uint8_t state)
{
    BU98R10_1_SEG71 =  state;
}

void SEG_LCD_Batterylow(uint8_t state)
{
    BU98R10_1_SEG66 =  state;
}

void SEG_LCD_HI_BEAM(uint8_t state)
{
    BU98R10_1_SEG68 =  state;
}

void SEG_LCD_Shore(uint8_t state)
{
    BU98R10_0_SEG62 =  state;
}

void SEG_LCD_OBD(uint8_t state)
{
    BU98R10_0_SEG132 =  state;
}

void SEG_LCD_HighBeam(uint8_t state)
{
    BU98R10_0_SEG129 =  state;
}

void SEG_LCD_LeftTurn(uint8_t state)
{
    BU98R10_0_SEG131 =  state;
}

void SEG_LCD_RightTurn(uint8_t state)
{
    BU98R10_1_SEG69 =  state;
}

void SEG_LCD_Fuel(uint8_t state)
{
    BU98R10_0_SEG134 =  state;
}

void SEG_LCD_Temp(uint8_t state)
{
    BU98R10_1_SEG39 =  state;
}
