//#include "common_include.h"
#include "stdlib.h"
#include "BAT32A239.h"
#include "userdefine.h"
#include "sci.h"
#include "dma.h"
#include "gpio.h"
#include "timm.h"
#include "wdt.h"


typedef unsigned int AW_U32;


//static uint32_t PDSampleTimerCnts = 0u;
#define DELAYUS 1
typedef struct msm_camera_i2c_reg_conf
{
     uint16_t addr;                    /*!<   */
     uint32_t RegVal;                  /*!<  */
} msm_camera_i2c_reg_conf_t;

//static const msm_camera_i2c_reg_conf_t PD_IIC_DAC_Int[] = {
//{0x0000,0x0000001F},
//{0x0004,0x0200000A},
//{0x0008,0x0017A13E},
//{0x000C,0x05000000},
//{0x0010,0x042433FD},
//{0x0014,0x0F3D0009},
//{0x0018,0xD81C8A07},
//{0x001C,0xFF000000},
//{0x0020,0x003D0F00},
//{0x0024,0x042433F7},
//{0x0028,0x0F240009},
//{0x002C,0xD81C8A07},
//{0x0030,0xFF000000},
//{0x0034,0x00240F00},
//{0x0038,0x042433DF},
//{0x003C,0x12300009},
//{0x0040,0xD81C8A07},
//{0x0044,0xFF000000},
//{0x0048,0x00301200},
//{0x004C,0x0424337F},
//{0x0050,0x10000009},
//{0x0054,0xD81C8A07},
//{0x0058,0xFF000000},
//{0x005C,0x00001000},
//{0x0060,0x042431FF},
//{0x0064,0x10310009},
//{0x0068,0xD81C8A07},
//{0x006C,0xFF000000},
//{0x0070,0x00311000},
//{0x0074,0x00050000},
//{0x0078,0x00000009},
//{0x007C,0xD81C8A07},
//{0x0080,0xFF000000},
//{0x0084,0x00000000},
//{0x00A0,0xE0400000},
//{0x00A4,0x00000000},
//{0x00A8,0x700008D2},
//{0x00AC,0x00000000},
//{0x00B0,0x00000000},
//{0x00B4,0x0000003F},
//{0x00B8,0x00004E20},
//{0x00BC,0x00000000},
//{0x00C0,0x00000000},
//{0x00C4,0x00000000},
//{0x00C8,0x00000000},
//{0x00CC,0x00000000},
//{0x00D0,0x00000000},
//{0x00D4,0x00000000},
//{0x00D8,0x00000000},
//{0x00DC,0xE0400000},
//{0x00E0,0x00000000},
//{0x00E4,0x700008D2},
//{0x00E8,0x00000000},
//{0x00EC,0x00000000},
//{0x00F0,0x0000003F},
//{0x00F4,0x00004E20},
//{0x00F8,0x00000000},
//{0x00FC,0x00000000},
//{0x0100,0x00000000},
//{0x0104,0x00000000},
//{0x0108,0x00000000},
//{0x010C,0x00000000},
//{0x0110,0x00000000},
//{0x0114,0x00000000},
//{0x0118,0xE0400000},
//{0x011C,0x00000000},
//{0x0120,0x700008D2},
//{0x0124,0x00000000},
//{0x0128,0x00000000},
//{0x012C,0x0000003F},
//{0x0130,0x00004E20},
//{0x0134,0x00000000},
//{0x0138,0x00000000},
//{0x013C,0x00000000},
//{0x0140,0x00000000},
//{0x0144,0x00000000},
//{0x0148,0x00000000},
//{0x014C,0x00000000},
//{0x0150,0x00000000},
//{0x0154,0xE0400000},
//{0x0158,0x00000000},
//{0x015C,0x700008D2},
//{0x0160,0x00000000},
//{0x0164,0x00000000},
//{0x0168,0x0000003F},
//{0x016C,0x00004E20},
//{0x0170,0x00000000},
//{0x0174,0x00000000},
//{0x0178,0x00000000},
//{0x017C,0x00000000},
//{0x0180,0x00000000},
//{0x0184,0x00000000},
//{0x0188,0x00000000},
//{0x018C,0x00000000},
//{0x0190,0xE0400000},
//{0x0194,0x00000000},
//{0x0198,0x700008D2},
//{0x019C,0x00000000},
//{0x01A0,0x00000000},
//{0x01A4,0x0000003F},
//{0x01A8,0x00004E20},
//{0x01AC,0x00000000},
//{0x01B0,0x00000000},
//{0x01B4,0x00000000},
//{0x01B8,0x00000000},
//{0x01BC,0x00000000},
//{0x01C0,0x00000000},
//{0x01C4,0x00000000},
//{0x01C8,0x00000000},
//{0x01CC,0xE0400000},
//{0x01D0,0x00000000},
//{0x01D4,0x000008D2},
//{0x01D8,0x00000000},
//{0x01DC,0x00000000},
//{0x01E0,0x0000003F},
//{0x01E4,0x00000000},
//{0x01E8,0x00000000},
//{0x01EC,0x00000000},
//{0x01F0,0x00000000},
//{0x01F4,0x00000000},
//{0x01F8,0x00000000},
//{0x01FC,0x00000000},
//{0x0200,0x00000000},
//{0x0204,0x00000000},
//{0x0208,0x0000000D},
//{0x020C,0x0000000D},
//{0x41FC,0x00000000},
//{0x4400,0x00000000},
//{0x4410,0x00000000},
//{0x4420,0x00000000},
//{0x4430,0x00000000},
//{0x4440,0x00000000},
//{0x4450,0x00000000},
//{0x4460,0x00000000},
//{0x4470,0x00000000},
//{0xF084,0x00000006},//0606
//{0xF800,0x00000000},
//{0xF804,0x00004C00},
//{0xF8C0,0x00000000},
//{0xF8D0,0x00000000},
//{0xF8D4,0x00000000},
//{0xFF00,0x00000301},
//{0xFF0C,0x01000000},
//{0xFFE0,0x00000000},
//{0xFFF0,0x00000000},
//{0xFFF4,0x00004011},
//{0xFFF8,0x00000000},
//{0xFFFC,0x00000000},
//{0x009C,0x001F1F00},
//};

static const msm_camera_i2c_reg_conf_t PD_IIC_DAC_Int[] = {
{0x0000,0x00001F1F},
{0x0004,0x0200000A},
{0x0008,0x0017A13E},
{0x000C,0x05000000},
{0x0010,0x042562A9},
{0x0014,0x32400009},
{0x0018,0xD81C8A07},
{0x001C,0xFF000000},
{0x0020,0x00403200},
{0x0024,0x042562A6},
{0x0028,0x282D0009},
{0x002C,0xD81C8A07},
{0x0030,0xFF000000},
{0x0034,0x002D2800},
{0x0038,0x0425629A},
{0x003C,0x28240009},
{0x0040,0xD81C8A07},
{0x0044,0xFF000000},
{0x0048,0x00242800},
{0x004C,0x0425626A},
{0x0050,0x22300009},
{0x0054,0xD81C8A07},
{0x0058,0xFF000000},
{0x005C,0x00302200},
{0x0060,0x042561AA},
{0x0064,0x232E0009},
{0x0068,0xD81C8A07},
{0x006C,0xFF000000},
{0x0070,0x002E2300},
{0x0074,0x00050000},
{0x0078,0x00000009},
{0x007C,0xD81C8A07},
{0x0080,0xFF000000},
{0x0084,0x00000000},
{0x00A0,0xE0400000},
{0x00A4,0x00000000},
{0x00A8,0x700008D2},
{0x00AC,0x00000000},
{0x00B0,0x00000000},
{0x00B4,0x0000003F},
{0x00B8,0x000249F0},//0x00B8,0x000249F0,{0x00B8,0x000493E0},0x00B8,0x000249F0,
{0x00BC,0x00000000},
{0x00C0,0x00000000},
{0x00C4,0x00000000},
{0x00C8,0x00000000},
{0x00CC,0x00000000},
{0x00D0,0x00000000},
{0x00D4,0x00000000},
{0x00D8,0x00000000},
{0x00DC,0xE0400000},
{0x00E0,0x00000000},
{0x00E4,0x700008D2},
{0x00E8,0x00000000},
{0x00EC,0x00000000},
{0x00F0,0x0000003F},
{0x00F4,0x000249F0},//{0x00F4,0x000493E0},
{0x00F8,0x00000000},
{0x00FC,0x00000000},
{0x0100,0x00000000},
{0x0104,0x00000000},
{0x0108,0x00000000},
{0x010C,0x00000000},
{0x0110,0x00000000},
{0x0114,0x00000000},
{0x0118,0xE0400000},
{0x011C,0x00000000},
{0x0120,0x700008D2},
{0x0124,0x00000000},
{0x0128,0x00000000},
{0x012C,0x0000003F},
{0x0130,0x000249F0},//{0x0130,0x000493E0},
{0x0134,0x00000000},
{0x0138,0x00000000},
{0x013C,0x00000000},
{0x0140,0x00000000},
{0x0144,0x00000000},
{0x0148,0x00000000},
{0x014C,0x00000000},
{0x0150,0x00000000},
{0x0154,0xE0400000},
{0x0158,0x00000000},
{0x015C,0x700008D2},
{0x0160,0x00000000},
{0x0164,0x00000000},
{0x0168,0x0000003F},
{0x016C,0x000249F0},//{0x016C,0x000493E0},
{0x0170,0x00000000},
{0x0174,0x00000000},
{0x0178,0x00000000},
{0x017C,0x00000000},
{0x0180,0x00000000},
{0x0184,0x00000000},
{0x0188,0x00000000},
{0x018C,0x00000000},
{0x0190,0xE0400000},
{0x0194,0x00000000},
{0x0198,0x700008D2},
{0x019C,0x00000000},
{0x01A0,0x00000000},
{0x01A4,0x0000003F},
{0x01A8,0x000249F0},//{0x01A8,0x000493E0},
{0x01AC,0x00000000},
{0x01B0,0x00000000},
{0x01B4,0x00000000},
{0x01B8,0x00000000},
{0x01BC,0x00000000},
{0x01C0,0x00000000},
{0x01C4,0x00000000},
{0x01C8,0x00000000},
{0x01CC,0xE0400000},
{0x01D0,0x00000000},
{0x01D4,0x000008D2},
{0x01D8,0x00000000},
{0x01DC,0x00000000},
{0x01E0,0x0000003F},
{0x01E4,0x00000000},
{0x01E8,0x00000000},
{0x01EC,0x00000000},
{0x01F0,0x00000000},
{0x01F4,0x00000000},
{0x01F8,0x00000000},
{0x01FC,0x00000000},
{0x0200,0x00000000},
{0x0204,0x00000000},
{0x0208,0x0000000D},
{0x020C,0x0000000D},
{0x41FC,0x00000000},
{0x4400,0x00000000},
{0x4410,0x00000000},
{0x4420,0x00000000},
{0x4430,0x00000000},
{0x4440,0x00000000},
{0x4450,0x00000000},
{0x4460,0x00000000},
{0x4470,0x00000000},
{0xF084,0x00000006},//0606
{0xF800,0x00000000},
{0xF804,0x00004C00},
{0xF8C0,0x00000000},
{0xF8D0,0x00000000},
{0xF8D4,0x00000000},
{0xFF00,0x00000101},
{0xFF0C,0x01000000},
{0xFFE0,0x00000000},
{0xFFF0,0x00000000},
{0xFFF4,0x00004011},
{0xFFF8,0x00000000},
{0xFFFC,0x00000000},
{0x009C,0x001F1F00},
{0xF008,0x00000001},
};


#define IIC2_SCL_1 PORT_SetBit(MCU_TOUCH_SCL);
#define IIC2_SCL_0 PORT_ClrBit(MCU_TOUCH_SCL)
#define IIC2_OUT_SDA_1 PORT_SetBit(MCU_TOUCH_SDA)
#define IIC2_OUT_SDA_0 PORT_ClrBit(MCU_TOUCH_SDA)
#define bsp_IIC2_delay(time) __NOP()          

#define IIC_IN_SDA (PORT_GetBit(PORT6, PIN1) != 0U)

#define PD_IIC_DeviceAddr 0x24 /*floating ox12  gnd 0x13  vcc 0x14*/

#define IIC_DELAY 6

void IIC_SDA2_IN(void)
{
  PORT_Init(PORT6, PIN1, INPUT);	
}

void IIC2_SDA_OUT(void)
{
	PORT_Init(PORT6, PIN1, OPENDRAIN_OUTPUT);		
	PORT_ClrBit(PORT6, PIN1);
}

void bsp_IIC_delay(uint32_t tmpTime)
{
    uint32_t i;
    for (i = 0; i < (tmpTime * 2000); i++) {             //this counts only adapt s6j324
        __NOP();
        WDT_Restart();
    }
}

void bsp_IIC2_Start(void)
{
    IIC2_SDA_OUT();
    IIC2_OUT_SDA_1;
    //bsp_IIC2_delay(1);
    IIC2_SCL_1;
    //bsp_IIC2_delay(1);
    IIC2_OUT_SDA_0;
    //bsp_IIC2_delay(1);
    IIC2_SCL_0;
    //bsp_IIC2_delay(10);
}

void bsp_IIC2_Stop(void)
{
    IIC2_SDA_OUT();
    IIC2_SCL_0;
    //bsp_IIC2_delay(1);
    IIC2_OUT_SDA_0;
    //bsp_IIC2_delay(1);
    IIC2_SCL_1;
    //bsp_IIC2_delay(1);
    IIC2_OUT_SDA_1;
    //bsp_IIC2_delay(10);
}

void bsp_IIC2_SendByte(uint8_t Data)
{
    uint8_t temp;
    uint8_t d = Data;
    IIC2_SDA_OUT();

    for(temp = 8;temp != 0;temp--)
    {
        if(d & 0x80)
        {
            IIC2_OUT_SDA_1;
        }
        else
        {
            IIC2_OUT_SDA_0;
        }
        //bsp_IIC2_delay(1);
        IIC2_SCL_1;
        //bsp_IIC2_delay(1);
        IIC2_SCL_0;
        //bsp_IIC2_delay(1);
        d = d <<1;
        //bsp_IIC2_delay(1);
    }
}

uint8_t bsp_IIC2_ReadByte(void)
{
    uint8_t temp;
    uint8_t rbyte = 0;
    IIC_SDA2_IN();
    __NOP();
    __NOP();
    __NOP();
    __NOP();
    for(temp = 8; temp != 0;temp--)
    {
        IIC2_SCL_1;
        //bsp_IIC2_delay(1);
        rbyte = rbyte << 1;
        //bsp_IIC2_delay(1);
        rbyte = rbyte | ((uint8_t)(IIC_IN_SDA));

        IIC2_SCL_0;
        //bsp_IIC2_delay(1);
    }
    return(rbyte);
}

void bsp_IIC2_ACK(void)
{
    IIC2_SDA_OUT();
    IIC2_OUT_SDA_0;
    //bsp_IIC2_delay(1);
    IIC2_SCL_1;
    //bsp_IIC2_delay(1);
    IIC2_SCL_0;
    //bsp_IIC2_delay(1);
    IIC2_OUT_SDA_1;
    //bsp_IIC2_delay(1);
}

void bsp_IIC2_NACK(void)
{
    IIC2_SDA_OUT();
    //bsp_IIC2_delay(1);
    IIC2_OUT_SDA_1;
    //bsp_IIC2_delay(1);
    IIC2_SCL_1;
    //bsp_IIC2_delay(1);
    IIC2_SCL_0;
    //bsp_IIC2_delay(1);
}

uint8_t bsp_IIC2_WaitAck(void)
{
    uint8_t  ack = 1;
    uint16_t i = 100;
    
    IIC_SDA2_IN();
    IIC2_SCL_1;
    while((ack) && (--i != 0 ))
    {
        ack = IIC_IN_SDA;
        WDT_Restart();
    }
    IIC2_SCL_0;
    //bsp_IIC2_delay(1);
    return(ack);
}

uint16_t WR_CN;
uint16_t WR_REG[100];
uint8_t PD_IIC_WritePage(uint8_t PhyAdd, uint16_t MemAdd, uint8_t *Data, uint8_t len);
uint8_t PD_IIC_WritePage(uint8_t PhyAdd, uint16_t MemAdd, uint8_t *Data, uint8_t len)
{
    uint8_t ack = 0u; 
    uint8_t  i;
	  uint8_t  cn = 0;
    uint8_t  *OldData;
    OldData = Data;
	  uint8_t Mem[2];
	   
		Mem[0] =  (uint8_t)((MemAdd >> 8) &0x00ff);
		Mem[1] =  (uint8_t)(MemAdd & 0x00ff);

		Data = OldData;
		while (cn < 5) {

			bsp_IIC2_Start();
			bsp_IIC2_SendByte(PhyAdd);
		ack |= bsp_IIC2_WaitAck();
			bsp_IIC2_SendByte(Mem[0]);
		ack |= bsp_IIC2_WaitAck();
			bsp_IIC2_SendByte(Mem[1]);
  	ack |= bsp_IIC2_WaitAck();
		
			for (i = 0; i < len; i++) {
					bsp_IIC2_SendByte(*Data);    
				ack |= bsp_IIC2_WaitAck();
					Data++;
			}
		 	bsp_IIC2_Stop();
		  //bsp_IIC2_delay(1);
			if (ack != 0) {
					cn ++;
			  	Data = OldData;
			} else {
				 break;
			}
	  }
		if (ack != 0) {
			WR_CN ++;
			WR_REG[WR_CN] =MemAdd;
		}
		//bsp_IIC2_delay(10);
    return ack;
}

uint8_t PD_IIC_ReadPage(uint8_t PhyAdd, uint16_t MemAdd, uint8_t *Data, uint8_t len);
uint8_t PD_IIC_ReadPage(uint8_t PhyAdd, uint16_t MemAdd, uint8_t *Data, uint8_t len)
{
    uint8_t ack = 0u; 
    uint8_t  i;
	  uint8_t Mem[2];
		Mem[0] = (uint8_t)((MemAdd >> 8) &0x00ff);
		Mem[1] = (uint8_t)(MemAdd & 0x00ff);
	
  		Data += 3;
		bsp_IIC2_Start();
		bsp_IIC2_SendByte(PhyAdd);
		ack |= bsp_IIC2_WaitAck();
		bsp_IIC2_SendByte(Mem[0]);
		ack |= bsp_IIC2_WaitAck();
		bsp_IIC2_SendByte(Mem[1]);
		ack |= bsp_IIC2_WaitAck();
    	bsp_IIC2_Start();
    	bsp_IIC2_SendByte(PhyAdd | 0x01);
    	ack |= bsp_IIC2_WaitAck();
		for(i = 0 ; i < (len -1); i++) 
		{
			*Data = bsp_IIC2_ReadByte();
			bsp_IIC2_ACK();
			Data--;
		}
		*Data = bsp_IIC2_ReadByte();
     	bsp_IIC2_ACK();
     	bsp_IIC2_Stop();

		uint8_t testcn=0;
		while (testcn < 8)
		{
		IIC2_SCL_0;
    //bsp_IIC2_delay(1);
    	IIC2_SCL_1;
    //bsp_IIC2_delay(1);
			testcn ++;
		}
	  //bsp_IIC2_delay(10);
    return ack;
}

static void PD_IIC_WriteReg(uint16_t addr, uint32_t data)
{
    //uint8_t TmpData[1] = {data};
		uint8_t TmpData[4] = {(data >> 24 & 0xff), (data >> 16 & 0xff), (data >> 8 & 0xff), (data & 0xff)};
    PD_IIC_WritePage(PD_IIC_DeviceAddr, addr, TmpData, 4);
}

uint32_t PD_IIC_ReadReg(uint16_t addr)
{
    uint8_t data1[4] = {0};
	  uint32_t rdata = 0;
    PD_IIC_ReadPage(PD_IIC_DeviceAddr, addr, data1, 4);
	  rdata  = data1[0]<<0;
	  rdata |= data1[1]<<8;
	  rdata |= data1[2]<<16;
	  rdata |= data1[3] << 24;
    return rdata;//data[0];
}


uint32_t test_read;
uint8_t IntKey = 0;
//uint32_t WriteRegVal = 0;
//uint32_t ReadRegVal = 0;
//uint8_t WriteCn = 0;
//uint32_t TmpBuffer123 [(sizeof(PD_IIC_DAC_Int) / sizeof(PD_IIC_DAC_Int[0]))];
void Init93015_IIC(void)
{
    uint16_t i;

    IntKey = 0;
    PORT_Init(MCU_TOUCH_SCL, OUTPUT);		
	PORT_Init(MCU_TOUCH_SDA, OPENDRAIN_OUTPUT);
	PORT_SetBit(MCU_TOUCH_SCL);
	PORT_SetBit(MCU_TOUCH_SDA);
	test_read = PD_IIC_ReadReg(0xff10);
	PD_IIC_WriteReg(0xFF0C, 0);
	test_read = PD_IIC_ReadReg(0xF080);//1
    for(i = 0;i < (sizeof(PD_IIC_DAC_Int) / sizeof(PD_IIC_DAC_Int[0])); i++)
	 {
      WDT_Restart();
	  PD_IIC_WriteReg(PD_IIC_DAC_Int[i].addr, PD_IIC_DAC_Int[i].RegVal);
/*	    while (WriteCn < 5) 
		{
					WriteRegVal = PD_IIC_DAC_Int[i].RegVal;
					bsp_IIC_delay(1);
					TmpBuffer123[i] = PD_IIC_ReadReg(PD_IIC_DAC_Int[i].addr);
					ReadRegVal = TmpBuffer123[i];
					if (WriteRegVal != ReadRegVal) 
					{
						//ReadRegVal = WriteRegVal;
							WriteCn ++;
						//  InitCount ++;
					} 
					else 
					{
						break;
					}						//
		 }*/
    }
	  PD_IIC_WriteReg(0xf008, 1);//AW9310X_ACTIVE_MODE
}
/*void READPD_IICTEST(void)
{
    uint16_t i;
    uint32_t TmpBuffer[(sizeof(PD_IIC_DAC_Int) / sizeof(PD_IIC_DAC_Int[0]))];

   for(i = 0;i < (sizeof(PD_IIC_DAC_Int) / sizeof(PD_IIC_DAC_Int[0])); i++)
	 {
      WDT_Restart();

	    bsp_IIC_delay(100);
		  TmpBuffer[i] = PD_IIC_ReadReg(PD_IIC_DAC_Int[i].addr);
    }
		// InitCount ++;
}*/

/******************************************************************************/
uint8_t GET_Key_Prosess(void)
{
  uint32_t reg = 0;
  
  if (PORT_GetBit(MCU_TOUCH_OUT) == 0)
  {
    reg = PD_IIC_ReadReg(0xf080);
    if (((reg >> 1) & 0x01) == 0x01)
    {
      reg = PD_IIC_ReadReg(0x0090);
      if ((reg >> 25 & 0x01) == 0x01)
      {
        IntKey = 1;
      }
      if ((reg >> 24 & 0x01) == 0x01)
      {
        IntKey = 2;
      }
    }

    if (((reg >> 2) & 0x01) == 0x01)
    {
      IntKey = 0;
    }
  }

  return IntKey;
}

