/*
 * bsp_clock.h
 *
 *  Created on: 2021
 *      Author: QTC
 */

#ifndef _CALCFREQ_H_
#define _CALCFREQ_H_
#include "common.h"
#include "CalcFrequency.h"
	

/*-------------------------------------------------------------------------
* Function Name  : RevFreInit
* Description    : 转速频率初始化函数
* Input          : MaxFreq：转速最大频率，单位Hz
                   TIMn_Clock：频率捕捉计数频率,单位Hz
                   SpeedRadio：转速速比     
                                                    转速 x 速比
                   转速速比计算方式：            频率 = ————————————————————————
                                                        60
* Output         : None
* Return         : None
* onther         : 30电初始化一次
--------------------------------------------------------------------------*/
extern void RevFreInit(uint32_t MaxFreq,uint32_t  TIMn_Clock,uint32_t SpeedRadio);



/*-------------------------------------------------------------------------
* Function Name  : InputRevLowPulseTime
* Description    : 输入转速脉冲低电平时间
* Input          : TIMn_TCx：时间计数。TIM_overFlag：是否发生溢出
* Output         : None
* Return         : None
* onther         : 捕获中断中调用
--------------------------------------------------------------------------*/
extern void InputRevLowPulseTime(uint16_t* TIMn_TCx,uint16_t* TIM_overFlag);


/*-------------------------------------------------------------------------
* Function Name  : InputRevHighPulseTime
* Description    : 输入转速脉冲高电平时间
* Input          : TIMn_TCx：时间计数。TIM_overFlag：是否发生溢出
* Output         : None
* Return         : None
* onther         : 捕获中断中调用
--------------------------------------------------------------------------*/
extern void InputRevHighPulseTime(uint16_t* TIMn_TCx,uint16_t* TIM_overFlag);


/*-------------------------------------------------------------------------
* Function Name  : CalcRevFreqService
* Description    : 计算转速频率服务函数
* Input          : deltaTime：函数调用周期时间，仅计算超时使用，时间要求不严格
* Output         : None
* Return         : None
* onther         : 建议放在100ms周期任务中
--------------------------------------------------------------------------*/
extern void CalcRevFreqService(uint16_t deltaTime);  

/*-------------------------------------------------------------------------
* Function Name  : Get_Rev_Speed
* Description    : 获取真实转速
* Input          : None
* Output         : 转速值
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
uint16_t Get_Rev_Speed(void);


/*-------------------------------------------------------------------------
* Function Name  : VehFreInit
* Description    : 车速频率初始化函数
* Input          : MaxSpeed：最大车速，单位km/h
                   TIMn_Clock：频率捕捉计数频率,单位Hz
                   SpeedRadio：转速速比     
                                                     车速 x PPK
                   车速PPK计算方式：            频率 = ————————————————————————
                                                        3600
* Output         : None
* Return         : None
* onther         : 30电初始化一次
--------------------------------------------------------------------------*/
void   VehFreInit(uint32_t MaxSpeed,uint32_t  TIMn_Clock,uint32_t PPK);


/*-------------------------------------------------------------------------
* Function Name  : CalcVehFreqService
* Description    : 计算车速频率服务函数
* Input          : deltaTime：函数调用周期时间，仅计算超时使用，时间要求不严格
* Output         : None
* Return         : None
* onther         : 建议放在100ms周期任务中
--------------------------------------------------------------------------*/
void CalcVehFreqService(uint16_t deltaTime);



/*-------------------------------------------------------------------------
* Function Name  : InputVehLowPulseTime
* Description    : 输入车速脉冲低电平时间
* Input          : TIMn_TCx：时间计数。TIM_overFlag：是否发生溢出
* Output         : None
* Return         : None
* onther         : 捕获中断中调用
--------------------------------------------------------------------------*/
void InputVehLowPulseTime(uint16_t* TIMn_TCx,uint16_t* TIM_overFlag);


/*-------------------------------------------------------------------------
* Function Name  : InputVehHighPulseTime
* Description    : 输入车速脉冲高电平时间
* Input          : TIMn_TCx：时间计数。TIM_overFlag：是否发生溢出
* Output         : None
* Return         : None
* onther         : 捕获中断中调用
--------------------------------------------------------------------------*/
void InputVehHighPulseTime(uint16_t* TIMn_TCx,uint16_t* TIM_overFlag);


/*-------------------------------------------------------------------------
* Function Name  : Get_Veh_Speed
* Description    : 获取真实车速
* Input          : None
* Output         : 车速值
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
uint16_t Get_Veh_Speed(void);


/*-----------user code --------------------*/
void CalcFreqData(uint16_t deltaTime);
void CalcFreq_KL15_Init(void);

#endif /* _CALCFREQ_H_ */
