#ifndef _BGLINTERFACE_H
#define _BGLINTERFACE_H

#include "common.h"

/*#define uint8_t unsigned char*/ 
/*#define uint16_t unsigned short*//*3360 324*/ 
/*#define uint16_t unsigned int*/ /*Freesecale */
/*#define uint32_t unsigned long*//*Freesecale */
/*#define uint32_t unsigned int*/
#define COLOR_LED_DEBUG 0u
/*占空比最大值*/
#define BACKLIGHTCYCLE 721u
#define NTC_AD_MAX 4096u
/*有小灯背光降到当前显示等级的百分比*/
#define POSITION_LIGHT_PERCENT 70u


/*自动调节背光参数*/
#define CHANGE_TO_NIGHT_MODE_VALUE 721u
#define CHANGE_TO_DAY_MODE_VALUE 1500u

#define BG_Debounce_Time_Ms 200u
#define Light_Buffer_Size 20u

#define BG_Auto_Mode_Min_Light  80u
#define BG_Auto_Mode_Min_Duty 400u

#define BG_Auto_Mode_Max_Light  2000u
#define BG_Auto_Mode_Max_Duty  950u


typedef enum _dayOrNight
{
    _DAY = 0,  //白天模式
    _NIGHT

}dayOrNight_E;

enum {
    TIMERBIO0,

};

enum {
    BGL_IGN_OFF,
    BGL_IGN_ON,
};

enum {
    BGL_GRADUAL,
    BGL_DIRECT,
};
enum {
    BL_TYPE_DAY,
    BL_TYPE_EVENING,
    BL_TYPE_NIGHT,
    BL_TYPE_TOTAL,
};
enum {
    BL_THEME_RED,
    BL_THEME_BLUE,
    BL_THEME_WHITE,
    BL_THEME_TOTAL,
};
enum {
    BL_LV_MIN = 0,
    BL_LV_1,
    BL_LV_2,
    BL_LV_3,
    BL_LV_4,
    BL_LV_5,
    BL_LV_6,
    BL_LV_7,
    BL_LV_8,
    BL_LV_9,
    BL_LV_10,
    BL_LV_MAX,
    BL_LV_TOTAL,
    BL_LV_AUTO = 0xFE,
};
enum {
    BL_TFT,
    BL_DIAL,
    BL_R,
    BL_G,
    BL_B,
    BACKLIGHT_TOTAL,
};

typedef struct {
    uint16_t DestBackLightDuty;
    uint16_t CurBackLightDuty;
    uint16_t BackLightDutyMin;
}BACKLIGHT_PARA;
typedef struct {
    uint8_t BL_User_PowerSt;
    uint8_t BL_User_WakeFlag;
    uint16_t BL_User_TFTDuty;
    uint16_t BL_User_GaugesDuty;
    uint16_t BL_User_RDuty;
    uint16_t BL_User_GDuty;
    uint16_t BL_User_BDuty;
    uint16_t BL_User_TFTDuty_MIN;
    uint16_t BL_User_GaugesDuty_MIN;
    uint16_t BL_User_RDuty_MIN;
    uint16_t BL_User_GDuty_MIN;
    uint16_t BL_User_BDuty_MIN;
}BL_USER_PARA;
typedef struct {
    uint8_t BL_User_Mode;
    uint8_t BL_User_Theme;
    uint8_t BL_User_Type;
    uint8_t BL_User_TFTLvl;
    uint8_t BL_User_DIALLvl;
    uint8_t BL_User_RGBLvl;
    uint8_t BL_User_Lvl_Total;
    uint16_t BL_User_NTC_AD;
    uint16_t BL_User_NTC_AD_MAX;
    uint8_t BL_User_effect;
}BL_STATE_PARA;

typedef struct {
    uint8_t BL_TFT_Lvl;
    uint8_t BL_DIAL_Lvl;
    uint8_t BL_RGB_Lvl;
}BL_Lvl_PARA;
extern void  BGLPwm_Config(uint8_t BGLType,  uint16_t DutyVal);
extern void BackLightDeal(BL_USER_PARA  BL_FunPara,BL_STATE_PARA BLFunStatePara);
extern void BGLPwm_Stop(uint8_t BGLType);
extern void BGLPwm_Start(uint8_t BGLType);
/*以下主函数调用*/
/*得到主题模式可自己在枚举中定义 在BackGroundLight.c里填表*/
extern void SetBGLTheme(uint8_t BGLTheme);
/*得到工作模式 白天 傍晚 夜晚 在枚举中已定义*/
extern void SetBGLType(uint8_t BGLType);
/*得到背光等级 可自己在枚举中定义 在BackGroundLight.c里填表*/
extern void  SetBGLLvl(BL_Lvl_PARA BGLLvl, uint8_t FunPositionLight);
/*小灯暗级处理*/
uint8_t  ProcessLittleLight(uint8_t BGLLvl);
/*得到热敏电阻电压参数为100倍电压值*/
extern void GetBGLNTCVol(uint16_t BGLNTCVol);
/*主函数中调用第一个参数电源状态 1是 ON档 2 off 第二个参数 唤醒条件 1是TTF唤醒 2 是表盘唤醒 3 是表盘和屏都有唤醒，0无唤醒*/
extern void BackLightSchedu(uint8_t BGLPowerSt,uint8_t WakeFlag);
/*定时函数中调用 1ms函数中调用 TimeX 填1u*/
extern void BackLightDamp(uint8_t TimeX);

extern dayOrNight_E Get_Day_Or_Night(void);
/*调试用*/
#if COLOR_LED_DEBUG
extern void  DebugBGLPara(void);
extern void  SetTFTDebugPara(uint16_t TestTFTDuty);
extern void  SetGaugesDebugPara(uint16_t TestGaugesDuty);
extern void  SetRDebugPara(uint16_t TestRDuty);
extern void  SetGDebugPara(uint16_t TestGDuty);
extern void  SetBDebugPara(uint16_t TestBDuty);
#endif
/**用户自定义函数**/
/*背光任务*/
extern void  BGTask(void);
/*陕汽M3000背光等级出来函数*/
extern uint8_t BL_Logic_Get_Lv(void);
#endif


