#include "bsp_BU27030.h"
#include "common.h"
#include  "IIC.h"

uint16_t IIC1_CheckSDA_Times = 0u;
uint16_t IIC1_NACK_Times = 0u;

#define BU2703_SLAVE_ADDR 0X38

#define BU2703_FITER_SIZE 10
typedef struct 
{
    /* data */
    uint16_t data1buf[BU2703_FITER_SIZE];
    uint8_t index1;
    uint16_t data1;

}BU2703_Datas_Struct;

BU2703_Datas_Struct BU2703Dat;

uint8_t Register_BU2703_Senser[] = 
{
    0x40,0X80,
    0x41,0X00,
    0x42,0X22,
    0x43,0X01,
};

void LIGHT_IIC_Write_Data(uint8_t devAddr, uint8_t len, uint8_t *Data)
{
    uint8_t Ack = 0;

    bsp_IIC_Start( );

    bsp_IIC_SendByte(devAddr*2);
    Ack = bsp_IIC_WaitAck( );
    if ( Ack != 0 )
    {
        bsp_IIC_Stop( );
    }

    while (len  )
    {
        len-- ;
        bsp_IIC_SendByte(*(Data++));
        Ack = bsp_IIC_WaitAck( );
        if ( Ack != 0 )
        {
            bsp_IIC_Stop( );
        }
    };

    bsp_IIC_Stop( );
}


void BU2703_Senser_Init(void )
{    
    uint8_t mAddr = 0XFF;    
    uint16_t i = 0;
 
    mAddr  = 0X38;    

    Simulated_IIC_2_Init();

    for ( i = 0; i < 4; i++)
    {
        LIGHT_IIC_Write_Data(mAddr, 2, &Register_BU2703_Senser[i*2]);
    }
}


uint8_t LIGHT_IIC_Read_Byte(uint8_t devAddr, uint8_t addr2, uint8_t *pData)
{
    uint8_t Ack = 0;

    bsp_IIC_Start( );

    bsp_IIC_SendByte(devAddr * 2);
    Ack = bsp_IIC_WaitAck( );
    if ( Ack != 0 )
    {
        bsp_IIC_Stop( );
        return 0;
    }

    bsp_IIC_SendByte(addr2);
    Ack = bsp_IIC_WaitAck( );
    if ( Ack != 0 )
    {
        bsp_IIC_Stop( );
        return 0;
    }

    bsp_IIC_Start( );
    bsp_IIC_SendByte(devAddr * 2 + 1);
    Ack = bsp_IIC_WaitAck( );
    if ( Ack != 0 )
    {
        bsp_IIC_Stop( );
        return 0;
    }

    *pData = bsp_IIC_ReadByte( );

    bsp_IIC_NACK();
    // 停止IIC
    bsp_IIC_Stop( );

    return 1;
}


void BU2703_Read_Datas(void )
{
    uint8_t dataL = 0;
    uint8_t dataH = 0;
    uint8_t meas_en = 0;
    uint16_t temp = 0xffff;

    LIGHT_IIC_Read_Byte(BU2703_SLAVE_ADDR, 0x43, &meas_en);
    if(meas_en & 0x80)
    {
        LIGHT_IIC_Read_Byte(BU2703_SLAVE_ADDR, 0x52, &dataL);
        LIGHT_IIC_Read_Byte(BU2703_SLAVE_ADDR, 0x53, &dataH);

        temp = dataH;
        temp = (temp << 8);
        temp |= dataL;

        if(BU2703Dat.index1 >= BU2703_FITER_SIZE)
        {
            BU2703Dat.index1 = 0;
            App_SortNWord_u16(BU2703Dat.data1buf, BU2703_FITER_SIZE);
            BU2703Dat.data1 = BU2703Dat.data1buf[BU2703_FITER_SIZE / 2]; //15*50ms update
        }

        if(temp < 0xffff)
        {
            BU2703Dat.data1buf[BU2703Dat.index1] = temp;
            BU2703Dat.index1++;
        }
    }

}

uint16_t BU2703_Get_Data1(void )
{
    return BU2703Dat.data1;
}


void App_SwapWord_u16(uint16_t *pData1,uint16_t *pData2)
{
    uint16_t psw;
    if((*pData1) > (*pData2))
    {
        psw = (*pData2);
        (*pData2) = (*pData1);
        (*pData1) = psw;
    }
}



void App_SortNWord_u16(uint16_t *SortData,uint8_t len)
{
    uint8_t n=0,m;
    for(;n < len-1;n++)
    {
        for(m = n+1;m < len;m++)
        {
            App_SwapWord_u16((SortData + n),(SortData + m));
        }
    }
}







