/******************************************************************************
�?�?名：Simulated_IIC_Master.c
功能描述：IO端口模拟的IIC(I2C)主机函数库文�?
�?   者：张暄
�?   本：V1.0
�?   期：2016.12.21
******************************************************************************/
#include  "IIC.h"
#include  "gpio.h"

uint8_t  IIC_addr = 0u;

__inline  void  bsp_IIC_nop( void )
{
    __NOP();
}

void  bsp_IIC_SCL_inConfig( void ) 
{
    *((volatile uint8_t*)(&PORT->PMC0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PM0+SCL_LED_DRIVER_PORT)) |= ( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PIM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->POM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PU0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
}

void  bsp_IIC_SCL_outConfig( void ) 
{
    *((volatile uint8_t*)(&PORT->PMC0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PIM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->POM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
}

void  bsp_IIC_SCL_out( uint8_t dat ) 
{
    if ( dat ) 
    {  
        *( ( volatile uint8_t* )( &PORT->P0 + 6 ) ) |= ( 1 << PIN2 );
    }
    else 
    {  
        *( ( volatile uint8_t * )( &PORT->P0 + 6 ) ) &= ( ~( 1 << PIN2 ) );
    }
}

void  bsp_IIC_SDA_inConfig( void ) 
{
    PORT_Init( IIC_SDA_27030, INPUT );
}

void  bsp_IIC_SDA_outConfig( void ) 
{
    PORT_Init( IIC_SDA_27030, OUTPUT );
}

void  bsp_IIC_SDA_out( uint8_t dat ) 
{
    if ( dat ) 
    {  
        *( ( volatile uint8_t* )( &PORT->P0 + 6 ) ) |= ( 1 << PIN3 );
    }
    else 
    {  
        *( ( volatile uint8_t * )( &PORT->P0 + 6 ) ) &= ( ~( 1 << PIN3 ) );
    }
}

uint8_t  bsp_IIC_SDA_getVal( void ) 
{
    if ( PORT_GetBit( IIC_SDA_27030 ) )
    {  return  1;  }
    else 
    {  return  0;  }
}


/******************************************************************************
函数名：IIC_Init
�? 能：初始化IIC总线
�? 数：�?
返回值：�?
******************************************************************************/
void  Simulated_IIC_2_Init( void )
{
    *((volatile uint8_t*)(&PORT->PMC0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PIM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->POM0+SCL_LED_DRIVER_PORT)) &= ~( 1 << SCL_LED_DRIVER_PIN );

    *((volatile uint8_t*)(&PORT->PMC0+SDA_LED_DRIVER_PORT)) &= ~( 1 << SDA_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PM0+SDA_LED_DRIVER_PORT)) &= ~( 1 << SDA_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->PIM0+SDA_LED_DRIVER_PORT)) &= ~( 1 << SDA_LED_DRIVER_PIN );
    *((volatile uint8_t*)(&PORT->POM0+SDA_LED_DRIVER_PORT)) &= ~( 1 << SDA_LED_DRIVER_PIN );

    bsp_IIC_Stop();
}

void  Simulated_Release_SCL( void )
{
    bsp_IIC_SCL_out( 0 );
    bsp_IIC_delay( 10 );
}


/*-------------------------------------------------------------------------
* Function Name  : bsp_delay
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void  bsp_IIC_delay( uint32_t time )
{
    uint32_t  i;
    
    for ( i = 0; i <= time; i++ )
    {
        bsp_IIC_nop();
    }
}

/******************************************************************************
函数名：IIC_Start
�? 能：在IIC总线上发送起始信�?发起一次IIC通信
�? 数：�?
返回值：�?
******************************************************************************/
void bsp_IIC_Start(void)
{
    bsp_IIC_SDA_outConfig();

    bsp_IIC_SDA_out( 1 );

    bsp_IIC_nop();

    bsp_IIC_SCL_out( 1 );

    bsp_IIC_nop();

    bsp_IIC_SDA_out( 0 );

    bsp_IIC_nop();

    bsp_IIC_SCL_out( 0 );

    bsp_IIC_nop();
}


/******************************************************************************
函数名：IIC_Stop
�? 能：在IIC总线上发送停止信�?终止当前IIC通信
�? 数：�?
返回值：�?
******************************************************************************/
void  bsp_IIC_Stop( void )
{
    bsp_IIC_SDA_outConfig();

    bsp_IIC_SCL_out( 0 );

    bsp_IIC_nop();

    bsp_IIC_SDA_out( 0 );

    bsp_IIC_nop();

    bsp_IIC_SCL_out( 1 );

    bsp_IIC_nop();

    bsp_IIC_SDA_out( 1 );

    bsp_IIC_nop();
}


/******************************************************************************
函数名：IIC_Transmit_Data
�? 能：向IIC总线上发�?字节数据
�? 数：Data：发送的数据
返回值：总线上器件的确认(ACK)  0 - ACK  1 - NAK
******************************************************************************/
void  bsp_IIC_SendByte( uint8_t Data )
{
    uint8_t  temp;
    uint8_t  d = Data;

    bsp_IIC_SDA_outConfig();

    for ( temp = 8; temp != 0; temp-- )
    {
        if ( d & 0x80 )
        {
            bsp_IIC_SDA_out( 1 );
        }
        else
        {
            bsp_IIC_SDA_out( 0 );
        }
        bsp_IIC_nop();
        bsp_IIC_SCL_out( 1 );
        bsp_IIC_nop();
        bsp_IIC_nop();        
        bsp_IIC_nop();
        bsp_IIC_nop();
        bsp_IIC_nop();
        bsp_IIC_SCL_out( 0 );

        bsp_IIC_nop();
        d = d << 1;
        bsp_IIC_nop();
    }
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_IIC_ReadByte
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t  bsp_IIC_ReadByte( void )
{
    uint8_t  temp;
    uint8_t  rbyte = 0;

    bsp_IIC_SDA_inConfig();

    bsp_IIC_nop();

    for ( temp = 8; temp != 0; temp-- )
    {
        bsp_IIC_nop();
        bsp_IIC_nop();
        bsp_IIC_nop();
        bsp_IIC_nop();
        bsp_IIC_nop();
        bsp_IIC_nop();
        bsp_IIC_nop();
        bsp_IIC_nop();
        bsp_IIC_nop();
        bsp_IIC_SCL_out( 1 );
        bsp_IIC_nop();

        rbyte = rbyte << 1;
        bsp_IIC_nop();

        rbyte = rbyte | ( ( uint8_t )( bsp_IIC_SDA_getVal() ) ); 

        bsp_IIC_SCL_out( 0 );

        bsp_IIC_nop();
    }

    return  ( rbyte );
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_IIC_ACK
* Description    : ack
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void  bsp_IIC_ACK( void )
{
    bsp_IIC_SDA_outConfig();

    bsp_IIC_SDA_out( 0 );

    bsp_IIC_nop();

    bsp_IIC_SCL_out( 1 );

    bsp_IIC_nop();

    bsp_IIC_SCL_out( 0 );

    bsp_IIC_nop();

    bsp_IIC_SDA_out( 1 );

    bsp_IIC_nop();
    bsp_IIC_nop();
    bsp_IIC_nop();
    bsp_IIC_nop();
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_IIC_NACK
* Description    : nack
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void  bsp_IIC_NACK( void )
{
    bsp_IIC_SDA_outConfig();

    bsp_IIC_nop();

    bsp_IIC_SDA_out( 1 );

    bsp_IIC_nop();

    bsp_IIC_SCL_out( 1 );

    bsp_IIC_nop();
    bsp_IIC_nop();
    bsp_IIC_nop();
    bsp_IIC_nop();
    bsp_IIC_nop();
    bsp_IIC_nop();
    bsp_IIC_nop();

    bsp_IIC_SCL_out( 0 );
    //sda = 1?
    bsp_IIC_nop();

}

/******************************************************************************
函数名：bsp_IIC_WaitAck
�? 能：获取从总线上接收到的确认信�?
�? 数：�?
返回值：
******************************************************************************/
uint8_t  bsp_IIC_WaitAck( void )
{
    uint8_t  ack = 1;
    uint16_t  i = IIC_WaitOverTime;

    bsp_IIC_SDA_inConfig();

    bsp_IIC_SCL_out( 1 );//高电平获取

    while ( ( ack ) && ( --i != 0 ) )
    {
        ack = bsp_IIC_SDA_getVal();
    }

    bsp_IIC_SCL_out( 0 );//从机可发送数据

    if ( IIC_addr == 0x38 )
    {
    
    }
    else if ( IIC_addr == 0x78 )
    {
        // if ( ack )
        // {
        //     if ( IIC_3236_NACK_Time < 0xFFFFFFFF )
        //     {  IIC_3236_NACK_Time ++;  }
        // }
        // else
        // {  IIC_3236_NACK_Time = 0;  }
    }

    bsp_IIC_nop();
    bsp_IIC_nop();
    bsp_IIC_nop();
    bsp_IIC_nop();

    return  ( ack );
}


