/**************************************************************************//**
  * \file     Tasks.c
  * \brief    Task list
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     07-Sep-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/
#include "BAT32A239.h"
#include "common.h"
#include "Sys_Scheduler.h"
#include "adc.h"
#include "Analog_Signals.h"
#include "PowerManagement.h"
#include "System_Monitor.h"
#include "Common_Interface.h"
#include "PowerManagement_user.h"
#include "Telltales_Lib.h"
#include "Sys_Tick.h"
#include "Fuel.h" 
#include "rtc.h" 
#include "Flash_synchronizer.h"
#include "eepromManage.h"
#include "CAN_User.h"
#include "gpio.h"
#include "uds_includes.h"
#include "U2_uds_includes.h"
#include "BU98R10.h"
#include "Services_Mileage_User.h"
#include "can.h"
#include "Key_user.h"

#include "app_Telltales.h"
#include "Services_Mileage.h"
#include "Gui_Seg_Dis.h"
#include "Data_ESpeed.h"
#include "Data_VSpeed.h"

/*******************************************************************************
*                                                                              *
*   系统常规运行模式(SYS_MODE_OFF / SYS_MODE_ON / SYS_MODE_STANDBY )任务列表   *
*                                                                              *
*******************************************************************************/

/*==============================================================================
伪实时任�?
------------------------------------------------------------------------------*/

void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{
    if (CAN_Initflag == 0xeb)
    {
        Diagnosis_main();
        U2_Diagnosis_main();
    }
}
/*============================================================================*/



/*==============================================================================
2ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_2ms_Tasks(void)
{
    Analog_Signal_Conv_Real_Time_Run();
    Power_Management_Service();
    Sys_Status_Update_Service();
	BU98R10_Update_Service();
}
/*============================================================================*/
/*==============================================================================
5ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_5ms_Tasks(void)
{
    CAN_RX_Tick();
}

/*==============================================================================
10ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_10ms_Tasks(void)
{					
	Common_SetSelfcheckStart(1);
    Analog_Signal_Conv_Service();
    Telltales_Management();
    Can_BusOff_Fun(10u);
    Key_Clear_Time();

    Data_Mileage_Write_EEPROM();
}
/*============================================================================*/


/*==============================================================================
20ms周期执行任务
------------------------------------------------------------------------------*/

void Sys_Run_Mode_20ms_Tasks(void)
{
	BU98R10_Update_Request();
    Diag_Req_Send(20);	
    Data_Vehicle_Speed_Processing_Service( );	
    Data_Engine_Speed_Processing_Service();
}
/*============================================================================*/


/*==============================================================================
50ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_50ms_Tasks(void)
{
    Flash_Sync_Signal_Generation_Service();






}
/*============================================================================*/


/*==============================================================================
100ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_100ms_Tasks_Group1(void)
{
    Power_Management_Service_user();
}

void Sys_Run_Mode_100ms_Tasks_Group2(void)
{
    /*燃油计算*/
    Fuel_Cal_Sevice(100u);
}

void Sys_Run_Mode_100ms_Tasks_Group3(void)
{
    BU2703_Read_Datas();
    Gui_LightProc();
}

void Sys_Run_Mode_100ms_Tasks_Group4(void)
{
    /*获取RTC时间*/
    RTC_Service();
}

void Sys_Run_Mode_100ms_Tasks_Group5(void)
{

}

void Sys_Run_Mode_100ms_Tasks_Group6(void)
{

}

void Sys_Run_Mode_100ms_Tasks_Group7(void)
{

}
void Sys_Run_Mode_100ms_Tasks_Group8(void)
{
    bsp_CAN_MaskCheck();
}

void Sys_Run_Mode_100ms_Tasks_Group9(void)
{	

}

void Sys_Run_Mode_100ms_Tasks_Group10(void)
{

}
/*============================================================================*/

/*******************************************************************************
*                                                                              *
*                     系统休眠模式(SYS_MODE_SLEEP)任务列表                     *
*                                                                              *
*******************************************************************************/
/*==============================================================================
休眠模式下执行的后台任务
------------------------------------------------------------------------------*/
void Sys_Sleep_Mode_Tasks(void)
{

}
/*============================================================================*/

/*******************************************************************************
*                                                                              *
*                           精确�?50us计时任务列表                             *
*                                                                              *
*******************************************************************************/
/*==============================================================================
精确�?50us计时任务 禁止添加修改列表中的任务
------------------------------------------------------------------------------*/
void Sys_Exact_50us_Tasks(void)
{
   
}
/*============================================================================*/

/*******************************************************************************
*                                                                              *
*                           精确�?100ms计时任务列表                            *
*                                                                              *
*******************************************************************************/
/*==============================================================================
精确�?100ms计时任务 禁止添加修改列表中的任务
------------------------------------------------------------------------------*/
void Sys_Exact_100ms_Tasks(void)
{

}
/*============================================================================*/


void APP_Startup_Init (uint8_t startMode)
{

}



