/**************************************************************************//**
  * \file     Sys_Scheduler.h
  * \brief    Task Scheduler header file
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     06-Sep-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/

#ifndef SYS_SCHEDULER_H
#define SYS_SCHEDULER_H

/* Includes ------------------------------------------------------------------*/

/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern  {
#endif

typedef enum SysOprModeType
{
  SYS_MODE_OFF      = 0U,
  SYS_MODE_ON       = 1U,
  SYS_MODE_STANDBY  = 2U,
  SYS_MODE_SLEEP    = 3U,
}Sys_Opr_Mode_en_t;

/*** 系统工作模式 ***/
extern Sys_Opr_Mode_en_t SysOprMode;
#define   SYS_OPR_MODE                      SysOprMode

/* Exported functions ------------------------------------------------------- */

extern void Sys_Init(void);
extern void Sys_Scheduling_Service(void);
extern void Sys_Process_ISR(void);

extern void Sys_Scheduling_Tmr(void);
// extern void Sys_Run_MODE_2ms_Tasks(void);
// extern void Sys_Run_MODE_5ms_Tasks(void);
// extern void Sys_Run_MODE_10ms_Tasks(void);


void APP_Startup_Init (uint8_t startMode);
void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void);
void Sys_Run_Mode_2ms_Tasks(void);
void Sys_Run_Mode_5ms_Tasks(void);
void Sys_Run_Mode_10ms_Tasks(void);
void Sys_Run_Mode_20ms_Tasks(void);
void Sys_Run_Mode_50ms_Tasks(void);
void Sys_Run_Mode_100ms_Tasks_Group1(void);
void Sys_Run_Mode_100ms_Tasks_Group2(void);
void Sys_Run_Mode_100ms_Tasks_Group3(void);
void Sys_Run_Mode_100ms_Tasks_Group4(void);
void Sys_Run_Mode_100ms_Tasks_Group5(void);
void Sys_Run_Mode_100ms_Tasks_Group6(void);
void Sys_Run_Mode_100ms_Tasks_Group7(void);
void Sys_Run_Mode_100ms_Tasks_Group8(void);
void Sys_Run_Mode_100ms_Tasks_Group9(void);
void Sys_Run_Mode_100ms_Tasks_Group10(void);
void Sys_Exact_50us_Tasks(void);
void Sys_Exact_100ms_Tasks(void);

#ifdef __cplusplus
}
#endif

#endif
