
#include "CalcFrequency.h" 
#include "Common_Interface.h"
#include "tim4.h"
#include "MCU_Core_Protocol.h"
#include "CAN_Communication_Matrix.h"
#include "SEG_LCD.h"

//static uint16_t VehSpeedBuf[3];
//static uint8_t VehSpeedCount;
void CalcFreq_KL15_Init(void)
{
//    E_Speed_Dir = E_SPEED_SEG_UP;
//    EspeedBak = 0;
//    E_Speed_Current_Bar = 0;
//    CurEspeed = 0;
//    DesEspeed = 0;
    // VehSpeedBuf[0] = 0;
    // VehSpeedBuf[1] = 0;
    // VehSpeedBuf[2] = 0;
    // VehSpeedCount = 0;
    Capture_Init(40u);
    RevFreInit(200u, 500000u, 1u);
    //Capture_Init(40u);
    //VehFreInit(360u, 500000u, 23616u); // 23637u);  //20230602;
}
uint16_t DisVehDelay = 0;
void CalcFreqData(uint16_t deltaTime)
{
    uint16_t RevSpeed = 0;
    uint16_t VehSpeed = 0;
    uint16_t DispVehSpeed = 0;
	uint16_t RearVeh = 0;
	uint16_t DispRearVeh = 0;
    uint32_t temp32 = 0;
	uint8_t Valid = 0;

	CalcRevFreqService(deltaTime);
    
    /*转�??*/
    RevSpeed = Get_Rev_Speed();
    if (RevSpeed > 18000)
    { /*输入频率大于300Hz，转速显�?0*/
        RevSpeed = 0;
    }
    else if (RevSpeed > 12000)
    {
        RevSpeed = 12000;
    }
    
    if ((RevSpeed < 12100) && (Common_GetIgnOnTime() > IGON_SelfcheckingTimer))
    { /*输入频率大于200HZ（小�?300HZ）时，保持当前�?�显示�??*/
        Common_Set_Act_E_Speed(RevSpeed);
        Common_Set_Act_E_Speed_Valid(COMMON_Valid);
        Common_Set_Disp_E_Speed(RevSpeed);
        Common_Set_Disp_E_Speed_Valid(COMMON_Valid);
    }
    

    temp32 = Get_ID_12B_Rear_Speed();
    temp32 *= 5625;
    temp32 /= 10000;
    Valid = Get_ID_12B_Rear_Wheel_Speed_Validity();
    if ((Valid == 1) || (temp32 < 30) || (CAN_SIG_LOST == CAN_MSG_Status(ID_ABS_12B_Count)))
    {
        VehSpeed = 0;
        DispVehSpeed = 0;
    }
    else
    {
        VehSpeed = temp32;
        DispVehSpeed = temp32 * 108 / 10;
        if (DispVehSpeed > 1990)
        {
            DispVehSpeed = 1990;
        }
        
    }
    Common_Set_Act_V_Speed(VehSpeed);
    Common_Set_Act_V_Speed_Valid(COMMON_Valid);

    DisVehDelay += deltaTime;
    if(DisVehDelay >= 200){
        DisVehDelay = 0;
        DispVehSpeed = ((uint32_t)VehSpeed*108)/100;
        if(DispVehSpeed  > 1990){
            DispVehSpeed = 1990;
        }
        Common_Set_Disp_V_Speed(DispVehSpeed);
        Common_Set_Disp_V_Speed_Valid(COMMON_Valid);
    }
}
