#include "eepromManage.h"
#include "eeManager_Interface.h"
#include "gpio.h"
#include "wdt.h"
//#include "bsp_port.h"
//#include "abstract.h"

/*-------------------------------------------------------------------------
* Function Name  : eeprom_StoreInfo_Init
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void eeprom_StoreInfo_Init(void)
{
    eeprom_SetParameter(AT24C16,distance_100m);
    EE_SCL_OutConfig();
    EE_SDA_OutConfig();
}

/*-------------------------------------------------------------------------
* Function Name  : eeprom_comm_DelayUs
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void eeprom_comm_DelayUs(ee_uint32_t time)
{
    ee_uint32_t i;
    ee_uint32_t dalayCnt = 0;
    dalayCnt = time;
    EE_FeedDog();
    for(i = 0;i < dalayCnt;i++)
    {
        EE_NOP();

    }
    EE_FeedDog();
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_InConfig
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_InConfig(void)
{
    PORT_Init(IIC_SDA_24G16, INPUT);
}
/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_OutConfig
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_OutConfig(void)
{ 
    PORT_Init(IIC_SDA_24G16, OPENDRAIN_OUTPUT);
}
/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_GetValue
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
ee_uint8_t EE_SDA_GetValue(void)
{ 
    ee_uint8_t temp8 = 0;
    if(PORT_GetBit(IIC_SDA_24G16)){
        temp8 = 1;
    }
    return  temp8;
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_OUT
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_OUT(ee_uint8_t data)
{
    if(data)
        PORT_SetBit(IIC_SDA_24G16);
    else
        PORT_ClrBit(IIC_SDA_24G16);
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_OutConfig
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SCL_OutConfig(void)
{
    PORT_Init(IIC_SCL_24G16, OPENDRAIN_OUTPUT); 
}
/*-------------------------------------------------------------------------
* Function Name  : EE_SCL_OUT
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SCL_OUT(ee_uint8_t data)
{
    if(data)
        PORT_SetBit(IIC_SCL_24G16);
    else
        PORT_ClrBit(IIC_SCL_24G16);

}

/*-------------------------------------------------------------------------
* Function Name  : EE_FeedDog
* Description    : 清零 DOG
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_FeedDog(void)
{

    WDT_Restart();

}

/*-------------------------------------------------------------------------
* Function Name  : EE_NOP
* Description    : nop 指令
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_NOP(void)
{
     __NOP();
  
}


