

#include "BU98R10.h"
#include "SEG_LCD.h"
#include "IS31FL3236.h"

/* 端口寄存器基地址 */
#define Register_Base_Address 0X40040000UL

/* 端口寄存器偏移地址*/
#define Port_0_Offset_Address 0X300UL
#define Port_01_Offset_Address 0X301UL
#define Port_02_Offset_Address 0X302UL
#define Port_03_Offset_Address 0X303UL
#define Port_04_Offset_Address 0X304UL
#define Port_05_Offset_Address 0X305UL
#define Port_06_Offset_Address 0X306UL
#define Port_07_Offset_Address 0X307UL
#define Port_08_Offset_Address 0X308UL
#define Port_10_Offset_Address 0X309UL
#define Port_11_Offset_Address 0X30AUL
#define Port_12_Offset_Address 0X30BUL
#define Port_13_Offset_Address 0X30CUL
#define Port_14_Offset_Address 0X30EUL
#define Port_15_Offset_Address 0X30FUL

/* 选择端口 */
#define Port_0 0UL
#define Port_01 1UL
#define Port_02 2UL
#define Port_03 3UL
#define Port_04 4UL
#define Port_05 5UL
#define Port_06 6UL
#define Port_07 7UL
#define Port_08 8UL
#define Port_10 10UL
#define Port_11 11UL
#define Port_12 12UL
#define Port_13 13UL
#define Port_14 14UL
#define Port_15 15UL

/* 选择端口对应PIN */
#define PIN_0 0
#define PIN_1 1
#define PIN_2 2
#define PIN_3 3
#define PIN_4 4
#define PIN_5 5
#define PIN_6 6
#define PIN_7 7
/* 基地址 + 偏移地址 + 对应Port*/
#define SEG_LCD0_SD Register_Base_Address + Port_0_Offset_Address + Port_0
#define SEG_LCD0_SCL Register_Base_Address + Port_0_Offset_Address + Port_0
#define SEG_LCD0_CS Register_Base_Address + Port_0_Offset_Address + Port_0

#define SEG_LCD1_SD Register_Base_Address + Port_07_Offset_Address + Port_07
#define SEG_LCD1_SCL Register_Base_Address + Port_07_Offset_Address + Port_07
#define SEG_LCD1_CS Register_Base_Address + Port_07_Offset_Address + Port_07

#define SEG_LCD0_SD_PIN PIN_2
#define SEG_LCD0_SCL_PIN PIN_4
#define SEG_LCD0_CS_PIN PIN_3

#define SEG_LCD1_SD_PIN PIN_2
#define SEG_LCD1_SCL_PIN PIN_0
#define SEG_LCD1_CS_PIN PIN_1

#if USE_BU98R10_CHIP_0
volatile BU98R10DDRAMUnion BU98R10Chip0DDRAM;
BU98R10DDRAMUnion BU98R10Chip0DDRAMBackup;
#endif

#if USE_BU98R10_CHIP_1
volatile BU98R10DDRAMUnion BU98R10Chip1DDRAM;
BU98R10DDRAMUnion BU98R10Chip1DDRAMBackup;
#endif

BU98R10UpdateCtrlStruct BU98R10Update;

void BU98R10_Init(void)
{
	uint8_t i;

#if BU98R10_WRITE_AT_SAME_TIME
#if BU98R10_COLORFUL_LCD_MODE

	BU98R10_All_Command_Write(BU98R10_CMD_SWRST);

	BU98R10_All_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);

	BU98R10_All_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_All_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_All_Data_Write(BU98R10_FRAME_FREQ, BU98R10_FRAME_FREQ);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_CTRL);
	BU98R10_All_Data_Write(0x12, 0x12);

	BU98R10_All_Command_Write(BU98R10_CMD_SEG_R);
	BU98R10_All_Data_Write(BU98R10_REG_SEG_R, BU98R10_REG_SEG_R);

	BU98R10_All_Command_Write(BU98R10_CMD_SEG_G);
	BU98R10_All_Data_Write(BU98R10_REG_SEG_G, BU98R10_REG_SEG_G);

	BU98R10_All_Command_Write(BU98R10_CMD_SEG_B);
	BU98R10_All_Data_Write(BU98R10_REG_SEG_B, BU98R10_REG_SEG_B);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTR);
	BU98R10_All_Data_Write(BU98R10_LRS, BU98R10_LRS);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTG);
	BU98R10_All_Data_Write(BU98R10_LGS, BU98R10_LGS);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTB);
	BU98R10_All_Data_Write(BU98R10_LBS, BU98R10_LBS);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHR);
	BU98R10_All_Data_Write(BU98R10_LRW, BU98R10_LRW);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHG);
	BU98R10_All_Data_Write(BU98R10_LGW, BU98R10_LGW);

	BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHB);
	BU98R10_All_Data_Write(BU98R10_LBW, BU98R10_LBW);

	BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_All_Data_Write(0x00, 0x00);

	BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_All_Data_Write(BU98R10_DEFAULT_BYTE, BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;

		BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_All_Command_Write(BU98R10_CMD_DISPON);

#else

	BU98R10_All_Command_Write(BU98R10_CMD_SWRST);

	BU98R10_All_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);

	BU98R10_All_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_All_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_All_Data_Write(BU98R10_FRAME_FREQ, BU98R10_FRAME_FREQ);

	BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_All_Data_Write(0x00, 0x00);

	BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_All_Data_Write(BU98R10_DEFAULT_BYTE, BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;

		BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_All_Command_Write(BU98R10_CMD_DISPON);

#endif
#else
#if BU98R10_COLORFUL_LCD_MODE
#if USE_BU98R10_CHIP_0

	BU98R10_0_Command_Write(BU98R10_CMD_SWRST);

	BU98R10_0_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);

	BU98R10_0_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_0_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_0_Data_Write(BU98R10_FRAME_FREQ);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_CTRL);
	BU98R10_0_Data_Write(0x12);

	BU98R10_0_Command_Write(BU98R10_CMD_SEG_R);
	BU98R10_0_Data_Write(BU98R10_REG_SEG_R);

	BU98R10_0_Command_Write(BU98R10_CMD_SEG_G);
	BU98R10_0_Data_Write(BU98R10_REG_SEG_G);

	BU98R10_0_Command_Write(BU98R10_CMD_SEG_B);
	BU98R10_0_Data_Write(BU98R10_REG_SEG_B);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTR);
	BU98R10_0_Data_Write(BU98R10_LRS);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTG);
	BU98R10_0_Data_Write(BU98R10_LGS);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTB);
	BU98R10_0_Data_Write(BU98R10_LBS);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHR);
	BU98R10_0_Data_Write(BU98R10_LRW);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHG);
	BU98R10_0_Data_Write(BU98R10_LGW);

	BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHB);
	BU98R10_0_Data_Write(BU98R10_LBW);

	BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_0_Data_Write(0x00);

	BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_0_Data_Write(BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_0_Command_Write(BU98R10_CMD_DISPON);

#endif
#if USE_BU98R10_CHIP_1

	BU98R10_1_Command_Write(BU98R10_CMD_SWRST);

	BU98R10_1_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);

	BU98R10_1_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_1_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_1_Data_Write(BU98R10_FRAME_FREQ);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_CTRL);
	BU98R10_1_Data_Write(0x12);

	BU98R10_1_Command_Write(BU98R10_CMD_SEG_R);
	BU98R10_1_Data_Write(BU98R10_REG_SEG_R);

	BU98R10_1_Command_Write(BU98R10_CMD_SEG_G);
	BU98R10_1_Data_Write(BU98R10_REG_SEG_G);

	BU98R10_1_Command_Write(BU98R10_CMD_SEG_B);
	BU98R10_1_Data_Write(BU98R10_REG_SEG_B);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTR);
	BU98R10_1_Data_Write(BU98R10_LRS);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTG);
	BU98R10_1_Data_Write(BU98R10_LGS);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTB);
	BU98R10_1_Data_Write(BU98R10_LBS);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHR);
	BU98R10_1_Data_Write(BU98R10_LRW);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHG);
	BU98R10_1_Data_Write(BU98R10_LGW);

	BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHB);
	BU98R10_1_Data_Write(BU98R10_LBW);

	BU98R10_1_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_1_Data_Write(0x00);

	BU98R10_1_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_1_Data_Write(BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_1_Command_Write(BU98R10_CMD_DISPON);

#endif
#else
#if USE_BU98R10_CHIP_0

	BU98R10_0_Command_Write(BU98R10_CMD_SWRST);

	BU98R10_0_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);

	BU98R10_0_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_0_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_0_Data_Write(BU98R10_FRAME_FREQ);

	BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_0_Data_Write(0x00);

	BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_0_Data_Write(BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_0_Command_Write(BU98R10_CMD_DISPON);

#endif
#if USE_BU98R10_CHIP_1

	BU98R10_1_Command_Write(BU98R10_CMD_SWRST);

	BU98R10_1_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);

	BU98R10_1_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

	BU98R10_1_Command_Write(BU98R10_CMD_FREQ);
	BU98R10_1_Data_Write(BU98R10_FRAME_FREQ);

	BU98R10_1_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_1_Data_Write(0x00);

	BU98R10_1_Command_Write(BU98R10_CMD_DATWR);
	for (i = 0; i < 90; i++)
		BU98R10_1_Data_Write(BU98R10_DEFAULT_BYTE);

	for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
	{
		BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
		BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
	}

	BU98R10_1_Command_Write(BU98R10_CMD_DISPON);

#endif
#endif
#endif

	BU98R10Update.En = 0;
	BU98R10Update.Step = 0;
	BU98R10Update.Cont = 0;
	BU98R10Update.Addr = 0;

#if USE_BU98R10_CHIP_0
	BU98R10Update.Chip = 0;
#elif USE_BU98R10_CHIP_1
	BU98R10Update.Chip = 1;
#else
	BU98R10Update.Chip = 255;
#endif
}

void BU98R10_Shutdown(void)
{
#if BU98R10_WRITE_AT_SAME_TIME
	BU98R10_All_Command_Write(BU98R10_CMD_DISPOFF);
#else
#if USE_BU98R10_CHIP_0
	BU98R10_0_Command_Write(BU98R10_CMD_DISPOFF);
#endif

#if USE_BU98R10_CHIP_1
	BU98R10_1_Command_Write(BU98R10_CMD_DISPOFF);
#endif
#endif
}

uint8_t u8BU98R10CheckCount = 0;
void BU98R10_Update_Request(void)
{
	// if (g_sysFlag.Bits.AccSaveState)
	//{
	//	//if (u8BU98R10CheckCount < 20)
	//	//{
	//	//	BU98R10Update.En = 1;
	//	//	u8BU98R10CheckCount++;
	//	//}
	//	BU98R10Update.En = 1;
	// }
	// else
	{

		u8BU98R10CheckCount = 0;
		BU98R10Update.En = 1;
	}

#if USE_BU98R10_CHIP_0
	BU98R10Update.Chip = 0;
#elif USE_BU98R10_CHIP_1
	BU98R10Update.Chip = 1;
#else
	BU98R10Update.Chip = 255;
#endif
}

void BU98R10_Update_Service(void)
{
	if (BU98R10Update.En)
	{
#if BU98R10_WRITE_AT_SAME_TIME

		switch (BU98R10Update.Step)
		{
		case 0:
			if ((BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr]) ||
				(BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr]))
			{
				BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr];
				BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr];

				if (BU98R10Update.Cont)
					BU98R10Update.Step = 4;
				else
					BU98R10Update.Step = 1;
			}
			else
			{
				BU98R10Update.Cont = 0;
				BU98R10Update.Addr++;
				if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
				{
					BU98R10Update.Addr = 0;
					BU98R10Update.En = 0;
				}
			}
			break;

		case 1:
			BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
			BU98R10Update.Step = 2;
			break;

		case 2:
#if BU98R10_COLORFUL_LCD_MODE
			BU98R10_All_Data_Write(BU98R10Update.Addr, BU98R10Update.Addr);
#else
			BU98R10_All_Data_Write(BU98R10Update.Addr * 4, BU98R10Update.Addr * 4);
#endif
			BU98R10Update.Step = 3;
			break;

		case 3:
			BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
			BU98R10Update.Step = 4;
			break;

		case 4:
			BU98R10_All_Data_Write(BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr], BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr]);
			BU98R10Update.Step = 5;
			break;

		case 5:
			BU98R10Update.Addr++;
			if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
			{
				BU98R10Update.Addr = 0;
				BU98R10Update.En = 0;
				BU98R10Update.Cont = 0;
			}
			else
				BU98R10Update.Cont = 1;

			BU98R10Update.Step = 0;
			break;

		default:
			BU98R10Update.En = 0;
			BU98R10Update.Step = 0;
			BU98R10Update.Cont = 0;
			BU98R10Update.Addr = 0;
			break;
		}

#else

#if USE_BU98R10_CHIP_0

		if (BU98R10Update.Chip == 0)
		{
			switch (BU98R10Update.Step)
			{
			case 0:
				if (BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr])
				{
					BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr];

					if (BU98R10Update.Cont)
						BU98R10Update.Step = 4;
					else
						BU98R10Update.Step = 1;
				}
				else
				{
					BU98R10Update.Cont = 0;
					BU98R10Update.Addr++;
					if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
					{
						BU98R10Update.Addr = 0;

#if USE_BU98R10_CHIP_1
						BU98R10Update.Chip = 1;
#else
						BU98R10Update.En = 0;
#endif
					}
				}
				break;

			case 1:
				BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
				BU98R10Update.Step = 2;
				break;

			case 2:
#if BU98R10_COLORFUL_LCD_MODE
				BU98R10_0_Data_Write(BU98R10Update.Addr);
#else
				BU98R10_0_Data_Write(BU98R10Update.Addr * 4);
#endif
				BU98R10Update.Step = 3;
				break;

			case 3:
				BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
				BU98R10Update.Step = 4;
				break;

			case 4:
				BU98R10_0_Data_Write(BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr]);
				BU98R10Update.Step = 5;
				break;

			case 5:
				BU98R10Update.Addr++;
				if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
				{
					BU98R10Update.Addr = 0;
					BU98R10Update.Cont = 0;

#if USE_BU98R10_CHIP_1
					BU98R10Update.Chip = 1;
#else
					BU98R10Update.En = 0;
#endif
				}
				else
					BU98R10Update.Cont = 1;

				BU98R10Update.Step = 0;
				break;

			default:
				BU98R10Update.En = 0;
				BU98R10Update.Step = 0;
				BU98R10Update.Cont = 0;
				BU98R10Update.Addr = 0;
				break;
			}
		}

#if USE_BU98R10_CHIP_1
		else if (BU98R10Update.Chip == 1)
#endif

#elif USE_BU98R10_CHIP_1
		if (BU98R10Update.Chip == 1)
#endif

#if USE_BU98R10_CHIP_1
		{
			switch (BU98R10Update.Step)
			{
			case 0:
				if (BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr])
				{
					BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr];

					if (BU98R10Update.Cont)
						BU98R10Update.Step = 4;
					else
						BU98R10Update.Step = 1;
				}
				else
				{
					BU98R10Update.Cont = 0;
					BU98R10Update.Addr++;
					if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
					{
						BU98R10Update.Addr = 0;
						BU98R10Update.En = 0;
					}
				}
				break;

			case 1:
				BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
				BU98R10Update.Step = 2;
				break;

			case 2:
#if BU98R10_COLORFUL_LCD_MODE
				BU98R10_0_Data_Write(BU98R10Update.Addr);
#else
				BU98R10_0_Data_Write(BU98R10Update.Addr * 4);
#endif
				BU98R10Update.Step = 3;
				break;

			case 3:
				BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
				BU98R10Update.Step = 4;
				break;

			case 4:
				BU98R10_0_Data_Write(BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr]);
				BU98R10Update.Step = 5;
				break;

			case 5:
				BU98R10Update.Addr++;
				if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
				{
					BU98R10Update.Addr = 0;
					BU98R10Update.Cont = 0;
					BU98R10Update.En = 0;
				}
				else
					BU98R10Update.Cont = 1;

				BU98R10Update.Step = 0;
				break;

			default:
				BU98R10Update.En = 0;
				BU98R10Update.Step = 0;
				BU98R10Update.Cont = 0;
				BU98R10Update.Addr = 0;
				break;
			}
		}
#endif

#if ((USE_BU98R10_CHIP_0) || (USE_BU98R10_CHIP_1))
		else
#endif
			BU98R10Update.En = 0;

#endif
	}
}

#if USE_BU98R10_CHIP_0

void BU98R10_0_Command_Write(uint8_t Cmd)
{
	uint8_t i;

	/*  SD 输出低 */
	*((volatile uint8_t *)(SEG_LCD0_SD)) &= ~(1 << SEG_LCD0_SD_PIN);

	/* SCL 输出低 */
	*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);

	/* CS 输出低 */
	*((volatile uint8_t *)(SEG_LCD0_CS)) &= ~(1 << SEG_LCD0_CS_PIN);

	__NOP();
	__NOP();
	__NOP();

	/* SCL 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);

	for (i = 0; i < 8; i++)
	{
		/* SCL 输出低 */
		*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);

		if (Cmd & 0x80)
			/* SD 输出高 */
			*((volatile uint8_t *)(SEG_LCD0_SD)) |= (1 << SEG_LCD0_SD_PIN);
		else
			/*  SD 输出低 */
			*((volatile uint8_t *)(SEG_LCD0_SD)) &= ~(1 << SEG_LCD0_SD_PIN);

		__NOP();
		__NOP();
		__NOP();

		/* SCL 输出高 */
		*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);

		Cmd <<= 1;
	}

	/* CS 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_CS)) |= (1 << SEG_LCD0_CS_PIN);
}

void BU98R10_0_Data_Write(uint8_t Dat)
{
	uint8_t i;

	/* SD 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_SD)) |= (1 << SEG_LCD0_SD_PIN);

	/* SCL 输出低 */
	*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);

	/* CS 输出低 */
	*((volatile uint8_t *)(SEG_LCD0_CS)) &= ~(1 << SEG_LCD0_CS_PIN);
	__NOP();
	__NOP();
	__NOP();

	/* SCL 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);

	for (i = 0; i < 8; i++)
	{
		/* SCL 输出低 */
		*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);

		if (Dat & 0x80)
			/* SD 输出高 */
			*((volatile uint8_t *)(SEG_LCD0_SD)) |= (1 << SEG_LCD0_SD_PIN);
		else
			/* SCL 输出低 */
			*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);

		__NOP();
		__NOP();
		__NOP();

		/* SCL 输出高 */
		*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);

		Dat <<= 1;
	}

	/* CS 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_CS)) |= (1 << SEG_LCD0_CS_PIN);
}
#endif

#if USE_BU98R10_CHIP_1

void BU98R10_1_Command_Write(uint8_t Cmd)
{
	uint8_t i;

	/*  SD 输出低 */
	*((volatile uint8_t *)(SEG_LCD1_SD)) &= ~(1 << SEG_LCD1_SD_PIN);
	/* SCL 输出低 */
	*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);
	/* CS 输出低 */
	*((volatile uint8_t *)(SEG_LCD1_CS)) &= ~(1 << SEG_LCD1_CS_PIN);

	__NOP();
	__NOP();
	__NOP();

	/* SCL 输出高 */
	*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);

	for (i = 0; i < 8; i++)
	{
		/* SCL 输出低 */
		*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);

		if (Cmd & 0x80)
			/* SD 输出高 */
			*((volatile uint8_t *)(SEG_LCD1_SD)) |= (1 << SEG_LCD1_SD_PIN);
		else
			/*  SD 输出低 */
			*((volatile uint8_t *)(SEG_LCD1_SD)) &= ~(1 << SEG_LCD1_SD_PIN);

		__NOP();
		__NOP();
		__NOP();

		/* SCL 输出高 */
		*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);

		Cmd <<= 1;
	}

	/* CS 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_CS)) |= (1 << SEG_LCD0_CS_PIN);
}

void BU98R10_1_Data_Write(uint8_t Dat)
{
	uint8_t i;

	/* SD 输出高 */
	*((volatile uint8_t *)(SEG_LCD1_SD)) |= (1 << SEG_LCD1_SD_PIN);
	/* SCL 输出低 */
	*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);
	/* CS 输出低 */
	*((volatile uint8_t *)(SEG_LCD1_CS)) &= ~(1 << SEG_LCD1_CS_PIN);

	__NOP();
	__NOP();
	__NOP();

	/* SCL 输出高 */
	*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);

	for (i = 0; i < 8; i++)
	{
		/* SCL 输出低 */
		*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);

		if (Dat & 0x80)
			/* SD 输出高 */
			*((volatile uint8_t *)(SEG_LCD1_SD)) |= (1 << SEG_LCD1_SD_PIN);
		else
			/*  SD 输出低 */
			*((volatile uint8_t *)(SEG_LCD1_SD)) &= ~(1 << SEG_LCD1_SD_PIN);

		__NOP();
		__NOP();
		__NOP();

		/* SCL 输出高 */
		*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);

		Dat <<= 1;
	}

	/* CS 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_CS)) |= (1 << SEG_LCD0_CS_PIN);
}

#endif

#if BU98R10_WRITE_AT_SAME_TIME

void BU98R10_All_Command_Write(uint8_t Cmd)
{
	uint8_t i;

	/* SD/SCL/CS 输出低电平 */
	*((volatile uint8_t *)(SEG_LCD0_SD)) &= ~(1 << SEG_LCD0_SD_PIN);
	*((volatile uint8_t *)(SEG_LCD1_SD)) &= ~(1 << SEG_LCD1_SD_PIN);

	*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);
	*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);

	*((volatile uint8_t *)(SEG_LCD0_CS)) &= ~(1 << SEG_LCD0_CS_PIN);
	*((volatile uint8_t *)(SEG_LCD1_CS)) &= ~(1 << SEG_LCD1_CS_PIN);

	__NOP();
	/* SCL 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);
	*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);

	for (i = 0; i < 8; i++)
	{
		/* SCL 输出低 */
		*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);
		*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);

		if (Cmd & 0x80)
		{
			/* SD 输出高 */
			*((volatile uint8_t *)(SEG_LCD0_SD)) |= (1 << SEG_LCD0_SD_PIN);
			*((volatile uint8_t *)(SEG_LCD1_SD)) |= (1 << SEG_LCD1_SD_PIN);
		}
		else
		{
			/* SD 输出低 */
			*((volatile uint8_t *)(SEG_LCD0_SD)) &= ~(1 << SEG_LCD0_SD_PIN);
			*((volatile uint8_t *)(SEG_LCD1_SD)) &= ~(1 << SEG_LCD1_SD_PIN);
		}

		__NOP();
		/* SCL 输出高 */
		*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);
		*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);

		Cmd <<= 1;
	}
	/* CS 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_CS)) |= (1 << SEG_LCD0_CS_PIN);
	*((volatile uint8_t *)(SEG_LCD1_CS)) |= (1 << SEG_LCD1_CS_PIN);
}

void BU98R10_All_Data_Write(uint8_t Dat0, uint8_t Dat1)
{
	uint8_t i;

	/* SD 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_SD)) |= (1 << SEG_LCD0_SD_PIN);
	*((volatile uint8_t *)(SEG_LCD1_SD)) |= (1 << SEG_LCD1_SD_PIN);

	/* SCL 输出低 */
	*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);
	*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);

	/* CS 输出低 */
	*((volatile uint8_t *)(SEG_LCD0_CS)) &= ~(1 << SEG_LCD0_CS_PIN);
	*((volatile uint8_t *)(SEG_LCD1_CS)) &= ~(1 << SEG_LCD1_CS_PIN);

	__NOP();

	/* SCL 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);
	*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);

	for (i = 0; i < 8; i++)
	{
		/* SCL 输出低 */
		*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);
		*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);

		if (Dat0 & 0x80)
			*((volatile uint8_t *)(SEG_LCD0_SD)) |= (1 << SEG_LCD0_SD_PIN);
		else
			*((volatile uint8_t *)(SEG_LCD0_SD)) &= ~(1 << SEG_LCD0_SD_PIN);

		if (Dat1 & 0x80)
			*((volatile uint8_t *)(SEG_LCD0_SD)) |= (1 << SEG_LCD0_SD_PIN);
		else
			*((volatile uint8_t *)(SEG_LCD1_SD)) &= ~(1 << SEG_LCD1_SD_PIN);

		__NOP();

		*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);
		*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);

		Dat0 <<= 1;
		Dat1 <<= 1;
	}

	/* CS 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_CS)) |= (1 << SEG_LCD0_CS_PIN);
	*((volatile uint8_t *)(SEG_LCD1_CS)) |= (1 << SEG_LCD1_CS_PIN);
}
#endif

#if BU98R10_WRITE_AT_SAME_TIME
static void BU98R10_All_ReadRam(uint8_t addr, uint8_t *data0, uint8_t *data1)
{
	uint8_t i;
	uint8_t Cmd = 0x09;
	uint8_t wdata0 = 0;
	uint8_t wdata1 = 0;

	BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
	BU98R10_All_Data_Write(addr, addr);

	Cmd = 0x09;
	// D/C = 0,表示发送命令
	*((volatile uint8_t *)(SEG_LCD0_SD)) &= ~(1 << SEG_LCD0_SD_PIN);
	*((volatile uint8_t *)(SEG_LCD1_SD)) &= ~(1 << SEG_LCD1_SD_PIN);

	*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);
	*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);

	*((volatile uint8_t *)(SEG_LCD0_CS)) &= ~(1 << SEG_LCD0_CS_PIN);
	*((volatile uint8_t *)(SEG_LCD1_CS)) &= ~(1 << SEG_LCD1_CS_PIN);

	__NOP();
	__NOP();
	__NOP();

	/* SCL 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);
	*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);

	for (i = 0; i < 8; i++)
	{
		/* SCL 输出低 */
		*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);
		*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);

		if (Cmd & 0x80)
		{
			/* SD 输出高 */
			*((volatile uint8_t *)(SEG_LCD0_SD)) |= (1 << SEG_LCD0_SD_PIN);
			*((volatile uint8_t *)(SEG_LCD1_SD)) |= (1 << SEG_LCD1_SD_PIN);
		}
		else
		{
			/*  SD 输出低 */
			*((volatile uint8_t *)(SEG_LCD0_SD)) &= ~(1 << SEG_LCD0_SD_PIN);
			*((volatile uint8_t *)(SEG_LCD1_SD)) &= ~(1 << SEG_LCD1_SD_PIN);
		}

		__NOP();
		__NOP();
		__NOP();

		/* SCL 输出高 */
		*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);
		*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);

		Cmd <<= 1;
	}

	// PORT_Init(SEG_LCD_SD1, INPUT);	// ？？？
	// PORT_Init(SEG_LCD_SD1, INPUT);	// ？？？

	/* SCL 输出低 */
	*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);
	*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);
	__NOP();
	__NOP();
	__NOP();

	/* SCL 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);
	*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);
	__NOP();
	__NOP();
	__NOP();

	for (i = 0; i < 8; i++)
	{
		/* SCL 输出低 */
		*((volatile uint8_t *)(SEG_LCD0_SCL)) &= ~(1 << SEG_LCD0_SCL_PIN);
		*((volatile uint8_t *)(SEG_LCD1_SCL)) &= ~(1 << SEG_LCD1_SCL_PIN);
		wdata0 <<= 1;
		wdata1 <<= 1;
		/* SCL 输出高 */
		*((volatile uint8_t *)(SEG_LCD0_SCL)) |= (1 << SEG_LCD0_SCL_PIN);
		*((volatile uint8_t *)(SEG_LCD1_SCL)) |= (1 << SEG_LCD1_SCL_PIN);

		if (*((volatile uint8_t *)(SEG_LCD0_SD)) & SEG_LCD0_SD_PIN)
		{
			wdata0 |= *((volatile uint8_t *)(SEG_LCD0_SD)) & SEG_LCD0_SD_PIN;
		}
		if (*((volatile uint8_t *)(SEG_LCD1_SD)) & SEG_LCD1_SD_PIN)
		{
			wdata0 |= *((volatile uint8_t *)(SEG_LCD1_SD)) & SEG_LCD1_SD_PIN;
		}
	}

	*data0 = wdata0;
	*data1 = wdata1;

	/* SD 方向设置成输出 */
	// PORT_Init(SEG_LCD_SD1, OUTPUT);	//？？？
	// PORT_Init(SEG_LCD_SD1, OUTPUT);	//？？？

	/* CS 输出高 */
	*((volatile uint8_t *)(SEG_LCD0_CS)) |= (1 << SEG_LCD0_CS_PIN);
	*((volatile uint8_t *)(SEG_LCD1_CS)) |= (1 << SEG_LCD1_CS_PIN);
}

#endif
/*
uint8_t checkData[2];
void checkSegTftState(void)
{

if (g_curkeyinput == KeyON)
{
   if ((u8BU98R10CheckCount >= 20) && (BU98R10Update.En == 0))
   {
	   u8BU98R10CheckCount = 0;
	   checkData[0] = 0;
	   checkData[1] = 0;

	   BU98R10_All_ReadRam(48, &checkData[0], &checkData[1]);

	   if ((checkData[0] & 0xf0) != 0x70)
	   {
		   BU98R10_Init();
	   }
   }
}
else
{
   u8BU98R10CheckCount = 0;
}
}
*/
