/*
 * includes.h
 *
 *  Created on: 2014-7-31
 *      Author: qitiancun
 */

#ifndef _U2_UDS_INCLUDES_H_
#define _U2_UDS_INCLUDES_H_
#include "common.h"
/*
#define uint8_t unsigned char
#define uint16_t unsigned short
#define uint32_t unsigned int
*/
#define U2_MaxBuff 266
typedef enum
{
    u2_STATE0 = 1,
    u2_N_OK,
    u2_CTS,
    u2_WAIT,
    u2_OVFLW,
    u2_N_TIMEOUT_Bs,
    u2_N_ERROR,
    u2_N_INVALID_FS,
    u2_N_WRONG_SN
} U2_Enum_Result;

typedef enum
{
    u2_empoty,
    u2_full
} U2_TransSt;
typedef struct
{
    uint16_t Identifier; //Fun--PGN--
    uint8_t DLC;
    uint8_t Data[8];
    U2_TransSt TransferStatus;
} _U2_LinkData;

typedef struct
{
    struct
    {
        uint16_t pos;
        uint16_t Length;
        uint16_t N_FC_Num;
        uint16_t N_RecSN_L;
        uint8_t N_SendSN;
        uint8_t N_BS_CNT;
        uint8_t N_BS;
        uint8_t N_SA;
        uint8_t N_TA;
        uint8_t N_PCI;
        uint8_t N_SID;
    } ind;
} _U2_N_US_Data_FF;

typedef struct
{
    struct
    {
        uint16_t N_TAtype;
        uint16_t Length;
        uint8_t N_SA;
        uint8_t N_TA;
        uint8_t N_AE;
        uint8_t N_PCI;
        uint8_t MsgData[8];
        U2_Enum_Result N_Result;
    } ind;
} _U2_N_USSFData;


typedef struct
{
    struct
    {
        uint16_t N_TAtype; //PGN  55808--0xDA00
        uint16_t Length;  
        uint8_t N_SA;
        uint8_t N_TA;
        uint8_t N_AE;
        uint8_t N_PCI;
        uint8_t MsgData[U2_MaxBuff];
        U2_Enum_Result N_Result;
    } ind;
} _U2_N_USData;

typedef struct
{
    struct
    {
        uint8_t len;
        uint8_t MsgData[8];
        uint8_t N_Result;
    } ind;
} _U2_N_RSPData;


typedef union
{
    struct
    {
        uint8_t SubFunBit0_6 : 7; 
        uint8_t SubFunBit7_7 : 1;
    } SubBits;
    uint8_t SubData;
} _U2_SubFun;


typedef struct
{
    uint8_t SessionType; 
    uint8_t AccessLock; 
    uint8_t AccessCount;
    uint8_t key[4]; 
    uint8_t SubFunction;
    uint8_t w27_Sequence;
    uint8_t A5_Sequence;
    uint8_t DTCSettingType;
    uint8_t tDiagStart;
    uint8_t tDiagKL30ONStart;
    uint8_t N_STmin;
    uint8_t N_REV_MAX_BS;
    uint8_t CommType;
    uint8_t CommCtl;
    uint8_t DTCByStatusMask;
} _U2_DiagnoCtl;

typedef struct
{
    uint16_t N_TAtype; //PGN--55808--DA00
    uint8_t FrameErr;  
    uint8_t RespSerId;
} _U2_ErrorFrame;

typedef struct
{
    uint32_t OverBsTime;
    uint32_t BsTime;

    uint32_t OverSTminTime;
    uint32_t STminTime;

    uint32_t OverCrTime;
    uint32_t CrTime;

    uint32_t OverSessionTime;
    uint32_t SessionTime;

    uint32_t OverSequenceTime;
    uint32_t SequenceTime;

    uint32_t OverUnlockTime;
    uint32_t UnlockTime;

    uint32_t OverDtcMsgTime;
    uint32_t DtcMsgTime;
    
    uint8_t TT_BsEnable;

    uint8_t TT_STminEnable;

    uint8_t TT_CrEnable;

    uint8_t TT_SessionEnable;

    uint8_t TT_SequenceEnable;

    uint8_t TT_UnlockEnable;

    uint8_t TT_DtcMsgEnable;

    uint8_t E2_WriteTime;

} _U2_DiagClock;
typedef union
{
    struct
    {
        uint32_t StructDTC[25]; 
    } SubDTC;
    uint8_t UnionDTC[100];
} _U2_DiagReciveDTC;
typedef struct
{
    uint8_t CoolantTemp[20];
    uint8_t MilLamp;
    uint8_t Gear_Reverse;
    uint8_t VSpeed;

} _U2_DiagReciveGaugePara;


#include "UDS_Def.h"
#include "U2_UDS_CFG.h"
#include "U2_TP_Layer.h"
#include "U2_Link_Layer.h"
#include "U2_app_ServiceProc.h"
#include "U2_app_Service.h"
extern _U2_DiagReciveDTC  U2_DiagReciveDTC   ;
extern _U2_DiagReciveGaugePara U2_DiagReciveGaugePara;
#endif /* _UDS_INCLUDES_H_ */
