

#include "PowerManagement.h"
#include "gpio.h"

st_PowerGroup pFuncPower;

static Power_Status_em g_Power_St; /*当前实际电源状态*/

void PowerMemInit(const st_PowerGroup *PowerGroup)
{
    pFuncPower.Pwr_IG_OFF_Init    = PowerGroup->Pwr_IG_OFF_Init;
    pFuncPower.Pwr_IG_ON_Init     = PowerGroup->Pwr_IG_ON_Init;
    pFuncPower.Pwr_Sleep_Init     = PowerGroup->Pwr_Sleep_Init;
    pFuncPower.Pwr_IG_OVP_Init    = PowerGroup->Pwr_IG_OVP_Init;
    pFuncPower.Pwr_IG_LVP_Init    = PowerGroup->Pwr_IG_LVP_Init;
    pFuncPower.Pwr_KL30_Init      = PowerGroup->Pwr_KL30_Init;
    pFuncPower.Pwr_Wakeup_Init    = PowerGroup->Pwr_Wakeup_Init;
    pFuncPower.Pwr_Stay_OFF     = PowerGroup->Pwr_Stay_OFF;
    pFuncPower.Pwr_Stay_ON      = PowerGroup->Pwr_Stay_ON;
    pFuncPower.Pwr_Stay_Sleep   = PowerGroup->Pwr_Stay_Sleep;
    pFuncPower.Pwr_Stay_Protect = PowerGroup->Pwr_Stay_Protect;
    g_Power_St                    = EM_IGN_OFF_Init;
}

void Power_Management_Init(PwrLib_uint8_t u8InitFlag)
{
    if ( u8InitFlag == 0x55u )
    {
        pFuncPower.Pwr_Wakeup_Init( );
    }
    else
    {
        pFuncPower.Pwr_KL30_Init( );
    }
    g_Power_St = EM_IGN_OFF_Init;
}

void Power_Management_Service(void)
{
    switch ( g_Power_St )
    {
        case EM_IGN_OFF_Init:
            if ( pFuncPower.Pwr_IG_OFF_Init != (( void * )0) )
            {
                pFuncPower.Pwr_IG_OFF_Init( );
            }
						//PORT_ClrBit(COM_OUT);//档位传感器供电_5V_MCU_OUT
            g_Power_St = EM_IGN_OFF;
        case EM_IGN_OFF:
            if ( pFuncPower.Pwr_Stay_OFF != (( void * )0) )
            {
                g_Power_St = pFuncPower.Pwr_Stay_OFF( );
            }
            break;
        case EM_IGN_Sleep_Init:
            if ( pFuncPower.Pwr_Sleep_Init != (( void * )0) )
            {
                pFuncPower.Pwr_Sleep_Init( );
            }
            g_Power_St = EM_IGN_Sleep;
        case EM_IGN_Sleep:
            if ( pFuncPower.Pwr_Stay_Sleep != (( void * )0) )
            {
                g_Power_St = pFuncPower.Pwr_Stay_Sleep( );
            }
            /*break;  LQY 2021.12.13*/
        case EM_IGN_Wakeup:
            if ( pFuncPower.Pwr_Wakeup_Init != (( void * )0) )
            {
                pFuncPower.Pwr_Wakeup_Init( );
            }
            g_Power_St = EM_IGN_OFF_Init;
            break;
        case EM_IGN_ON_Init:
            if ( pFuncPower.Pwr_IG_ON_Init != (( void * )0) )
            {
                pFuncPower.Pwr_IG_ON_Init( );
            }
            g_Power_St = EM_IGN_ON;
        case EM_IGN_ON:
            if ( pFuncPower.Pwr_Stay_ON != (( void * )0) )
            {
                g_Power_St = pFuncPower.Pwr_Stay_ON( );
            }
						//PORT_SetBit(COM_OUT);//档位传感器供电_5V_MCU_OUT
            break;
        case EM_IGN_LVP_Init:
        case EM_IGN_OVP_Init:
            if ( g_Power_St == EM_IGN_LVP_Init )
            {
                if ( pFuncPower.Pwr_IG_LVP_Init != (( void * )0) )
                {
                    pFuncPower.Pwr_IG_LVP_Init( );
                }
                g_Power_St = EM_IGN_LIMIT;
            }
            else if ( g_Power_St == EM_IGN_OVP_Init )
            {
                if ( pFuncPower.Pwr_IG_OVP_Init != (( void * )0) )
                {
                    pFuncPower.Pwr_IG_OVP_Init( );
                }
                g_Power_St = EM_IGN_LIMIT;
            }
            else
            {
                g_Power_St = EM_IGN_OFF_Init;
            }
        case EM_IGN_LIMIT:
            if ( g_Power_St != EM_IGN_OFF_Init )
            {
                if ( pFuncPower.Pwr_Stay_Protect != (( void * )0) )
                {
                    g_Power_St = pFuncPower.Pwr_Stay_Protect( );
                }
            }
            break;
        default:
            g_Power_St = EM_IGN_OFF_Init;
            break;
    }
    
}

PwrLib_uint16_t Get_PwrLibVersion(void)
{
    return 0x0001u;
}

