#include "PowerManagement.h"
#include "PowerManagement_user.h"
#include "System_Monitor.h"

#include "gpio.h"
#include "Common_Interface.h"
#include "clk.h"
#include "Sys_Tick.h"
#include "Analog_Signals.h"
#include "sci.h"
#include "Telltales_Lib.h"
#include "Telltales_user.h"

#include "tim4.h"

#include "Fuel.h"

#include "Services_Mileage_User.h"
#include "eeManager_Interface.h"

#include "timerA_B_C.h"


#include "uds_includes.h"
#include "U2_uds_includes.h"
#include "CAN_User.h"
#include "BU98R10.h"

#include "can.h"
#include "RTE_ADC.h"


#include "Services_Mileage.h"

uint16_t g_sleepDelay = 0;

void Power_KL30_Init ( void )
{
    Sys_KL30_Init();
    Telltales_Init();
    Fuel_KL30_Init();
    BU98R10_Init();
    Data_User_Mileage_KL30Init();
    BU2703_Senser_Init();
    GUI_Light_Init();
}


void Power_Sleep_Init(void)
{
    CAN_Initflag = 0;
    Sys_Tick_Timer_Stop();
  //  UART2_Stop();
    Capture_Stop(39);
    Capture_Stop(40);
    Analog_Signal_Conv_Stop();


    BU98R10_Shutdown();

	GPIO_Init(GPIO_SLEEP_MODE );
    INTC_DisableIRQ(LVI_IRQn      );
    INTC_DisableIRQ(INTP0_IRQn    );
    INTC_DisableIRQ(INTP1_IRQn    );
    INTC_DisableIRQ(INTP2_IRQn    );
    INTC_DisableIRQ(INTP4_IRQn    );
    INTC_DisableIRQ(INTP3_IRQn    );
    INTC_DisableIRQ(INTP5_IRQn    );
    INTC_DisableIRQ(ST2_IRQn      );
    INTC_DisableIRQ(SPI20_IRQn    );
    INTC_DisableIRQ(IIC20_IRQn    );
    INTC_DisableIRQ(SR2_IRQn      );
    INTC_DisableIRQ(SPI21_IRQn    );
    INTC_DisableIRQ(IIC21_IRQn    );
    INTC_DisableIRQ(SRE2_IRQn     );
    INTC_DisableIRQ(ST0_IRQn      );
    INTC_DisableIRQ(SPI00_IRQn    );
    INTC_DisableIRQ(IIC00_IRQn    );
    INTC_DisableIRQ(SR0_IRQn      );
    INTC_DisableIRQ(SPI01_IRQn    );
    INTC_DisableIRQ(IIC01_IRQn    );
    INTC_DisableIRQ(SRE0_IRQn     );
    INTC_DisableIRQ(ST1_IRQn      );
    INTC_DisableIRQ(SPI10_IRQn    );
    INTC_DisableIRQ(IIC10_IRQn    );
    INTC_DisableIRQ(SR1_IRQn      );
    INTC_DisableIRQ(SPI11_IRQn    );
    INTC_DisableIRQ(IIC11_IRQn    );
    INTC_DisableIRQ(SRE1_IRQn     );
    INTC_DisableIRQ(IICA0_IRQn    );
    INTC_DisableIRQ(TM00_IRQn     );
    INTC_DisableIRQ(TM01_IRQn     );
    INTC_DisableIRQ(TM02_IRQn     );
    INTC_DisableIRQ(TM03_IRQn     );
    INTC_DisableIRQ(ADC_IRQn      );
    INTC_DisableIRQ(RTC_IRQn      );
    INTC_DisableIRQ(KEY_IRQn      );
    INTC_DisableIRQ(CMP0_IRQn     );
    INTC_DisableIRQ(CMP1_IRQn     );
    INTC_DisableIRQ(TMA_IRQn      );
    INTC_DisableIRQ(TMM0_IRQn     );
    INTC_DisableIRQ(TMM1_IRQn     );
    INTC_DisableIRQ(TMB_IRQn      );
    INTC_DisableIRQ(TMC_IRQn      );
    INTC_DisableIRQ(FMC_IRQn      );
    INTC_DisableIRQ(INTP6_IRQn    );
    INTC_DisableIRQ(INTP7_IRQn    );
    INTC_DisableIRQ(INTP8_IRQn    );
    INTC_DisableIRQ(INTP9_IRQn    );
    INTC_DisableIRQ(INTP10_IRQn   );
    INTC_DisableIRQ(INTP11_IRQn   );
    INTC_DisableIRQ(CAN0ERR_IRQn  );
    INTC_DisableIRQ(DIV_IRQn      );
    INTC_DisableIRQ(IT_IRQn       );
    INTC_DisableIRQ(CAN0REC_IRQn  );
    INTC_DisableIRQ(CAN0WUP_IRQn  );
    INTC_DisableIRQ(CAN0TRX_IRQn  );



    INTC_ClearPendingIRQ(LVI_IRQn      );
    INTC_ClearPendingIRQ(INTP0_IRQn    );
    INTC_ClearPendingIRQ(INTP1_IRQn    );
    INTC_ClearPendingIRQ(INTP2_IRQn    );
    INTC_ClearPendingIRQ(INTP4_IRQn    );
    INTC_ClearPendingIRQ(INTP3_IRQn    );
    INTC_ClearPendingIRQ(INTP5_IRQn    );
    INTC_ClearPendingIRQ(ST2_IRQn      );
    INTC_ClearPendingIRQ(SPI20_IRQn    );
    INTC_ClearPendingIRQ(IIC20_IRQn    );
    INTC_ClearPendingIRQ(SR2_IRQn      );
    INTC_ClearPendingIRQ(SPI21_IRQn    );
    INTC_ClearPendingIRQ(IIC21_IRQn    );
    INTC_ClearPendingIRQ(SRE2_IRQn     );
    INTC_ClearPendingIRQ(ST0_IRQn      );
    INTC_ClearPendingIRQ(SPI00_IRQn    );
    INTC_ClearPendingIRQ(IIC00_IRQn    );
    INTC_ClearPendingIRQ(SR0_IRQn      );
    INTC_ClearPendingIRQ(SPI01_IRQn    );
    INTC_ClearPendingIRQ(IIC01_IRQn    );
    INTC_ClearPendingIRQ(SRE0_IRQn     );
    INTC_ClearPendingIRQ(ST1_IRQn      );
    INTC_ClearPendingIRQ(SPI10_IRQn    );
    INTC_ClearPendingIRQ(IIC10_IRQn    );
    INTC_ClearPendingIRQ(SR1_IRQn      );
    INTC_ClearPendingIRQ(SPI11_IRQn    );
    INTC_ClearPendingIRQ(IIC11_IRQn    );
    INTC_ClearPendingIRQ(SRE1_IRQn     );
    INTC_ClearPendingIRQ(IICA0_IRQn    );
    INTC_ClearPendingIRQ(TM00_IRQn     );
    INTC_ClearPendingIRQ(TM01_IRQn     );
    INTC_ClearPendingIRQ(TM02_IRQn     );
    INTC_ClearPendingIRQ(TM03_IRQn     );
    INTC_ClearPendingIRQ(ADC_IRQn      );
    INTC_ClearPendingIRQ(RTC_IRQn      );
    INTC_ClearPendingIRQ(KEY_IRQn      );
    INTC_ClearPendingIRQ(CMP0_IRQn     );
    INTC_ClearPendingIRQ(CMP1_IRQn     );
    INTC_ClearPendingIRQ(TMA_IRQn      );
    INTC_ClearPendingIRQ(TMM0_IRQn     );
    INTC_ClearPendingIRQ(TMM1_IRQn     );
    INTC_ClearPendingIRQ(TMB_IRQn      );
    INTC_ClearPendingIRQ(TMC_IRQn      );
    INTC_ClearPendingIRQ(FMC_IRQn      );
    INTC_ClearPendingIRQ(INTP6_IRQn    );
    INTC_ClearPendingIRQ(INTP7_IRQn    );
    INTC_ClearPendingIRQ(INTP8_IRQn    );
    INTC_ClearPendingIRQ(INTP9_IRQn    );
    INTC_ClearPendingIRQ(INTP10_IRQn   );
    INTC_ClearPendingIRQ(INTP11_IRQn   );
    INTC_ClearPendingIRQ(CAN0ERR_IRQn  );
    INTC_ClearPendingIRQ(DIV_IRQn      );
    INTC_ClearPendingIRQ(IT_IRQn       );
    INTC_ClearPendingIRQ(CAN0REC_IRQn  );
    INTC_ClearPendingIRQ(CAN0WUP_IRQn  );
    INTC_ClearPendingIRQ(CAN0TRX_IRQn  );
}


void Power_Wakeup_Init ( void )
{
    GPIO_Init(GPIO_WAKEUP_MODE);
    Sys_Tick_Timer_Start();
    Analog_Signal_Conv_Init();
    Sys_WakeUp_Init();
    Telltales_Init();
    Common_DataInit();
    BU98R10_Init();
	APP_CAN_Init();
    Data_User_Mileage_WakeupInit();
    BU2703_Senser_Init();
    GUI_Light_Init();
}




void Power_IG_OFF_Init(void)
{
	

    Common_Set_IG_Sts(COMMON_POWER_OFF);
    Set_CanSleepDelayTime(8000);
    g_sleepDelay = 300;//延时30s休眠

}
void Power_IG_ON_Init(void)
{

    Telltales_KL15_Init();
    bsp_CAN_SleepRelease();
    bsp_CAN_Init();

    Common_DataInit();
    Fuel_KL15_Init();

    TMB0_PWM_Pin33_Init();
    DiagnosisInit_main();
    U2_DiagnosisInit_main();

    APP_CAN_Init();

    Common_Set_IG_Sts(COMMON_POWER_ON);
    BU2703_Senser_Init();
    GUI_Light_Init();



}
void Power_IG_OVP_Init(void)
{

}
void Power_IG_LVP_Init(void)
{

}
Power_Status_em Power_Stay_ON(void)
{
    Power_Status_em u8PowerSts;
    uint8_t u8Condition3;
    u8Condition3 = System_FUN_KL30_Status_Get();
    if (SYS_OPR_STAT_IGN_ON )
    {
        u8PowerSts = EM_IGN_ON;
    }
    else
    {
        if (SYS_OPR_STAT_IGN_OFF )
        {
            u8PowerSts = EM_IGN_OFF_Init;
        }
        else
        {
            u8PowerSts = EM_IGN_ON;
        }
    }
    if (((u8Condition3 == 1u) || (u8Condition3 >= 7u)))
    {
        u8PowerSts = EM_IGN_LIMIT;
    }
    return  u8PowerSts;
}

//put in 100ms task
void Power_Management_Service_user(void)
{
    if(g_sleepDelay){
        g_sleepDelay--;
    }
}

Power_Status_em Power_Stay_OFF(void)
{
    Power_Status_em u8PowerSts;
    uint8_t u8Condition3;
    uint16_t u16Voltage;
    u8Condition3 = System_FUN_KL30_Status_Get();
    if ((SYS_OPR_STAT_IGN_ON ) && (u8Condition3 > 1u) && (u8Condition3 < 7u))
    {
        u8PowerSts = EM_IGN_ON_Init;
    }
    else
    {
        if ( SYS_OPR_STAT_IGN_OFF ) 
        {
            // if (PowerGetNMStatus() == POWER_NM_SLEEP)
            u16Voltage = (uint16_t)RTE_Read_KL15_Voltage();
            if(u16Voltage > 5000){
                g_sleepDelay = 100;
            }            
            if (bsp_Is_CAN_Sleep() && (g_sleepDelay == 0))//LQY 这里添加休眠条件
            {
                u8PowerSts = EM_IGN_Sleep_Init;
            }
            else
            {
                u8PowerSts = EM_IGN_OFF;
            }
        }
        else
        {
            u8PowerSts = EM_IGN_OFF;
        }
    }
    return  u8PowerSts;
}



Power_Status_em  Power_Stay_Protect(void)
{
    Power_Status_em u8PowerSts;
    u8PowerSts = EM_IGN_OFF_Init;
    return  u8PowerSts;
}



Power_Status_em Power_Stay_Sleep ( void )
{
    Power_Status_em u8PowerSts;

    Sys_Enter_Sleep_Mode();

     u8PowerSts = EM_IGN_Wakeup;
    return  u8PowerSts;
}

void Power_Management_Lib_Init(void)
{
    st_PowerGroup PowerGroup;
    PowerGroup.Pwr_IG_OFF_Init = Power_IG_OFF_Init;
    PowerGroup.Pwr_IG_ON_Init = Power_IG_ON_Init;
    PowerGroup.Pwr_Sleep_Init = Power_Sleep_Init;
    PowerGroup.Pwr_IG_OVP_Init = Power_IG_OVP_Init;
    PowerGroup.Pwr_IG_LVP_Init = Power_IG_LVP_Init;
    PowerGroup.Pwr_KL30_Init = Power_KL30_Init;
    PowerGroup.Pwr_Wakeup_Init = Power_Wakeup_Init;
    PowerGroup.Pwr_Stay_OFF = Power_Stay_OFF;
    PowerGroup.Pwr_Stay_ON = Power_Stay_ON;
    PowerGroup.Pwr_Stay_Sleep = Power_Stay_Sleep;
    PowerGroup.Pwr_Stay_Protect = Power_Stay_Protect;


    PowerMemInit(&PowerGroup);
}
