/***********************************************************************************************************************
* Copyright (C) All rights reserved.
***********************************************************************************************************************/

/***********************************************************************************************************************
* @file    gpio.h
* @brief   This file implements device driver for GPIO module.
* @version 1.0.0
* @date    2019/12/24
***********************************************************************************************************************/
#ifndef GPIO_H
#define GPIO_H
#ifndef __CORE_CM0PLUS_H_GENERIC
#include "common.h"
#endif

/***********************************************************************************************************************
Macro definitions (Register bit)
***********************************************************************************************************************/

/***********************************************************************************************************************
Macro definitions
***********************************************************************************************************************/
typedef enum
{
    GPIO_WAKEUP_MODE = 0U,
    GPIO_SLEEP_MODE,

} GPIO_Config_Mode_en_t;
    
/***********************************************************************************************************************
Typedef definitions
***********************************************************************************************************************/
typedef enum {
	PORT0 = 0,
	PORT1,
	PORT2,
	PORT3,
	PORT4,
	PORT5,
	PORT6,
	PORT7,
	PORT8,
	PORT9,
	PORT10,
	PORT11,
	PORT12,
	PORT13,
	PORT14,
	PORT15,
	
}PORT_TypeDef;

typedef enum {
	PIN0 = 0,
	PIN1,
	PIN2,
	PIN3,
	PIN4,
	PIN5,
	PIN6,
	PIN7,
	
}PIN_TypeDef;

typedef enum {
	INPUT = 0,
	PULLUP_INPUT,
	TTL_INPUT,
	ANALOG_INPUT,
	OUTPUT,
	OPENDRAIN_OUTPUT,
	
}PIN_ModeDef;

#define PIN_MASK_0                 ((uint8_t)(0x01))  /*!< Pin 0 selected    */
#define PIN_MASK_1                 ((uint8_t)(0x02))  /*!< Pin 1 selected    */
#define PIN_MASK_2                 ((uint8_t)(0x04))  /*!< Pin 2 selected    */
#define PIN_MASK_3                 ((uint8_t)(0x08))  /*!< Pin 3 selected    */
#define PIN_MASK_4                 ((uint8_t)(0x10))  /*!< Pin 4 selected    */
#define PIN_MASK_5                 ((uint8_t)(0x20))  /*!< Pin 5 selected    */
#define PIN_MASK_6                 ((uint8_t)(0x40))  /*!< Pin 6 selected    */
#define PIN_MASK_7                 ((uint8_t)(0x80))  /*!< Pin 7 selected    */


/****************************************************************************************************************************************************
GPIO重映射
****************************************************************************************************************************************************/

/*===================================================================================================================================================
PORT0 端口配置
-----------------------------------------------------------------------------------------------------------------------------------------------------
          | 名称                     |      端口                |  引脚  |  方向  |  初值    |  说明
===================================================================================================================================================*/
#define   VSPEED_PWM_IN                 PORT0,    PIN0        /* 62       IN      0       ABS输入*/
#define   WAKEUP_KL15_In                PORT0,    PIN1        /* 61       IN      0       KL15电源检测    */
#define   SEG1_SD                       PORT0,    PIN2        /* 60       OUT     1       */
#define   SEG1_CSB                      PORT0,    PIN3        /* 59       IN      0       */
#define   SEG1_SCL                      PORT0,    PIN4        /* 58       OUT     0       档位背光控制*/
#define   HighBeam_P_In                 PORT0,    PIN5        /* 31       IN      0       左转向*/
#define   VSPEED_TEN_OUT                PORT0,    PIN6        /* 30       IN      0       远光输入*/

/*===================================================================================================================================================
PORT1 端口配置
-----------------------------------------------------------------------------------------------------------------------------------------------------
          | 名称                     |      端口                |  引脚  |  方向  |  初值    |  说明
===================================================================================================================================================*/
#define   BACKLIGHT_PWM               PORT1,    PIN0        /* 46       OUT     0       LCD_CSB*/
#define   LIN_RXD_ESP                 PORT1,    PIN1        /* 45       OUT     0       LCD_SCL*/
#define   LIN_TXD_ESP                 PORT1,    PIN2        /* 44       OUT     0       LCD_SD*/
#define   EFI_FAULT_OUT               PORT1,    PIN3        /* 43       OUT     0       LCD_CSB1*/
#define   AMBIENT_LIGHT_R             PORT1,    PIN4        /* 42       OUT     0       光敏SDA */
#define   RESEVER1_OUT_LOW            PORT1,    PIN5        /* 41       OUT     0       光敏SCL*/
#define   AMBIENT_LIGHT_B             PORT1,    PIN6        /* 40       IN      0       转速传感器信号输入*/
#define   AMBIENT_LIGHT_G             PORT1,    PIN7        /* 39       IN      0       LCD_SCL1*/ 

/*===================================================================================================================================================
PORT2 端口配置
-----------------------------------------------------------------------------------------------------------------------------------------------------
          | 名称                     |      端口                |  引脚  |  方向  |  初值    |  说明
===================================================================================================================================================*/
#define   AVDD_OUT_LOW                PORT2,    PIN0        /* 56       IN      0       参考电压正（模拟输入）*/
#define   GND_OUT_LOW                 PORT2,    PIN1        /* 55       IN      0       参考电压地（模拟输入）*/
#define   POWER_KL30_In               PORT2,    PIN2        /* 54       IN      0       KL30电压输入（模拟输入）*/
#define   POWER_KL15_In               PORT2,    PIN3        /* 53       IN      0       */
#define   RESEVER2_OUT_LOW            PORT2,    PIN4        /* 52       IN      0       燃油电阻参考电压输入（模拟输入）*/
#define   FUEL_MCU_IN                 PORT2,    PIN5        /* 51       IN      0       燃油电阻1输入（模拟输入）*/
#define   VERSION_T_OUT_LOW           PORT2,    PIN6        /* 50       IN     0       */ 
#define   FUEL_POWER_IN               PORT2,    PIN7        /* 49       OUT     0       燃油电源控制*/

/*===================================================================================================================================================
PORT3 端口配置
-----------------------------------------------------------------------------------------------------------------------------------------------------
          | 名称                     |      端口                |  引脚  |  方向  |  初值    |  说明
===================================================================================================================================================*/
#define   MAINTENANCE_LAMP_OUT        PORT3,    PIN0        /* 32       IN      0       胎压*/
#define   RESEVER3_OUT_LOW            PORT3,    PIN1        /* 21       IN      0       背光输入*/

/*===================================================================================================================================================
PORT4 端口配置
-----------------------------------------------------------------------------------------------------------------------------------------------------
          | 名称                     |      端口                |  引脚  |  方向  |  初值    |  说明
===================================================================================================================================================*/
#define   SWDIO                       PORT4,    PIN0        /* 05       IN      0       */
#define   RESEVER4_OUT_LOW            PORT4,    PIN1        /* 04       OUT     1       L_BD433CTRL_OUT*/
#define   LeftTurn_P_In               PORT4,    PIN2        /* 03       IN      0       自动启停*/
#define   RightTurn_P_In              PORT4,    PIN3        /* 02       IN      0       OBD*/

/*===================================================================================================================================================
PORT5 端口配置
-----------------------------------------------------------------------------------------------------------------------------------------------------
          | 名称                     |      端口                |  引脚  |  方向  |  初值    |  说明
===================================================================================================================================================*/
#define   CAN_MCU_RXD                   PORT5,    PIN0        /* 33       OUT     0       背光PWM*/
#define   CAN_MCU_TXD                   PORT5 ,   PIN1        /* 34       IN      0       机油压力*/
#define   CAN_STB_MCU                   PORT5,    PIN2        /* 35       IN      0       右转输入*/
#define   MODE_P_IN                     PORT5,    PIN3        /* 36       OUT     1       VCC5V LED AW21036供电*/
#define   SET_P_IN                      PORT5,    PIN4        /* 37       OUT     1       VCC5V_光敏使能*/
#define   START_STOP_P_IN               PORT5,    PIN5        /* 38       OUT     0       LCD_SD1*/


/*===================================================================================================================================================
PORT6 端口配置
-----------------------------------------------------------------------------------------------------------------------------------------------------
          | 名称                     |      端口                |  引脚  |  方向  |  初值    |  说明
===================================================================================================================================================*/
#define   IIC_SCL_24G16                 PORT6,    PIN0        /* 17       OUT     1       触摸SCL*/
#define   IIC_SDA_24G16                 PORT6,    PIN1        /* 18       OUT     1       触摸SDA*/
#define   IIC_SCL_27030                 PORT6,    PIN2        /* 19       IN      0       */
#define   IIC_SDA_27030                 PORT6,    PIN3        /* 20       IN      0       */

/*===================================================================================================================================================
PORT7 端口配置
-----------------------------------------------------------------------------------------------------------------------------------------------------
          | 名称                     |      端口                |  引脚  |  方向  |  初值    |  说明
===================================================================================================================================================*/
#define   SEG2_SCL                      PORT7,    PIN0        /* 29       OUT      1       EErom_SCL*/
#define   SEG2_CSB                      PORT7,    PIN1        /* 28       OUT      1       EErom_SDA*/
#define   SEG2_SD                       PORT7,    PIN2		  /* 27       OUT      0       车速十位*/
#define   SDB_LED_DRIVER                PORT7,    PIN3        /* 26       OUT      0       SDB*/
#define   HighBeam_MUC_OUT              PORT7,    PIN4        /* 25       OUT      0       SDA*/
#define   TPMS_MUC_OUT                  PORT7,    PIN5        /* 24       OUT      0       SCL*/
#define   RightTurn_MUC_OUT             PORT7,    PIN6        /* 23       OUT      0       车速百位*/
#define   LeftTurn_MUC_OUT              PORT7,    PIN7        /* 22       OUT      1       3V3触摸使能*/

/*===================================================================================================================================================
PORT12 端口配置
-----------------------------------------------------------------------------------------------------------------------------------------------------
          | 名称                     |      端口                |  引脚  |  方向  |  初值    |  说明
===================================================================================================================================================*/
#define   POWER_5V_MCU                  PORT12,   PIN0        /* 01       OUT     1       */
#define   MCU_XI                        PORT12,   PIN1        /* 11       IN      0       */
#define   MCU_XO                        PORT12,   PIN2        /* 10       OUT     1       */
#define   X32768_IN                     PORT12,   PIN3        /* 08       IN      0       */
#define   X32768_OUT                    PORT12,   PIN4        /* 07       OUT     1       */

/*===================================================================================================================================================
PORT13 端口配置
-----------------------------------------------------------------------------------------------------------------------------------------------------
          | 名称                     |      端口                |  引脚  |  方向  |  初值    |  说明
===================================================================================================================================================*/
#define   VSPEED_HUNDREDS_OUT           PORT13,   PIN0        /* 57       IN      0       */
#define   RESEVER5_OUT_LOW              PORT13,   PIN6        /* 16       OUT     1      触摸_INT*/
#define   SWCLK                         PORT13,   PIN7        /* 09       IN      0       */

/*===================================================================================================================================================
PORT14 端口配置
-----------------------------------------------------------------------------------------------------------------------------------------------------
          | 名称                     |      端口                |  引脚  |  方向  |  初值    |  说明
===================================================================================================================================================*/
#define   L_BD433Ctrl_OUT               PORT14,   PIN0        /* 64       OUT     0       T指示灯(W)_OUT*/
#define   FUEL_POWER_MCU_OUT            PORT14,   PIN1        /* 63       OUT     0       电压背光控制*/
#define   VERSION_F_OUT_LOW             PORT14,   PIN6        /* 47       IN      0       */
#define   VERSION_S_OUT_LOW             PORT14,   PIN7        /* 48       IN      0       */

/***********************************************************************************************************************
Global functions
***********************************************************************************************************************/
void GPIO_Output_Enable(__IO uint8_t *port, uint8_t pinMsk);
void GPIO_Input_Enable(__IO uint8_t *port, uint8_t pinMsk);
void GPIO_PullUp_Enable(__IO uint8_t *port, uint8_t pinMsk);
void GPIO_PullUp_Disable(__IO uint8_t *port, uint8_t pinMsk);
void GPIO_Nch_OpenDrain(__IO uint8_t *port, uint8_t pinMsk);
void GPIO_Ttl_Input(__IO uint8_t *port, uint8_t pinMsk);
void GPIO_Set_Value(__IO uint8_t *port, uint8_t value);
uint8_t GPIO_Get_Value(__IO uint8_t *port);

void PORT_Init(PORT_TypeDef PORTx,PIN_TypeDef PINx,PIN_ModeDef MODEx);
void PORT_SetBit(PORT_TypeDef PORTx,PIN_TypeDef PINx);
void PORT_ClrBit(PORT_TypeDef PORTx,PIN_TypeDef PINx);
void PORT_ToggleBit(PORT_TypeDef PORTx,PIN_TypeDef PINx);
uint8_t PORT_GetBit(PORT_TypeDef PORTx,PIN_TypeDef PINx);

void GPIO_Init(GPIO_Config_Mode_en_t enGPIOConfigMode);
#endif
