#ifndef COMMON_H
#define COMMON_H
#include "BAT32A239.h"
/*

   ????(byte)      XHY    324     3360     rh850   SAMC21   BAT32
   unsigned int        2       4       4         4       4        4
   unsigned short      2       2       2         2       2        2
   unsigned char       1       1       1         1       1        1
   unsigned long       4       4       4         4       4        4
   unsigned long long  4       8       8         8       8        8
   float               4       4       4         4       4        4
   double              4       8       8         8       8        8
*/

#define Platform_BAT32
/*
#define Platform_XHY
#define Platform_S6J324
#define Platform_RH850
#define Platform_SAMC21
#define Platform_KEA64
#define Platform_S32K
#define Platform_BAT32
*/


#if (!defined(__cplusplus))

#ifndef false
#define false                       (0U)
#endif

#ifndef true
#define true                        (1U)
#endif


#ifndef TRUE
#define TRUE        (1U)
#endif

#ifndef FALSE
#define FALSE       (0U)
#endif

#endif




#if defined (Platform_XHY)

#ifndef uint8_t
typedef unsigned char       uint8_t;
typedef unsigned int        uint16_t;
/*typedef unsigned short      uint16_t;*/
typedef unsigned long       uint32_t;
/*typedef unsigned long long  uint32_t;*/

typedef char                int8_t;
typedef int                 int16_t;
/*typedef short               int16_t;*/
typedef long                int32_t;
/*typedef long long           int32_t;*/


typedef float               float32_T;
typedef double              double32_T;
typedef unsigned char       boolean_t;
#endif /* uint8_t */

#define MAX_int8_t                     ((int8_t)(127))
#define MIN_int8_t                     ((int8_t)(-128))
#define MAX_uint8_T                    ((uint8_t)(255U))

#define MAX_int16_t                    ((int16_t)(32767))
#define MIN_int16_t                    ((int16_t)(-32768))
#define MAX_uint16_t                   ((uint16_t)(65535U))

#define MAX_int32_t                    ((int32_t)(2147483647))
#define MIN_int32_t                    ((int32_t)(-2147483647-1))
#define MAX_uint32_t                   ((uint32_t)(0xFFFFFFFFU))

#define MAX_int64_t                    ((int64_t)(9223372036854775807LL))
#define MIN_int64_t                    ((int64_t)(-9223372036854775807LL-1LL))
#define MAX_uint64_t                   ((uint64_t)(0xFFFFFFFFFFFFFFFFULL))


#elif defined (Platform_S6J3360)



#define int8_t signed char
#define int16_t signed short
#define int32_t signed int
#define int64_t signed long long
#define uint8_t unsigned char
#define uint16_t unsigned short
#define uint32_t unsigned int
#define uint64_t unsigned long long


typedef float               float32_T;
typedef double              double64;
typedef unsigned char       boolean_t;

#define MAX_int8_t                     ((int8_t)(127))
#define MIN_int8_t                     ((int8_t)(-128))
#define MAX_uint8_T                    ((uint8_t)(255U))

#define MAX_int16_t                    ((int16_t)(32767))
#define MIN_int16_t                    ((int16_t)(-32768))
#define MAX_uint16_t                   ((uint16_t)(65535U))

#define MAX_int32_t                    ((int32_t)(2147483647))
#define MIN_int32_t                    ((int32_t)(-2147483647-1))
#define MAX_uint32_t                   ((uint32_t)(0xFFFFFFFFU))

#define MAX_int64_t                    ((int64_t)(9223372036854775807LL))
#define MIN_int64_t                    ((int64_t)(-9223372036854775807LL-1LL))
#define MAX_uint64_t                   ((uint64_t)(0xFFFFFFFFFFFFFFFFULL))

#elif defined (Platform_S6J324)


#define int8_t signed char
#define int16_t signed short
#define int32_t signed int
#define int64_t signed long long
#define uint8_t unsigned char
#define uint16_t unsigned short
#define uint32_t unsigned int
#define uint64_t unsigned long long


typedef float               float32_T;
typedef double              double64;
typedef unsigned char       boolean_t;


#define MAX_int8_t                     ((int8_t)(127))
#define MIN_int8_t                     ((int8_t)(-128))
#define MAX_uint8_T                    ((uint8_t)(255U))

#define MAX_int16_t                    ((int16_t)(32767))
#define MIN_int16_t                    ((int16_t)(-32768))
#define MAX_uint16_t                   ((uint16_t)(65535U))

#define MAX_int32_t                    ((int32_t)(2147483647))
#define MIN_int32_t                    ((int32_t)(-2147483647-1))
#define MAX_uint32_t                   ((uint32_t)(0xFFFFFFFFU))

#define MAX_int64_t                    ((int64_t)(9223372036854775807LL))
#define MIN_int64_t                    ((int64_t)(-9223372036854775807LL-1LL))
#define MAX_uint64_t                   ((uint64_t)(0xFFFFFFFFFFFFFFFFULL))

#elif defined (Platform_RH850)


#define int8_t signed char
#define int16_t signed short
#define int32_t signed int
#define int64_t signed long long
#define uint8_t unsigned char
#define uint16_t unsigned short
#define uint32_t unsigned int
#define uint64_t unsigned long long


typedef float               float32_T;
typedef double              double64;
typedef unsigned char       boolean_t;

#define MAX_int8_t                     ((int8_t)(127))
#define MIN_int8_t                     ((int8_t)(-128))
#define MAX_uint8_T                    ((uint8_t)(255U))

#define MAX_int16_t                    ((int16_t)(32767))
#define MIN_int16_t                    ((int16_t)(-32768))
#define MAX_uint16_t                   ((uint16_t)(65535U))

#define MAX_int32_t                    ((int32_t)(2147483647))
#define MIN_int32_t                    ((int32_t)(-2147483647-1))
#define MAX_uint32_t                   ((uint32_t)(0xFFFFFFFFU))

#define MAX_int64_t                    ((int64_t)(9223372036854775807LL))
#define MIN_int64_t                    ((int64_t)(-9223372036854775807LL-1LL))
#define MAX_uint64_t                   ((uint64_t)(0xFFFFFFFFFFFFFFFFULL))

#elif defined (Platform_SAMC21)

#define int8_t signed char
#define int16_t signed short
#define int32_t signed int
#define int64_t signed long long
#define uint8_t unsigned char
#define uint16_t unsigned short
#define uint32_t unsigned int
#define uint64_t unsigned long long


typedef float               float32_T;
typedef double              double64;
typedef unsigned char       boolean_t;

#define MAX_int8_t                     ((int8_t)(127))
#define MIN_int8_t                     ((int8_t)(-128))
#define MAX_uint8_T                    ((uint8_t)(255U))

#define MAX_int16_t                    ((int16_t)(32767))
#define MIN_int16_t                    ((int16_t)(-32768))
#define MAX_uint16_t                   ((uint16_t)(65535U))

#define MAX_int32_t                    ((int32_t)(2147483647))
#define MIN_int32_t                    ((int32_t)(-2147483647-1))
#define MAX_uint32_t                   ((uint32_t)(0xFFFFFFFFU))

#define MAX_int64_t                    ((int64_t)(9223372036854775807LL))
#define MIN_int64_t                    ((int64_t)(-9223372036854775807LL-1LL))
#define MAX_uint64_t                   ((uint64_t)(0xFFFFFFFFFFFFFFFFULL))


#elif defined (Platform_S32K)

#define int8_t signed char
#define int16_t signed short
#define int32_t signed int
#define int64_t signed long long
#define uint8_t unsigned char
#define uint16_t unsigned short
#define uint32_t unsigned int
#define uint64_t unsigned long long


typedef float               float32_T;
typedef double              double64;
typedef unsigned char       boolean_t;


#define MAX_int8_t                     ((int8_t)(127))
#define MIN_int8_t                     ((int8_t)(-128))
#define MAX_uint8_T                    ((uint8_t)(255U))

#define MAX_int16_t                    ((int16_t)(32767))
#define MIN_int16_t                    ((int16_t)(-32768))
#define MAX_uint16_t                   ((uint16_t)(65535U))

#define MAX_int32_t                    ((int32_t)(2147483647))
#define MIN_int32_t                    ((int32_t)(-2147483647-1))
#define MAX_uint32_t                   ((uint32_t)(0xFFFFFFFFU))

#define MAX_int64_t                    ((int64_t)(9223372036854775807LL))
#define MIN_int64_t                    ((int64_t)(-9223372036854775807LL-1LL))
#define MAX_uint64_t                   ((uint64_t)(0xFFFFFFFFFFFFFFFFULL))


#elif defined (Platform_KEA64)

#define int8_t signed char
#define int16_t signed short
#define int32_t signed int
#define int64_t signed long long
#define uint8_t unsigned char
#define uint16_t unsigned short
#define uint32_t unsigned int
#define uint64_t unsigned long long


typedef float               float32_T;
typedef double              double64;
typedef unsigned char       boolean_t;


#define MAX_int8_t                     ((int8_t)(127))
#define MIN_int8_t                     ((int8_t)(-128))
#define MAX_uint8_T                    ((uint8_t)(255U))

#define MAX_int16_t                    ((int16_t)(32767))
#define MIN_int16_t                    ((int16_t)(-32768))
#define MAX_uint16_t                   ((uint16_t)(65535U))

#define MAX_int32_t                    ((int32_t)(2147483647))
#define MIN_int32_t                    ((int32_t)(-2147483647-1))
#define MAX_uint32_t                   ((uint32_t)(0xFFFFFFFFU))

#define MAX_int64_t                    ((int64_t)(9223372036854775807LL))
#define MIN_int64_t                    ((int64_t)(-9223372036854775807LL-1LL))
#define MAX_uint64_t                   ((uint64_t)(0xFFFFFFFFFFFFFFFFULL))


#elif defined (Platform_BAT32)

#define int8_t signed char
#define int16_t signed short
#define int32_t signed int
#define int64_t signed long long
#define uint8_t unsigned char
#define uint16_t unsigned short
#define uint32_t unsigned int
#define uint64_t unsigned long long


typedef float               float32_T;
typedef double              double64;
typedef unsigned char       boolean_t;


#define MAX_int8_t                     ((int8_t)(127))
#define MIN_int8_t                     ((int8_t)(-128))
#define MAX_uint8_T                    ((uint8_t)(255U))

#define MAX_int16_t                    ((int16_t)(32767))
#define MIN_int16_t                    ((int16_t)(-32768))
#define MAX_uint16_t                   ((uint16_t)(65535U))

#define MAX_int32_t                    ((int32_t)(2147483647))
#define MIN_int32_t                    ((int32_t)(-2147483647-1))
#define MAX_uint32_t                   ((uint32_t)(0xFFFFFFFFU))

#define MAX_int64_t                    ((int64_t)(9223372036854775807LL))
#define MIN_int64_t                    ((int64_t)(-9223372036854775807LL-1LL))
#define MAX_uint64_t                   ((uint64_t)(0xFFFFFFFFFFFFFFFFULL))

#else

#error NO_Platform_Found

#endif/* Logical type definitions */


typedef enum
{
    /* Generic error codes */
    STATUS_SUCCESS                         = 0x000U,    /*!< Generic operation success status */
    STATUS_ERROR                           = 0x001U,    /*!< Generic operation failure status */
    STATUS_BUSY                            = 0x002U,    /*!< Generic operation busy status */
    STATUS_TIMEOUT                         = 0x003U,    /*!< Generic operation timeout status */
    STATUS_UNSUPPORTED                     = 0x004U,    /*!< Generic operation unsupported status */
    STATUS_NEGATIVE                        = 0x005U,    /* ??                 */
    STATUS_NONNEGATIVE                     = 0x006U,    /* ???               */

    /* CAN specific error codes */
    STATUS_CAN_BUFF_OUT_OF_RANGE           = 0x300U,  /*!< The specified MB index is out of the configurable range */
    STATUS_CAN_NO_TRANSFER_IN_PROGRESS     = 0x301U,  /*!< There is no transmission or reception in progress */

    SBC_COMM_ERROR                         = 0x802U, /*!< Data transfer was aborted */
    SBC_CMD_ERROR                          = 0x804U, /*!< Wrong command. */
    SBC_ERR_NA                             = 0x808U, /*!< Feature/device not available */

} status_t;

#define Telltales_SelfCheckOffset (uint32_t)(2ul)
#define StartAnimationStart       (uint32_t)(2ul)
#define StartAnimationEnd         (uint32_t)(3000ul)
#define PopupStart                (uint32_t)(4000ul)
#define BackLightStart            (uint32_t)(2ul)

/*LED Module*/
#if 0
typedef enum
{
    NoSelfCheck,
    SelfCheck ,
} SelfCheck_t;


typedef enum
{
    AllowBreak,
    NoBreak,
} SelfCheckBreak_t;

typedef enum
{
    NoExterNalCheck,
    ExterNalCheck,
} ExtCheck_t;

typedef enum
{
    LED_IGN_OFF,
    LED_IGN_ON,
    LED_IGN_ON_OFF,
} WorkStatus_t;

typedef enum
{
    LED_PWR_OFF,
    LED_PWR_ON,
} PowerStatus_t;

typedef enum
{
    LED_CheckNoFinish,
    LED_CheckFinished,
} Checktatus_t;

typedef enum
{
    LED_OFF_State,
    LED_ON_State,
} WorkPrease_t;

typedef enum
{
    State_OFF,
    State_ON,
} LEDState_t;
#endif


/*????,??????,????*/
typedef enum
{
    LINE_IN_LOGIC_INVALID = 0U, /*?????,??????,???*/
    LINE_IN_LOGIC_VALID,        /*?????,??????,???*/
} LineIn_LogicLevel_en_t;

/*????????*/
typedef enum
{
    LINE_IN_IG_OFF = 0U,
    LINE_IN_IG_ON,
    LINE_IN_IG_ONOFF,
} LINE_IN_WorkSt_en_t;

typedef enum
{
    LEVEL_LOW = 0u,
    LEVEL_HIGH,
} _LINE_IN_TriggerLevel_;

/*LineIn Module END*/

/*CAN TX Module*/

typedef enum
{
    CAN_MSG_TX_CYCLE = 0u,
    CAN_MSG_TX_CYCKE_EVENT,
} CAN_TX_Type_t;

typedef enum
{
    MSG_STD = 0u,
    MSG_EXT,
} CAN_MSG_FORMAT_t;

typedef enum
{
    CAN_APP_TX_DISABLE = 0u,
    CAN_APP_TX_ENABLE = 0X55u,
} CAN_APP_TX_Status_t;

/*CAN TX Module END*/


/*CAN RX Module*/
typedef enum
{
    CAN_BUFF_EMPTY,
    CAN_BUFF_FULL,
} CAN_BUFF_Status_t;

typedef enum
{
    CAN_MSG_UNLOCK,
    CAN_MSG_LOCKING,
} CAN_MSG_Mutex_t;

typedef enum
{
    CAN_SIG_NORMAL = 0u,
    CAN_SIG_LOST = 0x55U,
} CAN_MSG_Status_t;
/*CAN RX Module END*/



/*COMMON INTERFACE*/
typedef enum
{
    DISP_MODE_NONE = 0x00u,
    DISP_MODE_ANIMATION = 0x01u,
    DISP_MODE_DRIVE_INFO = 0x02u,
    DISP_MODE_MENU = 0x03u,
} MSG_01_DISP_MODE_t;

typedef enum
{
    LANGUAGE_ZH = 0x00u,
    LANGUAGE_EN = 0x01u,
} LANGUAGE_t;
    
typedef enum
{
    THEME_DAY = 0x00u,
    THEME_NIGHT = 0x01u,
} THEME_t;

typedef enum
{
    PHONE_NOT_CONNECT = 0x00u,
    PHONE_CONNECT = 0x01u,
} PHONE_CONNECT_t;


typedef enum
{
    COMMON_POWER_OFF = 0x00u,
    COMMON_POWER_ON = 0x01u,
    COMMON_POWER_UNKNOW = 0xFFu,
} COMMON_PowerStatus_t;

typedef enum
{
    COMMON_InValid = 0X00U,
    COMMON_Valid = 0X01U,
    COMMON_Valid_UNKNOW = 0XFFU,
} DataValid_t;

/*COMMON INTERFACE END*/


typedef enum
{
    GUI_DISP_MODE_NORMAL  = 0,         /*??*/
    GUI_DISP_MODE_BLANK,               /*??*/
    GUI_DISP_MODE_INVALID,             /*??*/
    GUI_DISP_MODE_FLASH,               /*??*/

} Dis_Sta_t;

typedef enum
{
    NM_Mode_Sleep,
    NM_Mode_Wakeup,
} NM_Mode_t;

#define GPIO_DIR_OUT        0
#define GPIO_DIR_IN         1

#endif
