/**************************************************************************//**
  * \file     Init.c
  * \brief    Initializations during work state switching
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     18-Jan-2019
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/

/* Includes ------------------------------------------------------------------*/

#include "BAT32A239.h"
#include "gpio.h"
#include "Sys_Tick.h"
#include "Analog_Signals.h"
#include "PowerManagement.h"
#include "PowerManagement_user.h"
#include "sci.h"
#include "clk.h"
#include "rtc.h"
#include "can.h"
#include "SEG_LCD.h"
#include "eeManager_Interface.h"
#include "Services_Mileage_User.h"
#include "IS31_IIC_Master.h"
#include "IS31FL3236.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**************************************************************************//**
  * \brief      Initializations during work state switching
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Startup_Pre_Init(void)
{
//    uint32_t i = 0u;
//    /* Release all Modules (except SDRAM controller) */
//    Sys_Peripheral_Reset(SYS_PERI_RESETTABLE & (~SYS_PERI_SDRB0));
//
//    /* Prepare device (clear all internal config, prepare interrupts) */
//    R_DEV_Prepare();
//    Clock_Pre_Init();
//	RTC_Pre_Init();
//    GPIO_Init(0);
//
//    /*时序延时*/
//    GPIO_OUT_PORT11_PIN02 = 0 ; /*FLASH电平转换信号  P17_0*/
//    for (i = 0u; i < 10000u;  i++) {;;}
//    GPIO_OUT_PORT11_PIN02 = 1 ;
//
//    VCC12V0_OUT_EN = 0u; /*P42_12*/
//    for (i = 0u; i < 1000u;  i++) {;;}
//    VCC12V0_OUT_EN = 1u;
//
//    GPIO_OUT_PORT42_PIN03 = 1u;/*P42_3*/
//
//    for (i = 0u; i < 6000000u;  i++) {;;}/*10000000u~127ms*/
//    MCU_RSTB_LCD = 1u;   /*P3_0*/
//
//    for (i = 0u; i < 3000000u;  i++) {;;}/*4000000u~66ms*/
//    LCD_BIAS_EN = 1u;   /*P3_1*/
//
//    for (i = 0u; i < 3000000u;  i++) {;;}
//    MCU_DCLK = 1u;   /*MCU_DCLK/P45_0*/
//
//    for (i = 0u; i < 1000u;  i++) {;;}
//    LCD_STDBYB = 1U; /*61194_EN_MCU/P11-3*/
//
//    Mem_SDRAM_Init(MEM_SDRAM_2x_W9812G6KH_120MHz, Mem_SDRAM_DRV_25Ohm);
//    //Mem_SDRAM_Init(MEM_SDRAM_2x_IS45S16800F_120MHz, Mem_SDRAM_DRV_25Ohm);
//
//    Sys_Enable_Preload_Buffer();
}

/**************************************************************************//**
  * \brief      Initializations during system power up
  * \attention
  * \retval     None
******************************************************************************/


void Sys_Startup_Init(void)
{
    
    Clock_Init();
    
    GPIO_Init(GPIO_WAKEUP_MODE);

	    Simulated_IIC_2_Init();
    IS31FL3236_Init();
		SEG_LCD_Init(); 
    SEG_LCD_Vehicle_Speed_Num_Display(0, 0, 0);
		SEG_LCD_Engine_Speed_Seg_Display(0, 0, 0);
		SEG_LCD_ODO_Trip_Display(0, 0, 0, 0);
		SEG_Fuel_Level_Display(0, 0);
    SEG_LCD_Battery_Voltage_Display(0, 0 ,0);
		SEG_LCD_Gear_Display(0, 0, 0);
	

    Sys_Tick_Timer_Start();

    
//    /*COM_CAN_Init(); 原CAN初始化位置*/
//
    Analog_Signal_Conv_Init();
 //   UART2_Init(115200);
    RTC_Init(RTC_FSUB);

//     /*30电数据初始化*/
    Power_Management_Lib_Init();
    Power_Management_Init(0u);
    bsp_CAN_Init();
    eeprom_StoreInfo_Init( );	//20221028
    CalcODOKL30Init();
		
}

/**************************************************************************//**
  * \brief      Initializations during work state switch to system sleep
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Sleep_Init(void)
{

}

/**************************************************************************//**
  * \brief      Initializations during work state switch to system run
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Wakeup_Init(void)
{

}

