/*
 * SystemProc.c
 *
 *  Created on: Jul 31, 2014
 *      Author: QTC
 */
#include "timerA_B_C.h"
#include "gpio.h"


/***********************************************************************************************************************
* Function Name: TMA0_Start
* @brief  This function starts TMA counter.
* @param  None
* @return None
***********************************************************************************************************************/
void TMA0_Start(void)
{
    INTC_ClearPendingIRQ(TMA_IRQn);/* clear INTTMA interrupt flag */
    INTC_EnableIRQ(TMA_IRQn);/* enable INTTMA interrupt */
    TMA->TACR0 |= 0x01;
}
/***********************************************************************************************************************
* Function Name: TMA0_Stop
* @brief  This function stops TMA counter.
* @param  None
* @return None
***********************************************************************************************************************/
void TMA0_Stop(void)
{
    TMA->TACR0 &= (uint8_t)~0x01;
    INTC_DisableIRQ(TMA_IRQn);/* disable INTTMA interrupt */
    INTC_ClearPendingIRQ(TMA_IRQn);/* clear INTTMA interrupt flag */
}

/***********************************************************************************************************************
* Function Name: TMA0_IntervalTimer
* @brief  The TMA operates as interval timer.
* @param  clk - select count source clock
* @param  num - specify the count value
* @return None
***********************************************************************************************************************/
void bsp_TMA0_IntervalTimer(tma_clock_t clk, uint16_t num)
{
    CGC->PER1 |= CGC_PER1_TMAEN_Msk;     /* enables input clock supply */
    TMA->TACR0 &= (uint8_t)~0x01;
    INTC_DisableIRQ(TMA_IRQn);           /* disable INTTMA interrupt */
    INTC_ClearPendingIRQ(TMA_IRQn);      /* clear INTTMA interrupt flag */
    TMA->TAMR0 = clk ;
    if(clk == TMA_COUNT_SOURCE_FIL)
    {
        CGC->OSMC = 0x10U;  /* WUTMMCK0 = 1 */
    }
    TMA->TA0 = num - 1;
    TMA0_Start();
}

/***********************************************************************************************************************
* Function Name: TMB0_Start
* @brief  This function starts TMB counter.
* @param  None
* @return None
***********************************************************************************************************************/
void TMB0_Start(void)
{
    volatile uint8_t tbsr_dummy;

    tbsr_dummy = TMB->TBSR; /* read TBSR before write 0 */
    TMB->TBSR = 0x00U;
    INTC_ClearPendingIRQ(TMB_IRQn);/* clear INTTMA interrupt flag */
    INTC_EnableIRQ(TMB_IRQn);/* enable INTTMA interrupt */
    TMB->TBMR |= 0x80U;

}
/***********************************************************************************************************************
* Function Name: TMB0_Stop
* @brief  This function stops TMB counter.
* @param  None
* @return None
***********************************************************************************************************************/
void TMB0_Stop(void)
{
    volatile uint8_t tbsr_dummy;

    TMB->TBMR &= (uint8_t)~(0x80U);
    INTC_DisableIRQ(TMB_IRQn);/* disable INTTMA interrupt */
    INTC_ClearPendingIRQ(TMB_IRQn);/* clear INTTMA interrupt flag */
    tbsr_dummy = TMB->TBSR; /* read TBSR before write 0 */
    TMB->TBSR = 0x00U;

    CGC->PER1 &= ~CGC_PER1_TMBEN_Msk;     /* disables input clock supply */
    PORT_Init(PWM_BL        , OUTPUT);
	PORT_ClrBit(PWM_BL);
}
/*-------------------------------------------------------------------------
* Function Name  : TMB0_PWM_Freq_Duty
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void TMB0_PWM_Pin33_Init(void)
{

    uint16_t half_period;
    uint16_t duty;
    uint16_t freq;
    uint32_t wduty;
    
    freq = 50000;
    duty = 0;

    CGC->PER1 |= CGC_PER1_TMBEN_Msk;     /* enables input clock supply */
    TMB->TBMR &= (uint8_t)~0x80;
    INTC_DisableIRQ(TMB_IRQn);/* disable INTTMB interrupt */
    INTC_ClearPendingIRQ(TMB_IRQn);/* clear INTTMB interrupt flag */
    /* the counter is cleared when it matches the TMGRB register */ 
    TMB->TBCR = 0x40 | 2U; //Fclk/4
    /* increment timer mode */
    TMB->TBMR = 0x01U;
    /* TBGRD/TBGRC is used as buffer register for TBGRB/TBGRA register, toggle output when matches */
    TMB->TBIOR = 0X80 | 0X30 |0X08 | 0X03;
    /* Set the interrupt enable register */
    TMB->TBIER = 0X08 | 0X02 | 0X01;

    half_period = (2000000 / freq);
    wduty = (half_period * duty) / 1000;
    TMB->TBGRA = (half_period - wduty);
    TMB->TBGRB = half_period;
    TMB->TBGRC = TMB->TBGRA;
    TMB->TBGRD = TMB->TBGRB;

    /* Set TBIO0 pin */
    TBO0_PORT_SETTING();

    TMB0_Start();
}
/*-------------------------------------------------------------------------
* Function Name  : TMB0_PWM_Freq_Duty
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void TMB0_PWM_Pin33_Freq_Duty(uint16_t freq, uint16_t duty)
{
    uint16_t half_period;
    uint32_t wduty;

    half_period = (2000000 / freq);
    wduty = (half_period * duty) / 1000;
    TMB->TBGRA = (half_period - wduty);
    TMB->TBGRB = half_period;
    TMB->TBGRC = TMB->TBGRA;
    TMB->TBGRD = TMB->TBGRB;

}

