/*
 * bsp_clock.h
 *
 *  Created on: 2021
 *      Author: QTC
 */

#ifndef _BSPTIMER4_H_
#define _BSPTIMER4_H_
#include "common.h"	
#define              TIMER4_CH0                 0x01
#define              TIMER4_CH1                 0x02
#define              TIMER4_CH2                 0x04
#define              TIMER4_CH3                 0x08

#define EdgeRising   0X0144
#define EdgeFalling  0X0104

#define TI00_PORT_SETTING() do{ \
        PORT->PM0  |=  (1 << 0);    /* P00 is used as TI00 input */ \
        PORT->PMC0 &= ~(1 << 0);    /* P00 is digital function */ \
}while(0)

#define TI01_PORT_SETTING() do{ \
        PORT->PM1  |=  (1 << 6);    /* P16 is used as TI01 input */ \
}while(0)

#define TI02_PORT_SETTING() do{ \
        PORT->PM1  |=  (1 << 7);    /* P17 is used as TI02 input */ \
}while(0)

#define TI03_PORT_SETTING() do{ \
        PORT->PM3  |=  (1 << 1);    /* P31 is used as TI03 input */ \
}while(0)

extern void Timer4_Init(uint16_t Frequency,uint8_t ch);
extern void Capture_Init(uint8_t pin_num);
extern void Capture_Stop(uint8_t pin_num);
void  bsp_tim4_01_isr_Handler( void );
void  bsp_tim4_02_isr_Handler( void );
#endif /* _BSPTIMER4_H_ */
