#define GLOBALS_SERPROC_DIAGNO

#include "app_Service.h"
#include "TP_Layer.h"
#include "UDS_def.h"
#include "app_ServiceProc.h"

/*-------------------------------------------------------------------------
* Function Name  : App_CreateCRCCheckSum
* Description    :
* Input          : uint8_t *p ,uint8_t Nub
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t App_CreateCRCCheckSum(uint8_t *p, uint8_t Nub)
{
    uint8_t bCheckSun;
    uint8_t i;
    bCheckSun = 0;
    while (Nub--)
    {
        bCheckSun ^= *p++;
        for (i = 0; i < 8; i++)
        {
            if (bCheckSun & 0x01)
            {
                bCheckSun = (bCheckSun >> 1) ^ 0x8C;
            }
            else
                bCheckSun >>= 1;
        }
    }
    return (bCheckSun);
}
/*-------------------------------------------------------------------------
* Function Name  : App_CopyRam
* Description    : ran copy
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_CopyRam(uint8_t *Dp, uint8_t *Sp, uint16_t Nub)
{
    uint16_t b;

    for (b = 0; b < Nub; b++)
    {
        *Dp++ = *Sp++;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_Load_DID
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_Load_DID(uint16_t *DID, uint8_t *data)
{
    (*DID) = data[0];
    (*DID) = (*DID) << 8;
    (*DID) |= data[1];
}
/*-------------------------------------------------------------------------
* Function Name  : App_ErrorInfoInit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_ErrorInfoInit(_N_USData *AppUSData)
{
    Error.RespSerId = AppUSData->ind.MsgData[0];
    Error.N_TAtype = AppUSData->ind.N_TAtype;

    Error.FrameErr = 0;
}

/*-------------------------------------------------------------------------
* Function Name  : App_11_Reset_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_11_Reset_handle(void)
{
    if (N_RSPData.ind.N_Result == STATE0)
    {
        switch (DiagnoCtl.SubFunction)
        {
        case SubHardReset:
             __NVIC_SystemReset();

        case SubSoftReset:

            break;
        case SubKeyOffOnReset:

            break;
        default:;
        }
        DiagnoCtl.SubFunction = 0;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_2F_IOCtl_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Diagno_Tick(uint16_t DiagnoTimeCn)
{
    //
    if (DiagClock.TT_STminEnable)
    {
        if (DiagClock.STminTime < DiagClock.OverSTminTime)
        {
            DiagClock.STminTime += DiagnoTimeCn;
        }
    }
    if (DiagClock.TT_BsEnable)
    {
        if (DiagClock.BsTime < DiagClock.OverBsTime)
        {
            DiagClock.BsTime += DiagnoTimeCn;
        }
    }
    if (DiagClock.TT_CrEnable)
    {
        if (DiagClock.CrTime < DiagClock.OverCrTime)
        {
            DiagClock.CrTime += DiagnoTimeCn;
        }
    }

    if (DiagClock.TT_SequenceEnable)
    {
        if (DiagClock.SequenceTime < DiagClock.OverSequenceTime)
        {
            DiagClock.SequenceTime += DiagnoTimeCn;
        }
    }

    if (DiagClock.TT_SessionEnable)
    {
        if (DiagClock.SessionTime < DiagClock.OverSessionTime)
        {
            DiagClock.SessionTime += DiagnoTimeCn;
        }
    }

    if (DiagClock.TT_UnlockEnable)
    {
        if (DiagClock.UnlockTime < DiagClock.OverUnlockTime)
        {
            DiagClock.UnlockTime += DiagnoTimeCn;
        }
    }
}
